/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.type.PhpExpressionAlwaysNullInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpEnumCase;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public final class PhpCaseWithValueNotFoundInEnumInspection
extends PhpInspection {
    private static final String TRY_FROM_METHOD_NAME = "tryFrom";

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpCaseWithValueNotFoundInEnumInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpMethodReference(MethodReference reference) {
                if (!reference.isStatic()) {
                    return;
                }
                PsiElement argument = reference.getParameter(0);
                if (argument == null) {
                    return;
                }
                PhpExpression classReference = reference.getClassReference();
                if (classReference instanceof ClassReference && PhpCaseWithValueNotFoundInEnumInspection.resolvedToEnumFromMethod(reference)) {
                    Collection<PhpClass> classes = ((ClassReference)classReference).multiResolveStrict(PhpClass.class);
                    if (ContainerUtil.exists(classes, c -> !c.isEnum() || c.getBackedEnumType().isEmpty())) {
                        return;
                    }
                    Collection<PhpEnumCase.PhpDefaultValueDescriptor> descriptors = PhpCaseWithValueNotFoundInEnumInspection.getDefaultValueDescriptors(classes);
                    if (ContainerUtil.and(descriptors, d -> d.match(argument) == PhpEnumCase.MatchResult.NOT_MATCHING)) {
                        holder.registerProblem(argument, PhpBundle.message("inspection.message.not.valid.backing.value.for.enum", argument.getText()), PhpCaseWithValueNotFoundInEnumInspection.isTryFrom(reference) ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.getFixes(classes, argument, descriptors, reference));
                    }
                }
            }

            private LocalQuickFix[] getFixes(Collection<PhpClass> classes, PsiElement argument, Collection<PhpEnumCase.PhpDefaultValueDescriptor> descriptors, @NotNull MethodReference methodReference) {
                PhpClass phpClass;
                if (methodReference == null) {
                    1.$$$reportNull$$$0(0);
                }
                ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
                if (PhpCaseWithValueNotFoundInEnumInspection.isTryFrom(methodReference)) {
                    ContainerUtil.addIfNotNull(fixes, (Object)PhpExpressionAlwaysNullInspection.getFix((PsiElement)methodReference, PhpBundle.message("php.replace.try.from.with.null.quick.fix.family.name", new Object[0])));
                }
                if (isOnTheFly && (phpClass = (PhpClass)ContainerUtil.getOnlyItem(classes)) != null) {
                    fixes.add(LocalQuickFix.from((ModCommandAction)new PhpAddCaseWithValueQuickFix((PhpClass)ContainerUtil.getOnlyItem(classes), argument)));
                }
                for (PhpEnumCase.PhpDefaultValueDescriptor d : descriptors) {
                    fixes.add(LocalQuickFix.from((ModCommandAction)new PhpReplaceExpressionQuickFix(argument, d.getValue())));
                }
                return fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodReference", "com/jetbrains/php/lang/inspections/probablyBug/PhpCaseWithValueNotFoundInEnumInspection$1", "getFixes"));
            }
        };
    }

    private static boolean isTryFrom(@NotNull MethodReference methodReference) {
        if (methodReference == null) {
            PhpCaseWithValueNotFoundInEnumInspection.$$$reportNull$$$0(1);
        }
        return PhpLangUtil.equalsMethodNames(methodReference.getName(), TRY_FROM_METHOD_NAME);
    }

    @NotNull
    public static Collection<PhpEnumCase.PhpDefaultValueDescriptor> getDefaultValueDescriptors(Collection<PhpClass> classes) {
        Collection collection = (Collection)StreamEx.of(classes).flatMap(e -> e.getEnumCases().stream()).map(PhpEnumCase::getDefaultValueDescriptor).nonNull().collect(Collectors.toSet());
        if (collection == null) {
            PhpCaseWithValueNotFoundInEnumInspection.$$$reportNull$$$0(2);
        }
        return collection;
    }

    private static boolean resolvedToEnumFromMethod(MethodReference reference) {
        Collection resolvedMethod = reference.multiResolveStrict(Method.class);
        return PhpCaseWithValueNotFoundInEnumInspection.resolvedToBackedEnumMethod(resolvedMethod, "from") || PhpCaseWithValueNotFoundInEnumInspection.resolvedToBackedEnumMethod(resolvedMethod, TRY_FROM_METHOD_NAME);
    }

    private static boolean resolvedToBackedEnumMethod(Collection<Method> resolvedMethod, String name) {
        return !resolvedMethod.isEmpty() && ContainerUtil.and(resolvedMethod, m -> ("\\IntBackedEnum." + name).equals(m.getFQN()) || ("\\StringBackedEnum." + name).equals(m.getFQN()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpCaseWithValueNotFoundInEnumInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpCaseWithValueNotFoundInEnumInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValueDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isTryFrom";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static class PhpReplaceExpressionQuickFix
    extends PsiUpdateModCommandAction<PsiElement> {
        private final String myValue;

        private PhpReplaceExpressionQuickFix(PsiElement argument, @NotNull String value) {
            if (value == null) {
                PhpReplaceExpressionQuickFix.$$$reportNull$$$0(0);
            }
            super(argument);
            this.myValue = value;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PsiElement argument, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpReplaceExpressionQuickFix.$$$reportNull$$$0(1);
            }
            if (argument == null) {
                PhpReplaceExpressionQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpReplaceExpressionQuickFix.$$$reportNull$$$0(3);
            }
            argument.replace((PsiElement)PhpPsiElementFactory.createPhpPsiFromText(context.project(), PhpExpression.class, this.myValue));
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with", this.myValue);
            if (string == null) {
                PhpReplaceExpressionQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "argument";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpCaseWithValueNotFoundInEnumInspection$PhpReplaceExpressionQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpCaseWithValueNotFoundInEnumInspection$PhpReplaceExpressionQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    private static class PhpAddCaseWithValueQuickFix
    extends PsiUpdateModCommandAction<PhpClass> {
        @NlsSafe
        private final String myArgumentText;

        private PhpAddCaseWithValueQuickFix(PhpClass phpClass, PsiElement argument) {
            super((PsiElement)phpClass);
            this.myArgumentText = argument.getText();
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PhpClass phpClass, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpAddCaseWithValueQuickFix.$$$reportNull$$$0(0);
            }
            if (phpClass == null) {
                PhpAddCaseWithValueQuickFix.$$$reportNull$$$0(1);
            }
            if (updater == null) {
                PhpAddCaseWithValueQuickFix.$$$reportNull$$$0(2);
            }
            @NotNull Project project = context.project();
            PsiElement insertedElement = PhpCodeEditUtil.insertClassMember(phpClass, (PsiElement)PhpPsiElementFactory.createEnumCase(project, "", this.myArgumentText));
            PsiElement opAsgn = PhpPsiUtil.getChildOfType(insertedElement, PhpTokenTypes.opASGN);
            updater.moveCaretTo((PsiElement)ObjectUtils.notNull((Object)opAsgn, (Object)insertedElement));
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.name.add.enum.case.with.value", this.myArgumentText);
            if (string == null) {
                PhpAddCaseWithValueQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "phpClass";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpCaseWithValueNotFoundInEnumInspection$PhpAddCaseWithValueQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpCaseWithValueNotFoundInEnumInspection$PhpAddCaseWithValueQuickFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

