/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.inspections.probablyBug.PhpDuplicateEntitiesInspectionBase;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.PhpDefaultMatchArm;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpMatchArm;
import com.jetbrains.php.lang.psi.elements.PhpMatchExpression;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpDuplicateMatchArmBodyInspection
extends PhpDuplicateEntitiesInspectionBase<PhpMatchExpression, PhpMatchArm> {
    @Override
    protected void registerDuplicatedEntry(@NotNull ProblemsHolder holder, PhpMatchArm duplicatedEntry, PhpMatchArm originalEntry) {
        PhpExpression bodyExpression;
        if (holder == null) {
            PhpDuplicateMatchArmBodyInspection.$$$reportNull$$$0(0);
        }
        if ((bodyExpression = duplicatedEntry.getBodyExpression()) == null) {
            return;
        }
        if (PhpDuplicateMatchArmBodyInspection.hasConditionWithSideEffect(originalEntry) || PhpDuplicateMatchArmBodyInspection.hasConditionWithSideEffect(duplicatedEntry)) {
            return;
        }
        holder.registerProblem((PsiElement)bodyExpression, PhpBundle.message("inspection.duplicate.match.arm.body", PhpDuplicateMatchArmBodyInspection.getMatchArmText(originalEntry)), new LocalQuickFix[]{new PhpMergeMatchArmConditions(originalEntry, duplicatedEntry)});
    }

    private static boolean hasConditionWithSideEffect(@NotNull PhpMatchArm matchArm) {
        if (matchArm == null) {
            PhpDuplicateMatchArmBodyInspection.$$$reportNull$$$0(1);
        }
        return ContainerUtil.exists(matchArm.getConditions(), cond -> PhpSideEffectDetector.canContainSideEffect((PsiElement)cond));
    }

    @NotNull
    private static String getMatchArmText(@NotNull PhpMatchArm arm) {
        if (arm == null) {
            PhpDuplicateMatchArmBodyInspection.$$$reportNull$$$0(2);
        }
        if (arm instanceof PhpDefaultMatchArm) {
            return "default";
        }
        String string = StringUtil.join((Collection)ContainerUtil.map(arm.getConditions(), PsiElement::getText), (String)", ");
        if (string == null) {
            PhpDuplicateMatchArmBodyInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    protected List<PhpMatchArm> getElements(@NotNull PhpMatchExpression parent) {
        if (parent == null) {
            PhpDuplicateMatchArmBodyInspection.$$$reportNull$$$0(4);
        }
        ArrayList<PhpMatchArm> arms = new ArrayList<PhpMatchArm>();
        if (parent.getDefaultMatchArm() != null) {
            arms.add(parent.getDefaultMatchArm());
        }
        arms.addAll(parent.getMatchArms());
        return arms;
    }

    @Override
    protected PsiElement getElementToCheckDuplication(@NotNull PhpMatchArm element) {
        if (element == null) {
            PhpDuplicateMatchArmBodyInspection.$$$reportNull$$$0(5);
        }
        return element.getBodyExpression();
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpDuplicateMatchArmBodyInspection.$$$reportNull$$$0(6);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpMatchExpression(PhpMatchExpression matchExpression) {
                PhpDuplicateMatchArmBodyInspection.this.processDuplicateEntries(matchExpression, holder);
            }
        };
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchArm";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arm";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpDuplicateMatchArmBodyInspection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpDuplicateMatchArmBodyInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMatchArmText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerDuplicatedEntry";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasConditionWithSideEffect";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMatchArmText";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getElements";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getElementToCheckDuplication";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private static class PhpMergeMatchArmConditions
    extends LocalQuickFixOnPsiElement {
        @NotNull
        private final String myOriginalEntryName;

        private PhpMergeMatchArmConditions(PhpMatchArm original, PhpMatchArm duplicate) {
            super((PsiElement)original, (PsiElement)duplicate);
            this.myOriginalEntryName = PhpDuplicateMatchArmBodyInspection.getMatchArmText(original);
        }

        @IntentionName
        @NotNull
        public String getText() {
            String string = PhpBundle.message("intention.name.merge.with.match.arm", this.myOriginalEntryName);
            if (string == null) {
                PhpMergeMatchArmConditions.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement original, @NotNull PsiElement duplicate) {
            if (project == null) {
                PhpMergeMatchArmConditions.$$$reportNull$$$0(1);
            }
            if (file == null) {
                PhpMergeMatchArmConditions.$$$reportNull$$$0(2);
            }
            if (original == null) {
                PhpMergeMatchArmConditions.$$$reportNull$$$0(3);
            }
            if (duplicate == null) {
                PhpMergeMatchArmConditions.$$$reportNull$$$0(4);
            }
            if (!(original instanceof PhpDefaultMatchArm)) {
                PsiElement toAddAfter = (PsiElement)ContainerUtil.getLastItem(((PhpMatchArm)original).getConditions());
                for (PhpExpression condition : ((PhpMatchArm)duplicate).getConditions()) {
                    toAddAfter = original.addAfter(PhpPsiElementFactory.createComma(project), toAddAfter);
                    toAddAfter = original.addAfter((PsiElement)condition, toAddAfter);
                }
            }
            PhpCodeEditUtil.removeStatementWithDelivery(duplicate, PhpTokenTypes.opCOMMA);
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.merge.with.duplicated.match.arm", new Object[0]);
            if (string == null) {
                PhpMergeMatchArmConditions.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpDuplicateMatchArmBodyInspection$PhpMergeMatchArmConditions";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "duplicate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpDuplicateMatchArmBodyInspection$PhpMergeMatchArmConditions";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

