/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpNavigateToMultipleElementsQuickFixBase;
import com.jetbrains.php.lang.inspections.controlFlow.PhpNavigateToElementQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class PhpMethodMayBeInaccessibleInLateStaticBindingInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpMethodMayBeInaccessibleInLateStaticBindingInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpMethodReference(MethodReference reference) {
                Method resolvedMethod;
                if (!PhpLangUtil.isStaticReference((PsiElement)reference.getClassReference())) {
                    return;
                }
                Method containingMethod = PhpPsiUtil.getParentOfClass((PsiElement)reference, Method.class);
                if (containingMethod == null) {
                    return;
                }
                PhpClass containingClass = containingMethod.getContainingClass();
                if (containingClass != null && !containingClass.isTrait() && (resolvedMethod = (Method)ObjectUtils.tryCast((Object)reference.resolve(), Method.class)) != null && resolvedMethod.getAccess().isPrivate()) {
                    if (PhpMethodMayBeInaccessibleInLateStaticBindingInspection.overridingMethodExists(containingMethod)) {
                        return;
                    }
                    Collection<Method> overridingMethods = PhpMethodMayBeInaccessibleInLateStaticBindingInspection.findOverridingNonAbstractClassesWithOverridingPrivateMethod(resolvedMethod);
                    if (overridingMethods.isEmpty()) {
                        return;
                    }
                    this.registerProblem(reference, overridingMethods);
                }
            }

            private void registerProblem(MethodReference reference, Collection<Method> overridingMethods) {
                LocalQuickFix[] localQuickFixArray;
                String message;
                Method onlyOverridingMethod = (Method)ContainerUtil.getOnlyItem(overridingMethods);
                String string = message = onlyOverridingMethod != null ? PhpBundle.message("inspection.message.existing.overriding.private.method.may.be.inaccessible.method", PhpLangUtil.toShortName(onlyOverridingMethod.getFQN())) : PhpBundle.message("inspection.message.existing.overriding.private.method.may.be.inaccessible", new Object[0]);
                if (isOnTheFly) {
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                    localQuickFixArray = localQuickFixArray2;
                    localQuickFixArray2[0] = PhpMethodMayBeInaccessibleInLateStaticBindingInspection.getQuickFix(overridingMethods, onlyOverridingMethod);
                } else {
                    localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                }
                LocalQuickFix[] fixes = localQuickFixArray;
                ASTNode nameNode = reference.getNameNode();
                if (nameNode != null) {
                    holder.registerProblem(nameNode.getPsi(), message, fixes);
                }
            }
        };
    }

    @NotNull
    private static LocalQuickFix getQuickFix(Collection<Method> overridingMethods, Method onlyOverridingMethod) {
        return onlyOverridingMethod != null ? LocalQuickFix.from((ModCommandAction)new PhpNavigateToElementQuickFix(onlyOverridingMethod)) : new PhpNavigateToMultipleMethodsQuickFix(overridingMethods);
    }

    private static Collection<Method> findOverridingNonAbstractClassesWithOverridingPrivateMethod(Method method) {
        PhpClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return Collections.emptyList();
        }
        HashSet<Method> res = new HashSet<Method>();
        PhpClassHierarchyUtils.processMethodInSubclasses((member, subClass, baseClass) -> {
            if (member.getAccess().isPrivate() && !subClass.isAbstract() && !subClass.hasTraitUses()) {
                res.add((Method)member);
            }
            return true;
        }, PhpIndex.getInstance(containingClass.getProject()), method.getName(), containingClass);
        return res;
    }

    private static boolean overridingMethodExists(Method containingMethod) {
        Ref res = new Ref((Object)false);
        PhpClassHierarchyUtils.processOverridingMethods(containingMethod, (member, subClass, baseClass) -> {
            res.set((Object)true);
            return false;
        });
        return (Boolean)res.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/probablyBug/PhpMethodMayBeInaccessibleInLateStaticBindingInspection", "buildVisitor"));
    }

    private static class PhpNavigateToMultipleMethodsQuickFix
    extends PhpNavigateToMultipleElementsQuickFixBase {
        private final Collection<SmartPsiElementPointer<Method>> myMethods;

        private PhpNavigateToMultipleMethodsQuickFix(Collection<Method> methods) {
            this.myMethods = ContainerUtil.map(methods, SmartPointerManager::createPointer);
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.navigate.to.possibly.inaccessible.methods", new Object[0]);
            if (string == null) {
                PhpNavigateToMultipleMethodsQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpNavigateToMultipleMethodsQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpNavigateToMultipleMethodsQuickFix.$$$reportNull$$$0(2);
            }
            List methods = this.myMethods.stream().map(e -> (Method)e.getElement()).filter(Objects::nonNull).collect(Collectors.toList());
            this.showPopup(descriptor.getStartElement(), methods, PhpBundle.message("overriding.private.methods", new Object[0]));
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            if (project == null) {
                PhpNavigateToMultipleMethodsQuickFix.$$$reportNull$$$0(3);
            }
            if (previewDescriptor == null) {
                PhpNavigateToMultipleMethodsQuickFix.$$$reportNull$$$0(4);
            }
            return new IntentionPreviewInfo.Html(PhpBundle.message("shows.list.of.child.classes.with.inaccessible.methods", new Object[0]));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpMethodMayBeInaccessibleInLateStaticBindingInspection$PhpNavigateToMultipleMethodsQuickFix";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpMethodMayBeInaccessibleInLateStaticBindingInspection$PhpNavigateToMultipleMethodsQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

