/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpNonStrictObjectEqualityQuickFix;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpNonStrictObjectEqualityInspection
extends PhpInspection {
    private static final String WARNING_KEY = "inspection.non.strict.object.equality";
    private static final PhpType DATETIME = PhpType.builder().add("\\DateTimeInterface").build();

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpNonStrictObjectEqualityInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpBinaryExpression(@NotNull BinaryExpression element) {
                IElementType[] operations;
                PsiElement operation;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (PhpPsiUtil.isOfType(operation = element.getOperation(), operations = new IElementType[]{PhpTokenTypes.opEQUAL, PhpTokenTypes.opNOT_EQUAL})) {
                    PsiElement left = element.getLeftOperand();
                    PsiElement right = element.getRightOperand();
                    if (!PhpPsiUtil.isOfType(right, PhpElementTypes.NUMBER, PhpElementTypes.STRING) && !PhpPsiUtil.isOfType(left, PhpElementTypes.NUMBER, PhpElementTypes.STRING) && PhpNonStrictObjectEqualityInspection.isObject(left) && PhpNonStrictObjectEqualityInspection.isObject(right)) {
                        String warning = PhpBundle.message(PhpNonStrictObjectEqualityInspection.WARNING_KEY, new Object[0]);
                        holder.registerProblem(operation, warning, new LocalQuickFix[]{PhpNonStrictObjectEqualityQuickFix.INSTANCE});
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/lang/inspections/probablyBug/PhpNonStrictObjectEqualityInspection$1", "visitPhpBinaryExpression"));
            }
        };
    }

    private static boolean isObject(@Nullable PsiElement element) {
        if (element instanceof PhpTypedElement) {
            Project project = element.getProject();
            PhpType type = ((PhpTypedElement)element).getGlobalType().filterNull().filterUnknown();
            PhpType typeNoPrimitiveAndPlural = type.filterPrimitives().filterPlurals();
            if (!typeNoPrimitiveAndPlural.isEmpty()) {
                boolean containsPrimitiveOrPlural;
                boolean bl = containsPrimitiveOrPlural = type.size() - typeNoPrimitiveAndPlural.size() > 0;
                if (containsPrimitiveOrPlural) {
                    return false;
                }
                return !DATETIME.isConvertibleFrom(type, PhpIndex.getInstance(project)) && !PhpAnnotatorVisitor.isEnum(project, type);
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/probablyBug/PhpNonStrictObjectEqualityInspection", "buildVisitor"));
    }
}

