/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.UpdateInspectionOptionFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.annotator.PhpDeleteElementQuickFix;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ControlStatement;
import com.jetbrains.php.lang.psi.elements.DoWhile;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.Finally;
import com.jetbrains.php.lang.psi.elements.For;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StatementWithArgument;
import com.jetbrains.php.lang.psi.elements.Try;
import com.jetbrains.php.lang.psi.elements.While;
import com.jetbrains.php.lang.psi.elements.impl.GroupStatementImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpStatementHasEmptyBodyInspection
extends PhpInspection {
    public boolean myCommentsCountAsContent = false;
    public boolean myIgnoreWhileWithoutBody = false;
    public boolean myIgnoreForWithoutBody = false;
    @Nls
    public static final String DELETE_ELEMENT_FIX_NAME = PhpBundle.message("delete.unused.element", new Object[0]);
    @Nls
    public static final String EXTRACT_SIDE_EFFECT_FIX_NAME = PhpBundle.message("extract.side.effect", new Object[0]);
    private static final Key<PhpStatementHasEmptyBodyInspection> SHORT_NAME_KEY = Key.create((String)"PhpStatementHasEmptyBodyInspection");

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpStatementHasEmptyBodyInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpIf(If ifStatement) {
                Else elseBranch = ifStatement.getElseBranch();
                boolean emptyElseBranch = elseBranch == null || PhpStatementHasEmptyBodyInspection.isEmpty((PsiElement)elseBranch.getStatement(), PhpStatementHasEmptyBodyInspection.this.myCommentsCountAsContent);
                Supplier<ModCommandAction[]> fixesSupplier = () -> emptyElseBranch && ifStatement.getElseIfBranches().length == 0 ? PhpStatementHasEmptyBodyInspection.createFixes(ifStatement) : ModCommandAction.EMPTY_ARRAY;
                if (this.processStatement((PsiElement)ifStatement, (PsiElement)ifStatement.getStatement(), fixesSupplier) && fixesSupplier.get().length > 0) {
                    return;
                }
                if (elseBranch != null && emptyElseBranch) {
                    this.processStatement((PsiElement)elseBranch, (PsiElement)elseBranch.getStatement(), new ModCommandAction[]{new PhpDeleteElementQuickFix((PsiElement)elseBranch, DELETE_ELEMENT_FIX_NAME)});
                }
            }

            @Override
            public void visitPhpElseIf(ElseIf elseIfStatement) {
                Supplier<ModCommandAction[]> fixes = () -> PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)elseIfStatement, true) == null ? PhpStatementHasEmptyBodyInspection.createFixes(elseIfStatement) : ModCommandAction.EMPTY_ARRAY;
                this.processStatement((PsiElement)elseIfStatement, (PsiElement)elseIfStatement.getStatement(), fixes);
            }

            @Override
            public void visitPhpForeach(ForeachStatement foreach) {
                this.processStatement((PsiElement)foreach, (PsiElement)foreach.getStatement(), new ModCommandAction[0]);
            }

            @Override
            public void visitPhpFor(For forStatement) {
                Statement statement = forStatement.getStatement();
                if (PhpStatementHasEmptyBodyInspection.this.myIgnoreForWithoutBody && statement != null && PhpPsiUtil.isOfType(statement.getFirstChild(), PhpTokenTypes.opSEMICOLON)) {
                    return;
                }
                this.processStatement((PsiElement)forStatement, (PsiElement)statement, new ModCommandAction[0]);
            }

            @Override
            public void visitPhpWhile(While whileStatement) {
                Statement statement = whileStatement.getStatement();
                if (PhpStatementHasEmptyBodyInspection.this.myIgnoreWhileWithoutBody && statement != null && PhpPsiUtil.isOfType(statement.getFirstChild(), PhpTokenTypes.opSEMICOLON)) {
                    return;
                }
                this.processStatement((PsiElement)whileStatement, (PsiElement)statement, new ModCommandAction[0]);
            }

            @Override
            public void visitPhpDoWhile(DoWhile doWhileStatement) {
                this.processStatement((PsiElement)doWhileStatement, (PsiElement)doWhileStatement.getStatement(), new ModCommandAction[0]);
            }

            @Override
            public void visitPhpSwitch(PhpSwitch switchStatement) {
                this.processStatement((PsiElement)switchStatement, (PsiElement)switchStatement, PhpStatementHasEmptyBodyInspection.createFixes(switchStatement));
            }

            @Override
            public void visitPhpTry(Try tryStatement) {
                this.processStatement((PsiElement)tryStatement, (PsiElement)tryStatement.getStatement(), new ModCommandAction[]{new PhpDeleteElementUnderControlStatementQuickFix((PsiElement)tryStatement)});
            }

            @Override
            public void visitPhpFinally(Finally element) {
                this.processStatement((PsiElement)element, (PsiElement)element.getStatement(), new ModCommandAction[]{new PhpDeleteElementUnderControlStatementQuickFix((PsiElement)element)});
            }

            private void processStatement(@NotNull PsiElement parent, @Nullable PsiElement statement, ModCommandAction ... fix) {
                if (parent == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (fix == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.processStatement(parent, statement, () -> fix);
            }

            private boolean processStatement(@NotNull PsiElement parent, @Nullable PsiElement statement, Supplier<ModCommandAction[]> fixesSupplier) {
                PsiElement firstChild;
                if (parent == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (PhpStatementHasEmptyBodyInspection.isEmpty(statement, PhpStatementHasEmptyBodyInspection.this.myCommentsCountAsContent) && (firstChild = parent.getFirstChild()) != null) {
                    Object[] fixes = fixesSupplier.get();
                    if (!PhpStatementHasEmptyBodyInspection.this.myCommentsCountAsContent && !PhpStatementHasEmptyBodyInspection.isEmpty(statement, true)) {
                        fixes = (ModCommandAction[])ArrayUtil.append((Object[])fixes, (Object)new UpdateInspectionOptionFix((InspectionProfileEntry)PhpStatementHasEmptyBodyInspection.this, "myCommentsCountAsContent", PhpBundle.message("intention.family.name.count.comments.as.content", new Object[0]), true));
                    }
                    holder.registerProblem(firstChild, PhpBundle.message("inspection.php.statement.has.empty.body.description", new Object[0]), (LocalQuickFix[])ContainerUtil.map2Array((Object[])fixes, (Object[])LocalQuickFix.EMPTY_ARRAY, LocalQuickFix::from));
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parent";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "fix";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpStatementHasEmptyBodyInspection$1";
                objectArray[2] = "processStatement";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static ModCommandAction @NotNull [] createFixes(StatementWithArgument statement) {
        PsiUpdateModCommandAction deleteElementFix;
        PsiUpdateModCommandAction psiUpdateModCommandAction = deleteElementFix = statement instanceof ElseIf ? new PhpDeleteElementQuickFix((PsiElement)statement, DELETE_ELEMENT_FIX_NAME) : new PhpDeleteElementUnderControlStatementQuickFix((PsiElement)statement);
        if (!PhpSideEffectDetector.canContainSideEffect(statement.getArgument())) {
            ModCommandAction[] modCommandActionArray = new ModCommandAction[]{deleteElementFix};
            if (modCommandActionArray == null) {
                PhpStatementHasEmptyBodyInspection.$$$reportNull$$$0(1);
            }
            return modCommandActionArray;
        }
        PsiUpdateModCommandAction extractSideEffectFix = statement instanceof ElseIf ? new PhpExtractSideEffectFromElseIfQuickFix(statement) : new PhpExtractSideEffectQuickFix(statement);
        ModCommandAction[] modCommandActionArray = new ModCommandAction[]{extractSideEffectFix, deleteElementFix};
        if (modCommandActionArray == null) {
            PhpStatementHasEmptyBodyInspection.$$$reportNull$$$0(2);
        }
        return modCommandActionArray;
    }

    @Contract(value="null, _ -> false")
    private static boolean isEmpty(@Nullable PsiElement element, boolean commentCountAsContent) {
        if (element instanceof PhpSwitch) {
            return ((PhpSwitch)element).getAllCases().length == 0;
        }
        if (element instanceof PsiWhiteSpace) {
            return true;
        }
        if (element instanceof PsiComment) {
            return !commentCountAsContent;
        }
        if (element instanceof Statement) {
            PsiElement firstChild = element.getFirstChild();
            if (PhpPsiUtil.isOfType(firstChild, PhpTokenTypes.opSEMICOLON)) {
                return !commentCountAsContent || !(PhpPsiUtil.getPrevSiblingIgnoreWhitespace(element, true) instanceof PsiComment);
            }
            if (element instanceof GroupStatement) {
                return PhpStatementHasEmptyBodyInspection.isEmpty((GroupStatement)element, commentCountAsContent);
            }
        }
        return false;
    }

    private static boolean isEmpty(@NotNull GroupStatement statement, boolean commentsCountAsContent) {
        if (statement == null) {
            PhpStatementHasEmptyBodyInspection.$$$reportNull$$$0(3);
        }
        for (PsiElement s = statement.getFirstChild(); s != null; s = s.getNextSibling()) {
            if (PhpPsiUtil.isOfType(s, PhpTokenTypes.chLBRACE, PhpTokenTypes.chRBRACE) || PhpStatementHasEmptyBodyInspection.isEmpty(s, commentsCountAsContent)) continue;
            return false;
        }
        return !commentsCountAsContent || !(PhpPsiUtil.getPrevSiblingIgnoreWhitespace((PsiElement)statement, true) instanceof PsiComment) && !(PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)statement, true) instanceof PsiComment);
    }

    @Override
    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"myCommentsCountAsContent", (String)PhpBundle.message("inspection.statement.has.empty.body.comments.count.as.content", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"myIgnoreWhileWithoutBody", (String)PhpBundle.message("inspection.statement.has.empty.body.ignore.empty.while", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"myIgnoreForWithoutBody", (String)PhpBundle.message("inspection.statement.has.empty.body.ignore.empty.for", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            PhpStatementHasEmptyBodyInspection.$$$reportNull$$$0(4);
        }
        return optPane;
    }

    @Nullable
    private static Statement getInnerStatement(@NotNull PsiElement startElement) {
        if (startElement == null) {
            PhpStatementHasEmptyBodyInspection.$$$reportNull$$$0(5);
        }
        return startElement instanceof ControlStatement ? ((ControlStatement)startElement).getStatement() : (Statement)PhpPsiUtil.getChildByCondition(startElement, Statement.INSTANCEOF);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpStatementHasEmptyBodyInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpStatementHasEmptyBodyInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createFixes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isEmpty";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInnerStatement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4 -> new IllegalStateException(string);
        };
    }

    private static final class PhpDeleteElementUnderControlStatementQuickFix
    extends PsiUpdateModCommandAction<PsiElement> {
        private PhpDeleteElementUnderControlStatementQuickFix(PsiElement element) {
            super(element);
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            Statement innerStatement;
            PsiElement parent;
            if (context == null) {
                PhpDeleteElementUnderControlStatementQuickFix.$$$reportNull$$$0(0);
            }
            if (startElement == null) {
                PhpDeleteElementUnderControlStatementQuickFix.$$$reportNull$$$0(1);
            }
            if (updater == null) {
                PhpDeleteElementUnderControlStatementQuickFix.$$$reportNull$$$0(2);
            }
            if (((parent = startElement.getParent()) instanceof ControlStatement || parent instanceof Else) && (innerStatement = PhpStatementHasEmptyBodyInspection.getInnerStatement(startElement)) != null) {
                startElement.replace((PsiElement)innerStatement);
                return;
            }
            startElement.delete();
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = DELETE_ELEMENT_FIX_NAME;
            if (string == null) {
                PhpDeleteElementUnderControlStatementQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpStatementHasEmptyBodyInspection$PhpDeleteElementUnderControlStatementQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpStatementHasEmptyBodyInspection$PhpDeleteElementUnderControlStatementQuickFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private static final class PhpExtractSideEffectFromElseIfQuickFix
    extends PsiUpdateModCommandAction<StatementWithArgument> {
        private PhpExtractSideEffectFromElseIfQuickFix(StatementWithArgument statement) {
            super((PsiElement)statement);
        }

        protected void invoke(@NotNull ActionContext context, @NotNull StatementWithArgument startElement, @NotNull ModPsiUpdater updater) {
            PsiElement argument;
            if (context == null) {
                PhpExtractSideEffectFromElseIfQuickFix.$$$reportNull$$$0(0);
            }
            if (startElement == null) {
                PhpExtractSideEffectFromElseIfQuickFix.$$$reportNull$$$0(1);
            }
            if (updater == null) {
                PhpExtractSideEffectFromElseIfQuickFix.$$$reportNull$$$0(2);
            }
            if ((argument = startElement.getArgument()) != null) {
                Project project = context.project();
                GroupStatement elseIfStatement = PhpExtractSideEffectFromElseIfQuickFix.createStatement(project, (ElseIf)startElement);
                elseIfStatement.addAfter((PsiElement)PhpExtractSideEffectQuickFix.createStatement(project, argument), elseIfStatement.getFirstChild());
                startElement.replace((PsiElement)PhpPsiElementFactory.createPhpPsiFromText(project, Else.class, "if () {} else " + elseIfStatement.getText()));
            }
        }

        @NotNull
        private static GroupStatement createStatement(@NotNull Project project, @NotNull ElseIf startElement) {
            GroupStatement statement;
            if (project == null) {
                PhpExtractSideEffectFromElseIfQuickFix.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                PhpExtractSideEffectFromElseIfQuickFix.$$$reportNull$$$0(4);
            }
            if ((statement = (GroupStatement)ObjectUtils.tryCast((Object)startElement.getStatement(), GroupStatement.class)) != null && PhpPsiUtil.isOfType(statement.getFirstChild(), PhpTokenTypes.chLBRACE)) {
                GroupStatement groupStatement = (GroupStatement)statement.copy();
                if (groupStatement == null) {
                    PhpExtractSideEffectFromElseIfQuickFix.$$$reportNull$$$0(5);
                }
                return groupStatement;
            }
            String statementText = statement != null ? "{" + statement.getText() + "}" : "{}";
            GroupStatement groupStatement = PhpPsiElementFactory.createPhpPsiFromText(project, GroupStatementImpl.class, "if " + statementText);
            if (groupStatement == null) {
                PhpExtractSideEffectFromElseIfQuickFix.$$$reportNull$$$0(6);
            }
            return groupStatement;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = EXTRACT_SIDE_EFFECT_FIX_NAME;
            if (string == null) {
                PhpExtractSideEffectFromElseIfQuickFix.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpStatementHasEmptyBodyInspection$PhpExtractSideEffectFromElseIfQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpStatementHasEmptyBodyInspection$PhpExtractSideEffectFromElseIfQuickFix";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createStatement";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createStatement";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6, 7 -> new IllegalStateException(string);
            };
        }
    }

    private static final class PhpExtractSideEffectQuickFix
    extends PsiUpdateModCommandAction<StatementWithArgument> {
        private PhpExtractSideEffectQuickFix(StatementWithArgument statement) {
            super((PsiElement)statement);
        }

        protected void invoke(@NotNull ActionContext context, @NotNull StatementWithArgument startElement, @NotNull ModPsiUpdater updater) {
            PsiElement argument;
            if (context == null) {
                PhpExtractSideEffectQuickFix.$$$reportNull$$$0(0);
            }
            if (startElement == null) {
                PhpExtractSideEffectQuickFix.$$$reportNull$$$0(1);
            }
            if (updater == null) {
                PhpExtractSideEffectQuickFix.$$$reportNull$$$0(2);
            }
            if ((argument = startElement.getArgument()) != null) {
                startElement.replace((PsiElement)PhpExtractSideEffectQuickFix.createStatement(context.project(), argument));
            }
        }

        @NotNull
        private static Statement createStatement(@NotNull Project project, PsiElement argument) {
            if (project == null) {
                PhpExtractSideEffectQuickFix.$$$reportNull$$$0(3);
            }
            Statement statement = PhpPsiElementFactory.createStatement(project, argument.getText() + ";");
            if (statement == null) {
                PhpExtractSideEffectQuickFix.$$$reportNull$$$0(4);
            }
            return statement;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = EXTRACT_SIDE_EFFECT_FIX_NAME;
            if (string == null) {
                PhpExtractSideEffectQuickFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpStatementHasEmptyBodyInspection$PhpExtractSideEffectQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpStatementHasEmptyBodyInspection$PhpExtractSideEffectQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createStatement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "createStatement";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

