/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeSmell.PhpInstanceofIsAlwaysTrueInspection;
import com.jetbrains.php.lang.inspections.type.PhpCastIsUnnecessaryInspection;
import com.jetbrains.php.lang.inspections.type.PhpExpressionAlwaysConstantEvaluator;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public final class PhpStrictComparisonWithOperandsOfDifferentTypesInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpStrictComparisonWithOperandsOfDifferentTypesInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpBinaryExpression(BinaryExpression expression) {
                IElementType operationType = expression.getOperationType();
                if (operationType != PhpTokenTypes.opIDENTICAL && operationType != PhpTokenTypes.opNOT_IDENTICAL) {
                    return;
                }
                PsiElement left = expression.getLeftOperand();
                PhpType leftType = new PhpType().add(left);
                if (leftType.isEmpty()) {
                    return;
                }
                PsiElement right = expression.getRightOperand();
                PhpType rightType = new PhpType().add(right);
                if (rightType.isEmpty()) {
                    return;
                }
                if ((leftType = leftType.global(holder.getProject())).isAmbiguous()) {
                    return;
                }
                if ((rightType = rightType.global(holder.getProject())).isAmbiguous()) {
                    return;
                }
                if (PhpType.intersects(leftType, rightType) || PhpStrictComparisonWithOperandsOfDifferentTypesInspection.mayBeConvertableType(leftType, rightType, holder.getProject()) || PhpStrictComparisonWithOperandsOfDifferentTypesInspection.mayBeConvertableType(rightType, leftType, holder.getProject()) || PhpCastIsUnnecessaryInspection.parameterWithoutRealType(left) || PhpCastIsUnnecessaryInspection.parameterWithoutRealType(right)) {
                    return;
                }
                PsiElement operation = expression.getOperation();
                if (operation != null) {
                    holder.registerProblem(operation, PhpBundle.message("inspection.message.operands.have.incompatible.types", new Object[0]), PhpStrictComparisonWithOperandsOfDifferentTypesInspection.getFixes(expression, operationType == PhpTokenTypes.opIDENTICAL));
                }
            }
        };
    }

    public static boolean mayBeConvertableType(PhpType f, PhpType s, Project project) {
        PhpIndex index = PhpIndex.getInstance(project);
        for (String fType : f.getTypes()) {
            for (String sType : s.getTypes()) {
                if (!(PhpStrictComparisonWithOperandsOfDifferentTypesInspection.isPrimitiveType(fType) ? PhpType.intersects(new PhpType().add(fType), new PhpType().add(sType)) : new PhpType().add(fType).isConvertibleFrom(new PhpType().add(sType), index))) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isPrimitiveType(String fType) {
        return !PhpType.isNull(fType) && PhpType.isNotExtendablePrimitiveType(fType);
    }

    private static LocalQuickFix[] getFixes(BinaryExpression expression, boolean identical) {
        LocalQuickFix[] localQuickFixArray;
        if (identical) {
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[2];
            localQuickFixArray2[0] = PhpInstanceofIsAlwaysTrueInspection.getFixInternal(PhpExpressionAlwaysConstantEvaluator.ConstantValue.FALSE, (PsiElement)expression);
            localQuickFixArray = localQuickFixArray2;
            localQuickFixArray2[1] = PhpReplaceWithOperationQuickFix.REPLACE_WITH_EQUALS;
        } else {
            LocalQuickFix[] localQuickFixArray3 = new LocalQuickFix[2];
            localQuickFixArray3[0] = PhpInstanceofIsAlwaysTrueInspection.getFixInternal(PhpExpressionAlwaysConstantEvaluator.ConstantValue.TRUE, (PsiElement)expression);
            localQuickFixArray = localQuickFixArray3;
            localQuickFixArray3[1] = PhpReplaceWithOperationQuickFix.REPLACE_WITH_NOT_EQUALS;
        }
        return localQuickFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/probablyBug/PhpStrictComparisonWithOperandsOfDifferentTypesInspection", "buildVisitor"));
    }

    private static class PhpReplaceWithOperationQuickFix
    extends PsiUpdateModCommandQuickFix {
        private static final LocalQuickFix REPLACE_WITH_EQUALS = new PhpReplaceWithOperationQuickFix("==");
        private static final LocalQuickFix REPLACE_WITH_NOT_EQUALS = new PhpReplaceWithOperationQuickFix("!=");
        private final String myOperationText;

        private PhpReplaceWithOperationQuickFix(String operationText) {
            this.myOperationText = operationText;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with", this.myOperationText);
            if (string == null) {
                PhpReplaceWithOperationQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiElement operation;
            if (project == null) {
                PhpReplaceWithOperationQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpReplaceWithOperationQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpReplaceWithOperationQuickFix.$$$reportNull$$$0(3);
            }
            if ((operation = PhpPsiElementFactory.createPhpPsiFromText(project, BinaryExpression.class, "1 " + this.myOperationText + " 2").getOperation()) == null) {
                return;
            }
            element.replace(operation);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpStrictComparisonWithOperandsOfDifferentTypesInspection$PhpReplaceWithOperationQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpStrictComparisonWithOperandsOfDifferentTypesInspection$PhpReplaceWithOperationQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

