/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug;

import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.codeInsight.highlighting.PhpConversionSpecificationParser;
import com.jetbrains.php.codeInsight.highlighting.PhpHighlightFormatStringParametersHandlerFactory;
import com.jetbrains.php.codeInsight.highlighting.PhpHighlightFormatStringParametersUsagesHandler;
import com.jetbrains.php.codeInsight.typeInference.PhpVariableInferredTypeAnalyzerProcessor;
import com.jetbrains.php.lang.inspections.type.PhpArithmeticTypeCheckInspection;
import com.jetbrains.php.lang.inspections.type.PhpStrictTypeCheckingInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpEchoStatement;
import com.jetbrains.php.lang.psi.elements.PhpPrintExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpToStringImplementationVisitor
extends PhpElementVisitor {
    @Override
    public void visitPhpEchoStatement(PhpEchoStatement echoStatement) {
        PhpPsiElement[] arguments;
        for (PhpPsiElement argument : arguments = echoStatement.getArguments()) {
            this.checkToStringImplementation((PsiElement)argument);
        }
    }

    @Override
    public void visitPhpPrint(PhpPrintExpression printExpression) {
        this.checkToStringImplementation((PsiElement)printExpression.getArgument());
    }

    @Override
    public void visitPhpBinaryExpression(BinaryExpression expression) {
        if (expression.getOperationType() == PhpTokenTypes.opCONCAT) {
            this.checkToStringImplementation(expression.getLeftOperand());
            this.checkToStringImplementation(expression.getRightOperand());
        }
    }

    @Override
    public void visitPhpUnaryExpression(UnaryExpression expr) {
        if (PhpPsiUtil.isOfType(expr.getOperation(), PhpTokenTypes.opSTRING_CAST)) {
            this.checkToStringImplementation((PsiElement)expr.getValue());
        }
    }

    @Override
    public void visitPhpFunctionCall(FunctionReference reference) {
        if (!(reference instanceof MethodReference) && "\\strval".equals(reference.getFQN())) {
            this.checkToStringImplementation(reference.getParameter(0));
        }
        this.checkFormatFunctionParameters(reference);
    }

    private void checkFormatFunctionParameters(FunctionReference reference) {
        List<StringLiteralExpression> literals;
        MultiMap<Integer, PhpConversionSpecificationParser.ConversionSpecification> specificationsWithIndices;
        int formatStringIndex = PhpHighlightFormatStringParametersHandlerFactory.getFormatStringIndex(reference.getProject(), reference);
        PsiElement[] parameters = (PsiElement[])PhpStrictTypeCheckingInspection.unwrapSpreadOperator(reference.getParameters()).toArray((Object[])PsiElement.EMPTY_ARRAY);
        if (formatStringIndex >= 0 && formatStringIndex < parameters.length && (specificationsWithIndices = PhpHighlightFormatStringParametersUsagesHandler.getSpecificationsWithIndices(literals = PhpHighlightFormatStringParametersUsagesHandler.getLiterals(parameters[formatStringIndex]))) != null) {
            for (Map.Entry e : specificationsWithIndices.entrySet()) {
                PsiElement parameter;
                Integer index = (Integer)e.getKey();
                if (!ContainerUtil.exists((Iterable)((Iterable)e.getValue()), c -> c.getType() == 's') || (parameter = PhpHighlightFormatStringParametersUsagesHandler.getParameter(parameters, index)) == null || PhpPsiUtil.isArgumentUnpacking(parameter)) continue;
                this.checkToStringImplementation(parameter);
            }
        }
    }

    @Override
    public void visitPhpSelfAssignmentExpression(SelfAssignmentExpression expression) {
        PsiElement operation = expression.getOperation();
        if (PhpPsiUtil.isOfType(operation, PhpTokenTypes.opCONCAT_ASGN)) {
            this.checkToStringImplementation((PsiElement)expression.getVariable());
            this.checkToStringImplementation((PsiElement)expression.getValue());
        }
    }

    @Override
    public void visitPhpStringLiteralExpression(StringLiteralExpression expression) {
        for (PsiElement variable : PhpPsiUtil.getChildren((PsiElement)expression, Variable.INSTANCEOF)) {
            this.checkToStringImplementation(variable);
        }
    }

    @Override
    public void visitPhpVariable(Variable variable) {
        for (PsiElement child : variable.getChildren()) {
            if (!(child instanceof Variable)) continue;
            this.checkToStringImplementation(child);
        }
    }

    private void checkToStringImplementation(@Nullable PsiElement element) {
        if (!(element instanceof StringLiteralExpression) && element != null) {
            this.checkImplementation(element);
        }
    }

    protected abstract void checkImplementation(@NotNull PsiElement var1);

    @NotNull
    protected PhpType getToStringElementType(@NotNull PsiElement toStringElement) {
        if (toStringElement == null) {
            PhpToStringImplementationVisitor.$$$reportNull$$$0(0);
        }
        PhpType phpType = PhpVariableInferredTypeAnalyzerProcessor.isSelfAssignmentVariable(toStringElement, PhpTokenTypes.opCONCAT_ASGN) ? PhpArithmeticTypeCheckInspection.getTypeFromSelfAssignmentVariableWithoutCurrentExpression(toStringElement) : new PhpType().add(toStringElement);
        if (phpType == null) {
            PhpToStringImplementationVisitor.$$$reportNull$$$0(1);
        }
        return phpType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toStringElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpToStringImplementationVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpToStringImplementationVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getToStringElementType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getToStringElementType";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

