/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug;

import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.probablyBug.PhpSwitchCaseWithoutDefaultBranchInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ControlStatement;
import com.jetbrains.php.lang.psi.elements.PhpCase;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpEnumCase;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpMatchArm;
import com.jetbrains.php.lang.psi.elements.PhpMatchExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.elements.impl.PhpMatchExpressionImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.move.member.PhpMoveMemberProcessor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.MoreCollectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpUncoveredEnumCasesInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpUncoveredEnumCasesInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpMatchExpression(PhpMatchExpression matchExpression) {
                PhpExpression argument = matchExpression.getArgument();
                if (argument == null) {
                    return;
                }
                if (!PhpUncoveredEnumCasesInspection.getUncoveredEnumCasesIntersection(PhpMatchExpressionImpl.getAllConditions(matchExpression), argument).isEmpty()) {
                    PsiElement matchKeyword = matchExpression.getFirstChild();
                    if (matchExpression.getDefaultMatchArm() == null) {
                        holder.registerProblem(matchKeyword, PhpBundle.message("inspection.message.uncovered.enum.cases", new Object[0]), new LocalQuickFix[]{PhpAddMissingEnumCasesQuickFix.INSTANCE, LocalQuickFix.from((ModCommandAction)new PhpAnnotatorVisitor.PhpAddDefaultMatchArmQuickFix(matchKeyword))});
                    } else if (isOnTheFly) {
                        holder.registerProblem(matchKeyword, PhpBundle.message("inspection.message.uncovered.enum.cases", new Object[0]), ProblemHighlightType.INFORMATION, new LocalQuickFix[]{PhpAddMissingEnumCasesQuickFix.INSTANCE});
                    }
                }
            }

            @Override
            public void visitPhpSwitch(PhpSwitch switchStatement) {
                PhpExpression argument = (PhpExpression)ObjectUtils.tryCast((Object)switchStatement.getArgument(), PhpExpression.class);
                if (argument == null) {
                    return;
                }
                if (!PhpUncoveredEnumCasesInspection.getUncoveredEnumCasesIntersection(ContainerUtil.map((Object[])switchStatement.getCases(), ControlStatement::getCondition), argument).isEmpty()) {
                    PsiElement switchKeyword = switchStatement.getFirstChild();
                    if (switchStatement.getDefaultCase() == null) {
                        holder.registerProblem(switchKeyword, PhpBundle.message("inspection.message.uncovered.enum.cases.switch", new Object[0]), new LocalQuickFix[]{PhpAddMissingEnumCasesInSwitchStatementQuickFix.INSTANCE});
                    } else if (isOnTheFly) {
                        holder.registerProblem(switchKeyword, PhpBundle.message("inspection.message.uncovered.enum.cases.switch", new Object[0]), ProblemHighlightType.INFORMATION, new LocalQuickFix[]{PhpAddMissingEnumCasesInSwitchStatementQuickFix.INSTANCE});
                    }
                }
            }
        };
    }

    @NotNull
    private static Collection<PhpEnumCase> getUncoveredEnumCasesIntersection(@NotNull Collection<? extends PhpPsiElement> conditions, @NotNull PhpExpression argument) {
        Collection<PhpClass> enums;
        if (conditions == null) {
            PhpUncoveredEnumCasesInspection.$$$reportNull$$$0(1);
        }
        if (argument == null) {
            PhpUncoveredEnumCasesInspection.$$$reportNull$$$0(2);
        }
        if ((enums = PhpUncoveredEnumCasesInspection.multiResolveEnum(argument.getProject(), argument)).isEmpty()) {
            List<PhpEnumCase> list = Collections.emptyList();
            if (list == null) {
                PhpUncoveredEnumCasesInspection.$$$reportNull$$$0(3);
            }
            return list;
        }
        Collection<PhpEnumCase> uncoveredEnumCases = PhpUncoveredEnumCasesInspection.getUncoveredEnumCases(conditions, (PhpClass)ContainerUtil.getFirstItem(enums));
        if (enums.size() == 1) {
            Collection<PhpEnumCase> collection = uncoveredEnumCases;
            if (collection == null) {
                PhpUncoveredEnumCasesInspection.$$$reportNull$$$0(4);
            }
            return collection;
        }
        Set caseNamesIntersection = (Set)StreamEx.of(enums).map(e -> ContainerUtil.map(PhpUncoveredEnumCasesInspection.getUncoveredEnumCases(conditions, e), PhpNamedElement::getName)).collect(MoreCollectors.intersecting());
        List list = ContainerUtil.filter(uncoveredEnumCases, enumCase -> caseNamesIntersection.contains(enumCase.getName()));
        if (list == null) {
            PhpUncoveredEnumCasesInspection.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    static Collection<PhpClass> multiResolveEnum(@NotNull Project project, @NotNull PhpExpression argument) {
        Map<String, List<PhpClass>> fqnToEnums;
        if (project == null) {
            PhpUncoveredEnumCasesInspection.$$$reportNull$$$0(6);
        }
        if (argument == null) {
            PhpUncoveredEnumCasesInspection.$$$reportNull$$$0(7);
        }
        if ((fqnToEnums = argument.getGlobalType().getTypes().stream().flatMap(ts -> PhpIndex.getInstance(project).getAnyByFQN((String)ts).stream()).filter(PhpClass::isEnum).collect(Collectors.groupingBy(PhpNamedElement::getFQN))).size() != 1) {
            List<PhpClass> list = Collections.emptyList();
            if (list == null) {
                PhpUncoveredEnumCasesInspection.$$$reportNull$$$0(8);
            }
            return list;
        }
        Collection collection = (Collection)((Map.Entry)ContainerUtil.getOnlyItem(fqnToEnums.entrySet())).getValue();
        if (collection == null) {
            PhpUncoveredEnumCasesInspection.$$$reportNull$$$0(9);
        }
        return collection;
    }

    @NotNull
    private static Collection<PhpEnumCase> getUncoveredEnumCases(@NotNull Collection<? extends PhpPsiElement> conditions, @NotNull PhpClass onlyEnum) {
        if (conditions == null) {
            PhpUncoveredEnumCasesInspection.$$$reportNull$$$0(10);
        }
        if (onlyEnum == null) {
            PhpUncoveredEnumCasesInspection.$$$reportNull$$$0(11);
        }
        HashSet<PhpEnumCase> resolvedElements = new HashSet<PhpEnumCase>();
        for (PhpPsiElement phpPsiElement : conditions) {
            Collection<PhpEnumCase> cases;
            if (phpPsiElement instanceof ClassConstantReference && !(cases = ((PhpReference)phpPsiElement).multiResolveStrict(PhpEnumCase.class)).isEmpty()) {
                resolvedElements.addAll(cases);
                continue;
            }
            List<PhpEnumCase> list = Collections.emptyList();
            if (list == null) {
                PhpUncoveredEnumCasesInspection.$$$reportNull$$$0(12);
            }
            return list;
        }
        Collection collection = (Collection)((StreamEx)StreamEx.of(onlyEnum.getEnumCases()).filter(enumCase -> !resolvedElements.contains(enumCase))).collect(Collectors.toList());
        if (collection == null) {
            PhpUncoveredEnumCasesInspection.$$$reportNull$$$0(13);
        }
        return collection;
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP810;
    }

    @NotNull
    private static String getConditionText(@NotNull PhpPsiElement element, PhpEnumCase enumCase) {
        if (element == null) {
            PhpUncoveredEnumCasesInspection.$$$reportNull$$$0(14);
        }
        PhpClass enumClass = enumCase.getContainingClass();
        assert (enumClass != null);
        String qualifiedName = PhpMoveMemberProcessor.importClassAndGetName(element, Collections.emptyList(), enumClass.getFQN());
        String string = qualifiedName + "::" + enumCase.getName();
        if (string == null) {
            PhpUncoveredEnumCasesInspection.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 8, 9, 12, 13, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditions";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpUncoveredEnumCasesInspection";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onlyEnum";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpUncoveredEnumCasesInspection";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUncoveredEnumCasesIntersection";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveEnum";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getUncoveredEnumCases";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getConditionText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getUncoveredEnumCasesIntersection";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 15: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveEnum";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getUncoveredEnumCases";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getConditionText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 8, 9, 12, 13, 15 -> new IllegalStateException(string);
        };
    }

    public static class PhpAddMissingEnumCasesInSwitchStatementQuickFix
    extends ModCommandQuickFix
    implements PriorityAction {
        private static final LocalQuickFix INSTANCE = new PhpAddMissingEnumCasesInSwitchStatementQuickFix();

        @NotNull
        public PriorityAction.Priority getPriority() {
            PriorityAction.Priority priority = PriorityAction.Priority.TOP;
            if (priority == null) {
                PhpAddMissingEnumCasesInSwitchStatementQuickFix.$$$reportNull$$$0(0);
            }
            return priority;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.add.remaining.enum.cases", new Object[0]);
            if (string == null) {
                PhpAddMissingEnumCasesInSwitchStatementQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public ModCommand perform(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpAddMissingEnumCasesInSwitchStatementQuickFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                PhpAddMissingEnumCasesInSwitchStatementQuickFix.$$$reportNull$$$0(3);
            }
            PhpSwitch switchStatement = PhpPsiUtil.getParentOfClass(descriptor.getStartElement(), PhpSwitch.class);
            assert (switchStatement != null);
            PhpExpression argument = (PhpExpression)ObjectUtils.tryCast((Object)switchStatement.getArgument(), PhpExpression.class);
            assert (argument != null);
            List conditions = ContainerUtil.map((Object[])switchStatement.getCases(), ControlStatement::getCondition);
            Collection<PhpEnumCase> uncoveredCases = PhpUncoveredEnumCasesInspection.getUncoveredEnumCasesIntersection(conditions, argument);
            ModCommand modCommand = ModCommand.psiUpdate((PsiElement)switchStatement, (writableSwitchStatement, updater) -> {
                for (PhpEnumCase enumCase : uncoveredCases) {
                    String text = "switch(a){ case " + PhpUncoveredEnumCasesInspection.getConditionText(writableSwitchStatement, enumCase) + ": throw new \\Exception('To be implemented');}";
                    PhpCase phpCase = PhpPsiElementFactory.createPhpPsiFromText(project, PhpCase.class, text);
                    PhpSwitchCaseWithoutDefaultBranchInspection.PhpAddDefaultSwitchCaseQuickFix.insertSwitchCase(writableSwitchStatement, phpCase);
                }
            });
            if (modCommand == null) {
                PhpAddMissingEnumCasesInSwitchStatementQuickFix.$$$reportNull$$$0(4);
            }
            return modCommand;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpUncoveredEnumCasesInspection$PhpAddMissingEnumCasesInSwitchStatementQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPriority";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpUncoveredEnumCasesInspection$PhpAddMissingEnumCasesInSwitchStatementQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "perform";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class PhpAddMissingEnumCasesQuickFix
    extends ModCommandQuickFix
    implements PriorityAction {
        public static final String MATCH_BODY_TEXT = "throw new \\Exception('To be implemented')";
        private static final LocalQuickFix INSTANCE = new PhpAddMissingEnumCasesQuickFix();

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.add.remaining.enum.cases", new Object[0]);
            if (string == null) {
                PhpAddMissingEnumCasesQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public ModCommand perform(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpAddMissingEnumCasesQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpAddMissingEnumCasesQuickFix.$$$reportNull$$$0(2);
            }
            PhpMatchExpression matchExpression = PhpPsiUtil.getParentOfClass(descriptor.getPsiElement(), PhpMatchExpression.class);
            assert (matchExpression != null && matchExpression.getArgument() != null);
            Collection<PhpExpression> conditions = PhpMatchExpressionImpl.getAllConditions(matchExpression);
            Collection<PhpEnumCase> uncoveredCases = PhpUncoveredEnumCasesInspection.getUncoveredEnumCasesIntersection(conditions, matchExpression.getArgument());
            ModCommand modCommand = ModCommand.psiUpdate((PsiElement)matchExpression, (writableMatchExpression, updater) -> {
                for (PhpEnumCase enumCase : uncoveredCases) {
                    PhpMatchArm matchArm = PhpPsiElementFactory.createMatchArm(project, PhpUncoveredEnumCasesInspection.getConditionText(matchExpression, enumCase), MATCH_BODY_TEXT);
                    PhpAddMissingEnumCasesQuickFix.appendMatchArm(project, writableMatchExpression, (PsiElement)matchArm);
                }
            });
            if (modCommand == null) {
                PhpAddMissingEnumCasesQuickFix.$$$reportNull$$$0(3);
            }
            return modCommand;
        }

        @NotNull
        public PriorityAction.Priority getPriority() {
            PriorityAction.Priority priority = PriorityAction.Priority.TOP;
            if (priority == null) {
                PhpAddMissingEnumCasesQuickFix.$$$reportNull$$$0(4);
            }
            return priority;
        }

        public static void appendMatchArm(@NotNull Project project, @NotNull PhpMatchExpression matchExpression, @NotNull PsiElement matchArm) {
            if (project == null) {
                PhpAddMissingEnumCasesQuickFix.$$$reportNull$$$0(5);
            }
            if (matchExpression == null) {
                PhpAddMissingEnumCasesQuickFix.$$$reportNull$$$0(6);
            }
            if (matchArm == null) {
                PhpAddMissingEnumCasesQuickFix.$$$reportNull$$$0(7);
            }
            if (!matchExpression.getMatchArms().isEmpty()) {
                PhpMatchArm lastMatchArm = (PhpMatchArm)ContainerUtil.getLastItem(matchExpression.getMatchArms());
                PsiElement comma = matchExpression.addAfter(PhpPsiElementFactory.createComma(project), (PsiElement)lastMatchArm);
                matchExpression.addAfter(matchArm, comma);
            } else {
                PsiElement newMatchArm = matchExpression.addAfter(matchArm, PhpPsiUtil.getChildOfType((PsiElement)matchExpression, PhpTokenTypes.chLBRACE));
                matchExpression.addAfter(PhpPsiElementFactory.createComma(project), newMatchArm);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 5, 6, 7 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpUncoveredEnumCasesInspection$PhpAddMissingEnumCasesQuickFix";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matchExpression";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matchArm";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpUncoveredEnumCasesInspection$PhpAddMissingEnumCasesQuickFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "perform";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPriority";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "appendMatchArm";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 5, 6, 7 -> new IllegalArgumentException(string);
            };
        }
    }
}

