/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ASTNode;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ConcatenationExpression;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.impl.MemberReferenceImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpWrongStringConcatenationInspection
extends PhpInspection {
    private static final ReplacePlusToConcatQuickFix REPLACE_PLUS_TO_CONCAT_FIX = new ReplacePlusToConcatQuickFix();
    public static final String REPLACE_PLUS_TO_CONCAT_FIX_NAME = REPLACE_PLUS_TO_CONCAT_FIX.getName();
    private static final ReplacePlusAsgnToConcatAsgnQuickFix REPLACE_PLUS_ASGN_TO_CONCAT_ASGN_FIX = new ReplacePlusAsgnToConcatAsgnQuickFix();
    public static final String REPLACE_PLUS_ASGN_TO_CONCAT_ASGN_FIX_NAME = REPLACE_PLUS_ASGN_TO_CONCAT_ASGN_FIX.getName();
    public boolean DISABLE_FOR_MAGIC_PROPERTIES = false;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpWrongStringConcatenationInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpBinaryExpression(BinaryExpression expression) {
                if (PhpTokenTypes.opPLUS == expression.getOperationType()) {
                    int numberOfStrings = PhpWrongStringConcatenationInspection.this.checkOperands(expression.getLeftOperand(), expression.getRightOperand());
                    PhpWrongStringConcatenationInspection.inspect(expression, numberOfStrings, isOnTheFly, holder, (LocalQuickFix)REPLACE_PLUS_TO_CONCAT_FIX);
                }
            }

            @Override
            public void visitPhpSelfAssignmentExpression(SelfAssignmentExpression expression) {
                PsiElement operation = expression.getOperation();
                if (operation == null) {
                    return;
                }
                if (PhpPsiUtil.isOfType(operation, PhpTokenTypes.opPLUS_ASGN)) {
                    int numberOfStrings = PhpWrongStringConcatenationInspection.this.checkOperands((PsiElement)expression.getVariable(), (PsiElement)expression.getValue());
                    PhpWrongStringConcatenationInspection.inspect(expression, numberOfStrings, isOnTheFly, holder, (LocalQuickFix)REPLACE_PLUS_ASGN_TO_CONCAT_ASGN_FIX);
                }
            }
        };
    }

    private static void inspect(PhpExpression expression, int numberOfStrings, boolean isOnTheFly, @NotNull ProblemsHolder holder, LocalQuickFix quickFix) {
        if (holder == null) {
            PhpWrongStringConcatenationInspection.$$$reportNull$$$0(1);
        }
        if (numberOfStrings >= 1) {
            String message = PhpWrongStringConcatenationInspection.getInspectionMessage(isOnTheFly);
            if (numberOfStrings == 2) {
                holder.registerProblem((PsiElement)expression, message, new LocalQuickFix[]{quickFix});
            } else {
                holder.registerProblem((PsiElement)expression, message, LocalQuickFix.EMPTY_ARRAY);
            }
        }
    }

    @InspectionMessage
    private static String getInspectionMessage(boolean isOnTheFly) {
        return isOnTheFly ? PhpBundle.message("inspection.wrong.string.concatenation.operator.problem", new Object[0]) : PhpBundle.message("inspection.wrong.string.concatenation.operator.problem.batch", new Object[0]);
    }

    private int checkOperands(@Nullable PsiElement leftOperand, @Nullable PsiElement rightOperand) {
        PhpTypedElement typedLeftOperand;
        block6: {
            block5: {
                if (!(leftOperand instanceof PhpTypedElement)) break block5;
                typedLeftOperand = (PhpTypedElement)leftOperand;
                if (rightOperand instanceof PhpTypedElement) break block6;
            }
            return 0;
        }
        PhpTypedElement typedRightOperand = (PhpTypedElement)rightOperand;
        Project project = leftOperand.getProject();
        int answer = 0;
        if (this.isString(typedLeftOperand, project)) {
            ++answer;
        }
        if (this.isString(typedRightOperand, project)) {
            ++answer;
        }
        return answer;
    }

    private boolean isString(PhpTypedElement element, Project project) {
        if (element instanceof FieldReference && this.isTypeTricky(element, project)) {
            return false;
        }
        return PhpType.globalTypeEquals(element, PhpType.STRING);
    }

    private boolean isTypeTricky(PhpTypedElement element, Project project) {
        FieldReference reference = (FieldReference)element;
        ASTNode nameNode = reference.getNameNode();
        if (nameNode == null || PhpPsiUtil.isOfType(nameNode, PhpStubElementTypes.VARIABLE)) {
            return true;
        }
        PhpExpression classReference = reference.getClassReference();
        if (MemberReferenceImpl.chainIsTooDeep(classReference)) {
            return true;
        }
        return this.DISABLE_FOR_MAGIC_PROPERTIES && PhpWrongStringConcatenationInspection.isAccessedViaMagicMethod(project, reference, classReference);
    }

    private static boolean isAccessedViaMagicMethod(Project project, FieldReference reference, PhpExpression classReference) {
        PhpIndex index;
        PhpType type;
        return classReference instanceof PhpReference && reference.getReferenceType() == PhpModifier.State.DYNAMIC && PhpCodeInsightUtil.hasMagicMethod(type = classReference.getGlobalType(), index = PhpIndex.getInstance(project), reference.isWriteAccess() ? "__set" : "__get") && reference.multiResolve(false).length == 0 && ((PhpReference)classReference).multiResolve(false).length > 0;
    }

    @Override
    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"DISABLE_FOR_MAGIC_PROPERTIES", (String)PhpBundle.message("inspection.wrong.string.concatenation.operator.option.ignore.magic", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            PhpWrongStringConcatenationInspection.$$$reportNull$$$0(2);
        }
        return optPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpWrongStringConcatenationInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpWrongStringConcatenationInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "inspect";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static class ReplacePlusToConcatQuickFix
    extends PsiUpdateModCommandQuickFix {
        private ReplacePlusToConcatQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("replace.plus.to.concat.quick.fix.family.name", new Object[0]);
            if (string == null) {
                ReplacePlusToConcatQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            BinaryExpression binaryExpression;
            PsiElement operation;
            if (project == null) {
                ReplacePlusToConcatQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                ReplacePlusToConcatQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ReplacePlusToConcatQuickFix.$$$reportNull$$$0(3);
            }
            if ((operation = (binaryExpression = (BinaryExpression)element).getOperation()) != null) {
                int operationOffset = operation.getStartOffsetInParent();
                String currentText = binaryExpression.getText();
                String newText = currentText.substring(0, operationOffset) + "." + currentText.substring(operationOffset + 1);
                ConcatenationExpression result = PhpPsiElementFactory.createFirstFromText(project, ConcatenationExpression.class, newText);
                assert (result != null);
                binaryExpression.replace((PsiElement)result);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpWrongStringConcatenationInspection$ReplacePlusToConcatQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpWrongStringConcatenationInspection$ReplacePlusToConcatQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class ReplacePlusAsgnToConcatAsgnQuickFix
    extends PsiUpdateModCommandQuickFix {
        private ReplacePlusAsgnToConcatAsgnQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("replace.plus.asgn.to.concat.asgn.quick.fix.family.name", new Object[0]);
            if (string == null) {
                ReplacePlusAsgnToConcatAsgnQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                ReplacePlusAsgnToConcatAsgnQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                ReplacePlusAsgnToConcatAsgnQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                ReplacePlusAsgnToConcatAsgnQuickFix.$$$reportNull$$$0(3);
            }
            SelfAssignmentExpression selfAssignmentExpression = (SelfAssignmentExpression)element;
            selfAssignmentExpression.getOperation().replace(PhpPsiElementFactory.createOpConcatAsgn(project));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/PhpWrongStringConcatenationInspection$ReplacePlusAsgnToConcatAsgnQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/PhpWrongStringConcatenationInspection$ReplacePlusAsgnToConcatAsgnQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

