/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.psr0;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.refactoring.move.namespace.PhpMoveNamespaceProcessor;
import com.jetbrains.php.refactoring.move.namespace.PhpMoveNamespaceUsage;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

class FixPackagePathFix
implements LocalQuickFix {
    private final String myNewPackage;
    private String myOldPackage;

    FixPackagePathFix(String newPackage, String oldPackage) {
        this.myNewPackage = newPackage;
        this.myOldPackage = oldPackage;
    }

    @NotNull
    public String getName() {
        String string = PhpBundle.message("fix.package.text", FixPackagePathFix.fixName(this.myOldPackage), FixPackagePathFix.fixName(this.myNewPackage));
        if (string == null) {
            FixPackagePathFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static String fixName(@NotNull String name) {
        if (name == null) {
            FixPackagePathFix.$$$reportNull$$$0(1);
        }
        return StringUtil.isEmpty((String)name) ? "\\" : name;
    }

    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("fix.package.text.family", new Object[0]);
        if (string == null) {
            FixPackagePathFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PhpNamespace phpNamespace;
        if (project == null) {
            FixPackagePathFix.$$$reportNull$$$0(3);
        }
        if (descriptor == null) {
            FixPackagePathFix.$$$reportNull$$$0(4);
        }
        if ((phpNamespace = PhpPsiUtil.getParentOfClass(descriptor.getPsiElement(), PhpNamespace.class)) != null) {
            new PhpMoveNamespaceProcessor(project, Collections.singletonList(phpNamespace), this.myNewPackage, Collections.emptyMap(), false, false){}.run();
        }
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        PhpNamespace phpNamespace;
        if (project == null) {
            FixPackagePathFix.$$$reportNull$$$0(5);
        }
        if (previewDescriptor == null) {
            FixPackagePathFix.$$$reportNull$$$0(6);
        }
        if ((phpNamespace = PhpPsiUtil.getParentOfClass(previewDescriptor.getPsiElement(), PhpNamespace.class)) == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                FixPackagePathFix.$$$reportNull$$$0(7);
            }
            return intentionPreviewInfo;
        }
        PhpMoveNamespaceUsage.PhpMoveNamespaceDeclaration.moveNamespace(phpNamespace, this.myNewPackage);
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
        if (intentionPreviewInfo == null) {
            FixPackagePathFix.$$$reportNull$$$0(8);
        }
        return intentionPreviewInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/psr0/FixPackagePathFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/psr0/FixPackagePathFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "fixName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

