/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.psr0;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.testIntegration.TestFinderHelper;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.psr0.MoveClassToSeparateFileFix;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import org.apache.http.util.LangUtils;
import org.jetbrains.annotations.NotNull;

public final class PhpMultipleClassesDeclarationsInOneFile
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpMultipleClassesDeclarationsInOneFile.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpFile(PhpFile phpFile) {
                Collection<PhpClass> classes;
                ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)phpFile.getProject()).getFileIndex();
                if (!fileIndex.isInSourceContent(phpFile.getVirtualFile())) {
                    return;
                }
                Collection<PhpClass> collection = classes = fileIndex.isInTestSourceContent(phpFile.getVirtualFile()) ? PhpPsiUtil.findClasses(phpFile, (Condition<? super PhpClass>)((Condition)TestFinderHelper::isTest)) : PhpPsiUtil.findAllClasses(phpFile);
                if (classes.size() > 1) {
                    for (PhpClass it : classes) {
                        LocalQuickFix[] localQuickFixArray;
                        PsiElement identifier = it.getNameIdentifier();
                        if (identifier == null || LangUtils.equals((Object)FileUtil.getNameWithoutExtension((String)identifier.getContainingFile().getName()), (Object)it.getNameCS())) continue;
                        String string = PhpBundle.message("inspection.multiple.classes.declarations.in.one.file", new Object[0]);
                        if (isOnTheFly) {
                            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                            localQuickFixArray = localQuickFixArray2;
                            localQuickFixArray2[0] = MoveClassToSeparateFileFix.INSTANCE;
                        } else {
                            localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                        }
                        holder.registerProblem(identifier, string, localQuickFixArray);
                    }
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/psr0/PhpMultipleClassesDeclarationsInOneFile", "buildVisitor"));
    }
}

