/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.psr12;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class PhpModifierOrderInspection
extends PhpInspection
implements CleanupLocalInspectionTool {
    TokenSet beforeSet = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.kwABSTRACT, PhpTokenTypes.kwFINAL});

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpModifierOrderInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpModifierList(PhpModifierList modifierList) {
                Object[] children = modifierList.getNode().getChildren(PhpTokenTypes.tsMODIFIERS);
                if (ArrayUtil.isEmpty((Object[])children)) {
                    return;
                }
                ASTNode visibilityNode = (ASTNode)ContainerUtil.find((Object[])children, i1 -> PhpTokenTypes.tsVISIBILITY_MODIFIERS.contains(i1.getElementType()));
                ASTNode staticNode = (ASTNode)ContainerUtil.find((Object[])children, i -> PhpTokenTypes.kwSTATIC.equals(i.getElementType()));
                boolean wrongOrder = false;
                for (int i2 = 0; i2 < children.length; ++i2) {
                    IElementType elementType = children[i2].getElementType();
                    if (!(PhpModifierOrderInspection.this.beforeSet.contains(elementType) && (visibilityNode != null && i2 > ArrayUtil.indexOf((Object[])children, (Object)visibilityNode) || staticNode != null && i2 > ArrayUtil.indexOf((Object[])children, (Object)staticNode))) && (elementType != PhpTokenTypes.kwSTATIC || visibilityNode == null || i2 >= ArrayUtil.indexOf((Object[])children, (Object)visibilityNode))) continue;
                    wrongOrder = true;
                }
                if (wrongOrder) {
                    holder.problem((PsiElement)modifierList, PhpBundle.message("inspection.message.psr.order.modifiers.incorrect", new Object[0])).fix((ModCommandAction)new PhpFixModifierOrderQuickFix(modifierList)).register();
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/psr12/PhpModifierOrderInspection", "buildVisitor"));
    }

    private static final class PhpFixModifierOrderQuickFix
    extends PsiUpdateModCommandAction<PhpModifierList> {
        PhpFixModifierOrderQuickFix(@NotNull PhpModifierList list) {
            if (list == null) {
                PhpFixModifierOrderQuickFix.$$$reportNull$$$0(0);
            }
            super((PsiElement)list);
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("psr.12.fix.modifiers.order", new Object[0]);
            if (string == null) {
                PhpFixModifierOrderQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PhpModifierList element, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpFixModifierOrderQuickFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                PhpFixModifierOrderQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                PhpFixModifierOrderQuickFix.$$$reportNull$$$0(4);
            }
            String builder2 = (element.hasAbstract() ? "abstract " : "") + (element.hasFinal() ? "final " : "") + (element.hasPublic() ? "public " : "") + (element.hasPrivate() ? "private " : "") + (element.hasProtected() ? "protected " : "") + (element.hasStatic() ? "static " : "");
            PsiElement newModifierList = PhpPsiElementFactory.createMethod(context.project(), builder2 + " function foo();").getFirstChild();
            element.replace(newModifierList);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/psr12/PhpModifierOrderInspection$PhpFixModifierOrderQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/psr12/PhpModifierOrderInspection$PhpFixModifierOrderQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

