/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.intentions.PhpDeclareFieldIntention;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpAddFieldDeclarationQuickFix
extends ModCommandQuickFix {
    public static final PhpAddFieldDeclarationQuickFix INSTANCE = new PhpAddFieldDeclarationQuickFix();

    protected PhpAddFieldDeclarationQuickFix() {
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static PsiElement createField(@NotNull Project project, @NotNull PhpClass klass, @NotNull String fieldName, @Nullable PhpType type, boolean staticRef, PhpModifier.Access access) {
        if (project == null) {
            PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(0);
        }
        if (klass == null) {
            PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(1);
        }
        if (fieldName == null) {
            PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(2);
        }
        if (!IntentionPreviewUtils.isPreviewElement((PsiElement)klass) && !ModuleUtilCore.projectContainsFile((Project)project, (VirtualFile)klass.getContainingFile().getVirtualFile(), (boolean)false)) {
            Messages.showErrorDialog((Project)project, (String)PhpBundle.message("the.original.class.0.does.not.belong.to.the.project.and.cannot.be.modified", klass.getName()), (String)PhpBundle.message("quick.fix.error", new Object[0]));
            return null;
        }
        PhpModifier modifier = PhpModifier.instance(access, PhpModifier.Abstractness.IMPLEMENTED, staticRef ? PhpModifier.State.STATIC : PhpModifier.State.DYNAMIC);
        return PhpPsiElementFactory.createClassField(project, modifier, false, fieldName, null, PhpRefactoringUtil.createFieldTypeDeclaration(project, type, (PsiElement)klass));
    }

    @NotNull
    public String getName() {
        String string = PhpBundle.message("php.add.field.declaration.quick.fix.text", new Object[0]);
        if (string == null) {
            PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public ModCommand perform(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement fieldNameElement;
        MemberReference reference;
        if (project == null) {
            PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(5);
        }
        if (descriptor == null) {
            PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(6);
        }
        if ((reference = PhpPsiUtil.getParentOfClass(fieldNameElement = descriptor.getPsiElement(), false, MemberReference.class)) == null) {
            ModCommand modCommand = ModCommand.nop();
            if (modCommand == null) {
                PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(7);
            }
            return modCommand;
        }
        PhpClass klass = PhpQuickFixBase.resolveClass(reference, true);
        if (klass == null) {
            ModCommand modCommand = ModCommand.nop();
            if (modCommand == null) {
                PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(8);
            }
            return modCommand;
        }
        if (!ModuleUtilCore.projectContainsFile((Project)project, (VirtualFile)klass.getContainingFile().getVirtualFile(), (boolean)false)) {
            ModCommand modCommand = ModCommand.error((String)PhpBundle.message("the.original.class.0.does.not.belong.to.the.project.and.cannot.be.modified", klass.getName()));
            if (modCommand == null) {
                PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(9);
            }
            return modCommand;
        }
        ModCommand modCommand = ModCommand.psiUpdate((PsiElement)klass, (writableClass, updater) -> this.doFix((ModPsiUpdater)updater, (PhpClass)writableClass, reference, fieldNameElement));
        if (modCommand == null) {
            PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(10);
        }
        return modCommand;
    }

    protected void doFix(@NotNull ModPsiUpdater updater, @NotNull PhpClass klass, @NotNull MemberReference reference, @NotNull PsiElement fieldNameElement) {
        if (updater == null) {
            PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(11);
        }
        if (klass == null) {
            PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(12);
        }
        if (reference == null) {
            PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(13);
        }
        if (fieldNameElement == null) {
            PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(14);
        }
        PhpDeclareFieldIntention.insertFieldFromUsage(klass, reference, fieldNameElement.getText(), updater);
    }

    public static void runTemplate(@NotNull PsiElement element, @NotNull Template template, @Nullable TemplateEditingListener listener) {
        if (element == null) {
            PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(15);
        }
        if (template == null) {
            PhpAddFieldDeclarationQuickFix.$$$reportNull$$$0(16);
        }
        Project project = element.getProject();
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return;
        }
        VirtualFile vFile = psiFile.getVirtualFile();
        if (vFile == null) {
            return;
        }
        Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, vFile), true);
        if (editor != null) {
            TextRange range = element.getTextRange();
            WriteAction.run(() -> {
                editor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
                editor.getCaretModel().moveToOffset(range.getStartOffset());
                TemplateManager.getInstance((Project)project).startTemplate(editor, template, listener);
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 7, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/PhpAddFieldDeclarationQuickFix";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldNameElement";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpAddFieldDeclarationQuickFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "perform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createField";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doFix";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "runTemplate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 7, 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

