/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpChangeMethodModifiersQuickFix
extends PsiUpdateModCommandQuickFix {
    public static final LocalQuickFix CHANGE_TO_PUBLIC_STATIC = new PhpChangeMethodModifiersQuickFix(PhpModifier.PUBLIC_IMPLEMENTED_STATIC);
    public static final LocalQuickFix CHANGE_TO_PUBLIC = new PhpChangeMethodModifiersQuickFix(PhpModifier.PUBLIC_IMPLEMENTED_DYNAMIC);
    private final PhpModifier myModifier;

    public PhpChangeMethodModifiersQuickFix(@Nullable PhpModifier modifier) {
        this.myModifier = modifier;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = this.myModifier != null ? PhpBundle.message("change.method.modifiers.to.0", this.myModifier.toString()) : PhpBundle.message("php.change.method.modifiers.quick.fix.text", new Object[0]);
        if (string == null) {
            PhpChangeMethodModifiersQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("php.change.method.modifiers.quick.fix.family.name", new Object[0]);
        if (string == null) {
            PhpChangeMethodModifiersQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        Method method;
        if (project == null) {
            PhpChangeMethodModifiersQuickFix.$$$reportNull$$$0(2);
        }
        if (element == null) {
            PhpChangeMethodModifiersQuickFix.$$$reportNull$$$0(3);
        }
        if (updater == null) {
            PhpChangeMethodModifiersQuickFix.$$$reportNull$$$0(4);
        }
        if ((method = PhpPsiUtil.getParentOfClass(element, false, Method.class)) == null) {
            return;
        }
        PhpChangeMethodModifiersQuickFix.changeMethodModifier(method, this.myModifier);
    }

    public static void changeMethodModifier(@NotNull Method method, PhpModifier modifier) {
        if (method == null) {
            PhpChangeMethodModifiersQuickFix.$$$reportNull$$$0(5);
        }
        Object oldModifierList = PhpPsiUtil.getChildByCondition(method, (Condition<? super PsiElement>)((Condition)PhpModifierList.class::isInstance));
        if (oldModifierList == null) {
            return;
        }
        String methodText = (modifier != null ? modifier.toString() : "") + " function foo();";
        PsiElement newModifierList = PhpPsiElementFactory.createMethod(method.getProject(), methodText).getFirstChild();
        oldModifierList.replace(newModifierList);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/PhpChangeMethodModifiersQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpChangeMethodModifiersQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "changeMethodModifier";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

