/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.codeStyle.PhpLoopCanBeConvertedToArrayMapInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpConvertArrayMapToLoopQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ControlStatement;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.refactoring.PhpNameStyle;
import com.jetbrains.php.refactoring.PhpNameSuggestionUtil;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpConvertArrayFilterToLoopQuickFix
extends PsiUpdateModCommandQuickFix {
    public static final PhpConvertArrayFilterToLoopQuickFix INSTANCE = new PhpConvertArrayFilterToLoopQuickFix();

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = PhpConvertArrayFilterToLoopQuickFix.getNameText();
        if (string == null) {
            PhpConvertArrayFilterToLoopQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        FunctionReference arrayFilterCall;
        if (project == null) {
            PhpConvertArrayFilterToLoopQuickFix.$$$reportNull$$$0(1);
        }
        if (element == null) {
            PhpConvertArrayFilterToLoopQuickFix.$$$reportNull$$$0(2);
        }
        if (updater == null) {
            PhpConvertArrayFilterToLoopQuickFix.$$$reportNull$$$0(3);
        }
        if ((arrayFilterCall = PhpPsiUtil.getParentOfClass(element, false, FunctionReference.class)) == null) {
            return;
        }
        PsiElement[] arguments = arrayFilterCall.getParameters();
        if (arguments.length < 2) {
            return;
        }
        Function closure = PhpConvertArrayMapToLoopQuickFix.resolveFunction(arguments[1]);
        GroupStatement statement = (GroupStatement)PhpPsiUtil.getChildByCondition(closure, GroupStatement.INSTANCEOF);
        String resultArrayName = PhpConvertArrayFilterToLoopQuickFix.getResultArrayName(arrayFilterCall);
        String flagArgument = arguments.length > 2 ? arguments[2].getText() : null;
        Pair<String, String> pair = PhpConvertArrayFilterToLoopQuickFix.getKeyAndValueNames(flagArgument, closure);
        String template = String.format("foreach(%s as $%s => $%s){%s}", arguments[0].getText(), pair.getFirst(), pair.getSecond(), PhpConvertArrayFilterToLoopQuickFix.getForeachBody(statement, resultArrayName, (String)pair.getFirst(), (String)pair.getSecond(), PhpConvertArrayMapToLoopQuickFix.getFunctionName(arguments[1]), flagArgument));
        ForeachStatement foreach = PhpPsiElementFactory.createFromText(project, ForeachStatement.class, template);
        PhpConvertArrayFilterToLoopQuickFix.replaceCallWithStatement(project, arrayFilterCall, resultArrayName, foreach, new PsiElement[0]);
    }

    public static void replaceCallWithStatement(@NotNull Project project, @NotNull FunctionReference functionCall, @NotNull String resultArrayName, @Nullable PsiElement statement, PsiElement ... additionalStatements) {
        Statement parentStatement;
        if (project == null) {
            PhpConvertArrayFilterToLoopQuickFix.$$$reportNull$$$0(4);
        }
        if (functionCall == null) {
            PhpConvertArrayFilterToLoopQuickFix.$$$reportNull$$$0(5);
        }
        if (resultArrayName == null) {
            PhpConvertArrayFilterToLoopQuickFix.$$$reportNull$$$0(6);
        }
        if (statement != null && (parentStatement = PhpPsiUtil.getParentOfClass((PsiElement)functionCall, Statement.class)) != null) {
            PhpLangUtil.addCopiedCommentsBeforeElement((PsiElement)parentStatement);
            functionCall.replace((PsiElement)PhpPsiElementFactory.createVariable(project, resultArrayName, true));
            Object oneLineParentControlStatement = PhpPsiUtil.getParentByCondition((PsiElement)parentStatement, (Condition<? super PsiElement>)Conditions.or(ControlStatement.INSTANCEOF, Else.INSTANCEOF), GroupStatement.INSTANCEOF);
            if (oneLineParentControlStatement != null) {
                parentStatement = PhpRefactoringUtil.wrapWithBraces(project, parentStatement);
            }
            PsiElement parent = parentStatement.getParent();
            PsiElement lastStatement = parent.addBefore((PsiElement)PhpPsiElementFactory.createStatement(project, "$" + resultArrayName + " = [];"), (PsiElement)parentStatement);
            for (PsiElement additionalStatement : additionalStatements) {
                lastStatement = parent.addAfter(additionalStatement, lastStatement);
            }
            parent.addAfter(statement, lastStatement);
        }
    }

    @NotNull
    public static String getResultArrayName(@NotNull FunctionReference functionReference) {
        if (functionReference == null) {
            PhpConvertArrayFilterToLoopQuickFix.$$$reportNull$$$0(7);
        }
        Set occupiedNames = StreamEx.of(VariableImpl.collectDeclarations((PsiElement)functionReference, false, null)).map(PhpNamedElement::getName).toSet();
        return PhpConvertArrayFilterToLoopQuickFix.generateName((String)ContainerUtil.getFirstItem(PhpNameSuggestionUtil.nameByReference(functionReference, PhpNameStyle.DECAPITALIZE), (Object)"x"), occupiedNames, new String[0]);
    }

    @Nullable
    private static String getForeachBody(@Nullable GroupStatement closureBody, @NotNull String declaredArrayName, @NotNull String keyName, @NotNull String valueName, @Nullable String functionName, @Nullable String flagArgument) {
        Object conditionValue;
        String bodyText2;
        List statements;
        if (declaredArrayName == null) {
            PhpConvertArrayFilterToLoopQuickFix.$$$reportNull$$$0(8);
        }
        if (keyName == null) {
            PhpConvertArrayFilterToLoopQuickFix.$$$reportNull$$$0(9);
        }
        if (valueName == null) {
            PhpConvertArrayFilterToLoopQuickFix.$$$reportNull$$$0(10);
        }
        List list = statements = closureBody != null ? ContainerUtil.filter((Object[])closureBody.getStatements(), Statement.INSTANCEOF) : ContainerUtil.emptyList();
        if (functionName == null) {
            bodyText2 = ((StreamEx)StreamEx.of((Collection)statements).limit((long)Math.max(0, statements.size() - 1))).map(PsiElement::getText).joining((CharSequence)"\n");
            PhpReturn phpReturn = (PhpReturn)ObjectUtils.tryCast((Object)ContainerUtil.getLastItem((List)statements), PhpReturn.class);
            PsiElement returnValue = phpReturn != null ? phpReturn.getArgument() : null;
            conditionValue = returnValue != null ? returnValue.getText() : null;
        } else {
            bodyText2 = "";
            conditionValue = PhpConvertArrayFilterToLoopQuickFix.keyFlagUsed(flagArgument) ? functionName + "( $" + keyName + ")" : (PhpConvertArrayFilterToLoopQuickFix.bothFlagUsed(flagArgument) ? functionName + "( $" + keyName + ", $" + valueName + ")" : functionName + "( $" + valueName + ")");
        }
        return conditionValue != null ? String.format("%s\nif(%s){$%s[$%s] = $%s;}", bodyText2, conditionValue, declaredArrayName, keyName, valueName) : null;
    }

    @NotNull
    private static Pair<String, String> getKeyAndValueNames(@Nullable String flagArgument, @Nullable Function closure) {
        Parameter[] parameters = closure != null ? closure.getParameters() : Parameter.EMPTY_ARRAY;
        String firstParameterName = parameters.length > 0 ? parameters[0].getName() : null;
        String secondParameterName = parameters.length > 1 ? parameters[1].getName() : null;
        Set<String> usedVariableNames = PhpLoopCanBeConvertedToArrayMapInspection.collectUsedVariables(closure, ContainerUtil.newHashSet((Object[])new String[]{firstParameterName, secondParameterName}));
        if (PhpConvertArrayFilterToLoopQuickFix.keyFlagUsed(flagArgument)) {
            String keyName = PhpConvertArrayFilterToLoopQuickFix.generateName(firstParameterName, usedVariableNames, "key", "index");
            usedVariableNames.add(keyName);
            String valueName = PhpConvertArrayFilterToLoopQuickFix.generateName(secondParameterName, usedVariableNames, "item", "value");
            Pair pair = Pair.create((Object)keyName, (Object)valueName);
            if (pair == null) {
                PhpConvertArrayFilterToLoopQuickFix.$$$reportNull$$$0(11);
            }
            return pair;
        }
        String valueName = PhpConvertArrayFilterToLoopQuickFix.generateName(firstParameterName, usedVariableNames, "item", "value");
        usedVariableNames.add(valueName);
        String keyName = PhpConvertArrayFilterToLoopQuickFix.generateName(secondParameterName, usedVariableNames, "key", "index");
        Pair pair = Pair.create((Object)keyName, (Object)valueName);
        if (pair == null) {
            PhpConvertArrayFilterToLoopQuickFix.$$$reportNull$$$0(12);
        }
        return pair;
    }

    private static boolean keyFlagUsed(@Nullable String flagArgument) {
        return StringUtil.equals((CharSequence)flagArgument, (CharSequence)"ARRAY_FILTER_USE_KEY");
    }

    private static boolean bothFlagUsed(@Nullable String flagArgument) {
        return StringUtil.equals((CharSequence)flagArgument, (CharSequence)"ARRAY_FILTER_USE_BOTH");
    }

    @NotNull
    public static String generateName(@Nullable String name, @NotNull Set<String> occupiedNames, String ... preferedNames) {
        if (occupiedNames == null) {
            PhpConvertArrayFilterToLoopQuickFix.$$$reportNull$$$0(13);
        }
        if (name == null || occupiedNames.contains(name)) {
            String preferedUniqueName = ((StreamEx)StreamEx.of((Object[])preferedNames).filter(preferedName -> !occupiedNames.contains(preferedName))).findFirst().orElse(null);
            if (preferedUniqueName == null) {
                name = StreamEx.of((Object[])new String[]{name, (String)ArrayUtil.getFirstElement((Object[])preferedNames), occupiedNames.iterator().next()}).nonNull().findFirst().orElse("x");
                String string = PhpNameUtil.unique(name, "", "", (Condition<? super String>)((Condition)occupiedNames::contains));
                if (string == null) {
                    PhpConvertArrayFilterToLoopQuickFix.$$$reportNull$$$0(14);
                }
                return string;
            }
            String string = preferedUniqueName;
            if (string == null) {
                PhpConvertArrayFilterToLoopQuickFix.$$$reportNull$$$0(15);
            }
            return string;
        }
        String string = name;
        if (string == null) {
            PhpConvertArrayFilterToLoopQuickFix.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Nls
    public static String getNameText() {
        return PhpBundle.message("quickfix.convert.arrayfilter.to.loop", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 13 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/PhpConvertArrayFilterToLoopQuickFix";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionCall";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultArrayName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionReference";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaredArrayName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "occupiedNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpConvertArrayFilterToLoopQuickFix";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyAndValueNames";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "generateName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "replaceCallWithStatement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getResultArrayName";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getForeachBody";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "generateName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 13 -> new IllegalArgumentException(string);
        };
    }
}

