/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.codeStyle.PhpLoopCanBeConvertedToArrayMapInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpConvertLoopToArrayMapQuickFix
extends PsiUpdateModCommandQuickFix {
    @Nls
    @NotNull
    public String getName() {
        String string = PhpConvertLoopToArrayMapQuickFix.getNameText();
        if (string == null) {
            PhpConvertLoopToArrayMapQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = PhpConvertLoopToArrayMapQuickFix.getNameText();
        if (string == null) {
            PhpConvertLoopToArrayMapQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        String resultArrayName;
        ForeachStatement foreach;
        if (project == null) {
            PhpConvertLoopToArrayMapQuickFix.$$$reportNull$$$0(2);
        }
        if (element == null) {
            PhpConvertLoopToArrayMapQuickFix.$$$reportNull$$$0(3);
        }
        if (updater == null) {
            PhpConvertLoopToArrayMapQuickFix.$$$reportNull$$$0(4);
        }
        if ((foreach = PhpPsiUtil.getParentOfClass(element, false, ForeachStatement.class)) == null) {
            return;
        }
        Statement prevStatement = (Statement)PhpPsiUtil.getPrevSiblingByCondition(foreach, Statement.INSTANCEOF);
        AssignmentExpression emptyArrayDeclaration = PhpLoopCanBeConvertedToArrayMapInspection.getEmptyArrayDeclaration(prevStatement);
        PhpPsiElement resultArray = emptyArrayDeclaration != null ? emptyArrayDeclaration.getVariable() : null;
        String string = resultArrayName = resultArray != null ? resultArray.getName() : null;
        if (resultArrayName == null) {
            return;
        }
        PsiElement arrayPushValue = PhpConvertLoopToArrayMapQuickFix.getArrayPushValue(foreach.getStatement());
        if (arrayPushValue == null) {
            return;
        }
        Statement arrayMapStatement = PhpConvertLoopToArrayMapQuickFix.createArrayMapStatement(project, foreach, arrayPushValue, resultArrayName);
        if (arrayMapStatement != null) {
            PhpLangUtil.addCopiedCommentsBeforeElement(foreach);
            foreach.replace((PsiElement)arrayMapStatement);
            prevStatement.delete();
        }
    }

    @Nullable
    private static Statement createArrayMapStatement(@NotNull Project project, @NotNull ForeachStatement foreach, @NotNull PsiElement arrayPushValue, @NotNull String resultArrayName) {
        String valueName;
        if (project == null) {
            PhpConvertLoopToArrayMapQuickFix.$$$reportNull$$$0(5);
        }
        if (foreach == null) {
            PhpConvertLoopToArrayMapQuickFix.$$$reportNull$$$0(6);
        }
        if (arrayPushValue == null) {
            PhpConvertLoopToArrayMapQuickFix.$$$reportNull$$$0(7);
        }
        if (resultArrayName == null) {
            PhpConvertLoopToArrayMapQuickFix.$$$reportNull$$$0(8);
        }
        PsiElement array = foreach.getArray();
        Variable value = foreach.getValue();
        String string = valueName = value != null ? value.getName() : null;
        if (array == null || valueName == null) {
            return null;
        }
        String arrayName = array instanceof PhpNamedElement ? ((PhpNamedElement)array).getName() : "";
        Set<String> variableNames = PhpLoopCanBeConvertedToArrayMapInspection.collectUsedVariables(arrayPushValue, ContainerUtil.newHashSet((Object[])new String[]{valueName, arrayName, resultArrayName}));
        String useList = PhpConvertLoopToArrayMapQuickFix.createUseListStatement(variableNames);
        return PhpPsiElementFactory.createStatement(project, String.format("$%s = %s;", resultArrayName, PhpConvertLoopToArrayMapQuickFix.createArrayMapText(valueName, useList, arrayPushValue.getText(), array.getText())));
    }

    public static String createUseListStatement(@NotNull Set<String> variableNames) {
        if (variableNames == null) {
            PhpConvertLoopToArrayMapQuickFix.$$$reportNull$$$0(9);
        }
        if (variableNames.isEmpty()) {
            return "";
        }
        return String.format("use (%s)", StreamEx.of(variableNames).map(s -> "$" + s).reduce((s, s2) -> s + "," + s2).orElse(""));
    }

    @Nullable
    public static PsiElement getArrayPushValue(@Nullable Statement statement) {
        if (statement == null) {
            return null;
        }
        if (statement instanceof GroupStatement) {
            GroupStatement unwrappedGroupStatement = PhpConvertLoopToArrayMapQuickFix.unwrapGroupStatement((GroupStatement)statement, 0);
            if (unwrappedGroupStatement == null) {
                return null;
            }
            statement = (Statement)ObjectUtils.tryCast((Object)ContainerUtil.find((Object[])unwrappedGroupStatement.getStatements(), Statement.INSTANCEOF), Statement.class);
        }
        if (statement == null) {
            return null;
        }
        AssignmentExpression assignment = (AssignmentExpression)ObjectUtils.tryCast((Object)statement.getFirstPsiChild(), AssignmentExpression.class);
        if (assignment != null) {
            return assignment.getValue();
        }
        return null;
    }

    private static String createArrayMapText(@NotNull String parameterName, @NotNull String useList, @NotNull String pushValue, @NotNull String arrayText) {
        if (parameterName == null) {
            PhpConvertLoopToArrayMapQuickFix.$$$reportNull$$$0(10);
        }
        if (useList == null) {
            PhpConvertLoopToArrayMapQuickFix.$$$reportNull$$$0(11);
        }
        if (pushValue == null) {
            PhpConvertLoopToArrayMapQuickFix.$$$reportNull$$$0(12);
        }
        if (arrayText == null) {
            PhpConvertLoopToArrayMapQuickFix.$$$reportNull$$$0(13);
        }
        return String.format("array_map(function($%s) %s {return %s;}, %s)", parameterName, useList, pushValue, arrayText);
    }

    @Nullable
    public static GroupStatement unwrapGroupStatement(@Nullable GroupStatement statement, int recursionDepth) {
        if (recursionDepth >= 200 || statement == null) {
            return statement;
        }
        List innerStatements = ContainerUtil.filter((Object[])statement.getStatements(), Statement.INSTANCEOF);
        if (innerStatements.size() != 1) {
            return statement;
        }
        GroupStatement onlyInnerStatement = (GroupStatement)ObjectUtils.tryCast(innerStatements.get(0), GroupStatement.class);
        return onlyInnerStatement != null ? PhpConvertLoopToArrayMapQuickFix.unwrapGroupStatement(onlyInnerStatement, recursionDepth + 1) : statement;
    }

    @Nls
    public static String getNameText() {
        return PhpBundle.message("quickfix.convert.loop.to.arraymap", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/PhpConvertLoopToArrayMapQuickFix";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foreach";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayPushValue";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultArrayName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableNames";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "useList";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pushValue";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpConvertLoopToArrayMapQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createArrayMapStatement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createUseListStatement";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createArrayMapText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13 -> new IllegalArgumentException(string);
        };
    }
}

