/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.codeInspection.util.IntentionName;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ExtendsList;
import com.jetbrains.php.lang.psi.elements.ImplementsList;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpExchangeExtendsImplementsQuickFix
extends PsiUpdateModCommandAction<PhpClass> {
    @IntentionName
    private final String myName;
    private final boolean toExtends;
    @NotNull
    private final SmartPsiElementPointer<ClassReference> myRefPointer;

    public PhpExchangeExtendsImplementsQuickFix(PhpClass aClass, @NotNull ClassReference myClassToExtendFromRef) {
        if (myClassToExtendFromRef == null) {
            PhpExchangeExtendsImplementsQuickFix.$$$reportNull$$$0(0);
        }
        super((PsiElement)aClass);
        this.myRefPointer = SmartPointerManager.createPointer((PsiElement)myClassToExtendFromRef);
        PhpClass myClassToExtendFrom = (PhpClass)myClassToExtendFromRef.resolve();
        assert (myClassToExtendFrom != null);
        this.toExtends = aClass.isInterface() == myClassToExtendFrom.isInterface();
        this.myName = PhpBundle.message("php.annotator.exchange.extends.implements.keyword", this.toExtends ? "implements" : "extends", this.toExtends ? "extends" : "implements", myClassToExtendFrom.getName());
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("replace.extends.implements", new Object[0]);
        if (string == null) {
            PhpExchangeExtendsImplementsQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PhpClass myClass) {
        if (context == null) {
            PhpExchangeExtendsImplementsQuickFix.$$$reportNull$$$0(2);
        }
        if (myClass == null) {
            PhpExchangeExtendsImplementsQuickFix.$$$reportNull$$$0(3);
        }
        if (this.myRefPointer.getElement() == null) {
            return null;
        }
        if (this.toExtends && !myClass.getExtendsList().getReferenceElements().isEmpty()) {
            return null;
        }
        return Presentation.of((String)this.myName);
    }

    @Nullable
    private static PsiWhiteSpace getNextWhiteSpace(PhpPsiElement element) {
        PsiElement sibling = element.getNextSibling();
        return sibling instanceof PsiWhiteSpace && sibling.textContains('\n') ? (PsiWhiteSpace)sibling : null;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PhpClass myClass, @NotNull ModPsiUpdater updater) {
        ClassReference myClassReference;
        if (context == null) {
            PhpExchangeExtendsImplementsQuickFix.$$$reportNull$$$0(4);
        }
        if (myClass == null) {
            PhpExchangeExtendsImplementsQuickFix.$$$reportNull$$$0(5);
        }
        if (updater == null) {
            PhpExchangeExtendsImplementsQuickFix.$$$reportNull$$$0(6);
        }
        if ((myClassReference = (ClassReference)updater.getWritable((PsiElement)((ClassReference)this.myRefPointer.getElement()))) == null) {
            return;
        }
        PhpClass declaration = PhpPsiUtil.getParentOfClass((PsiElement)myClassReference, PhpClass.class);
        if (declaration == null) {
            return;
        }
        ExtendsList extendsList = declaration.getExtendsList();
        ImplementsList implementsList = declaration.getImplementsList();
        if (!this.toExtends) {
            ExtendsList emptyExtendsList = PhpPsiElementFactory.createFromText(extendsList.getProject(), ExtendsList.class, "class A ");
            if (emptyExtendsList != null) {
                extendsList.replace((PsiElement)emptyExtendsList);
            }
        } else {
            ImplementsList emptyImplementsList;
            List<ClassReference> elements = implementsList.getReferenceElements();
            assert (!elements.isEmpty());
            if (elements.size() == 1 && (emptyImplementsList = PhpPsiElementFactory.createFromText(extendsList.getProject(), ImplementsList.class, "class A ")) != null) {
                implementsList.replace((PsiElement)emptyImplementsList);
            }
        }
        this.updateList(extendsList, implementsList, myClassReference, this.toExtends);
        PsiWhiteSpace space = PhpExchangeExtendsImplementsQuickFix.getNextWhiteSpace(myClass.getExtendsList());
        if (space != null) {
            space.replace((PsiElement)PhpPsiElementFactory.createWhiteSpace(context.project()));
        }
    }

    public void updateList(@NotNull ExtendsList extendsList, @NotNull ImplementsList implementsList, @NotNull ClassReference classReference, boolean toExtends) {
        if (extendsList == null) {
            PhpExchangeExtendsImplementsQuickFix.$$$reportNull$$$0(7);
        }
        if (implementsList == null) {
            PhpExchangeExtendsImplementsQuickFix.$$$reportNull$$$0(8);
        }
        if (classReference == null) {
            PhpExchangeExtendsImplementsQuickFix.$$$reportNull$$$0(9);
        }
        if (toExtends) {
            List<ClassReference> referenceElements = extendsList.getReferenceElements();
            if (referenceElements.isEmpty()) {
                ExtendsList newExtendsList = PhpPsiElementFactory.createFromText(extendsList.getProject(), ExtendsList.class, "class A extends " + classReference.getText());
                if (newExtendsList != null) {
                    extendsList.replace((PsiElement)newExtendsList);
                }
            } else {
                this.addClassReferenceToExtendsList(extendsList, classReference);
            }
        } else {
            List<ClassReference> referenceElements = implementsList.getReferenceElements();
            if (referenceElements.isEmpty()) {
                ImplementsList newImplementsList = PhpPsiElementFactory.createFromText(extendsList.getProject(), ImplementsList.class, "class A implements " + classReference.getText());
                if (newImplementsList != null) {
                    implementsList.replace((PsiElement)newImplementsList);
                }
            } else {
                this.addClassReferenceToImplementsList(implementsList, classReference);
            }
        }
    }

    public void addClassReferenceToImplementsList(@NotNull ImplementsList implementsList, @NotNull ClassReference classReference) {
        if (implementsList == null) {
            PhpExchangeExtendsImplementsQuickFix.$$$reportNull$$$0(10);
        }
        if (classReference == null) {
            PhpExchangeExtendsImplementsQuickFix.$$$reportNull$$$0(11);
        }
        Object text = implementsList.getText();
        text = (String)text + "," + classReference.getText();
        ImplementsList newImplementsList = PhpPsiElementFactory.createFromText(classReference.getProject(), ImplementsList.class, "class A " + (String)text);
        if (newImplementsList != null) {
            implementsList.replace((PsiElement)newImplementsList);
        }
    }

    public void addClassReferenceToExtendsList(@NotNull ExtendsList extendsList, @NotNull ClassReference classReference) {
        if (extendsList == null) {
            PhpExchangeExtendsImplementsQuickFix.$$$reportNull$$$0(12);
        }
        if (classReference == null) {
            PhpExchangeExtendsImplementsQuickFix.$$$reportNull$$$0(13);
        }
        Object text = extendsList.getText();
        text = (String)text + "," + classReference.getText();
        ExtendsList newExtendsList = PhpPsiElementFactory.createFromText(classReference.getProject(), ExtendsList.class, "class A " + (String)text);
        if (newExtendsList != null) {
            extendsList.replace((PsiElement)newExtendsList);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myClassToExtendFromRef";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/PhpExchangeExtendsImplementsQuickFix";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extendsList";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementsList";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpExchangeExtendsImplementsQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateList";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addClassReferenceToImplementsList";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addClassReferenceToExtendsList";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

