/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.quickfix.PhpBaseImportQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpImportConstantQuickFix
extends PhpBaseImportQuickFix<Constant> {
    private static final String KEYWORD = "const";
    public static final PhpImportConstantQuickFix INSTANCE = new PhpImportConstantQuickFix();

    @NotNull
    public String getFamilyName() {
        String string = PhpImportConstantQuickFix.getNameText();
        if (string == null) {
            PhpImportConstantQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    @NlsContexts.Command
    protected String getCommandName() {
        String string = PhpImportConstantQuickFix.getNameText();
        if (string == null) {
            PhpImportConstantQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getImportPopupTitle() {
        String string = PhpBundle.message("quickfix.import.constant.popup.title", new Object[0]);
        if (string == null) {
            PhpImportConstantQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    protected String getImportKeyword() {
        return KEYWORD;
    }

    @Override
    protected void replaceReference(@NotNull Project project, @NotNull PhpReference reference, @NotNull String fqn) {
        if (project == null) {
            PhpImportConstantQuickFix.$$$reportNull$$$0(3);
        }
        if (reference == null) {
            PhpImportConstantQuickFix.$$$reportNull$$$0(4);
        }
        if (fqn == null) {
            PhpImportConstantQuickFix.$$$reportNull$$$0(5);
        }
        ConstantReference qualifiedConstantReference = PhpPsiElementFactory.createConstantReference(project, PhpLangUtil.toPresentableFQN(fqn));
        reference.replace((PsiElement)qualifiedConstantReference);
    }

    @Override
    @NotNull
    public Collection<Constant> getCandidates(@NotNull Project project, @NotNull PhpReference reference) {
        if (project == null) {
            PhpImportConstantQuickFix.$$$reportNull$$$0(6);
        }
        if (reference == null) {
            PhpImportConstantQuickFix.$$$reportNull$$$0(7);
        }
        Collection<Constant> collection = PhpIndex.getInstance(project).getConstantsByName(reference.getText());
        if (collection == null) {
            PhpImportConstantQuickFix.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @IntentionFamilyName
    public static String getNameText() {
        return PhpBundle.message("quickfix.import.constant.name", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/PhpImportConstantQuickFix";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportPopupTitle";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpImportConstantQuickFix";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "replaceReference";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCandidates";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

