/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.quickfix.PhpBaseImportQuickFix;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpImportFunctionQuickFix
extends PhpBaseImportQuickFix<Function> {
    private static final String KEYWORD = "function";
    public static final PhpImportFunctionQuickFix INSTANCE = new PhpImportFunctionQuickFix();

    @NotNull
    public String getFamilyName() {
        String string = PhpImportFunctionQuickFix.getNameText();
        if (string == null) {
            PhpImportFunctionQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    @NlsContexts.Command
    protected String getCommandName() {
        String string = PhpImportFunctionQuickFix.getNameText();
        if (string == null) {
            PhpImportFunctionQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getImportPopupTitle() {
        String string = PhpBundle.message("quickfix.import.function.popup.title", new Object[0]);
        if (string == null) {
            PhpImportFunctionQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    protected String getImportKeyword() {
        return KEYWORD;
    }

    @Override
    protected void replaceReference(@NotNull Project project, @NotNull PhpReference reference, @NotNull String fqn) {
        if (project == null) {
            PhpImportFunctionQuickFix.$$$reportNull$$$0(3);
        }
        if (reference == null) {
            PhpImportFunctionQuickFix.$$$reportNull$$$0(4);
        }
        if (fqn == null) {
            PhpImportFunctionQuickFix.$$$reportNull$$$0(5);
        }
        FunctionReference functionReference = PhpPsiElementFactory.createFunctionReference(project, "use function " + PhpLangUtil.toPresentableFQN(fqn) + ";");
        reference.replace((PsiElement)functionReference);
    }

    @Override
    @NotNull
    public Collection<Function> getCandidates(@NotNull Project project, @NotNull PhpReference reference) {
        String text;
        int i;
        if (project == null) {
            PhpImportFunctionQuickFix.$$$reportNull$$$0(6);
        }
        if (reference == null) {
            PhpImportFunctionQuickFix.$$$reportNull$$$0(7);
        }
        if ((i = (text = reference.getText()).indexOf("(")) > 0) {
            text = text.substring(0, i);
        }
        Collection<Function> collection = PhpIndex.getInstance(project).getFunctionsByName(text);
        if (collection == null) {
            PhpImportFunctionQuickFix.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @Nls
    public static String getNameText() {
        return PhpBundle.message("quickfix.import.function.name", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/PhpImportFunctionQuickFix";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportPopupTitle";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpImportFunctionQuickFix";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "replaceReference";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCandidates";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

