/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpParameterInfo {
    @NotNull
    private final String name;
    @NotNull
    private final Collection<String> possibleTypesFqns;
    private final boolean nullable;

    public PhpParameterInfo(@NotNull String name, @NotNull Collection<String> possibleTypesFqns, boolean nullable) {
        if (name == null) {
            PhpParameterInfo.$$$reportNull$$$0(0);
        }
        if (possibleTypesFqns == null) {
            PhpParameterInfo.$$$reportNull$$$0(1);
        }
        this.name = name;
        this.possibleTypesFqns = possibleTypesFqns;
        this.nullable = nullable;
    }

    public PhpParameterInfo(String name) {
        this(name, Collections.emptyList(), false);
    }

    @NotNull
    public String getName() {
        String string = this.name;
        if (string == null) {
            PhpParameterInfo.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    @NotNull
    public PhpType createType() {
        PhpType type = new PhpType();
        this.possibleTypesFqns.forEach(type::add);
        if (this.isNullable() && !type.isEmpty()) {
            type.add(PhpType.NULL);
        }
        PhpType phpType = type;
        if (phpType == null) {
            PhpParameterInfo.$$$reportNull$$$0(3);
        }
        return phpType;
    }

    @NotNull
    public Collection<String> getTypeHints(@NotNull PhpLanguageLevel languageLevel, @Nullable PhpPsiElement scope) {
        if (languageLevel == null) {
            PhpParameterInfo.$$$reportNull$$$0(4);
        }
        return PhpParameterInfo.getTypeHints(languageLevel, scope, this.possibleTypesFqns);
    }

    @NotNull
    private static Collection<String> getTypeHints(@NotNull PhpLanguageLevel languageLevel, @Nullable PhpPsiElement scope, Collection<String> fqns) {
        boolean hasMixedType;
        if (languageLevel == null) {
            PhpParameterInfo.$$$reportNull$$$0(5);
        }
        if ((hasMixedType = fqns.stream().anyMatch(t -> "\\mixed".equalsIgnoreCase((String)t))) && !languageLevel.hasFeature(PhpLanguageFeature.MIXED_TYPE_HINT)) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                PhpParameterInfo.$$$reportNull$$$0(6);
            }
            return list;
        }
        List list = ((StreamEx)StreamEx.of(PhpParameterInfo.replacePluralsWithArray(fqns)).map(t -> PhpParameterInfo.getQualifiedTypeHint(languageLevel, scope, t)).nonNull().distinct()).toList();
        if (list == null) {
            PhpParameterInfo.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static Collection<String> replacePluralsWithArray(@NotNull Collection<String> fqns) {
        if (fqns == null) {
            PhpParameterInfo.$$$reportNull$$$0(8);
        }
        return fqns.stream().map(f -> PhpType.isPluralType(f) ? "\\array" : f).distinct().collect(Collectors.toList());
    }

    @Nullable
    private static String getQualifiedTypeHint(PhpLanguageLevel languageLevel, @Nullable PhpPsiElement scope, String typeString) {
        if (("\\false".equals(typeString) || "\\true".equals(typeString)) && !languageLevel.hasFeature(PhpLanguageFeature.STANDALONE_NULL_FALSE)) {
            return PhpParameterInfo.getQualifiedTypeHint(languageLevel, scope, "\\bool");
        }
        if (PhpType.isPrimitiveType(typeString) || PhpType.isResourceOrNumberType(typeString)) {
            return PhpLangUtil.isParameterTypeHint(languageLevel, typeString) ? PhpType.toString(typeString) : null;
        }
        if (PhpLangUtil.isPhpReservedClassName(typeString)) {
            return typeString;
        }
        return PhpParameterInfo.createQualifiedName(scope, typeString);
    }

    private static String createQualifiedName(@Nullable PhpPsiElement scope, @Nullable String typeString) {
        return scope != null && typeString != null ? PhpCodeInsightUtil.createQualifiedName(scope, PhpLangUtil.toFQN(typeString)) : typeString;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleTypesFqns";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/PhpParameterInfo";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpParameterInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createType";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeHints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTypeHints";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "replacePluralsWithArray";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6, 7 -> new IllegalStateException(string);
        };
    }
}

