/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.classes.PhpHierarchyChecksInspection;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpReferenceImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpQuickFixBase
implements LocalQuickFix {
    @Nullable
    private static Collection<PhpClass> resolveClasses(@NotNull MemberReference reference, boolean classesOnly) {
        if (reference == null) {
            PhpQuickFixBase.$$$reportNull$$$0(0);
        }
        Project project = reference.getProject();
        PhpIndex index = PhpIndex.getInstance(project);
        PhpExpression classReference = reference.getClassReference();
        PhpType type = PhpHierarchyChecksInspection.unwrapAlias(new PhpType().add((PsiElement)classReference).global(project), project);
        if (PhpType.isAnonymousClass((String)ContainerUtil.getOnlyItem(type.getTypes())) && PhpLangUtil.isThisReference((PsiElement)classReference)) {
            return ContainerUtil.createMaybeSingletonList((Object)PhpClassImpl.getContainingClass((PsiElement)reference));
        }
        List classes = StreamEx.of(type.getTypes()).flatMap(fqn -> classesOnly ? index.getClassesByFQN((String)fqn).stream() : index.getAnyByFQN((String)fqn).stream()).select(PhpClass.class).toList();
        return PhpReferenceImpl.extendedResolve2(reference, classes);
    }

    @Nullable
    public static PhpClass resolveClassWithErrorReporting(@NotNull Project project, @Nullable MemberReference reference, boolean classesOnly) {
        if (project == null) {
            PhpQuickFixBase.$$$reportNull$$$0(1);
        }
        if (reference == null) {
            PhpQuickFixBase.showErrorMessage(project, PhpBundle.message("quickfix.cannot.find.class.reference", new Object[0]), null);
        } else {
            Collection<PhpClass> classes = PhpQuickFixBase.resolveClasses(reference, classesOnly);
            if (classes != null && IntentionPreviewUtils.isPreviewElement((PsiElement)reference)) {
                return (PhpClass)ContainerUtil.getFirstItem(classes);
            }
            if (classes == null || classes.isEmpty()) {
                PhpQuickFixBase.showErrorMessage(project, PhpBundle.message("quickfix.cannot.find.target.class", reference.getText()), (PsiElement)reference);
            } else if (classes.size() > 1) {
                String fqn = PhpLangUtil.toPresentableFQN(StringUtil.notNullize((String)classes.iterator().next().getFQN()));
                PhpQuickFixBase.showErrorMessage(project, PhpBundle.message("quickfix.multiple.target.class.resolve", fqn), (PsiElement)reference);
            } else {
                return classes.iterator().next();
            }
        }
        return null;
    }

    @Nullable
    public static PhpClass resolveClass(@Nullable MemberReference reference, boolean classesOnly) {
        if (reference == null) {
            return null;
        }
        return (PhpClass)ContainerUtil.getOnlyItem(PhpQuickFixBase.resolveClasses(reference, classesOnly));
    }

    @NlsContexts.HintText
    protected static String validateClass(@NotNull Project project, @Nullable PhpClass clazz) {
        if (project == null) {
            PhpQuickFixBase.$$$reportNull$$$0(2);
        }
        if (clazz == null) {
            return PhpBundle.message("hint.text.can.not.find.target.class.for.modification", new Object[0]);
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)clazz)) {
            return PhpBundle.message("hint.text.target.class.not.writable", clazz.getName());
        }
        if (!ModuleUtilCore.projectContainsFile((Project)project, (VirtualFile)clazz.getContainingFile().getVirtualFile(), (boolean)false)) {
            return PhpBundle.message("hint.text.target.class.does.not.belong.to.project.can.not.be.modified", clazz.getName());
        }
        return null;
    }

    protected void showIsInDumpModeMessage(@NotNull Project project, @Nullable PsiElement element) {
        if (project == null) {
            PhpQuickFixBase.$$$reportNull$$$0(3);
        }
        String message = PhpBundle.message("quickfix.is.not.available.in.dump.mode", this.getName());
        Editor editor = element == null ? null : PsiEditorUtil.findEditor((PsiElement)element);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (editor == null || editor.getComponent().getRootPane() == null) {
                Messages.showMessageDialog((Project)project, (String)message, (String)PhpBundle.message("fix.not.available", new Object[0]), (Icon)Messages.getWarningIcon());
            } else {
                HintManager.getInstance().showErrorHint(editor, message);
            }
        });
    }

    public static void showErrorMessage(@NotNull Project project, @NotNull @NlsContexts.HintText @NlsContexts.DialogMessage String message, @Nullable PsiElement element) {
        if (project == null) {
            PhpQuickFixBase.$$$reportNull$$$0(4);
        }
        if (message == null) {
            PhpQuickFixBase.$$$reportNull$$$0(5);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            throw new PhpErrorHintException(message);
        }
        Editor editor = element == null ? null : PsiEditorUtil.findEditor((PsiElement)element);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (editor == null || editor.getComponent().getRootPane() == null) {
                Messages.showMessageDialog((Project)project, (String)message, (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            } else {
                HintManager.getInstance().showErrorHint(editor, message);
            }
        });
    }

    public static boolean ensureFileWritableInQuickFix(Project project, VirtualFile file) {
        if (!ApplicationManager.getApplication().isWriteIntentLockAcquired()) {
            return true;
        }
        return ReadonlyStatusHandler.ensureFilesWritable((Project)project, (VirtualFile[])new VirtualFile[]{file});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpQuickFixBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveClasses";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveClassWithErrorReporting";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "validateClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "showIsInDumpModeMessage";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "showErrorMessage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class PhpErrorHintException
    extends RuntimeException {
        public PhpErrorHintException(String message) {
            super(message);
        }
    }
}

