/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpPropertyHook;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeInfo;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureProcessor;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureUsageProcessor;
import com.jetbrains.php.refactoring.changeSignature.PhpMethodDescriptor;
import com.jetbrains.php.refactoring.changeSignature.PhpParameterInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpRemoveParametersQuickFix
implements LocalQuickFix {
    @Nls
    @NotNull
    public String getName() {
        String string = PhpBundle.message("php.remove.parameters.quick.fix.text", new Object[0]);
        if (string == null) {
            PhpRemoveParametersQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            PhpRemoveParametersQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Parameter parameter;
        Function function;
        if (project == null) {
            PhpRemoveParametersQuickFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            PhpRemoveParametersQuickFix.$$$reportNull$$$0(3);
        }
        if ((function = PhpPsiUtil.getParentOfClass(parameter = PhpPsiUtil.getParentOfClass(descriptor.getPsiElement(), Parameter.class), Function.class)) == null) {
            return;
        }
        this.doRemoveParameters(parameter, function);
    }

    protected void doRemoveParameters(Parameter parameter, Function function) {
        Collection<Parameter> parameters = this.getParametersToDelete(parameter);
        if (parameters != null) {
            if (function instanceof PhpPropertyHook) {
                PhpPropertyHook propertyHook = (PhpPropertyHook)function;
                WriteAction.run(() -> PhpRemoveParametersQuickFix.removePropertyHookParameter(propertyHook));
            } else {
                PhpRemoveParametersQuickFix.removeParameters(function, parameters);
            }
        }
    }

    public static void removePropertyHookParameter(PhpPropertyHook propertyHook) {
        ParameterList parameterList = propertyHook.getParameterList();
        if (parameterList == null) {
            return;
        }
        PhpRemoveParametersQuickFix.removeParenthesis(parameterList);
        parameterList.delete();
    }

    private static void removeParenthesis(ParameterList parameterList) {
        PsiElement leftParenthesis = PhpPsiUtil.getPrevSiblingIgnoreWhitespace((PsiElement)parameterList, true);
        PsiElement rightParenthesis = PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)parameterList, true);
        if (PhpPsiUtil.isOfType(leftParenthesis, PhpTokenTypes.chLPAREN)) {
            leftParenthesis.delete();
        }
        if (PhpPsiUtil.isOfType(rightParenthesis, PhpTokenTypes.chRPAREN)) {
            rightParenthesis.delete();
        }
    }

    @Nullable
    protected Collection<Parameter> getParametersToDelete(@NotNull Parameter parameter) {
        if (parameter == null) {
            PhpRemoveParametersQuickFix.$$$reportNull$$$0(4);
        }
        return Set.of(parameter);
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Parameter parameter;
        if (project == null) {
            PhpRemoveParametersQuickFix.$$$reportNull$$$0(5);
        }
        if (descriptor == null) {
            PhpRemoveParametersQuickFix.$$$reportNull$$$0(6);
        }
        Collection<Parameter> parametersToDelete = (parameter = PhpPsiUtil.getParentOfClass(descriptor.getPsiElement(), Parameter.class)) != null ? this.getParametersToDelete(parameter) : null;
        Function function = PhpPsiUtil.getParentOfClass(parameter, Function.class);
        return PhpRemoveParametersQuickFix.generatePreview(parametersToDelete, function);
    }

    @NotNull
    public static IntentionPreviewInfo generatePreview(Collection<? extends Parameter> parametersToDelete, Function function) {
        if (parametersToDelete == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                PhpRemoveParametersQuickFix.$$$reportNull$$$0(7);
            }
            return intentionPreviewInfo;
        }
        if (function == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                PhpRemoveParametersQuickFix.$$$reportNull$$$0(8);
            }
            return intentionPreviewInfo;
        }
        PhpChangeInfo info = PhpRemoveParametersQuickFix.createChangeInfo(function, parametersToDelete);
        PhpChangeSignatureUsageProcessor.processFunctionDeclaration(info, function);
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.DIFF;
        if (intentionPreviewInfo == null) {
            PhpRemoveParametersQuickFix.$$$reportNull$$$0(9);
        }
        return intentionPreviewInfo;
    }

    public static void removeParameters(@NotNull Function function, @NotNull Collection<? extends Parameter> parametersToDelete) {
        if (function == null) {
            PhpRemoveParametersQuickFix.$$$reportNull$$$0(10);
        }
        if (parametersToDelete == null) {
            PhpRemoveParametersQuickFix.$$$reportNull$$$0(11);
        }
        PhpChangeInfo changeInfo = PhpRemoveParametersQuickFix.createChangeInfo(function, parametersToDelete);
        if (IntentionPreviewUtils.isPreviewElement((PsiElement)function)) {
            PhpChangeSignatureUsageProcessor.processFunctionDeclaration(changeInfo, function);
        } else {
            new PhpChangeSignatureProcessor(function.getProject(), changeInfo).run();
        }
    }

    @NotNull
    private static PhpChangeInfo createChangeInfo(@NotNull Function function, @NotNull Collection<? extends Parameter> parametersToDelete) {
        if (function == null) {
            PhpRemoveParametersQuickFix.$$$reportNull$$$0(12);
        }
        if (parametersToDelete == null) {
            PhpRemoveParametersQuickFix.$$$reportNull$$$0(13);
        }
        Parameter[] oldParameters = function.getParameters();
        ArrayList<PhpParameterInfo> infos = new ArrayList<PhpParameterInfo>(oldParameters.length - 1);
        for (int i = 0; i < oldParameters.length; ++i) {
            if (parametersToDelete.contains(oldParameters[i])) continue;
            infos.add(new PhpParameterInfo(i, oldParameters[i]));
        }
        PhpChangeInfo phpChangeInfo = PhpChangeSignatureProcessor.generateChangeInfo(new PhpMethodDescriptor(function), new PhpMethodDescriptor(function).getVisibility(), function.getName(), PhpRemoveParametersQuickFix.getReturnType(function), (PhpParameterInfo[])ContainerUtil.toArray(infos, PhpParameterInfo[]::new), Collections.emptySet(), false, true);
        if (phpChangeInfo == null) {
            PhpRemoveParametersQuickFix.$$$reportNull$$$0(14);
        }
        return phpChangeInfo;
    }

    @Nullable
    private static String getReturnType(@NotNull Function function) {
        PhpTypeDeclaration returnType;
        if (function == null) {
            PhpRemoveParametersQuickFix.$$$reportNull$$$0(15);
        }
        return (returnType = function.getTypeDeclaration()) != null ? returnType.getText() : null;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 10, 11, 12, 13, 15 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/PhpRemoveParametersQuickFix";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 10: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersToDelete";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpRemoveParametersQuickFix";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createChangeInfo";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getParametersToDelete";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeParameters";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createChangeInfo";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 10, 11, 12, 13, 15 -> new IllegalArgumentException(string);
        };
    }
}

