/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.inspections.PhpUnitMissingTargetForTestInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpUnitCreateTargetClassQuickFix;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.phpunit.PhpUnitTestDescriptor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnitCreateTargetMethodQuickFix
extends PhpUnitCreateTargetClassQuickFix {
    public static final PhpUnitCreateTargetMethodQuickFix ON_THE_FLY = new PhpUnitCreateTargetMethodQuickFix(true);
    public static final PhpUnitCreateTargetMethodQuickFix BATCH_MODE = new PhpUnitCreateTargetMethodQuickFix(false);

    protected PhpUnitCreateTargetMethodQuickFix(boolean onTheFly) {
        super(onTheFly);
    }

    @Override
    @Nls
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("php.unit.create.target.method.quick.fix.family.name", new Object[0]);
        if (string == null) {
            PhpUnitCreateTargetMethodQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Method testMethod;
        if (project == null) {
            PhpUnitCreateTargetMethodQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            PhpUnitCreateTargetMethodQuickFix.$$$reportNull$$$0(2);
        }
        if ((testMethod = PhpPsiUtil.getParentOfClass(descriptor.getStartElement(), false, Method.class)) == null) {
            return;
        }
        PhpClass testClass = testMethod.getContainingClass();
        if (testClass == null) {
            return;
        }
        String targetMethodName = PhpUnitMissingTargetForTestInspection.getTargetMethodName(testMethod);
        PhpClass targetClass = this.getOrCreateTargetClass(project, descriptor, testClass, targetMethodName);
        if (targetClass == null || targetClass.findOwnMethodByName(targetMethodName) != null) {
            return;
        }
        PsiElement createdMethod = PhpCodeEditUtil.insertClassMember(targetClass, PhpPsiElementFactory.createMethod(project, PhpUnitCreateTargetMethodQuickFix.getTargetMethodText(targetMethodName)));
        if (this.myOnTheFly) {
            PhpCodeUtil.openRelatedFile(project, createdMethod);
        }
    }

    @NotNull
    private static String getTargetMethodText(String targetMethodName) {
        String string = "public function " + targetMethodName + "(){}";
        if (string == null) {
            PhpUnitCreateTargetMethodQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Method testMethod;
        if (project == null) {
            PhpUnitCreateTargetMethodQuickFix.$$$reportNull$$$0(4);
        }
        if (descriptor == null) {
            PhpUnitCreateTargetMethodQuickFix.$$$reportNull$$$0(5);
        }
        if ((testMethod = PhpPsiUtil.getParentOfClass(descriptor.getStartElement(), false, Method.class)) == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                PhpUnitCreateTargetMethodQuickFix.$$$reportNull$$$0(6);
            }
            return intentionPreviewInfo;
        }
        PhpClass testClass = testMethod.getContainingClass();
        if (testClass == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                PhpUnitCreateTargetMethodQuickFix.$$$reportNull$$$0(7);
            }
            return intentionPreviewInfo;
        }
        String targetMethodName = PhpUnitMissingTargetForTestInspection.getTargetMethodName(testMethod);
        String containingFileName = PhpUnitMissingTargetForTestInspection.findTargetClasses(testClass).stream().findFirst().map(e -> e.getContainingFile().getName()).orElse(null);
        if (containingFileName != null) {
            return new IntentionPreviewInfo.CustomDiff((FileType)PhpFileType.INSTANCE, containingFileName, "", PhpUnitCreateTargetMethodQuickFix.getTargetMethodText(targetMethodName));
        }
        return new IntentionPreviewInfo.Html(PhpBundle.message("creates.new.class.method.0.in.a.separate.file", PhpUnitTestDescriptor.getTargetClassName(testClass), targetMethodName));
    }

    @Nullable
    private PhpClass getOrCreateTargetClass(@NotNull Project project, @NotNull ProblemDescriptor descriptor, @NotNull PhpClass testClass, @NotNull String targetMethodName) {
        if (project == null) {
            PhpUnitCreateTargetMethodQuickFix.$$$reportNull$$$0(8);
        }
        if (descriptor == null) {
            PhpUnitCreateTargetMethodQuickFix.$$$reportNull$$$0(9);
        }
        if (testClass == null) {
            PhpUnitCreateTargetMethodQuickFix.$$$reportNull$$$0(10);
        }
        if (targetMethodName == null) {
            PhpUnitCreateTargetMethodQuickFix.$$$reportNull$$$0(11);
        }
        return PhpUnitMissingTargetForTestInspection.findTargetClasses(testClass).stream().filter(clazz -> clazz.findOwnMethodByName(targetMethodName) == null).findAny().orElseGet(() -> (PhpClass)PsiTreeUtil.findChildOfType((PsiElement)this.createTargetClassFile(project, testClass, descriptor), PhpClass.class, (boolean)false));
    }

    @Override
    @NotNull
    @Nls
    protected String getActionName() {
        String string = PhpBundle.message("create.missing.target.method.fix", new Object[0]);
        if (string == null) {
            PhpUnitCreateTargetMethodQuickFix.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 5, 8, 9, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/PhpUnitCreateTargetMethodQuickFix";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testClass";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetMethodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/PhpUnitCreateTargetMethodQuickFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetMethodText";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateTargetClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 5, 8, 9, 10, 11 -> new IllegalArgumentException(string);
        };
    }
}

