/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix.assignment;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpReplaceAssignmentWithOperatorAssignmentQuickFix
extends PsiUpdateModCommandQuickFix {
    @Nls
    private final String myName;

    public PhpReplaceAssignmentWithOperatorAssignmentQuickFix(@Nls String name) {
        this.myName = name;
    }

    @NotNull
    public String getReplacementExpressionString(@NotNull AssignmentExpression assignment) {
        if (assignment == null) {
            PhpReplaceAssignmentWithOperatorAssignmentQuickFix.$$$reportNull$$$0(0);
        }
        StringBuilder newExpression = new StringBuilder();
        PhpPsiElement variable = assignment.getVariable();
        assert (variable != null);
        newExpression.append(variable.getText());
        BinaryExpression expression = (BinaryExpression)assignment.getValue();
        assert (expression != null);
        newExpression.append(" ").append(PhpReplaceAssignmentWithOperatorAssignmentQuickFix.getOperatorText(expression)).append("= ");
        PsiElement leftOperand = expression.getLeftOperand();
        PsiElement rightOperand = expression.getRightOperand();
        assert (leftOperand != null && rightOperand != null);
        PsiElement operand = PsiEquivalenceUtil.areElementsEquivalent((PsiElement)variable, (PsiElement)leftOperand) ? rightOperand : leftOperand;
        newExpression.append(operand.getText());
        String string = newExpression.toString();
        if (string == null) {
            PhpReplaceAssignmentWithOperatorAssignmentQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static String getOperatorText(@NotNull BinaryExpression expression) {
        if (expression == null) {
            PhpReplaceAssignmentWithOperatorAssignmentQuickFix.$$$reportNull$$$0(2);
        }
        PsiElement operation = expression.getOperation();
        assert (operation != null);
        return operation.getText();
    }

    @Nls
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            PhpReplaceAssignmentWithOperatorAssignmentQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = PhpReplaceAssignmentWithOperatorAssignmentQuickFix.getFamilyNameText();
        if (string == null) {
            PhpReplaceAssignmentWithOperatorAssignmentQuickFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        if (project == null) {
            PhpReplaceAssignmentWithOperatorAssignmentQuickFix.$$$reportNull$$$0(5);
        }
        if (element == null) {
            PhpReplaceAssignmentWithOperatorAssignmentQuickFix.$$$reportNull$$$0(6);
        }
        if (updater == null) {
            PhpReplaceAssignmentWithOperatorAssignmentQuickFix.$$$reportNull$$$0(7);
        }
        AssignmentExpression assignment = (AssignmentExpression)element;
        String replacementExpression = this.getReplacementExpressionString(assignment);
        SelfAssignmentExpression newExpressionElement = PhpPsiElementFactory.createFromText(project, SelfAssignmentExpression.class, replacementExpression);
        assert (newExpressionElement != null);
        assignment.replace((PsiElement)newExpressionElement);
    }

    @Nls
    private static String getFamilyNameText() {
        return PhpBundle.message("quickfix.replace.assignment.with.operator.assignment.family.name", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/assignment/PhpReplaceAssignmentWithOperatorAssignmentQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/assignment/PhpReplaceAssignmentWithOperatorAssignmentQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReplacementExpressionString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReplacementExpressionString";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOperatorText";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4 -> new IllegalStateException(string);
        };
    }
}

