/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix.assignment;

import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class PhpReplaceWithPrefixExpressionQuickFix<F extends AssignmentExpression>
extends PsiUpdateModCommandQuickFix {
    @Nls
    private final String myName;
    private final String myReplacementExpression;

    public PhpReplaceWithPrefixExpressionQuickFix(F assignment) {
        this.myReplacementExpression = this.getReplacementExpressionString(assignment);
        String operatorText = this.getToBeReplacedOperatorText(assignment);
        this.myName = PhpBundle.message("quickfix.replace.one.operator.with.another", operatorText, this.myReplacementExpression);
    }

    @NotNull
    private String getReplacementExpressionString(@NotNull F assignment) {
        if (assignment == null) {
            PhpReplaceWithPrefixExpressionQuickFix.$$$reportNull$$$0(0);
        }
        PhpPsiElement variable = assignment.getVariable();
        assert (variable != null);
        String variableName = variable.getText();
        IElementType operatorType = this.getOperatorType(assignment);
        String prefix = operatorType.equals(this.getPlusOperatorType()) ? "++" : "--";
        String string = prefix + variableName;
        if (string == null) {
            PhpReplaceWithPrefixExpressionQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public final String getReplacementExpressionString() {
        String string = this.myReplacementExpression;
        if (string == null) {
            PhpReplaceWithPrefixExpressionQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    protected abstract IElementType getOperatorType(@NotNull F var1);

    @NotNull
    protected abstract IElementType getPlusOperatorType();

    @NotNull
    @Contract(pure=true)
    protected abstract String getToBeReplacedOperatorText(@NotNull F var1);

    @Nls
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            PhpReplaceWithPrefixExpressionQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement assignment, @NotNull ModPsiUpdater updater) {
        if (project == null) {
            PhpReplaceWithPrefixExpressionQuickFix.$$$reportNull$$$0(4);
        }
        if (assignment == null) {
            PhpReplaceWithPrefixExpressionQuickFix.$$$reportNull$$$0(5);
        }
        if (updater == null) {
            PhpReplaceWithPrefixExpressionQuickFix.$$$reportNull$$$0(6);
        }
        UnaryExpression newExpressionElement = PhpPsiElementFactory.createFromText(project, UnaryExpression.class, this.myReplacementExpression);
        assert (newExpressionElement != null);
        assignment.replace((PsiElement)newExpressionElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/assignment/PhpReplaceWithPrefixExpressionQuickFix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/assignment/PhpReplaceWithPrefixExpressionQuickFix";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReplacementExpressionString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReplacementExpressionString";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

