/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.quickfix.type;

import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpChangeFieldTypeToMatchSuperQuickFix
extends PsiUpdateModCommandQuickFix {
    private final PhpType mySuperType;
    private final String myTypeStr;

    public PhpChangeFieldTypeToMatchSuperQuickFix(Field field, PhpType globalizedSuperType) {
        this.mySuperType = globalizedSuperType;
        this.myTypeStr = PhpChangeFieldTypeToMatchSuperQuickFix.getDeclaredTypeString(field.getProject(), this.mySuperType, field);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("quickfix.change.field.type.to.match.super", new Object[0]);
        if (string == null) {
            PhpChangeFieldTypeToMatchSuperQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getName() {
        if (StringUtil.isNotEmpty((String)this.myTypeStr)) {
            String string = PhpBundle.message("quickfix.change.field.type.to.match.super.0", this.myTypeStr);
            if (string == null) {
                PhpChangeFieldTypeToMatchSuperQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (this.mySuperType.isEmpty()) {
            String string = PhpBundle.message("quickfix.change.field.type.to.match.super.remove", new Object[0]);
            if (string == null) {
                PhpChangeFieldTypeToMatchSuperQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = this.getFamilyName();
        if (string == null) {
            PhpChangeFieldTypeToMatchSuperQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        Field field;
        if (project == null) {
            PhpChangeFieldTypeToMatchSuperQuickFix.$$$reportNull$$$0(4);
        }
        if (element == null) {
            PhpChangeFieldTypeToMatchSuperQuickFix.$$$reportNull$$$0(5);
        }
        if (updater == null) {
            PhpChangeFieldTypeToMatchSuperQuickFix.$$$reportNull$$$0(6);
        }
        if ((field = PhpChangeFieldTypeToMatchSuperQuickFix.getTargetField(element)) == null) {
            return;
        }
        field.updateType(this.mySuperType);
    }

    @Nullable
    static Field getTargetField(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof Field) {
            return (Field)parent;
        }
        return (Field)PhpPsiUtil.getChildByCondition(parent, Field.INSTANCEOF);
    }

    @Nullable
    public static String getDeclaredTypeString(@NotNull Project project, @NotNull PhpType declaredType, @Nullable PsiElement element) {
        if (project == null) {
            PhpChangeFieldTypeToMatchSuperQuickFix.$$$reportNull$$$0(7);
        }
        if (declaredType == null) {
            PhpChangeFieldTypeToMatchSuperQuickFix.$$$reportNull$$$0(8);
        }
        return PhpChangeFieldTypeToMatchSuperQuickFix.getDeclaredTypeString(project, declaredType, element, false);
    }

    @Nullable
    public static String getDeclaredTypeString(@NotNull Project project, @NotNull PhpType declaredType, @Nullable PsiElement element, boolean forPhpDoc) {
        if (project == null) {
            PhpChangeFieldTypeToMatchSuperQuickFix.$$$reportNull$$$0(9);
        }
        if (declaredType == null) {
            PhpChangeFieldTypeToMatchSuperQuickFix.$$$reportNull$$$0(10);
        }
        if (declaredType.getTypes().contains("\\false") && declaredType.size() == 1 && !PhpLanguageFeature.STANDALONE_NULL_FALSE.isSupported(project)) {
            return PhpType.BOOLEAN.toString();
        }
        boolean isNullable = declaredType.isNullable();
        if (isNullable && declaredType.size() == 1 && !PhpLanguageFeature.STANDALONE_NULL_FALSE.isSupported(project)) {
            return null;
        }
        Collection<String> normalizedTypeStrings = PhpChangeFieldTypeToMatchSuperQuickFix.getNormalizedTypeStrings(project, declaredType, element, forPhpDoc);
        List normalizedTypes = normalizedTypeStrings.stream().flatMap(t -> PhpChangeFieldTypeToMatchSuperQuickFix.mapIntersectionTypeForUnion(project, t, normalizedTypeStrings.size() > 1)).distinct().toList();
        boolean unionTypesSupported = PhpLanguageFeature.UNION_TYPES.isSupported(project);
        if (normalizedTypes.isEmpty() || normalizedTypes.size() == 2 && !isNullable && !unionTypesSupported || normalizedTypes.size() > 2 && !unionTypesSupported) {
            return null;
        }
        if (normalizedTypes.size() == 2 && isNullable) {
            return "?" + (String)ContainerUtil.getFirstItem((List)ContainerUtil.filter(normalizedTypes, ts -> !PhpType.isNull(PhpLangUtil.toFQN(ts))));
        }
        return StringUtil.join(normalizedTypes, (String)"|");
    }

    private static Stream<String> mapIntersectionTypeForUnion(@NotNull Project project, String type, boolean unionType) {
        if (project == null) {
            PhpChangeFieldTypeToMatchSuperQuickFix.$$$reportNull$$$0(11);
        }
        if (PhpType.isIntersectionType(type) && unionType) {
            if (PhpLanguageFeature.INTERSECTION_AND_UNION_IN_SAME_TYPE.isSupported(project)) {
                return Stream.of("(" + type + ")");
            }
            return StringUtil.split((String)type, (String)"&").stream();
        }
        return Stream.of(type);
    }

    @NotNull
    private static Collection<String> getNormalizedTypeStrings(@NotNull Project project, @NotNull PhpType declaredType, @Nullable PsiElement element, boolean forPhpDoc) {
        boolean hasSelf;
        if (project == null) {
            PhpChangeFieldTypeToMatchSuperQuickFix.$$$reportNull$$$0(12);
        }
        if (declaredType == null) {
            PhpChangeFieldTypeToMatchSuperQuickFix.$$$reportNull$$$0(13);
        }
        PhpType declaredTypeWithoutSelf = declaredType.filterOut(PhpTypeSignatureKey.SELF_CLASS::isSigned);
        PhpType globalType = declaredTypeWithoutSelf.global(project).filterUnknown();
        List normalizedTypes = ((StreamEx)StreamEx.of(globalType.getTypes()).map(t -> !forPhpDoc && PhpType.isPluralType(t) ? "\\array" : t).distinct()).map(t -> PhpChangeFieldTypeToMatchSuperQuickFix.getNormalizedTypeString(t, element)).toList();
        boolean bl = hasSelf = declaredTypeWithoutSelf.size() != declaredType.size();
        if (hasSelf) {
            List list = ContainerUtil.append((List)normalizedTypes, (Object[])new String[]{"self"});
            if (list == null) {
                PhpChangeFieldTypeToMatchSuperQuickFix.$$$reportNull$$$0(14);
            }
            return list;
        }
        List list = normalizedTypes;
        if (list == null) {
            PhpChangeFieldTypeToMatchSuperQuickFix.$$$reportNull$$$0(15);
        }
        return list;
    }

    @NotNull
    private static String getNormalizedTypeString(@NotNull String typeString, @Nullable PsiElement element) {
        if (typeString == null) {
            PhpChangeFieldTypeToMatchSuperQuickFix.$$$reportNull$$$0(16);
        }
        typeString = PhpType.toString(typeString);
        if (element == null) {
            String string = typeString;
            if (string == null) {
                PhpChangeFieldTypeToMatchSuperQuickFix.$$$reportNull$$$0(17);
            }
            return string;
        }
        PhpPsiElement scope = PhpCodeInsightUtil.findScopeForUseOperator(element);
        String string = scope != null && PhpLangUtil.isFqn(typeString) ? PhpCodeInsightUtil.createQualifiedName(scope, typeString) : typeString;
        if (string == null) {
            PhpChangeFieldTypeToMatchSuperQuickFix.$$$reportNull$$$0(18);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/quickfix/type/PhpChangeFieldTypeToMatchSuperQuickFix";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaredType";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/quickfix/type/PhpChangeFieldTypeToMatchSuperQuickFix";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedTypeStrings";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedTypeString";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredTypeString";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "mapIntersectionTypeForUnion";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedTypeStrings";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedTypeString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16 -> new IllegalArgumentException(string);
        };
    }
}

