/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.reference;

import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.SmartRefElementPointer;
import com.intellij.codeInspection.reference.SmartRefElementPointerImpl;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.reference.PhpEntryPointsManager;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClass;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClassImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClassMember;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefElementImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefField;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefFunction;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefMethod;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="PhpEntryPointsManager")
public final class PhpEntryPointsManagerImpl
extends PhpEntryPointsManager
implements PersistentStateComponent<Element> {
    @NotNull
    private static final Set<String> REF_ELEMENT_NAMES = ContainerUtil.newHashSet((Object[])new String[]{"phpField", "phpMethod", "phpClass", "phpFunction", "phpNamespace", "phpConst"});
    @NotNull
    @NonNls
    private static final String ENTRY_POINTS_ELEMENT = "entry_point";
    @NotNull
    @NonNls
    private static final String ENTRY_POINT_ATTR = "entry_point";
    @NotNull
    @NonNls
    private static final String ENTRY_POINT_PATTERN_ELEMENT = "pattern";
    private static final String SUPPRESSED_ANNOTATIONS = "suppressed_annotations";
    @NotNull
    private final Set<RefElement> myTemporaryEntryPoints = Collections.synchronizedSet(new HashSet());
    @NotNull
    private final Map<String, SmartRefElementPointer> myPersistentEntryPoints = new LinkedHashMap<String, SmartRefElementPointer>();
    @NotNull
    private final Set<ClassPattern> myPatterns = new LinkedHashSet<ClassPattern>();
    private boolean myResolved = false;
    private final Collection<String> mySuppressedAnnotations = new HashSet<String>();

    public void resolveEntryPoints(@NotNull RefManager manager) {
        if (manager == null) {
            PhpEntryPointsManagerImpl.$$$reportNull$$$0(0);
        }
        if (!this.myResolved) {
            this.myResolved = true;
            this.cleanup();
            ReadAction.run(() -> ((StreamEx)StreamEx.of(this.myPersistentEntryPoints.values()).filter(entry -> entry.resolve(manager))).map(SmartRefElementPointer::getRefElement).select(RefElement.class).forEach(PhpEntryPointsManagerImpl::setPermanentEntryAndTraversed));
            this.getPatternEntryPoints(manager).forEach(PhpEntryPointsManagerImpl::setPermanentEntryPoint);
        }
    }

    @NotNull
    private Collection<RefElement> getPatternEntryPoints(@NotNull RefManager manager) {
        if (manager == null) {
            PhpEntryPointsManagerImpl.$$$reportNull$$$0(1);
        }
        ArrayList<RefElement> entries = new ArrayList<RefElement>();
        for (ClassPattern pattern : this.myPatterns) {
            RefEntity patternRefElement = (RefEntity)ReadAction.compute(() -> manager.getReference("phpClass", pattern.pattern));
            PhpRefClassImpl refClass = (PhpRefClassImpl)ObjectUtils.tryCast((Object)patternRefElement, PhpRefClassImpl.class);
            if (refClass == null) continue;
            refClass.setInitialized(true);
            if (pattern.isOfClassType()) {
                entries.add((RefElement)ObjectUtils.notNull((Object)refClass.getOwnConstructor(), (Object)refClass));
                continue;
            }
            ((StreamEx)refClass.getOwnMethods().filter(entity -> StringUtil.startsWithIgnoreCase((String)entity.getName(), (String)pattern.member))).forEach(entries::add);
        }
        ArrayList<RefElement> arrayList = entries;
        if (arrayList == null) {
            PhpEntryPointsManagerImpl.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public void removeEntryPoint(@NotNull RefElement anEntryPoint) {
        if (anEntryPoint == null) {
            PhpEntryPointsManagerImpl.$$$reportNull$$$0(3);
        }
        this.myTemporaryEntryPoints.remove(anEntryPoint);
        ReadAction.run(() -> this.myPersistentEntryPoints.remove(anEntryPoint.getExternalName()));
        ((RefElementImpl)anEntryPoint).setEntry(false);
        if (anEntryPoint.isPermanentEntry() && anEntryPoint.isValid()) {
            this.doActionToProjectEntryPointsManager(anEntryPoint, (Consumer<EntryPointsManager>)((Consumer)manager -> manager.removeEntryPoint(anEntryPoint)));
        }
        this.removeClassPatterns(anEntryPoint);
    }

    private void removeClassPatterns(@NotNull RefElement anEntryPoint) {
        PhpRefClass aClass;
        if (anEntryPoint == null) {
            PhpEntryPointsManagerImpl.$$$reportNull$$$0(4);
        }
        if ((aClass = PhpRefUtil.getContainingRefClass(anEntryPoint)) == null) {
            return;
        }
        String classFqn = aClass.getQualifiedName();
        String memberName = anEntryPoint.getName();
        Iterator<ClassPattern> iterator = this.getPatterns().iterator();
        while (iterator.hasNext()) {
            ClassPattern classPattern = iterator.next();
            if (!classPattern.matchesClassFqn(classFqn) || !(classPattern.isOfClassType() && PhpEntryPointsManagerImpl.shouldParticipateInInitialization(anEntryPoint) || anEntryPoint instanceof PhpRefMethod && classPattern.isAcceptedMemberName(memberName, true)) && (!(anEntryPoint instanceof PhpRefField) || !classPattern.isAcceptedMemberName(memberName, false))) continue;
            iterator.remove();
        }
    }

    public Collection<String> getSuppressedAnnotations() {
        return this.mySuppressedAnnotations;
    }

    public void updateSuppressedAnnotations(List<String> data) {
        this.mySuppressedAnnotations.clear();
        this.mySuppressedAnnotations.addAll(data);
    }

    private static boolean shouldParticipateInInitialization(@NotNull RefElement refElement) {
        if (refElement == null) {
            PhpEntryPointsManagerImpl.$$$reportNull$$$0(5);
        }
        return refElement instanceof PhpRefClass || refElement instanceof PhpRefMethod && ((PhpRefMethod)refElement).isConstructor();
    }

    public void addEntryPoint(@NotNull RefElement newEntryPoint, boolean isPersistent) {
        if (newEntryPoint == null) {
            PhpEntryPointsManagerImpl.$$$reportNull$$$0(6);
        }
        if (!newEntryPoint.isValid() || !PhpEntryPointsManagerImpl.canBeEntryPoint(newEntryPoint) || isPersistent && PhpEntryPointsManagerImpl.cannotPersist(newEntryPoint)) {
            return;
        }
        this.addNewEntryPoint(newEntryPoint, isPersistent);
        this.addEntryPointsForInitializers(newEntryPoint, isPersistent);
    }

    private void addNewEntryPoint(@NotNull RefElement newEntryPoint, boolean isPersistent) {
        if (newEntryPoint == null) {
            PhpEntryPointsManagerImpl.$$$reportNull$$$0(7);
        }
        if (!isPersistent) {
            this.myTemporaryEntryPoints.add(newEntryPoint);
            ((RefElementImpl)newEntryPoint).setEntry(true);
        } else {
            this.addToClassPatterns(newEntryPoint);
            this.addPersistentEntryPoint(newEntryPoint);
        }
    }

    private static boolean canBeEntryPoint(@NotNull RefElement refElement) {
        if (refElement == null) {
            PhpEntryPointsManagerImpl.$$$reportNull$$$0(8);
        }
        return !(refElement instanceof PhpRefClass) || !((PhpRefClass)refElement).isAnonymous();
    }

    private static boolean cannotPersist(@NotNull RefElement refElement) {
        if (refElement == null) {
            PhpEntryPointsManagerImpl.$$$reportNull$$$0(9);
        }
        return refElement instanceof PhpRefFunction && ((PhpRefFunction)refElement).isClosure();
    }

    @Override
    public void addEntryPointsForInitializers(@NotNull RefElement refElement, boolean isPersistent) {
        if (refElement == null) {
            PhpEntryPointsManagerImpl.$$$reportNull$$$0(10);
        }
        if (!PhpEntryPointsManagerImpl.shouldMarkInitializers(refElement)) {
            return;
        }
        PhpRefClass refClass = PhpRefUtil.getContainingRefClass(refElement);
        if (refClass == null) {
            return;
        }
        this.addEntryPointsForClassInitializers(refClass, isPersistent);
    }

    private static boolean shouldMarkInitializers(@NotNull RefElement refElement) {
        if (refElement == null) {
            PhpEntryPointsManagerImpl.$$$reportNull$$$0(11);
        }
        return refElement instanceof PhpRefClass || refElement instanceof PhpRefMethod && !((PhpRefMethod)refElement).isStatic();
    }

    private void addEntryPointsForClassInitializers(@NotNull PhpRefClass refClass, boolean isPersistent) {
        PhpRefMethod refConstructor;
        if (refClass == null) {
            PhpEntryPointsManagerImpl.$$$reportNull$$$0(12);
        }
        if (PhpEntryPointsManagerImpl.canBeEntryPoint(refClass) && !PhpEntryPointsManagerImpl.isEntryPoint(refClass, isPersistent)) {
            this.addEntryPoint(refClass, isPersistent);
        }
        if ((refConstructor = refClass.getConstructor()) != null && !PhpEntryPointsManagerImpl.isEntryPoint(refConstructor, isPersistent)) {
            this.addEntryPoint(refConstructor, isPersistent);
        }
    }

    private static boolean isEntryPoint(@NotNull RefElement refElement, boolean isPersistent) {
        if (refElement == null) {
            PhpEntryPointsManagerImpl.$$$reportNull$$$0(13);
        }
        return refElement.isEntry() && (!isPersistent || refElement.isPermanentEntry());
    }

    private void addToClassPatterns(@NotNull RefElement refElement) {
        PhpRefClass refClass;
        if (refElement == null) {
            PhpEntryPointsManagerImpl.$$$reportNull$$$0(14);
        }
        if ((refClass = PhpRefUtil.getContainingRefClass(refElement)) == null) {
            return;
        }
        String memberName = refElement instanceof PhpRefClassMember ? refElement.getName() : null;
        ClassPattern classPattern = new ClassPattern(refClass.getExternalName(), memberName);
        this.getPatterns().add(classPattern);
    }

    private void addPersistentEntryPoint(@NotNull RefElement newEntryPoint) {
        if (newEntryPoint == null) {
            PhpEntryPointsManagerImpl.$$$reportNull$$$0(15);
        }
        PhpEntryPointsManagerImpl.setPermanentEntryPoint(newEntryPoint);
        if (this.myPersistentEntryPoints.containsKey(newEntryPoint.getExternalName())) {
            return;
        }
        this.persistEntryPoints(newEntryPoint);
        SmartRefElementPointerImpl entry = new SmartRefElementPointerImpl((RefEntity)newEntryPoint, true);
        this.myPersistentEntryPoints.put(entry.getFQName(), (SmartRefElementPointer)entry);
    }

    private void persistEntryPoints(@NotNull RefElement newEntryPoint) {
        if (newEntryPoint == null) {
            PhpEntryPointsManagerImpl.$$$reportNull$$$0(16);
        }
        this.doActionToProjectEntryPointsManager(newEntryPoint, (Consumer<EntryPointsManager>)((Consumer)manager -> manager.addEntryPoint(newEntryPoint, true)));
    }

    private void doActionToProjectEntryPointsManager(@NotNull RefElement newEntryPoint, @NotNull Consumer<EntryPointsManager> action) {
        PhpEntryPointsManager entryPointsManager;
        if (newEntryPoint == null) {
            PhpEntryPointsManagerImpl.$$$reportNull$$$0(17);
        }
        if (action == null) {
            PhpEntryPointsManagerImpl.$$$reportNull$$$0(18);
        }
        if (this != (entryPointsManager = PhpEntryPointsManagerImpl.getProjectInstance(newEntryPoint.getRefManager().getProject()))) {
            action.consume((Object)entryPointsManager);
        }
    }

    public void addAllPersistentEntries(@NotNull PhpEntryPointsManager manager) {
        if (manager == null) {
            PhpEntryPointsManagerImpl.$$$reportNull$$$0(19);
        }
        PhpEntryPointsManagerImpl managerImpl = (PhpEntryPointsManagerImpl)manager;
        this.myPersistentEntryPoints.putAll(managerImpl.myPersistentEntryPoints);
        this.myPatterns.addAll(managerImpl.getPatterns());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public RefElement @NotNull [] getEntryPoints(@NotNull RefManager refManager) {
        if (refManager == null) {
            PhpEntryPointsManagerImpl.$$$reportNull$$$0(20);
        }
        Set<RefElement> set = this.myTemporaryEntryPoints;
        // MONITORENTER : set
        RefElement[] refElementArray = (RefElement[])StreamEx.of(this.myPersistentEntryPoints.values()).map(SmartRefElementPointer::getRefElement).select(RefElement.class).append(this.myTemporaryEntryPoints).toArray(RefElement.class);
        // MONITOREXIT : set
        if (refElementArray != null) return refElementArray;
        PhpEntryPointsManagerImpl.$$$reportNull$$$0(21);
        return refElementArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        Set<RefElement> set = this.myTemporaryEntryPoints;
        synchronized (set) {
            for (RefElement entryPoint : this.myTemporaryEntryPoints) {
                ((RefElementImpl)entryPoint).setEntry(false);
            }
            this.myTemporaryEntryPoints.clear();
        }
        this.myPersistentEntryPoints.values().forEach(SmartRefElementPointer::freeReference);
    }

    public void removePersistentEntryPoints() {
        this.myPersistentEntryPoints.clear();
    }

    public boolean isAddNonJavaEntries() {
        return false;
    }

    public void configureAnnotations() {
    }

    public boolean isEntryPoint(@NotNull PsiElement element) {
        if (element == null) {
            PhpEntryPointsManagerImpl.$$$reportNull$$$0(22);
        }
        return false;
    }

    public boolean isImplicitWrite(@NotNull PsiElement element) {
        if (element == null) {
            PhpEntryPointsManagerImpl.$$$reportNull$$$0(23);
        }
        return false;
    }

    public void dispose() {
        this.cleanup();
    }

    public void loadState(@NotNull Element element) {
        Element entryPointsElement;
        if (element == null) {
            PhpEntryPointsManagerImpl.$$$reportNull$$$0(24);
        }
        if ((entryPointsElement = element.getChild("entry_point")) != null) {
            PhpEntryPointsManagerImpl.convert(entryPointsElement, this.myPersistentEntryPoints);
        }
        this.getPatterns().clear();
        for (Element pattern : element.getChildren(ENTRY_POINT_PATTERN_ELEMENT)) {
            ClassPattern classPattern = new ClassPattern();
            XmlSerializer.deserializeInto((Element)pattern, (Object)classPattern);
            this.getPatterns().add(classPattern);
        }
        for (Element suppressedAnnotation : element.getChildren(SUPPRESSED_ANNOTATIONS)) {
            this.getSuppressedAnnotations().add(suppressedAnnotation.getText());
        }
    }

    public Element getState() {
        Element element = new Element("state");
        PhpEntryPointsManagerImpl.writeExternal(element, this.myPersistentEntryPoints);
        for (Element pattern : ContainerUtil.mapNotNull(this.getPatterns(), XmlSerializer::serialize)) {
            element.addContent(pattern);
        }
        for (String annotation : this.getSuppressedAnnotations()) {
            Element e = new Element(SUPPRESSED_ANNOTATIONS);
            e.setText(annotation);
            element.addContent(e);
        }
        return element;
    }

    @NotNull
    public Set<ClassPattern> getPatterns() {
        Set<ClassPattern> set = this.myPatterns;
        if (set == null) {
            PhpEntryPointsManagerImpl.$$$reportNull$$$0(25);
        }
        return set;
    }

    @NotNull
    public List<ClassPattern> getModifiablePatterns() {
        return new ArrayList<ClassPattern>(ContainerUtil.map(this.myPatterns, ClassPattern::new));
    }

    public void updatePatterns(@NotNull Collection<ClassPattern> patterns) {
        if (patterns == null) {
            PhpEntryPointsManagerImpl.$$$reportNull$$$0(26);
        }
        this.myPatterns.clear();
        this.myPatterns.addAll(patterns);
    }

    @Override
    public boolean isAcceptedByPattern(@NotNull PsiElement element) {
        Set<ClassPattern> patterns;
        if (element == null) {
            PhpEntryPointsManagerImpl.$$$reportNull$$$0(27);
        }
        return !(patterns = this.getPatterns()).isEmpty() && (element instanceof PhpClass && PhpEntryPointsManagerImpl.isAcceptedByClassPattern((PhpClass)element, patterns) || element instanceof PhpClassMember && PhpEntryPointsManagerImpl.isAcceptedByMemberPattern((PhpClassMember)element, patterns));
    }

    private static boolean isAcceptedByClassPattern(@NotNull PhpClass phpClass, @NotNull Collection<ClassPattern> patterns) {
        if (phpClass == null) {
            PhpEntryPointsManagerImpl.$$$reportNull$$$0(28);
        }
        if (patterns == null) {
            PhpEntryPointsManagerImpl.$$$reportNull$$$0(29);
        }
        String classFqn = phpClass.getFQN();
        return ContainerUtil.exists(patterns, pattern -> pattern.isOfClassType() && pattern.isAcceptedClass(classFqn));
    }

    private static boolean isAcceptedByMemberPattern(@NotNull PhpClassMember member, @NotNull Collection<ClassPattern> patterns) {
        PhpClass containingClass;
        if (member == null) {
            PhpEntryPointsManagerImpl.$$$reportNull$$$0(30);
        }
        if (patterns == null) {
            PhpEntryPointsManagerImpl.$$$reportNull$$$0(31);
        }
        if ((containingClass = member.getContainingClass()) == null) {
            return false;
        }
        String classFqn = containingClass.getFQN();
        String memberName = member.getName();
        return ContainerUtil.exists(patterns, pattern -> !pattern.isOfClassType() && pattern.isAcceptedMember(classFqn, memberName, member instanceof Method));
    }

    private static void setPermanentEntryAndTraversed(@NotNull RefElement refElement) {
        if (refElement == null) {
            PhpEntryPointsManagerImpl.$$$reportNull$$$0(32);
        }
        PhpEntryPointsManagerImpl.setPermanentEntryPoint(refElement);
        if (refElement instanceof PhpRefElementImpl) {
            ((PhpRefElementImpl)refElement).setInitialized(true);
            ((PhpRefElementImpl)refElement).setTraversed();
        }
    }

    private static void setPermanentEntryPoint(@NotNull RefElement refElement) {
        if (refElement == null) {
            PhpEntryPointsManagerImpl.$$$reportNull$$$0(33);
        }
        ((RefElementImpl)refElement).setEntry(true);
        ((RefElementImpl)refElement).setPermanentEntry(true);
    }

    static void convert(@NotNull Element element, @NotNull Map<? super String, ? super SmartRefElementPointer> persistentEntryPoints) {
        if (element == null) {
            PhpEntryPointsManagerImpl.$$$reportNull$$$0(34);
        }
        if (persistentEntryPoints == null) {
            PhpEntryPointsManagerImpl.$$$reportNull$$$0(35);
        }
        for (Element entryElement : element.getChildren()) {
            if (!"entry_point".equals(entryElement.getName())) continue;
            String fqName = entryElement.getAttributeValue("FQNAME");
            String type = entryElement.getAttributeValue("TYPE");
            if (!StringUtil.isNotEmpty((String)fqName) || !REF_ELEMENT_NAMES.contains(type)) continue;
            persistentEntryPoints.put(fqName, (SmartRefElementPointer)new SmartRefElementPointerImpl(type, fqName));
        }
    }

    static void writeExternal(@NotNull Element element, @NotNull Map<String, SmartRefElementPointer> persistentEntryPoints) {
        if (element == null) {
            PhpEntryPointsManagerImpl.$$$reportNull$$$0(36);
        }
        if (persistentEntryPoints == null) {
            PhpEntryPointsManagerImpl.$$$reportNull$$$0(37);
        }
        if (!persistentEntryPoints.isEmpty()) {
            Element entryPointsElement = new Element("entry_point");
            ((StreamEx)StreamEx.of(persistentEntryPoints.values()).filter(SmartRefElementPointer::isPersistent)).forEach(entryPoint -> entryPoint.writeExternal(entryPointsElement));
            element.addContent(entryPointsElement);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 21, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/reference/PhpEntryPointsManagerImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anEntryPoint";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 6: 
            case 7: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newEntryPoint";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refClass";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refManager";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 26: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patterns";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpClass";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "persistentEntryPoints";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/reference/PhpEntryPointsManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatternEntryPoints";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntryPoints";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveEntryPoints";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPatternEntryPoints";
                break;
            }
            case 2: 
            case 21: 
            case 25: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeEntryPoint";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeClassPatterns";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "shouldParticipateInInitialization";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addEntryPoint";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addNewEntryPoint";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "canBeEntryPoint";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "cannotPersist";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addEntryPointsForInitializers";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "shouldMarkInitializers";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addEntryPointsForClassInitializers";
                break;
            }
            case 13: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isEntryPoint";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addToClassPatterns";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addPersistentEntryPoint";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "persistEntryPoints";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "doActionToProjectEntryPointsManager";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addAllPersistentEntries";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getEntryPoints";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitWrite";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "updatePatterns";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptedByPattern";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptedByClassPattern";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptedByMemberPattern";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setPermanentEntryAndTraversed";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "setPermanentEntryPoint";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 21, 25 -> new IllegalStateException(string);
        };
    }

    @Tag(value="pattern")
    public static class ClassPattern {
        @Attribute(value="value")
        @NotNull
        @NlsSafe
        public String pattern;
        @Attribute(value="member")
        @NotNull
        public String member;
        @Nullable
        private Pattern regexp;
        @Nullable
        private Pattern methodRegexp;
        @Nullable
        private Pattern fieldRegexp;

        public ClassPattern() {
            this.pattern = "";
            this.member = "";
        }

        public ClassPattern(@NotNull ClassPattern classPattern) {
            if (classPattern == null) {
                ClassPattern.$$$reportNull$$$0(0);
            }
            this(classPattern.pattern, classPattern.member);
        }

        public ClassPattern(@NotNull String classFqn) {
            if (classFqn == null) {
                ClassPattern.$$$reportNull$$$0(1);
            }
            this(classFqn, "");
        }

        public ClassPattern(@NotNull String classFqn, @Nullable String memberName) {
            if (classFqn == null) {
                ClassPattern.$$$reportNull$$$0(2);
            }
            this.pattern = "";
            this.member = "";
            this.pattern = classFqn;
            this.member = StringUtil.notNullize((String)memberName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassPattern classPattern = (ClassPattern)o;
            if (!this.matchesClassFqn(classPattern.pattern)) {
                return false;
            }
            return this.member.equals(classPattern.member);
        }

        public int hashCode() {
            int result = StringUtil.toLowerCase((String)this.pattern).hashCode();
            result = 31 * result + this.member.hashCode();
            return result;
        }

        @Nullable
        public Pattern getRegexp() {
            if (this.regexp == null && this.pattern.contains("*")) {
                this.regexp = ClassPattern.createRegexp(this.pattern, true);
            }
            return this.regexp;
        }

        @Nullable
        public Pattern getMethodRegexp() {
            if (this.methodRegexp == null && this.member.contains("*")) {
                this.methodRegexp = ClassPattern.createRegexp(this.member, true);
            }
            return this.methodRegexp;
        }

        @Nullable
        public Pattern getFieldRegexp() {
            if (this.fieldRegexp == null && this.member.contains("*")) {
                this.fieldRegexp = ClassPattern.createRegexp(this.member, false);
            }
            return this.fieldRegexp;
        }

        @Nullable
        private static Pattern createRegexp(@NotNull String pattern, boolean insensitive) {
            if (pattern == null) {
                ClassPattern.$$$reportNull$$$0(3);
            }
            String replace = pattern.replace("\\", "\\\\").replace("*", ".*");
            try {
                int flags = insensitive ? 66 : 0;
                return Pattern.compile(replace, flags);
            }
            catch (PatternSyntaxException e) {
                return null;
            }
        }

        private boolean isOfClassType() {
            return this.member.isEmpty();
        }

        private boolean isAcceptedClass(@NotNull String fqn) {
            if (fqn == null) {
                ClassPattern.$$$reportNull$$$0(4);
            }
            return this.matchesClassFqn(fqn) || ClassPattern.matchesRegex(this.getRegexp(), fqn);
        }

        private boolean matchesClassFqn(@NotNull String fqn) {
            if (fqn == null) {
                ClassPattern.$$$reportNull$$$0(5);
            }
            return PhpLangUtil.equalsClassNames(this.pattern, fqn);
        }

        private boolean isAcceptedMember(@NotNull String fqn, @NotNull String name, boolean isMethod) {
            if (fqn == null) {
                ClassPattern.$$$reportNull$$$0(6);
            }
            if (name == null) {
                ClassPattern.$$$reportNull$$$0(7);
            }
            return this.isAcceptedMemberName(name, isMethod) && this.isAcceptedClass(fqn);
        }

        private boolean isAcceptedMemberName(@NotNull String name, boolean isMethod) {
            if (name == null) {
                ClassPattern.$$$reportNull$$$0(8);
            }
            return isMethod ? this.isAcceptedMethodName(name) : this.isAcceptedFieldName(name);
        }

        private boolean isAcceptedMethodName(@NotNull String name) {
            if (name == null) {
                ClassPattern.$$$reportNull$$$0(9);
            }
            return PhpLangUtil.equalsMethodNames(this.member, name) || ClassPattern.matchesRegex(this.getMethodRegexp(), name);
        }

        private boolean isAcceptedFieldName(@NotNull String name) {
            if (name == null) {
                ClassPattern.$$$reportNull$$$0(10);
            }
            return PhpLangUtil.equalsFieldNames(this.member, name) || ClassPattern.matchesRegex(this.getFieldRegexp(), name);
        }

        private static boolean matchesRegex(@Nullable Pattern pattern, @NotNull String input) {
            if (input == null) {
                ClassPattern.$$$reportNull$$$0(11);
            }
            try {
                return pattern != null && pattern.matcher(input).matches();
            }
            catch (PatternSyntaxException ignored) {
                return false;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classPattern";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classFqn";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = PhpEntryPointsManagerImpl.ENTRY_POINT_PATTERN_ELEMENT;
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fqn";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "input";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/inspections/reference/PhpEntryPointsManagerImpl$ClassPattern";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createRegexp";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAcceptedClass";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "matchesClassFqn";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAcceptedMember";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAcceptedMemberName";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAcceptedMethodName";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAcceptedFieldName";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "matchesRegex";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

