/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.reference;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.JobDescriptor;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.smartPointers.SmartPointerEx;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.PsiReferenceProcessor;
import com.intellij.psi.search.PsiReferenceProcessorAdapter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.deadcode.PhpGlobalInspectionTool;
import com.jetbrains.php.lang.inspections.reference.PhpEntryPointsManager;
import com.jetbrains.php.lang.inspections.reference.PhpExternalUsagesSearcher;
import com.jetbrains.php.lang.inspections.reference.PhpGlobalInspectionContext;
import com.jetbrains.php.lang.inspections.reference.PhpRefManager;
import com.jetbrains.php.lang.inspections.reference.PhpRefManagerImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClass;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefConstant;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefField;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefFileImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefFunction;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefMethod;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefNamespaceImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefUtil;
import com.jetbrains.php.lang.inspections.reference.util.PhpRefScopeUtil;
import com.jetbrains.php.lang.inspections.reference.visitors.PhpRefVisitor;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import com.jetbrains.php.refactoring.rename.PhpRenameSearchParameters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpGlobalInspectionContextImpl
extends PhpGlobalInspectionContext {
    @NotNull
    private static final Logger LOG = Logger.getInstance(PhpGlobalInspectionContext.class);
    @NotNull
    private static final Comparator<SmartPsiElementPointer> containingFileNamesComparator = (o1, o2) -> {
        PsiFile psiFile1 = o1.getContainingFile();
        LOG.assertTrue(psiFile1 != null);
        PsiFile psiFile2 = o2.getContainingFile();
        LOG.assertTrue(psiFile2 != null);
        return psiFile1.getName().compareTo(psiFile2.getName());
    };
    @Nullable
    LowMemoryWatcher lowMemoryWatcher = null;
    @Nullable
    private Map<SmartPsiElementPointer, List<PhpGlobalInspectionContext.UsagesProcessor>> myClassUsagesRequests;
    @Nullable
    private Map<SmartPsiElementPointer, List<Processor<PhpClass>>> myDerivedClassesRequests;
    @Nullable
    private Map<SmartPsiElementPointer, List<Processor<PhpClassMember>>> myDerivedMethodsRequests;
    @Nullable
    private Map<SmartPsiElementPointer, List<PhpGlobalInspectionContext.UsagesProcessor>> myMethodUsagesRequests;
    @Nullable
    private Map<SmartPsiElementPointer, List<PhpGlobalInspectionContext.UsagesProcessor>> myFunctionsUsagesRequests;
    @Nullable
    private Map<SmartPsiElementPointer, List<Processor<PhpClassMember>>> myDerivedFieldsRequests;
    @Nullable
    private Map<SmartPsiElementPointer, List<PhpGlobalInspectionContext.UsagesProcessor>> myFieldUsagesRequests;
    @Nullable
    private Map<SmartPsiElementPointer, List<PhpGlobalInspectionContext.UsagesProcessor>> myConstantUsagesRequests;

    public void cleanup() {
        this.myClassUsagesRequests = null;
        this.myDerivedClassesRequests = null;
        this.myMethodUsagesRequests = null;
        this.myDerivedMethodsRequests = null;
        this.myDerivedFieldsRequests = null;
        this.myFieldUsagesRequests = null;
        this.myConstantUsagesRequests = null;
        this.disposeLowMemoryWatcher();
    }

    @NotNull
    protected <T> Map<SmartPsiElementPointer, List<T>> getOrCreateMap(@Nullable Map<SmartPsiElementPointer, List<T>> requestMap) {
        Map map = (Map)ObjectUtils.notNull(requestMap, HashMap::new);
        if (map == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(0);
        }
        return map;
    }

    private static <T> void enqueueRequestImpl(@NotNull Map<SmartPsiElementPointer, List<T>> requestMap, @NotNull T processor, @NotNull RefElement refElement) {
        if (requestMap == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(2);
        }
        if (refElement == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(3);
        }
        List requests = requestMap.computeIfAbsent(refElement.getPointer(), __ -> new ArrayList());
        requests.add(processor);
    }

    @Override
    public void enqueueClassUsagesProcessor(@NotNull PhpRefClass refClass, @NotNull PhpGlobalInspectionContext.UsagesProcessor p) {
        if (refClass == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(4);
        }
        if (p == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(5);
        }
        this.myClassUsagesRequests = this.getOrCreateMap(this.myClassUsagesRequests);
        PhpGlobalInspectionContextImpl.enqueueRequestImpl(this.myClassUsagesRequests, p, refClass);
    }

    @Override
    public void enqueueDerivedClassesProcessor(@NotNull PhpRefClass refClass, @NotNull Processor<PhpClass> p) {
        if (refClass == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(6);
        }
        if (p == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(7);
        }
        this.myDerivedClassesRequests = this.getOrCreateMap(this.myDerivedClassesRequests);
        PhpGlobalInspectionContextImpl.enqueueRequestImpl(this.myDerivedClassesRequests, p, refClass);
    }

    @Override
    public void enqueueDerivedMethodUsagesProcessor(@NotNull PhpRefMethod refMethod, @NotNull Processor<PhpClassMember> p) {
        if (refMethod == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(8);
        }
        if (p == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(9);
        }
        this.myDerivedMethodsRequests = this.getOrCreateMap(this.myDerivedMethodsRequests);
        PhpGlobalInspectionContextImpl.enqueueRequestImpl(this.myDerivedMethodsRequests, p, refMethod);
    }

    @Override
    public void enqueueMethodUsagesProcessor(@NotNull PhpRefMethod refMethod, @NotNull PhpGlobalInspectionContext.UsagesProcessor p) {
        if (refMethod == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(10);
        }
        if (p == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(11);
        }
        this.myMethodUsagesRequests = this.getOrCreateMap(this.myMethodUsagesRequests);
        PhpGlobalInspectionContextImpl.enqueueRequestImpl(this.myMethodUsagesRequests, p, refMethod);
    }

    @Override
    public void enqueueFunctionUsagesProcessor(@NotNull PhpRefFunction refFunction, @NotNull PhpGlobalInspectionContext.UsagesProcessor p) {
        if (refFunction == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(12);
        }
        if (p == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(13);
        }
        this.myFunctionsUsagesRequests = this.getOrCreateMap(this.myFunctionsUsagesRequests);
        PhpGlobalInspectionContextImpl.enqueueRequestImpl(this.myFunctionsUsagesRequests, p, refFunction);
    }

    @Override
    public void enqueueDerivedFieldUsagesProcessor(@NotNull PhpRefField refField, @NotNull Processor<PhpClassMember> p) {
        if (refField == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(14);
        }
        if (p == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(15);
        }
        this.myDerivedFieldsRequests = this.getOrCreateMap(this.myDerivedFieldsRequests);
        PhpGlobalInspectionContextImpl.enqueueRequestImpl(this.myDerivedFieldsRequests, p, refField);
    }

    @Override
    public void enqueueFieldUsagesProcessor(@NotNull PhpRefField refField, @NotNull PhpGlobalInspectionContext.UsagesProcessor p) {
        if (refField == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(16);
        }
        if (p == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(17);
        }
        this.myFieldUsagesRequests = this.getOrCreateMap(this.myFieldUsagesRequests);
        PhpGlobalInspectionContextImpl.enqueueRequestImpl(this.myFieldUsagesRequests, p, refField);
    }

    @Override
    public void enqueueConstantUsagesProcessor(@NotNull PhpRefConstant refConstant, @NotNull PhpGlobalInspectionContext.UsagesProcessor p) {
        if (refConstant == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(18);
        }
        if (p == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(19);
        }
        this.myConstantUsagesRequests = this.getOrCreateMap(this.myConstantUsagesRequests);
        PhpGlobalInspectionContextImpl.enqueueRequestImpl(this.myConstantUsagesRequests, p, refConstant);
    }

    public void performPreRunActivities(@NotNull List<Tools> globalTools, @NotNull List<Tools> localTools, @NotNull GlobalInspectionContext context) {
        List globalInspections;
        if (globalTools == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(20);
        }
        if (localTools == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(21);
        }
        if (context == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(22);
        }
        if (ContainerUtil.exists((Iterable)(globalInspections = StreamEx.of(globalTools).map(Tools::getTool).map(InspectionToolWrapper::getTool).select(PhpGlobalInspectionTool.class).toList()), GlobalInspectionTool::isGraphNeeded)) {
            RefManagerImpl refManager = (RefManagerImpl)context.getRefManager();
            PhpEntryPointsManager entryPointsManager = PhpRefManager.getEntryPointsManager((RefManager)refManager);
            entryPointsManager.resolveEntryPoints((RefManager)refManager);
            this.setLowMemoryWatcher(refManager);
        }
        if (ContainerUtil.exists((Iterable)globalInspections, PhpGlobalInspectionTool::canAnalyseGlobalVariables)) {
            PhpRefManagerImpl phpRefManager = (PhpRefManagerImpl)PhpRefManager.getInstance(context.getRefManager());
            phpRefManager.setWithGlobalVariables();
        }
    }

    public <T> void processPointersMap(@Nullable Map<SmartPsiElementPointer, List<T>> requestMap, @NotNull BiConsumer<? super PhpPsiElement, List<T>> psiElementConsumer) {
        if (psiElementConsumer == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(23);
        }
        List<SmartPsiElementPointer> sortedIDs = PhpGlobalInspectionContextImpl.getSortedIDs(requestMap);
        for (SmartPsiElementPointer sortedId : sortedIDs) {
            PhpPsiElement phpPsiElement = (PhpPsiElement)ObjectUtils.tryCast((Object)PhpGlobalInspectionContextImpl.dereferenceInReadAction(sortedId), PhpPsiElement.class);
            if (phpPsiElement == null || requestMap == null) {
                return;
            }
            ReadAction.nonBlocking(() -> {
                List processors = (List)requestMap.get(sortedId);
                LOG.assertTrue(processors != null, (Object)phpPsiElement.getName());
                psiElementConsumer.accept(phpPsiElement, processors);
                return true;
            }).executeSynchronously();
        }
    }

    private static void processClassMember(@NotNull PsiElement psiElement, @NotNull GlobalInspectionContext context, @NotNull SearchScope searchScope, @NotNull List<PhpGlobalInspectionContext.UsagesProcessor> processors) {
        PhpClassMember member;
        if (psiElement == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(24);
        }
        if (context == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(25);
        }
        if (searchScope == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(26);
        }
        if (processors == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(27);
        }
        if ((member = (PhpClassMember)ObjectUtils.tryCast((Object)psiElement, PhpClassMember.class)) == null) {
            return;
        }
        context.incrementJobDoneAmount(context.getStdJobDescriptors().FIND_EXTERNAL_USAGES, member.getFQN());
        if (!PhpGlobalInspectionContextImpl.isPublicImplementedMember(member)) {
            return;
        }
        PhpRenameSearchParameters searchParameters = new PhpRenameSearchParameters((PsiElement)member, searchScope);
        PhpGlobalInspectionContextImpl.searchReferences(context, searchParameters, processors);
    }

    protected void processDerivedClasses(@NotNull GlobalInspectionContext context, @NotNull AnalysisScope analysisScope) {
        if (context == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(28);
        }
        if (analysisScope == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(29);
        }
        this.processPointersMap(this.myDerivedClassesRequests, (psiElement, processors) -> {
            PhpClass phpClass = (PhpClass)ObjectUtils.tryCast((Object)psiElement, PhpClass.class);
            if (phpClass == null) {
                return;
            }
            context.incrementJobDoneAmount(context.getStdJobDescriptors().FIND_EXTERNAL_USAGES, phpClass.getPresentableFQN());
            PsiElementProcessorAdapter processor = PhpGlobalInspectionContextImpl.createElementsProcessor(analysisScope, processors);
            PhpClassHierarchyUtils.getDirectSubclasses(phpClass).forEach(arg_0 -> processor.process(arg_0));
        });
    }

    protected void processDerivedMethods(@NotNull GlobalInspectionContext context, @NotNull AnalysisScope analysisScope) {
        if (context == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(30);
        }
        if (analysisScope == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(31);
        }
        this.processPointersMap(this.myDerivedMethodsRequests, (psiElement, processors) -> {
            if (psiElement instanceof Method) {
                context.incrementJobDoneAmount(context.getStdJobDescriptors().FIND_EXTERNAL_USAGES, ((Method)psiElement).getName());
                PhpGlobalInspectionContextImpl.processDerivedMembers(analysisScope, psiElement, processors);
            }
        });
    }

    protected void processDerivedFields(@NotNull GlobalInspectionContext context, @NotNull AnalysisScope analysisScope) {
        if (context == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(32);
        }
        if (analysisScope == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(33);
        }
        this.processPointersMap(this.myDerivedFieldsRequests, (psiElement, processors) -> {
            if (psiElement instanceof Field) {
                context.incrementJobDoneAmount(context.getStdJobDescriptors().FIND_EXTERNAL_USAGES, ((Field)psiElement).getName());
                PhpGlobalInspectionContextImpl.processDerivedMembers(analysisScope, psiElement, processors);
            }
        });
    }

    private static void processDerivedMembers(@NotNull AnalysisScope analysisScope, @NotNull PhpPsiElement psiElement, @NotNull List<Processor<PhpClassMember>> processors) {
        if (analysisScope == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(34);
        }
        if (psiElement == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(35);
        }
        if (processors == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(36);
        }
        PhpClassHierarchyUtils.HierarchyClassMemberProcessor processor = PhpGlobalInspectionContextImpl.createMemberHierarchyProcessor(analysisScope, processors);
        PhpClassHierarchyUtils.processOverridingMembers((PhpClassMember)psiElement, processor);
    }

    protected void processFieldUsages(@NotNull GlobalInspectionContext context, @NotNull SearchScope searchScope) {
        if (context == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(37);
        }
        if (searchScope == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(38);
        }
        this.processPointersMap(this.myFieldUsagesRequests, (psiElement, processors) -> PhpGlobalInspectionContextImpl.processClassMember((PsiElement)psiElement, context, searchScope, processors));
    }

    protected void processMethodUsages(@NotNull GlobalInspectionContext context, @NotNull SearchScope searchScope) {
        if (context == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(39);
        }
        if (searchScope == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(40);
        }
        this.processPointersMap(this.myMethodUsagesRequests, (psiElement, processors) -> PhpGlobalInspectionContextImpl.processClassMember((PsiElement)psiElement, context, searchScope, processors));
    }

    protected void processFunctionUsages(@NotNull GlobalInspectionContext context, @NotNull SearchScope searchScope) {
        if (context == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(41);
        }
        if (searchScope == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(42);
        }
        this.processPointersMap(this.myFunctionsUsagesRequests, (psiElement, processors) -> {
            if (psiElement != null) {
                context.incrementJobDoneAmount(context.getStdJobDescriptors().FIND_EXTERNAL_USAGES, ((Function)psiElement).getFQN());
                ReferencesSearch.SearchParameters searchParameters = new ReferencesSearch.SearchParameters((PsiElement)psiElement, searchScope, true);
                PhpGlobalInspectionContextImpl.searchReferences(context, searchParameters, processors);
            }
        });
    }

    private void processConstantUsages(@NotNull GlobalInspectionContext context, @NotNull SearchScope searchScope) {
        if (context == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(43);
        }
        if (searchScope == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(44);
        }
        this.processPointersMap(this.myConstantUsagesRequests, (psiElement, processors) -> {
            if (psiElement instanceof Constant) {
                context.incrementJobDoneAmount(context.getStdJobDescriptors().FIND_EXTERNAL_USAGES, ((Constant)psiElement).getFQN());
                ReferencesSearch.SearchParameters searchParameters = new ReferencesSearch.SearchParameters((PsiElement)psiElement, searchScope, true);
                PhpGlobalInspectionContextImpl.searchReferences(context, searchParameters, processors);
            }
        });
    }

    protected void processClassUsages(@NotNull GlobalInspectionContext context, @NotNull SearchScope searchScope) {
        if (context == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(45);
        }
        if (searchScope == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(46);
        }
        this.processPointersMap(this.myClassUsagesRequests, (psiElement, processors) -> {
            RefElement refPhpClass;
            if (psiElement instanceof PhpClass && (refPhpClass = PhpRefUtil.getReferenceEx((PsiElement)psiElement, (RefManagerImpl)context.getRefManager())) != null && !refPhpClass.isEntry()) {
                context.incrementJobDoneAmount(context.getStdJobDescriptors().FIND_EXTERNAL_USAGES, ((PhpClass)psiElement).getFQN());
                PhpCodeInsightUtil.PhpAliasSearchParameters parameters = new PhpCodeInsightUtil.PhpAliasSearchParameters((PsiElement)psiElement, searchScope);
                PhpGlobalInspectionContextImpl.searchReferences(context, parameters, processors);
            }
        });
    }

    private static void searchReferences(@NotNull GlobalInspectionContext context, @NotNull ReferencesSearch.SearchParameters parameters, @NotNull List<PhpGlobalInspectionContext.UsagesProcessor> processors) {
        if (context == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(47);
        }
        if (parameters == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(48);
        }
        if (processors == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(49);
        }
        if ((processors = new ArrayList<PhpGlobalInspectionContext.UsagesProcessor>(ContainerUtil.filter(processors, PhpGlobalInspectionContext.UsagesProcessor::isSensibleToProcess))).isEmpty()) {
            return;
        }
        PsiReferenceProcessorAdapter processor = new PsiReferenceProcessorAdapter(PhpGlobalInspectionContextImpl.createReferenceProcessor(context.getRefManager(), processors));
        PhpGlobalInspectionContextImpl.processExtendedUsages(context, parameters.getEffectiveSearchScope(), parameters.getElementToSearch(), (Processor<? super PsiReference>)processor);
        if (processors.isEmpty()) {
            return;
        }
        ReferencesSearch.search((ReferencesSearch.SearchParameters)parameters).forEach((Processor)processor);
    }

    private static void processExtendedUsages(@NotNull GlobalInspectionContext context, @NotNull SearchScope scope, @NotNull PsiElement element, @NotNull Processor<? super PsiReference> processor) {
        if (context == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(50);
        }
        if (scope == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(51);
        }
        if (element == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(52);
        }
        if (processor == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(53);
        }
        for (PhpExternalUsagesSearcher searcher : PhpExternalUsagesSearcher.EP_NAME.getExtensionList()) {
            searcher.processUsages(context, scope, element, processor);
        }
    }

    protected void processSearchRequests(@NotNull GlobalInspectionContext context) {
        AnalysisScope scope;
        if (context == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(54);
        }
        if ((scope = context.getRefManager().getScope()) != null) {
            GlobalSearchScope searchScope = PhpRefScopeUtil.getReferencesSearchScopeOutOf(scope);
            this.processUsages(context, scope, (SearchScope)searchScope);
        }
    }

    private void processUsages(@NotNull GlobalInspectionContext context, @NotNull AnalysisScope scope, @NotNull SearchScope searchScope) {
        if (context == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(55);
        }
        if (scope == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(56);
        }
        if (searchScope == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(57);
        }
        if (this.myDerivedClassesRequests != null) {
            this.processDerivedClasses(context, scope);
            this.myDerivedClassesRequests = null;
        }
        if (this.myDerivedFieldsRequests != null) {
            this.processDerivedFields(context, scope);
            this.myDerivedFieldsRequests = null;
        }
        if (this.myDerivedMethodsRequests != null) {
            this.processDerivedMethods(context, scope);
            this.myDerivedMethodsRequests = null;
        }
        if (this.myClassUsagesRequests != null) {
            this.processClassUsages(context, searchScope);
            this.myClassUsagesRequests = null;
        }
        if (this.myFieldUsagesRequests != null) {
            this.processFieldUsages(context, searchScope);
            this.myFieldUsagesRequests = null;
        }
        if (this.myMethodUsagesRequests != null) {
            this.processMethodUsages(context, searchScope);
            this.myMethodUsagesRequests = null;
        }
        if (this.myFunctionsUsagesRequests != null) {
            this.processFunctionUsages(context, searchScope);
            this.myFunctionsUsagesRequests = null;
        }
        if (this.myConstantUsagesRequests != null) {
            this.processConstantUsages(context, searchScope);
            this.myConstantUsagesRequests = null;
        }
    }

    public void performPostRunActivities(@NotNull List<InspectionToolWrapper<?, ?>> needRepeatSearchRequest, @NotNull GlobalInspectionContext context) {
        if (needRepeatSearchRequest == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(58);
        }
        if (context == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(59);
        }
        JobDescriptor progress = context.getStdJobDescriptors().FIND_EXTERNAL_USAGES;
        progress.setTotalAmount(this.getRequestCount());
        do {
            this.processSearchRequests(context);
            InspectionManager inspectionManager = InspectionManager.getInstance((Project)context.getProject());
            for (InspectionToolWrapper toolWrapper : needRepeatSearchRequest.toArray(InspectionToolWrapper.EMPTY_ARRAY)) {
                boolean result = false;
                if (toolWrapper instanceof GlobalInspectionToolWrapper) {
                    InspectionToolPresentation presentation = ((GlobalInspectionContextImpl)context).getPresentation(toolWrapper);
                    result = ((GlobalInspectionTool)((GlobalInspectionToolWrapper)toolWrapper).getTool()).queryExternalUsagesRequests(inspectionManager, context, (ProblemDescriptionsProcessor)presentation);
                }
                if (result) continue;
                needRepeatSearchRequest.remove(toolWrapper);
            }
            int oldDoneAmount = progress.getDoneAmount();
            progress.setTotalAmount(progress.getTotalAmount() + this.getRequestCount());
            progress.setDoneAmount(oldDoneAmount);
        } while (!needRepeatSearchRequest.isEmpty());
    }

    private int getRequestCount() {
        return IntStreamEx.of((int[])new int[]{PhpGlobalInspectionContextImpl.getRequestSize(this.myClassUsagesRequests), PhpGlobalInspectionContextImpl.getRequestSize(this.myDerivedClassesRequests), PhpGlobalInspectionContextImpl.getRequestSize(this.myFieldUsagesRequests), PhpGlobalInspectionContextImpl.getRequestSize(this.myDerivedFieldsRequests), PhpGlobalInspectionContextImpl.getRequestSize(this.myMethodUsagesRequests), PhpGlobalInspectionContextImpl.getRequestSize(this.myDerivedMethodsRequests), PhpGlobalInspectionContextImpl.getRequestSize(this.myFunctionsUsagesRequests), PhpGlobalInspectionContextImpl.getRequestSize(this.myConstantUsagesRequests)}).sum();
    }

    private static <T> int getRequestSize(@Nullable Map<?, List<T>> map) {
        return map != null ? map.size() : 0;
    }

    @Nullable
    private static PsiElement dereferenceInReadAction(@NotNull SmartPsiElementPointer sortedID) {
        if (sortedID == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(60);
        }
        return (PsiElement)ReadAction.compute(() -> sortedID.getElement());
    }

    @NotNull
    private static List<SmartPsiElementPointer> getSortedIDs(@Nullable Map<SmartPsiElementPointer, ?> requests) {
        List list = requests == null ? Collections.emptyList() : (List)ReadAction.compute(() -> {
            List pointers = ContainerUtil.sorted((Collection)ContainerUtil.filter(requests.keySet(), id -> id != null && id.getContainingFile() != null), containingFileNamesComparator);
            return pointers;
        });
        if (list == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(61);
        }
        return list;
    }

    @NotNull
    private static <Member extends PhpPsiElement, P extends Processor<Member>> PsiElementProcessorAdapter<Member> createElementsProcessor(@NotNull AnalysisScope scope, @NotNull List<P> processors) {
        if (scope == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(62);
        }
        if (processors == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(63);
        }
        return new PsiElementProcessorAdapter(member -> {
            if (scope.contains(member)) {
                return true;
            }
            ArrayList processorsArrayed = new ArrayList(processors);
            for (Processor processor : processorsArrayed) {
                if (processor.process((Object)member)) continue;
                processors.remove(processor);
            }
            return !processors.isEmpty();
        });
    }

    private static PhpClassHierarchyUtils.HierarchyClassMemberProcessor createMemberHierarchyProcessor(@NotNull AnalysisScope scope, @NotNull List<Processor<PhpClassMember>> processors) {
        if (scope == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(64);
        }
        if (processors == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(65);
        }
        PsiElementProcessorAdapter adapter = PhpGlobalInspectionContextImpl.createElementsProcessor(scope, processors);
        return (classMember, subClass, baseClass) -> adapter.process((Object)classMember);
    }

    private static boolean isPublicImplementedMember(@NotNull PhpClassMember classMember) {
        PhpModifier modifier;
        if (classMember == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(66);
        }
        return (modifier = classMember.getModifier()).isPublic() && !modifier.isAbstract();
    }

    @NotNull
    private static PsiReferenceProcessor createReferenceProcessor(@NotNull RefManager refManager, @NotNull List<PhpGlobalInspectionContext.UsagesProcessor> processors) {
        if (refManager == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(67);
        }
        if (processors == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(68);
        }
        PsiReferenceProcessor psiReferenceProcessor = reference -> {
            AnalysisScope scope = refManager.getScope();
            PsiElement referenceElement = reference.getElement();
            if (scope != null && scope.contains(referenceElement) && referenceElement.getLanguage() == PhpLanguage.INSTANCE || PhpGlobalInspectionContextImpl.isInNegligiblePhpDoc(referenceElement)) {
                return true;
            }
            List list = processors;
            synchronized (list) {
                for (PhpGlobalInspectionContext.UsagesProcessor processor : processors.toArray(PhpGlobalInspectionContext.UsagesProcessor.EMPTY_ARRAY)) {
                    if (processor.process(reference)) continue;
                    processors.remove(processor);
                }
            }
            return !processors.isEmpty();
        };
        if (psiReferenceProcessor == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(69);
        }
        return psiReferenceProcessor;
    }

    private static boolean isInNegligiblePhpDoc(@NotNull PsiElement element) {
        PhpDocTag docTag;
        PhpDocComment docComment;
        if (element == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(70);
        }
        if ((docComment = PhpPsiUtil.getParentOfClass((PsiElement)(docTag = PhpPsiUtil.getParentOfClass(element, PhpDocTag.class)), PhpDocComment.class)) == null || !PhpUnitUtil.isInPhpUnitTag((PsiElement)docTag)) {
            return false;
        }
        PsiElement commentOwner = docComment.getOwner();
        return !(commentOwner instanceof PhpClass) && !(commentOwner instanceof Method) || commentOwner instanceof PhpClass && !PhpUnitUtil.isTestClass((PhpClass)commentOwner) || commentOwner instanceof Method && !PhpUnitUtil.isTestMethod((Method)commentOwner);
    }

    private void setLowMemoryWatcher(@NotNull RefManagerImpl refManager) {
        if (refManager == null) {
            PhpGlobalInspectionContextImpl.$$$reportNull$$$0(71);
        }
        this.lowMemoryWatcher = LowMemoryWatcher.register(() -> {
            PhpRefVisitor visitor = new PhpRefVisitor(){

                private static boolean isAlreadyReleased(@NotNull RefElementImpl refEntity) {
                    SmartPointerEx pointer;
                    if (refEntity == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return (pointer = (SmartPointerEx)ObjectUtils.tryCast((Object)refEntity.getPointer(), SmartPointerEx.class)) == null || pointer.getCachedElement() == null;
                }

                private static void clearScope(@Nullable PhpScopeHolder scopeHolder) {
                    if (scopeHolder != null) {
                        scopeHolder.getScope().clear();
                    }
                }

                @Override
                public void visitRefFile(@NotNull PhpRefFileImpl refFile) {
                    if (refFile == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (1.isAlreadyReleased((RefElementImpl)refFile)) {
                        return;
                    }
                    PhpFile file = (PhpFile)ObjectUtils.tryCast((Object)refFile.getContainingFile(), PhpFile.class);
                    1.clearScope(file);
                }

                @Override
                public void visitRefMethod(@NotNull PhpRefMethod refMethod) {
                    if (refMethod == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (1.isAlreadyReleased((RefElementImpl)refMethod)) {
                        return;
                    }
                    1.clearScope(refMethod.getPhpElement());
                }

                @Override
                public void visitRefFunction(@NotNull PhpRefFunction refFunction) {
                    if (refFunction == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    if (1.isAlreadyReleased((RefElementImpl)refFunction)) {
                        return;
                    }
                    1.clearScope(refFunction.getPhpElement());
                }

                @Override
                public void visitRefNamespace(@NotNull PhpRefNamespaceImpl refNamespace) {
                    if (refNamespace == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    if (1.isAlreadyReleased(refNamespace)) {
                        return;
                    }
                    1.clearScope(refNamespace.getPhpElement());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "refEntity";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "refFile";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "refMethod";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "refFunction";
                            break;
                        }
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "refNamespace";
                            break;
                        }
                    }
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/reference/PhpGlobalInspectionContextImpl$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isAlreadyReleased";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitRefFile";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitRefMethod";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitRefFunction";
                            break;
                        }
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitRefNamespace";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            refManager.getElements().forEach(visitor::apply);
        });
    }

    private void disposeLowMemoryWatcher() {
        if (this.lowMemoryWatcher != null) {
            this.lowMemoryWatcher.stop();
            this.lowMemoryWatcher = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 62, 63, 64, 65, 66, 67, 68, 70, 71 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/reference/PhpGlobalInspectionContextImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestMap";
                break;
            }
            case 2: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refClass";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refMethod";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refFunction";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refField";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refConstant";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalTools";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localTools";
                break;
            }
            case 22: 
            case 25: 
            case 28: 
            case 30: 
            case 32: 
            case 37: 
            case 39: 
            case 41: 
            case 43: 
            case 45: 
            case 47: 
            case 50: 
            case 54: 
            case 55: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElementConsumer";
                break;
            }
            case 24: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 26: 
            case 38: 
            case 40: 
            case 42: 
            case 44: 
            case 46: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 27: 
            case 36: 
            case 49: 
            case 63: 
            case 65: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processors";
                break;
            }
            case 29: 
            case 31: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "analysisScope";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 51: 
            case 56: 
            case 62: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 52: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "needRepeatSearchRequest";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sortedID";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classMember";
                break;
            }
            case 67: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateMap";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/reference/PhpGlobalInspectionContextImpl";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedIDs";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferenceProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "enqueueRequestImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "enqueueClassUsagesProcessor";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "enqueueDerivedClassesProcessor";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "enqueueDerivedMethodUsagesProcessor";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "enqueueMethodUsagesProcessor";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "enqueueFunctionUsagesProcessor";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "enqueueDerivedFieldUsagesProcessor";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "enqueueFieldUsagesProcessor";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "enqueueConstantUsagesProcessor";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "performPreRunActivities";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processPointersMap";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "processClassMember";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "processDerivedClasses";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "processDerivedMethods";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "processDerivedFields";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "processDerivedMembers";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "processFieldUsages";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "processMethodUsages";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "processFunctionUsages";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "processConstantUsages";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "processClassUsages";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "searchReferences";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "processExtendedUsages";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "processSearchRequests";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "processUsages";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "performPostRunActivities";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "dereferenceInReadAction";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "createElementsProcessor";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "createMemberHierarchyProcessor";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "isPublicImplementedMember";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "createReferenceProcessor";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "isInNegligiblePhpDoc";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "setLowMemoryWatcher";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 62, 63, 64, 65, 66, 67, 68, 70, 71 -> new IllegalArgumentException(string);
        };
    }
}

