/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.reference.elements;

import com.google.common.base.Predicates;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefEntityImpl;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.containers.Stack;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.deadcode.coreDeclaration.PhpCoreHandler;
import com.jetbrains.php.lang.inspections.deadcode.magicDeclaration.PhpMagicContext;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClass;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClassMember;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClassMemberImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefElement;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefElementImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefFieldImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefMethod;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefMethodImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefUtil;
import com.jetbrains.php.lang.inspections.reference.visitors.PhpRefVisitor;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassAlias;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpRefClassImpl
extends PhpRefElementImpl
implements PhpRefClass {
    private static final int IS_ANONYMOUS_MASK = 65536;
    private static final int IS_INTERFACE_MASK = 131072;
    private static final int IS_ABSTRACT_MASK = 524288;
    private static final int IS_FINAL_MASK = 0x100000;
    private static final int IS_TRAIT_MASK = 0x200000;
    private static final int IS_WITH_IMPLICIT_CONSTRUCTOR = 0x400000;
    private static final int IS_UTILITY = 0x800000;
    private static final int IS_TEST = 0x1000000;
    private static final int IS_IMPLICITLY_USED_CONSTRUCTOR = 0x2000000;
    private static final int IS_WITH_DUPLICATES = 0x4000000;
    private static final int IS_DUPLICATES_INITIATOR = 0x8000000;
    @Nullable
    private final RefModule myRefModule;
    @Nullable
    private Set<PhpRefClass> myBases;
    @Nullable
    private Set<PhpRefClass> mySubClasses;
    @Nullable
    private Set<PhpRefClass> myDuplicates;
    @Nullable
    private PhpRefMethod myConstructor;
    private int myMagicMethodsReferencedFlag;
    private int myCoreMethodsReferencedFlag;
    private int myCoreInterfacesFlag;
    private boolean myWasUsedByConstantsFlag;
    private boolean isRootTestClass;

    public PhpRefClassImpl(PhpClass psi, RefManager manager) {
        super(psi.getName(), psi, manager);
        this.myRefModule = manager.getRefModule(ModuleUtilCore.findModuleForPsiElement((PsiElement)psi));
        if (!(psi.isAbstract() || psi.isInterface() || psi.isTrait())) {
            this.setWithImplicitConstructor(true);
        }
    }

    private synchronized boolean isRootTestClass() {
        return this.isRootTestClass;
    }

    private synchronized void setRootTestClass(boolean rootTestClass) {
        this.isRootTestClass = rootTestClass;
    }

    @Override
    public synchronized boolean isCoreInterfacesImplemented(int coreInterfacesHash) {
        return (this.myCoreInterfacesFlag & coreInterfacesHash) > 0;
    }

    @Override
    public synchronized void setCoreInterfacesImplemented(int coreInterfacesHash) {
        this.myCoreInterfacesFlag |= coreInterfacesHash;
    }

    @Override
    public synchronized boolean isUsedByConstants() {
        return this.myWasUsedByConstantsFlag;
    }

    private synchronized void setUsedByConstants() {
        this.myWasUsedByConstantsFlag = true;
    }

    @Override
    public synchronized boolean isWithDuplicates() {
        return this.checkFlag(0x4000000L);
    }

    private synchronized void setWithDuplicates() {
        this.setFlag(true, 0x4000000L);
    }

    private synchronized boolean isDuplicatesInitiator() {
        return this.checkFlag(0x8000000L);
    }

    private synchronized void setDuplicatesInitiator() {
        this.setFlag(true, 0x8000000L);
    }

    @Override
    public synchronized boolean isMagicMethodReferenced(int magicMethodHash) {
        return (this.myMagicMethodsReferencedFlag & magicMethodHash) > 0;
    }

    @Override
    public synchronized void setMagicMethodReferenced(int magicMethodHash) {
        this.myMagicMethodsReferencedFlag |= magicMethodHash;
    }

    @Override
    public synchronized void setConstructorImplicitlyUsed() {
        this.setFlag(true, 0x2000000L);
    }

    @Override
    public synchronized boolean isConstructorImplicitlyUsed() {
        return this.checkFlag(0x2000000L);
    }

    @Override
    public synchronized boolean isFieldsImplicitlyUsed() {
        return (this.myCoreMethodsReferencedFlag & 0x200) > 0;
    }

    @Override
    public synchronized void setFieldsImplicitlyUsed() {
        this.myCoreMethodsReferencedFlag |= 0x200;
    }

    @Override
    public synchronized int getCoreMethodsReferencedFlag() {
        return this.myCoreMethodsReferencedFlag;
    }

    @Override
    public synchronized void setCoreMethodReferenced(int coreMethodHash) {
        this.myCoreMethodsReferencedFlag |= coreMethodHash;
    }

    @Override
    protected synchronized void initialize() {
        PhpClass phpClass = this.getPhpElement();
        if (phpClass != null) {
            PhpRefMethod refConstructor;
            Method constructor = phpClass.getConstructor();
            if (constructor != null && (refConstructor = (PhpRefMethod)PhpRefUtil.getReferenceEx(constructor, this.getRefManager())) != null && constructor.getParent() == phpClass) {
                this.setConstructor(refConstructor);
            }
            this.setAbstract(phpClass.isAbstract());
            this.setAnonymous(phpClass.isAnonymous());
            this.setInterface(phpClass.isInterface());
            this.setFinal(phpClass.isFinal());
            this.setTrait(phpClass.isTrait());
            this.setRootTestClass(PhpUnitUtil.isRootTestClass(phpClass));
        }
    }

    private void attachParentClass(@NotNull PhpRefClassImpl refParentClass) {
        if (refParentClass == null) {
            PhpRefClassImpl.$$$reportNull$$$0(0);
        }
        this.addSuperClass(refParentClass);
        refParentClass.addSubClass(this);
        this.addReference(refParentClass, (PsiElement)refParentClass.getPhpElement(), (PsiElement)this.getPhpElement(), false, false, null);
    }

    private void initializeSuperReferences(PhpClass phpClass) {
        ((StreamEx)StreamEx.of((Object[])phpClass.getSupers()).filter(arg_0 -> ((RefManagerImpl)this.getRefManager()).belongsToScope(arg_0))).map(superPhpClass -> PhpRefUtil.getReferenceEx((PsiElement)superPhpClass, this.getRefManager())).select(PhpRefClassImpl.class).forEach(this::attachParentClass);
    }

    @Nullable
    public RefModule getModule() {
        return this.myRefModule;
    }

    @Override
    @Nullable
    public PhpClass getPhpElement() {
        return super.getPhpElement(PhpClass.class);
    }

    @NotNull
    public String getQualifiedName() {
        PhpClass phpClass = this.getPhpElement();
        return phpClass != null ? phpClass.getFQN() : "";
    }

    @Override
    public void buildReferences() {
        PhpClass phpClass = this.getPhpElement();
        if (phpClass == null) {
            return;
        }
        this.addDuplicates(this.findDuplicates(phpClass));
        this.initializeMembers(phpClass);
        this.initializeSuperReferences(phpClass);
        PhpRefUtil.traversePhpUnitDocTagsForReferences(this, phpClass);
        super.buildReferences();
    }

    private void initializeMembers(@NotNull PhpClass phpClass) {
        if (phpClass == null) {
            PhpRefClassImpl.$$$reportNull$$$0(1);
        }
        PhpClassMember[] methods = phpClass.getOwnMethods();
        this.initializeMembers(methods);
        PhpClassMember[] fields = phpClass.getOwnFields();
        this.initializeMembers(fields);
        this.setUtility(this.isRegular() && PhpRefClassImpl.isUtilityMembers((Method[])methods, (Field[])fields));
    }

    private void initializeMembers(PhpClassMember @NotNull [] members) {
        if (members == null) {
            PhpRefClassImpl.$$$reportNull$$$0(2);
        }
        for (PhpClassMember member : members) {
            RefElement ref = PhpRefUtil.getReferenceEx((PsiElement)member, this.getRefManager());
            if (ref == null) continue;
            this.addChild((RefEntity)ref);
        }
    }

    private boolean isRegular() {
        return !this.isInterface() && !this.isAbstract() && !this.isTrait();
    }

    private static boolean isUtilityMembers(Method @NotNull [] methods, Field @NotNull [] fields) {
        if (methods == null) {
            PhpRefClassImpl.$$$reportNull$$$0(3);
        }
        if (fields == null) {
            PhpRefClassImpl.$$$reportNull$$$0(4);
        }
        return (methods.length > 0 || fields.length > 0) && !ContainerUtil.exists((Object[])methods, (Condition)Conditions.not(Method::isStatic)) && !ContainerUtil.exists((Object[])fields, (Condition)Conditions.not(Field::isConstant));
    }

    private void addDuplicates(@NotNull Set<PhpRefClass> duplicates) {
        if (duplicates == null) {
            PhpRefClassImpl.$$$reportNull$$$0(5);
        }
        if (!duplicates.isEmpty()) {
            this.setDuplicatesInitiator();
            duplicates.add(this);
            for (PhpRefClass duplicate : duplicates) {
                if (!(duplicate instanceof PhpRefClassImpl)) continue;
                ((PhpRefClassImpl)duplicate).setWithDuplicates();
            }
            for (PhpRefClass refClass : duplicates) {
                ((PhpRefClassImpl)refClass).setDuplicates(duplicates);
            }
        }
    }

    @NotNull
    private Set<PhpRefClass> findDuplicates(@NotNull PhpClass phpClass) {
        if (phpClass == null) {
            PhpRefClassImpl.$$$reportNull$$$0(6);
        }
        if (!(phpClass instanceof PhpClassAlias) && !this.isWithDuplicates()) {
            Set set = ((StreamEx)((StreamEx)StreamEx.of(PhpIndex.getInstance(phpClass.getProject()).getAnyByFQN(phpClass.getFQN())).map(duplicate -> PhpRefUtil.getReferenceEx((PsiElement)duplicate, this.getRefManager())).select(PhpRefClass.class).filter((Predicate)Predicates.not(this::equals))).filter((Predicate)Predicates.not(PhpRefClass::isWithDuplicates))).toSet();
            if (set == null) {
                PhpRefClassImpl.$$$reportNull$$$0(7);
            }
            return set;
        }
        Set<PhpRefClass> set = Collections.emptySet();
        if (set == null) {
            PhpRefClassImpl.$$$reportNull$$$0(8);
        }
        return set;
    }

    private static void addToHierarchyClasses(@NotNull Set<PhpRefClass> myHierarchyClasses, @NotNull Consumer<? super PhpRefClass> consumer) {
        if (myHierarchyClasses == null) {
            PhpRefClassImpl.$$$reportNull$$$0(9);
        }
        if (consumer == null) {
            PhpRefClassImpl.$$$reportNull$$$0(10);
        }
        StreamEx.of(myHierarchyClasses).select(PhpRefClassImpl.class).forEach(arg_0 -> consumer.consume(arg_0));
    }

    private void addPhpUnitInfo() {
        PhpClass phpClass = this.getPhpElement();
        if (phpClass != null && !this.isTest() && PhpUnitUtil.isRunnableTestClass(phpClass)) {
            PhpRefClassImpl.addPhpUnitRecursively(this, true);
            PhpRefClassImpl.addPhpUnitRecursively(this, false);
        }
    }

    private void addPhpUnitInfoFromGraph() {
        if (!this.isTest() && this.isRootTestClass()) {
            PhpRefClassImpl.addPhpUnitRecursively(this, true);
        }
    }

    public void accept(@NotNull RefVisitor visitor) {
        if (visitor == null) {
            PhpRefClassImpl.$$$reportNull$$$0(11);
        }
        if (visitor instanceof PhpRefVisitor) {
            ReadAction.run(() -> ((PhpRefVisitor)visitor).visitRefClass(this));
        } else {
            super.accept(visitor);
        }
    }

    @Override
    @NotNull
    public synchronized Set<PhpRefClass> getSuperClasses() {
        Set set = (Set)ObjectUtils.notNull(this.myBases, Collections.emptySet());
        if (set == null) {
            PhpRefClassImpl.$$$reportNull$$$0(12);
        }
        return set;
    }

    @Override
    @NotNull
    public synchronized Set<PhpRefClass> getDuplicates() {
        Set set = (Set)ObjectUtils.notNull(this.myDuplicates, Collections.emptySet());
        if (set == null) {
            PhpRefClassImpl.$$$reportNull$$$0(13);
        }
        return set;
    }

    private synchronized void setDuplicates(@NotNull Set<PhpRefClass> duplicates) {
        if (duplicates == null) {
            PhpRefClassImpl.$$$reportNull$$$0(14);
        }
        this.myDuplicates = duplicates;
    }

    private synchronized void addSuperClass(@NotNull PhpRefClass refClass) {
        if (refClass == null) {
            PhpRefClassImpl.$$$reportNull$$$0(15);
        }
        this.myBases = (Set)ObjectUtils.notNull(this.myBases, SmartHashSet::new);
        this.myBases.add(refClass);
    }

    private synchronized void removeSuperClass(@NotNull PhpRefClass superClass) {
        if (superClass == null) {
            PhpRefClassImpl.$$$reportNull$$$0(16);
        }
        if (this.myBases != null && this.myBases.contains(superClass)) {
            this.myBases.remove(superClass);
            this.myBases = this.myBases.isEmpty() ? null : this.myBases;
        }
    }

    @Override
    @NotNull
    public synchronized Set<PhpRefClass> getSubClasses() {
        Set set = (Set)ObjectUtils.notNull(this.mySubClasses, Collections.emptySet());
        if (set == null) {
            PhpRefClassImpl.$$$reportNull$$$0(17);
        }
        return set;
    }

    private synchronized void addSubClass(@NotNull PhpRefClass refClass) {
        if (refClass == null) {
            PhpRefClassImpl.$$$reportNull$$$0(18);
        }
        this.mySubClasses = (Set)ObjectUtils.notNull(this.mySubClasses, SmartHashSet::new);
        this.mySubClasses.add(refClass);
    }

    private synchronized void removeSubClass(PhpRefClassImpl refClass) {
        if (this.mySubClasses != null && this.mySubClasses.contains(refClass)) {
            this.mySubClasses.remove(refClass);
            this.mySubClasses = this.mySubClasses.isEmpty() ? null : this.mySubClasses;
        }
    }

    @Override
    @Nullable
    public synchronized PhpRefMethod getConstructor() {
        return this.myConstructor;
    }

    @Override
    public synchronized void setConstructor(@NotNull PhpRefMethod refConstructor) {
        if (refConstructor == null) {
            PhpRefClassImpl.$$$reportNull$$$0(19);
        }
        this.myConstructor = refConstructor;
        this.setWithImplicitConstructor(false);
    }

    @Override
    @Nullable
    public PhpRefMethod getOwnConstructor() {
        return null;
    }

    @Override
    public synchronized boolean hasOnlyStaticMethodsOrConstants() {
        return this.getSubClasses().isEmpty() && this.getSuperClasses().isEmpty() && (this.getOwnMethods().findAny().isPresent() || this.getOwnFields().findAny().isPresent()) && this.getOwnMethods().allMatch(PhpRefMethod::isStatic) && this.getOwnFields().allMatch(refField -> refField.isConstant());
    }

    @NotNull
    public StreamEx<PhpRefMethodImpl> getOwnMethods() {
        StreamEx streamEx = StreamEx.of((Collection)this.getChildren()).select(PhpRefMethodImpl.class);
        if (streamEx == null) {
            PhpRefClassImpl.$$$reportNull$$$0(20);
        }
        return streamEx;
    }

    @NotNull
    public StreamEx<PhpRefFieldImpl> getOwnFields() {
        StreamEx streamEx = StreamEx.of((Collection)this.getChildren()).select(PhpRefFieldImpl.class);
        if (streamEx == null) {
            PhpRefClassImpl.$$$reportNull$$$0(21);
        }
        return streamEx;
    }

    @NotNull
    public String getExternalName() {
        String string = this.getQualifiedName();
        if (string == null) {
            PhpRefClassImpl.$$$reportNull$$$0(22);
        }
        return string;
    }

    @Override
    public void referenceRemoved() {
        super.referenceRemoved();
        PhpRefUtil.runOnCollection(PhpRefClass::getOwnConstructor, this.getSubClasses());
        PhpRefUtil.runOnCollection(superClass -> {
            ((PhpRefClassImpl)superClass).removeSubClass(this);
            this.removeSuperClass((PhpRefClass)superClass);
        }, this.getSuperClasses().toArray(PhpRefClass.EMPTY_ARRAY));
    }

    @Override
    public boolean isTest() {
        return this.checkFlag(0x1000000L);
    }

    private void setTest() {
        this.setFlag(true, 0x1000000L);
    }

    @Override
    public boolean isUtility() {
        return this.checkFlag(0x800000L);
    }

    private void setUtility(boolean utility) {
        this.setFlag(utility, 0x800000L);
    }

    @Override
    public boolean isAnonymous() {
        return this.checkFlag(65536L);
    }

    private void setAnonymous(boolean anonymous) {
        this.setFlag(anonymous, 65536L);
    }

    @Override
    public boolean isInterface() {
        return this.checkFlag(131072L);
    }

    private void setInterface(boolean anInterface) {
        this.setFlag(anInterface, 131072L);
    }

    public synchronized boolean isSuspicious() {
        return !this.isUsedByConstants() && (!this.isUtility() || !this.getOutReferences().isEmpty()) && super.isSuspicious();
    }

    @Override
    public boolean isAbstract() {
        return this.checkFlag(524288L);
    }

    private void setAbstract(boolean anAbstract) {
        this.setFlag(anAbstract, 524288L);
    }

    @Override
    public boolean isFinal() {
        return this.checkFlag(0x100000L);
    }

    private void setFinal(boolean isFinal) {
        this.setFlag(isFinal, 0x100000L);
    }

    @Override
    public boolean isTrait() {
        return this.checkFlag(0x200000L);
    }

    private void setTrait(boolean isTrait) {
        this.setFlag(isTrait, 0x200000L);
    }

    private synchronized boolean isImplemented() {
        return (this.isInterface() || this.isAbstract()) && !this.getSubClasses().isEmpty();
    }

    @Override
    public boolean isWithImplicitConstructor() {
        return this.checkFlag(0x400000L);
    }

    private void setWithImplicitConstructor(boolean withImplicitConstructor) {
        this.setFlag(withImplicitConstructor, 0x400000L);
    }

    public synchronized boolean isReferenced() {
        return super.isReferenced() || this.isImplemented();
    }

    public synchronized boolean hasSuspiciousCallers() {
        return this.hasSuspiciousCallersByClass() || this.hasSuspiciousCallersInDuplicates();
    }

    @Override
    public synchronized boolean hasSuspiciousCallersByClass() {
        return !this.isReferencedOnlyFromTheInside() && super.hasSuspiciousCallers() || this.isImplemented();
    }

    private synchronized boolean hasSuspiciousCallersInDuplicates() {
        for (PhpRefClass duplicate : this.getDuplicates()) {
            if (duplicate == this || duplicate.isEntry() || !duplicate.hasSuspiciousCallersByClass()) continue;
            return true;
        }
        return false;
    }

    private synchronized boolean isReferencedOnlyFromTheInside() {
        boolean referencedOnlyFromOwnMembers;
        Collection inReferences = this.getInReferences();
        boolean bl = referencedOnlyFromOwnMembers = !inReferences.isEmpty() && this.getSuperClasses().isEmpty() && this.getSubClasses().isEmpty();
        if (referencedOnlyFromOwnMembers) {
            for (RefElement reference : inReferences) {
                if (!(reference instanceof PhpRefClassMember)) {
                    return false;
                }
                referencedOnlyFromOwnMembers &= ((PhpRefClassMember)reference).getOwnerClass() == this;
            }
        }
        return referencedOnlyFromOwnMembers;
    }

    @Override
    public void attachFieldsImplicitly() {
        this.attachFieldsImplicitlyInternal(new HashSet<PhpRefClass>());
    }

    private void attachFieldsImplicitlyInternal(@NotNull Set<PhpRefClass> usedClasses) {
        if (usedClasses == null) {
            PhpRefClassImpl.$$$reportNull$$$0(23);
        }
        if (usedClasses.add(this)) {
            this.setFieldsImplicitlyUsed();
            PhpRefClassImpl.addToHierarchyClasses(this.getSuperClasses(), (Consumer<? super PhpRefClass>)((Consumer)phpRefClass -> ((PhpRefClassImpl)phpRefClass).attachFieldsImplicitlyInternal(usedClasses)));
        }
    }

    private synchronized int getMagicMethodsHash() {
        return this.myMagicMethodsReferencedFlag;
    }

    public static void acceptImplicitlyUsagesInfo(@NotNull PhpRefClassImpl refClass, boolean isFullGraph, boolean isPhpUnitPassed) {
        int coreHash;
        if (refClass == null) {
            PhpRefClassImpl.$$$reportNull$$$0(24);
        }
        if (isPhpUnitPassed) {
            if (isFullGraph) {
                refClass.addPhpUnitInfoFromGraph();
            } else {
                refClass.addPhpUnitInfo();
            }
        }
        if (refClass.isFromCommon() && (coreHash = PhpCoreHandler.getCoreDeclarationHash(refClass)) > 0) {
            PhpRefClassImpl.addCoreHash(refClass, coreHash, refClass.getRefManager());
        }
        if (refClass.isFieldsImplicitlyUsed()) {
            refClass.attachFieldsImplicitly();
        }
        if (refClass.isDuplicatesInitiator()) {
            PhpRefClassImpl.propagateDuplicatesToMembers(refClass);
        }
        if (refClass.isUtility() && !refClass.getSubClasses().isEmpty()) {
            refClass.setUtility(false);
        }
        if (refClass.hasReferencedConstants()) {
            refClass.setUsedByConstants();
        }
        if (refClass.isUtility() && refClass.hasOnlyUnreferencedUtilityMembers()) {
            refClass.setUtility(false);
        }
        PhpRefClassImpl.pullMagicMethodsHashUp(refClass);
    }

    private static void propagateDuplicatesToMembers(@NotNull PhpRefClassImpl refClass) {
        Set<PhpRefClass> duplicates;
        if (refClass == null) {
            PhpRefClassImpl.$$$reportNull$$$0(25);
        }
        if (!(duplicates = refClass.getDuplicates()).isEmpty()) {
            Map memberDuplicateGroups = StreamEx.of(duplicates).select(PhpRefClassImpl.class).flatMap(PhpRefClassImpl::getOwnMembers).select(PhpRefClassMemberImpl.class).groupingBy(RefEntity::getName);
            for (List classMembersGroup : memberDuplicateGroups.values()) {
                for (PhpRefClassMemberImpl member : classMembersGroup) {
                    member.addDuplicates(classMembersGroup);
                }
            }
            PhpRefClassImpl.handleImplicitlyDerivedClassMembers(duplicates);
        }
    }

    private static void handleImplicitlyDerivedClassMembers(@NotNull Set<PhpRefClass> duplicates) {
        if (duplicates == null) {
            PhpRefClassImpl.$$$reportNull$$$0(26);
        }
        Map<String, List<PhpRefClassMember>> duplicateMembers = PhpRefClassImpl.getHeritableMemberGroupsWithSupers(duplicates);
        SmartHashSet namesToSearch = new SmartHashSet(duplicateMembers.keySet());
        PhpRefClassImpl.addMemberSuperReferences(duplicateMembers, PhpRefClassImpl.findNearestDerivedMembers(duplicates, (Set<String>)namesToSearch));
    }

    @NotNull
    private static Map<String, List<PhpRefClassMember>> getHeritableMemberGroupsWithSupers(@NotNull Set<PhpRefClass> duplicates) {
        if (duplicates == null) {
            PhpRefClassImpl.$$$reportNull$$$0(27);
        }
        HashSet<PhpRefClass> usedClasses = new HashSet<PhpRefClass>();
        HashSet<PhpRefClass> classesToProcess = new HashSet<PhpRefClass>(duplicates);
        Stack refClassesStack = new Stack(duplicates);
        while (!refClassesStack.empty()) {
            PhpRefClass refClass = (PhpRefClass)refClassesStack.pop();
            if (!usedClasses.add(refClass)) continue;
            if (!refClass.isWithDuplicates()) {
                classesToProcess.add(refClass);
            } else {
                classesToProcess.addAll(refClass.getDuplicates());
            }
            refClassesStack.addAll(refClass.getSuperClasses());
        }
        return PhpRefClassImpl.getHeritableMemberGroups(classesToProcess);
    }

    @NotNull
    private static Map<String, List<PhpRefClassMember>> getHeritableMemberGroups(@NotNull Set<PhpRefClass> classesToProcess) {
        if (classesToProcess == null) {
            PhpRefClassImpl.$$$reportNull$$$0(28);
        }
        Map map = ((StreamEx)((StreamEx)StreamEx.of(classesToProcess).select(PhpRefClassImpl.class).flatMap(PhpRefClassImpl::getOwnMembers).filter((Predicate)Predicates.not(PhpRefClassMember::isFinal))).filter((Predicate)Predicates.not(PhpRefClassMember::isPrivate))).groupingBy(RefEntity::getName);
        if (map == null) {
            PhpRefClassImpl.$$$reportNull$$$0(29);
        }
        return map;
    }

    private static void addMemberSuperReferences(@NotNull Map<String, List<PhpRefClassMember>> memberDuplicateGroups, @NotNull Set<PhpRefClassMember> derivedMembers) {
        if (memberDuplicateGroups == null) {
            PhpRefClassImpl.$$$reportNull$$$0(30);
        }
        if (derivedMembers == null) {
            PhpRefClassImpl.$$$reportNull$$$0(31);
        }
        for (PhpRefClassMember member : derivedMembers) {
            for (PhpRefClassMember superMember : memberDuplicateGroups.get(member.getName())) {
                if (superMember == member) continue;
                if (member instanceof PhpRefMethodImpl && superMember instanceof PhpRefMethodImpl) {
                    ((PhpRefMethodImpl)member).attachSuperMethod((PhpRefMethodImpl)superMember);
                    continue;
                }
                if (!(member instanceof PhpRefFieldImpl) || !(superMember instanceof PhpRefFieldImpl)) continue;
                ((PhpRefFieldImpl)member).attachSuperField((PhpRefFieldImpl)superMember);
            }
        }
    }

    @NotNull
    private static Set<PhpRefClassMember> findNearestDerivedMembers(@NotNull Set<PhpRefClass> refClassesToSearch, @NotNull Set<String> memberNames) {
        if (refClassesToSearch == null) {
            PhpRefClassImpl.$$$reportNull$$$0(32);
        }
        if (memberNames == null) {
            PhpRefClassImpl.$$$reportNull$$$0(33);
        }
        HashSet<PhpRefClass> usedClasses = new HashSet<PhpRefClass>();
        HashSet<PhpRefClassMember> derivedMembers = new HashSet<PhpRefClassMember>();
        PhpRefClassImpl.findNearestDerivedMembersInternal(refClassesToSearch, derivedMembers, usedClasses, memberNames);
        HashSet<PhpRefClassMember> hashSet = derivedMembers;
        if (hashSet == null) {
            PhpRefClassImpl.$$$reportNull$$$0(34);
        }
        return hashSet;
    }

    private static void findNearestDerivedMembersInternal(@NotNull Set<PhpRefClass> refClassesToSearch, @NotNull Set<PhpRefClassMember> derivedMembers, @NotNull Set<PhpRefClass> usedClasses, @NotNull Set<String> memberNames) {
        if (refClassesToSearch == null) {
            PhpRefClassImpl.$$$reportNull$$$0(35);
        }
        if (derivedMembers == null) {
            PhpRefClassImpl.$$$reportNull$$$0(36);
        }
        if (usedClasses == null) {
            PhpRefClassImpl.$$$reportNull$$$0(37);
        }
        if (memberNames == null) {
            PhpRefClassImpl.$$$reportNull$$$0(38);
        }
        ArrayDeque<PhpRefClass> classesToProcess = new ArrayDeque<PhpRefClass>(refClassesToSearch);
        while (!memberNames.isEmpty() && !classesToProcess.isEmpty()) {
            Set<PhpRefClass> subClasses = ((PhpRefClass)classesToProcess.poll()).getSubClasses();
            if (subClasses.isEmpty()) continue;
            SmartHashSet currentMemberNames = new SmartHashSet(memberNames);
            for (PhpRefClass subClass : subClasses) {
                if (!(subClass instanceof PhpRefClassImpl) || !usedClasses.add(subClass)) continue;
                for (PhpRefClassMember member : ((PhpRefClassImpl)subClass).getOwnMembers()) {
                    if (!currentMemberNames.contains(member.getName()) || !derivedMembers.add(member)) continue;
                    memberNames.remove(member.getName());
                }
                classesToProcess.add(subClass);
            }
        }
    }

    @NotNull
    private StreamEx<PhpRefClassMember> getOwnMembers() {
        StreamEx streamEx = StreamEx.of((Collection)this.getChildren()).select(PhpRefClassMember.class);
        if (streamEx == null) {
            PhpRefClassImpl.$$$reportNull$$$0(39);
        }
        return streamEx;
    }

    private boolean hasOnlyUnreferencedUtilityMembers() {
        return this.referencedOnlyInside(true, true);
    }

    private boolean referencedOnlyInside(boolean withMethods, boolean constantsRestriction) {
        return ((StreamEx)((StreamEx)((StreamEx)this.getOwnFields().filter(refField -> !constantsRestriction || refField.isConstant())).select(PhpRefElement.class).append(withMethods ? this.getOwnMethods() : StreamEx.empty())).filter(RefElement::isReferenced)).flatMap(member -> StreamEx.of((Collection)member.getInReferences())).map(member -> member instanceof PhpRefClassMember ? ((PhpRefClassMember)member).getOwnerClass() : member).allMatch(refClass -> refClass == this);
    }

    private boolean hasReferencedConstants() {
        return !this.referencedOnlyInside(false, true);
    }

    private static void pullMagicMethodsHashUp(@NotNull PhpRefClassImpl refClass) {
        if (refClass == null) {
            PhpRefClassImpl.$$$reportNull$$$0(40);
        }
        PhpRefClassImpl.pullMagicMethodsHashUpInternal(refClass, new HashSet<String>(), new HashSet<PhpRefClassImpl>(), refClass.getMagicMethodsHash());
    }

    private static void pullMagicMethodsHashUpInternal(@NotNull PhpRefClassImpl refClass, @NotNull Set<String> usedMagicMethods, @NotNull Set<PhpRefClassImpl> usedClasses, int magicMethodsHash) {
        if (refClass == null) {
            PhpRefClassImpl.$$$reportNull$$$0(41);
        }
        if (usedMagicMethods == null) {
            PhpRefClassImpl.$$$reportNull$$$0(42);
        }
        if (usedClasses == null) {
            PhpRefClassImpl.$$$reportNull$$$0(43);
        }
        if (magicMethodsHash > 0 && usedClasses.add(refClass)) {
            usedMagicMethods.addAll(refClass.getMagicMethods(magicMethodsHash));
            for (PhpRefClass superClass : refClass.getSuperClasses()) {
                superClass.setMagicMethodReferenced((Integer)((StreamEx)((StreamEx)((PhpRefClassImpl)superClass).getOwnMethods().map(method -> method.getName()).filter(PhpLangUtil::isMagicMethod)).filter((Predicate)Predicates.not(usedMagicMethods::contains))).map(PhpMagicContext::getMagicDeclarationHash).map(hash -> magicMethodsHash & hash).reduce((Object)0, (a, b) -> a | b));
                PhpRefClassImpl.pullMagicMethodsHashUpInternal((PhpRefClassImpl)superClass, usedMagicMethods, usedClasses, magicMethodsHash);
            }
        }
    }

    private Set<String> getMagicMethods(int magicMethodsHash) {
        return ((StreamEx)((StreamEx)this.getOwnMethods().map(RefEntityImpl::getName).filter(PhpLangUtil::isMagicMethod)).filter(method -> PhpMagicContext.isMagicDeclarationReferenced(method, magicMethodsHash))).toSet();
    }

    private static void addPhpUnitRecursively(@NotNull PhpRefClassImpl refClass, boolean isForSubClasses) {
        if (refClass == null) {
            PhpRefClassImpl.$$$reportNull$$$0(44);
        }
        PhpRefClassImpl.addPhpUnitRecursivelyInternal(refClass, new HashSet<PhpRefClassImpl>(), isForSubClasses);
    }

    private static void addPhpUnitRecursivelyInternal(@NotNull PhpRefClassImpl refClass, @NotNull Set<PhpRefClassImpl> usedClasses, boolean isForSubClasses) {
        if (refClass == null) {
            PhpRefClassImpl.$$$reportNull$$$0(45);
        }
        if (usedClasses == null) {
            PhpRefClassImpl.$$$reportNull$$$0(46);
        }
        if (usedClasses.add(refClass)) {
            refClass.setTest();
            PhpRefClassImpl.addToHierarchyClasses(isForSubClasses ? refClass.getSubClasses() : refClass.getSuperClasses(), (Consumer<? super PhpRefClass>)((Consumer)subClass -> PhpRefClassImpl.addPhpUnitRecursivelyInternal((PhpRefClassImpl)subClass, usedClasses, isForSubClasses)));
        }
    }

    private static void addCoreHash(@NotNull PhpRefClassImpl refClass, int coreHash, @NotNull RefManagerImpl refManager) {
        if (refClass == null) {
            PhpRefClassImpl.$$$reportNull$$$0(47);
        }
        if (refManager == null) {
            PhpRefClassImpl.$$$reportNull$$$0(48);
        }
        refClass.setCoreInterfacesImplemented(coreHash);
        PhpClass phpClass = refClass.getPhpElement();
        if (phpClass instanceof PhpClassImpl) {
            StreamEx.of(PhpClassHierarchyUtils.getAllSubclasses(phpClass)).map(subClass -> PhpRefUtil.getReferenceEx((PsiElement)subClass, refManager)).select(PhpRefClass.class).forEach(subClass -> subClass.setCoreInterfacesImplemented(coreHash));
        }
    }

    @Nullable
    public static RefEntity classFromExternalName(RefManagerImpl manager, String name) {
        return manager.getReference((PsiElement)ContainerUtil.getFirstItem(PhpIndex.getInstance(manager.getProject()).getClassesByFQN(name)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 12, 13, 17, 20, 21, 22, 29, 34, 39 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refParentClass";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 5: 
            case 14: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duplicates";
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 29: 
            case 34: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/reference/elements/PhpRefClassImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myHierarchyClasses";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 15: 
            case 18: 
            case 24: 
            case 25: 
            case 40: 
            case 41: 
            case 44: 
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refClass";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refConstructor";
                break;
            }
            case 23: 
            case 37: 
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedClasses";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesToProcess";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberDuplicateGroups";
                break;
            }
            case 31: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "derivedMembers";
                break;
            }
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refClassesToSearch";
                break;
            }
            case 33: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberNames";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedMagicMethods";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/reference/elements/PhpRefClassImpl";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findDuplicates";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperClasses";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDuplicates";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubClasses";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnMethods";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnFields";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalName";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeritableMemberGroups";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "findNearestDerivedMembers";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnMembers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "attachParentClass";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "initializeMembers";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isUtilityMembers";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addDuplicates";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findDuplicates";
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 29: 
            case 34: 
            case 39: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addToHierarchyClasses";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setDuplicates";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addSuperClass";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeSuperClass";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addSubClass";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setConstructor";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "attachFieldsImplicitlyInternal";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "acceptImplicitlyUsagesInfo";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "propagateDuplicatesToMembers";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "handleImplicitlyDerivedClassMembers";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getHeritableMemberGroupsWithSupers";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getHeritableMemberGroups";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addMemberSuperReferences";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "findNearestDerivedMembers";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findNearestDerivedMembersInternal";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "pullMagicMethodsHashUp";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "pullMagicMethodsHashUpInternal";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "addPhpUnitRecursively";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "addPhpUnitRecursivelyInternal";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "addCoreHash";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 12, 13, 17, 20, 21, 22, 29, 34, 39 -> new IllegalStateException(string);
        };
    }
}

