/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.reference.elements;

import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.WritableRefEntity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.lang.inspections.reference.PhpRefManager;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefElement;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefFileImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefMethod;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefNamespace;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefParameter;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefUtil;
import com.jetbrains.php.lang.inspections.reference.visitors.PhpExpressionVisitor;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpRefElementImpl
extends RefElementImpl
implements PhpRefElement {
    private static final int IS_FROM_COMMON = 1024;
    private static final int IS_TRAVERSED = 2048;
    private List<RefElement> myPhpDocReferences;

    protected PhpRefElementImpl(@NotNull String elemName, @NotNull RefElement owner) {
        if (elemName == null) {
            PhpRefElementImpl.$$$reportNull$$$0(0);
        }
        if (owner == null) {
            PhpRefElementImpl.$$$reportNull$$$0(1);
        }
        super(elemName, owner);
    }

    protected PhpRefElementImpl(@NotNull String elemName, @NotNull PhpPsiElement psi, @NotNull RefManager manager) {
        if (elemName == null) {
            PhpRefElementImpl.$$$reportNull$$$0(2);
        }
        if (psi == null) {
            PhpRefElementImpl.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            PhpRefElementImpl.$$$reportNull$$$0(4);
        }
        super(elemName, (PsiElement)psi, manager);
    }

    public void buildReferences() {
        PhpPsiElement phpElement = this.getPhpElement(PhpPsiElement.class);
        if (phpElement != null) {
            PhpRefUtil.attachRefToOuter((RefManager)this.getRefManager(), phpElement, this);
        }
    }

    public boolean isSuppressed(String ... toolIds) {
        if (toolIds == null) {
            PhpRefElementImpl.$$$reportNull$$$0(5);
        }
        if (this.isSuppressedByOwners(toolIds)) {
            return true;
        }
        RefElement fileRef = this.getRefManager().getReference((PsiElement)this.getContainingFile());
        return fileRef instanceof PhpRefFileImpl && fileRef.isSuppressed(toolIds);
    }

    protected boolean isSuppressedByOwners(String ... toolId) {
        if (toolId == null) {
            PhpRefElementImpl.$$$reportNull$$$0(6);
        }
        return super.isSuppressed(toolId);
    }

    @Override
    public boolean wasNotCalled() {
        return this.getInReferences().isEmpty();
    }

    @Override
    public boolean wasCalled() {
        return !this.getInReferences().isEmpty();
    }

    public boolean isSuspiciousRecursive() {
        return this.isCalledOnlyFrom(this, (Stack<PhpRefElement>)new Stack());
    }

    private boolean isCalledOnlyFrom(PhpRefElement refElement, Stack<PhpRefElement> callStack) {
        if (callStack.contains((Object)this)) {
            return refElement == this;
        }
        if (this.wasNotCalled()) {
            return false;
        }
        if (refElement instanceof PhpRefMethod) {
            PhpRefMethod refMethod = (PhpRefMethod)refElement;
            boolean superWasCalled = ContainerUtil.exists(refMethod.getSuperMethods(), PhpRefElement::wasCalled);
            if (superWasCalled) {
                return false;
            }
            if (refMethod.isConstructor()) {
                boolean unreachable = true;
                for (RefElement refOut : refMethod.getOutReferences()) {
                    unreachable &= !refOut.isReachable();
                }
                if (unreachable) {
                    return true;
                }
            }
        }
        callStack.push((Object)this);
        for (RefElement refCaller : this.getInReferences()) {
            if (refCaller instanceof PhpRefElementImpl && ((PhpRefElementImpl)refCaller).isCalledOnlyFrom(refElement, callStack)) continue;
            callStack.pop();
            return false;
        }
        callStack.pop();
        return true;
    }

    @Override
    public boolean isTraversed() {
        return this.checkFlag(2048L);
    }

    public void setTraversed() {
        this.setFlag(true, 2048L);
    }

    @Override
    public boolean isFromCommon() {
        return this.checkFlag(1024L);
    }

    public void setFromCommon(boolean fromLibrary) {
        this.setFlag(fromLibrary, 1024L);
    }

    protected void markReferenced(RefElementImpl refFrom, PsiElement psiFrom, PsiElement psiWhat, boolean forWriting, boolean forReading, PhpPsiElement expressionFrom) {
        this.addInReference((RefElement)refFrom);
        this.getRefManager().fireNodeMarkedReferenced((RefElement)this, (RefElement)refFrom, this.isClassInitializer(), forReading, forWriting, (PsiElement)expressionFrom);
    }

    @Override
    public void addReference(@Nullable RefElement refWhat, @Nullable PsiElement psiWhat, @Nullable PsiElement from, boolean wasUsedForWriting, boolean wasUsedForReading, @Nullable PhpPsiElement expression) {
        if (refWhat != null) {
            if (refWhat instanceof PhpRefParameter) {
                if (wasUsedForWriting) {
                    ((PhpRefParameter)refWhat).paramReferenced(true);
                }
                if (wasUsedForReading) {
                    ((PhpRefParameter)refWhat).paramReferenced(false);
                }
            }
            this.addOutReference(refWhat);
            this.markInReference(refWhat, psiWhat, from, wasUsedForWriting, wasUsedForReading, expression);
        }
    }

    protected void markInReference(@NotNull RefElement refWhat, @Nullable PsiElement psiWhat, @Nullable PsiElement from, boolean forWriting, boolean forReading, @Nullable PhpPsiElement expression) {
        if (refWhat == null) {
            PhpRefElementImpl.$$$reportNull$$$0(7);
        }
        if (refWhat instanceof PhpRefFileImpl) {
            ((PhpRefFileImpl)refWhat).addInReference(this);
            this.getRefManager().fireNodeMarkedReferenced(psiWhat, from);
        } else if (refWhat instanceof PhpRefElementImpl) {
            ((PhpRefElementImpl)refWhat).markReferenced(this, from, psiWhat, forWriting, forReading, expression);
        }
    }

    @Override
    public void markOutReference(@NotNull PhpPsiElement expression) {
        if (expression == null) {
            PhpRefElementImpl.$$$reportNull$$$0(8);
        }
        this.getRefManager().fireNodeMarkedReferenced(null, (RefElement)this, this.isClassInitializer(), true, true, (PsiElement)expression);
    }

    protected boolean isClassInitializer() {
        return false;
    }

    public void referenceRemoved() {
        super.referenceRemoved();
        if (this.isEntry()) {
            PhpRefManager.getEntryPointsManager((RefManager)this.getRefManager()).removeEntryPoint(this);
        }
    }

    protected synchronized void initialize() {
    }

    protected void buildReferencesInside(@NotNull Consumer<? super PhpPsiElement> referenceBuilder) {
        PhpPsiElement myElement;
        if (referenceBuilder == null) {
            PhpRefElementImpl.$$$reportNull$$$0(9);
        }
        if ((myElement = this.getPhpElement()) instanceof PhpScopeHolder) {
            PhpExpressionVisitor visitor = new PhpExpressionVisitor(referenceBuilder);
            for (PsiElement child : myElement.getChildren()) {
                child.accept((PsiElementVisitor)visitor);
            }
        }
    }

    protected void buildInnerReference(@NotNull PhpPsiElement innerExpressionOutRef) {
        PhpScopeHolder myScope;
        if (innerExpressionOutRef == null) {
            PhpRefElementImpl.$$$reportNull$$$0(10);
        }
        if ((myScope = (PhpScopeHolder)ObjectUtils.tryCast((Object)this.getPhpElement(), PhpScopeHolder.class)) != null) {
            PhpRefUtil.addReferencesTo(myScope, this, (PsiElement)innerExpressionOutRef);
        }
    }

    @Nullable
    protected <T extends PhpPsiElement> T getPhpElement(Class<T> classToCast) {
        return (T)((PhpPsiElement)ObjectUtils.tryCast((Object)this.getPsiElement(), classToCast));
    }

    @Nullable
    public WritableRefEntity getOwner() {
        WritableRefEntity owner = super.getOwner();
        if (owner instanceof PhpRefNamespace && PhpRefElementImpl.isStructureGroupingUsed(this.getRefManager())) {
            return null;
        }
        return owner;
    }

    private static boolean isStructureGroupingUsed(@NotNull RefManagerImpl refManager) {
        if (refManager == null) {
            PhpRefElementImpl.$$$reportNull$$$0(11);
        }
        return ((GlobalInspectionContextImpl)refManager.getContext()).getUIOptions().SHOW_STRUCTURE;
    }

    @Override
    @NotNull
    public synchronized Collection<RefElement> getPhpDocReferences() {
        Collection collection = (Collection)ObjectUtils.notNull(this.myPhpDocReferences, (Object)ContainerUtil.emptyList());
        if (collection == null) {
            PhpRefElementImpl.$$$reportNull$$$0(12);
        }
        return collection;
    }

    @Override
    public synchronized void addPhpDocReference(@NotNull PhpRefElement refElement) {
        if (refElement == null) {
            PhpRefElementImpl.$$$reportNull$$$0(13);
        }
        this.myPhpDocReferences = (List)ObjectUtils.chooseNotNull(this.myPhpDocReferences, (Object)new SmartList());
        if (!this.myPhpDocReferences.contains(refElement)) {
            this.myPhpDocReferences.add(refElement);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elemName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolIds";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolId";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refWhat";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceBuilder";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerExpressionOutRef";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refManager";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/reference/elements/PhpRefElementImpl";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/reference/elements/PhpRefElementImpl";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhpDocReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressed";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedByOwners";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "markInReference";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "markOutReference";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildReferencesInside";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildInnerReference";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isStructureGroupingUsed";
                break;
            }
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addPhpDocReference";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12 -> new IllegalStateException(string);
        };
    }
}

