/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.reference.elements;

import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.lang.inspections.deadcode.local.PhpUnusedSymbolsFilterVisitor;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClassMember;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClassMemberImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefField;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefUtil;
import com.jetbrains.php.lang.inspections.reference.visitors.PhpRefVisitor;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpRefFieldImpl
extends PhpRefClassMemberImpl
implements PhpRefField {
    private static final int USED_FOR_READING_MASK = 65536;
    private static final int USED_FOR_WRITING_MASK = 131072;
    private static final int ASSIGNED_ONLY_IN_INITIALIZER_MASK = 262144;
    @Nullable
    private Set<PhpRefField> mySuperFields;
    @Nullable
    private Set<PhpRefField> myDerivedFields;
    @Nullable
    private PhpRefField myMirrorField;

    public PhpRefFieldImpl(@NotNull Field psi, @NotNull RefManager manager) {
        if (psi == null) {
            PhpRefFieldImpl.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            PhpRefFieldImpl.$$$reportNull$$$0(1);
        }
        super(psi, manager);
    }

    @Override
    protected synchronized void initialize() {
        super.initialize();
        this.appendDirectSuperMembers(PhpRefFieldImpl.class, superRefField -> this.attachSuperField((PhpRefFieldImpl)superRefField));
    }

    void attachSuperField(PhpRefFieldImpl superRefField) {
        this.addOverlappedField(superRefField);
        this.getRefManager().executeTask(() -> superRefField.markFieldOverlap(this));
    }

    @Override
    @Nullable
    public Field getPhpElement() {
        return super.getPhpElement(Field.class);
    }

    @Override
    @NotNull
    public Collection<? extends PhpRefClassMember> getDerivedMembers() {
        Collection<PhpRefField> collection = this.getDerivedFields();
        if (collection == null) {
            PhpRefFieldImpl.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<? extends PhpRefClassMember> getSuperMembers() {
        return this.getSuperFields();
    }

    @Override
    public void buildReferences() {
        super.buildReferences();
        Field field = this.getPhpElement();
        if (field == null) {
            return;
        }
        PhpRefUtil.attachTypeToDeclaration(field.getType(), field, this);
        this.bindMirrorField(field);
        PsiElement defaultValue = field.getDefaultValue();
        if (defaultValue == null) {
            return;
        }
        PhpRefUtil.addReferencesTo(field, this, defaultValue);
    }

    private void bindMirrorField(@NotNull Field field) {
        RefElement mirrorFieldRef;
        if (field == null) {
            PhpRefFieldImpl.$$$reportNull$$$0(3);
        }
        if ((mirrorFieldRef = PhpRefUtil.getReferenceEx(PhpUnusedSymbolsFilterVisitor.getMirror(field), this.getRefManager())) instanceof PhpRefFieldImpl) {
            ((PhpRefFieldImpl)mirrorFieldRef).setMirror(this);
        }
    }

    @Override
    public boolean isConstant() {
        Field field = this.getPhpElement();
        return field != null && field.isConstant();
    }

    @Override
    public boolean isForReading() {
        return this.checkFlag(65536L);
    }

    public void setForReading(boolean forReading) {
        this.setFlag(forReading, 65536L);
    }

    @Override
    public boolean isForWriting() {
        return this.checkFlag(131072L);
    }

    public void setForWriting(boolean forWriting) {
        this.setFlag(forWriting, 131072L);
    }

    @Override
    public boolean isOnlyAssignedInInitializer() {
        return this.checkFlag(262144L);
    }

    @NotNull
    private synchronized Collection<PhpRefField> getSuperFields() {
        Collection collection = (Collection)ObjectUtils.notNull(this.mySuperFields, Collections.emptySet());
        if (collection == null) {
            PhpRefFieldImpl.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @Override
    @NotNull
    public synchronized Collection<PhpRefField> getDerivedFields() {
        Collection collection = (Collection)ObjectUtils.notNull(this.myDerivedFields, Collections.emptySet());
        if (collection == null) {
            PhpRefFieldImpl.$$$reportNull$$$0(5);
        }
        return collection;
    }

    private synchronized void addOverlappedField(PhpRefField refSuperField) {
        this.mySuperFields = this.addRefMemberTo(refSuperField, this.mySuperFields);
    }

    private synchronized void markFieldOverlap(PhpRefField refOverlappingField) {
        this.myDerivedFields = this.addRefMemberTo(refOverlappingField, this.myDerivedFields);
    }

    @Override
    @Nullable
    public synchronized PhpRefField getRefMirror() {
        return this.myMirrorField;
    }

    public synchronized void setMirror(@NotNull PhpRefField fieldMirror) {
        if (fieldMirror == null) {
            PhpRefFieldImpl.$$$reportNull$$$0(6);
        }
        this.myMirrorField = fieldMirror;
    }

    public void accept(@NotNull RefVisitor visitor) {
        if (visitor == null) {
            PhpRefFieldImpl.$$$reportNull$$$0(7);
        }
        if (visitor instanceof PhpRefVisitor) {
            ReadAction.run(() -> ((PhpRefVisitor)visitor).visitRefField(this));
        } else {
            super.accept(visitor);
        }
    }

    @Override
    public void referenceRemoved() {
        super.referenceRemoved();
        PhpRefUtil.runOnCollection(this::removeSuper, this.getSuperFields().toArray(PhpRefField.EMPTY_FIELD_ARRAY));
    }

    private synchronized void removeSuper(@NotNull PhpRefField superField) {
        if (superField == null) {
            PhpRefFieldImpl.$$$reportNull$$$0(8);
        }
        this.removeRefMemberFrom(this, superField.getDerivedFields());
        this.removeRefMemberFrom(superField, this.getSuperFields());
    }

    public void setAssignedOnlyInInitializer(boolean onlyInInitializer) {
        this.setFlag(onlyInInitializer, 262144L);
    }

    @Nullable
    public static RefEntity fieldFromExternalName(RefManagerImpl manager, String externalName) {
        List qualifiedPath = StringUtil.split((String)externalName, (String)" ");
        if (qualifiedPath.size() == 2) {
            PhpClass phpClass = PhpRefFieldImpl.classFromClassMemberExternalName(manager, qualifiedPath);
            return phpClass != null ? PhpRefUtil.getReferenceEx((PsiElement)ObjectUtils.chooseNotNull((Object)phpClass.findOwnFieldByName((CharSequence)qualifiedPath.get(1), false), (Object)phpClass.findOwnFieldByName((CharSequence)qualifiedPath.get(1), true)), manager) : null;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/reference/elements/PhpRefFieldImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldMirror";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/reference/elements/PhpRefFieldImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDerivedMembers";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperFields";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDerivedFields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "bindMirrorField";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setMirror";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeSuper";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5 -> new IllegalStateException(string);
        };
    }
}

