/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.reference.elements;

import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefEntityImpl;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.PhpTargetElementEvaluator;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.config.library.PhpRuntimeLibraryRootsProvider;
import com.jetbrains.php.lang.PhpCallbackReferenceBase;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocPsiElement;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.PhpDocCommentImpl;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.deadcode.coreDeclaration.PhpCoreHandler;
import com.jetbrains.php.lang.inspections.deadcode.coreDeclaration.PhpCoreHandlerAnnotator;
import com.jetbrains.php.lang.inspections.deadcode.magicDeclaration.PhpMagicContext;
import com.jetbrains.php.lang.inspections.deadcode.magicDeclaration.PhpMagicCreationProvider;
import com.jetbrains.php.lang.inspections.deadcode.magicDeclaration.PhpMagicHandler;
import com.jetbrains.php.lang.inspections.reference.PhpRefManager;
import com.jetbrains.php.lang.inspections.reference.PhpRefManagerImpl;
import com.jetbrains.php.lang.inspections.reference.PhpReferenceScopeExtension;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClass;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClassMember;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefElement;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefElementImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefEntity;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefFileImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefFunction;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefMethod;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefMethodImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefParameter;
import com.jetbrains.php.lang.inspections.reference.util.PhpRefScopeUtil;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Include;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.MultiassignmentExpression;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpEchoStatement;
import com.jetbrains.php.lang.psi.elements.PhpEmpty;
import com.jetbrains.php.lang.psi.elements.PhpEval;
import com.jetbrains.php.lang.psi.elements.PhpExit;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpIsset;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPrintExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpStaticStatement;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.PhpUnset;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ClassReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpRefUtil {
    @NotNull
    private static final String CLOSURE_SIGNATURE = PhpTypeSignatureKey.CLASS.sign("\\Closure");
    @NotNull
    private static final Pattern CLASS_NAME_PATTERN = Pattern.compile("^[a-zA-Z_\\x80-\\xff][a-zA-Z0-9_\\x80-\\xff]*$");
    @NotNull
    private static final Set<String> MAGIC_REFERENCES = ContainerUtil.newHashSet((Object[])new String[]{"__construct", "__invoke", "var_dump", "clone", "var_export", "serialize", "unserialize"});
    @NotNull
    private static final Set<String> CORE_REFERENCES = ContainerUtil.newHashSet((Object[])new String[]{"count", "get_object_vars"});
    @NotNull
    private static final TokenSet PHP_DOC_REFERENCE_HOLDERS = TokenSet.create((IElementType[])new IElementType[]{PhpDocElementTypes.phpDocType, PhpDocElementTypes.phpDocRef, PhpDocElementTypes.phpDocTagValue});
    @NotNull
    private static final Condition<PsiElement> MAGIC_CONTEXTS = psi -> psi instanceof PhpEchoStatement || psi instanceof PhpPrintExpression || psi instanceof PhpIsset || psi instanceof PhpUnset || PhpPsiUtil.isOfType(psi, PhpElementTypes.CLONE_EXPRESSION);
    @NotNull
    private static final Condition<PsiElement> CORE_CONTEXTS = psi -> psi instanceof ForeachStatement || psi instanceof ArrayAccessExpression || psi instanceof PhpIsset || psi instanceof PhpUnset || psi instanceof PhpEmpty;
    private static final Logger LOG = Logger.getInstance(PhpRefUtil.class);

    private PhpRefUtil() {
    }

    public static <T> void runOnCollection(@NotNull Consumer<? super T> consumer, T ... refElements) {
        if (consumer == null) {
            PhpRefUtil.$$$reportNull$$$0(0);
        }
        if (refElements == null) {
            PhpRefUtil.$$$reportNull$$$0(1);
        }
        StreamEx.of((Object[])refElements).forEach(arg_0 -> consumer.consume(arg_0));
    }

    public static <T> void runOnCollection(@NotNull Consumer<? super T> consumer, @NotNull Collection<T> refElements) {
        if (consumer == null) {
            PhpRefUtil.$$$reportNull$$$0(2);
        }
        if (refElements == null) {
            PhpRefUtil.$$$reportNull$$$0(3);
        }
        refElements.forEach(arg_0 -> consumer.consume(arg_0));
    }

    public static <T extends PhpRefElement> void attachRefToOuter(@NotNull RefManager refManager, @NotNull PhpPsiElement phpPsiElement, @NotNull T refElement) {
        if (refManager == null) {
            PhpRefUtil.$$$reportNull$$$0(4);
        }
        if (phpPsiElement == null) {
            PhpRefUtil.$$$reportNull$$$0(5);
        }
        if (refElement == null) {
            PhpRefUtil.$$$reportNull$$$0(6);
        }
        PhpRefUtil.attachRefToModule(refManager, refElement, phpPsiElement);
        PhpRefUtil.attachRefToOuterScope(refManager, refElement, phpPsiElement);
    }

    public static <T extends PhpRefElement> void attachRefToOuterScope(@NotNull RefManager refManager, @NotNull T refElement, @NotNull PhpPsiElement phpPsiElement) {
        PhpScopeHolder scopeHolder;
        if (refManager == null) {
            PhpRefUtil.$$$reportNull$$$0(7);
        }
        if (refElement == null) {
            PhpRefUtil.$$$reportNull$$$0(8);
        }
        if (phpPsiElement == null) {
            PhpRefUtil.$$$reportNull$$$0(9);
        }
        if ((scopeHolder = PhpPsiUtil.getScopeHolder((PsiElement)phpPsiElement)) instanceof PhpNamespace) {
            PhpRefManager phpRefManager = PhpRefManager.getInstance(refManager);
            PhpRefUtil.attachRefToOwner(refElement, (RefEntity)phpRefManager.getNamespace((PhpNamespace)scopeHolder));
        } else {
            PhpRefUtil.attachRefToOwner(refElement, (RefEntity)PhpRefUtil.getReferenceEx((PsiElement)scopeHolder, (RefManagerImpl)refManager));
        }
    }

    public static <T extends PhpRefElement> void attachRefToModule(@NotNull RefManager refManager, @NotNull T refElement, @NotNull PhpPsiElement phpPsiElement) {
        if (refManager == null) {
            PhpRefUtil.$$$reportNull$$$0(10);
        }
        if (refElement == null) {
            PhpRefUtil.$$$reportNull$$$0(11);
        }
        if (phpPsiElement == null) {
            PhpRefUtil.$$$reportNull$$$0(12);
        }
        PhpRefUtil.attachRefToOwner(refElement, (RefEntity)refManager.getRefModule(ModuleUtilCore.findModuleForPsiElement((PsiElement)phpPsiElement.getContainingFile())));
    }

    private static void attachRefToOwner(@NotNull RefElement refElement, @Nullable RefEntity owner) {
        if (refElement == null) {
            PhpRefUtil.$$$reportNull$$$0(13);
        }
        if (owner instanceof RefEntityImpl) {
            ((RefEntityImpl)owner).add((RefEntity)refElement);
        }
    }

    public static void attachTypeToDeclaration(@NotNull PhpType phpTypeLocal, @NotNull PhpPsiElement function, @NotNull PhpRefElementImpl refFunction) {
        if (phpTypeLocal == null) {
            PhpRefUtil.$$$reportNull$$$0(14);
        }
        if (function == null) {
            PhpRefUtil.$$$reportNull$$$0(15);
        }
        if (refFunction == null) {
            PhpRefUtil.$$$reportNull$$$0(16);
        }
        Project project = function.getProject();
        PhpIndex phpIndex = PhpIndex.getInstance(project);
        RefManagerImpl refManager = refFunction.getRefManager();
        for (String type : phpTypeLocal.global(project).getTypes()) {
            if (PhpType.isPrimitiveType(type)) continue;
            for (PhpNamedElement phpNamedElement : phpIndex.getAnyByFQN(type)) {
                RefElement refElement = PhpRefUtil.getReferenceEx((PsiElement)phpNamedElement, refManager);
                if (!(refElement instanceof PhpRefElement)) continue;
                refFunction.addReference(refElement, (PsiElement)phpNamedElement, (PsiElement)function, true, true, null);
            }
        }
    }

    @NotNull
    public static StreamEx<PsiElement> resolveReferenceToList(@NotNull PsiPolyVariantReference phpReference) {
        if (phpReference == null) {
            PhpRefUtil.$$$reportNull$$$0(17);
        }
        StreamEx streamEx = StreamEx.ofNullable((Object)PhpRefUtil.getReferenceToResolve(phpReference)).flatMap(PhpRefUtil::resolve).nonNull();
        if (streamEx == null) {
            PhpRefUtil.$$$reportNull$$$0(18);
        }
        return streamEx;
    }

    private static StreamEx<PsiElement> resolve(PsiPolyVariantReference ref) {
        StreamEx result = StreamEx.of((Object[])ref.multiResolve(false)).map(ResolveResult::getElement);
        if (ref instanceof ClassReference && ClassReferenceImpl.shouldResolveToConstructor((PhpReference)ref)) {
            return result.append((Object)PhpTargetElementEvaluator.getTargetClass((ClassReference)ref));
        }
        return result;
    }

    @Nullable
    private static PsiPolyVariantReference getReferenceToResolve(@NotNull PsiPolyVariantReference phpReference) {
        if (phpReference == null) {
            PhpRefUtil.$$$reportNull$$$0(19);
        }
        if (phpReference instanceof ClassConstantReference) {
            PhpExpression phpExpression;
            ClassConstantReference classConstantReference = (ClassConstantReference)phpReference;
            if (PhpLangUtil.equalsClassNames("class", classConstantReference.getName()) && (phpExpression = classConstantReference.getClassReference()) instanceof ClassReference) {
                return (ClassReference)phpExpression;
            }
        } else if (phpReference instanceof ConstantReference && PhpLangUtil.isBuiltInConstant((ConstantReference)phpReference)) {
            return null;
        }
        return phpReference;
    }

    public static void addReferencesTo(final @NotNull PhpPsiElement fromElement, final @NotNull RefElement fromRefElement, @NotNull PsiElement element) {
        if (fromElement == null) {
            PhpRefUtil.$$$reportNull$$$0(20);
        }
        if (fromRefElement == null) {
            PhpRefUtil.$$$reportNull$$$0(21);
        }
        if (element == null) {
            PhpRefUtil.$$$reportNull$$$0(22);
        }
        final PhpRefEntity fromRefElementImpl = (PhpRefEntity)fromRefElement;
        element.accept((PsiElementVisitor)new PhpElementVisitor(){
            @NotNull
            private final Set<PhpTypedElement> visitedMagicElements = new HashSet<PhpTypedElement>();
            @NotNull
            private final Set<PhpTypedElement> visitedCoreElements = new HashSet<PhpTypedElement>();

            private void visitElementsRecursive(PsiElement ... elements) {
                for (PsiElement element : elements) {
                    this.apply(element);
                }
            }

            @Override
            public void visitPhpNewExpression(NewExpression expression) {
                ClassReference classReference = expression.getClassReference();
                if (classReference != null) {
                    this.apply((PsiElement)classReference);
                } else {
                    PhpPsiElement phpPsiElement = expression.getFirstPsiChild();
                    if (phpPsiElement instanceof PhpClass) {
                        PhpClass anonymousClass = (PhpClass)phpPsiElement;
                        RefManagerImpl refManager = (RefManagerImpl)fromRefElement.getRefManager();
                        RefElement refScope = PhpRefUtil.getReferenceEx((PsiElement)PhpPsiUtil.getScopeHolder((PsiElement)expression), refManager);
                        RefElement ref = PhpRefUtil.getReferenceEx((PsiElement)anonymousClass, refManager);
                        if (ref instanceof PhpRefClass) {
                            PhpRefClass anonymousRefClass = (PhpRefClass)ref;
                            if (refScope instanceof PhpRefEntity) {
                                anonymousRefClass.setMagicMethodReferenced(PhpMagicCreationProvider.getReferencedHash());
                                ((PhpRefEntity)refScope).addReference(anonymousRefClass, (PsiElement)anonymousClass, (PsiElement)fromElement, true, true, expression);
                            }
                        }
                    }
                }
                this.visitElementsRecursive(expression.getParameters());
            }

            @Override
            public void visitPhpReturn(PhpReturn returnStatement) {
                this.visitElementsRecursive(returnStatement.getArgument());
            }

            @Override
            public void visitPhpArrayIndex(ArrayIndex arrayIndex) {
                this.visitElementsRecursive(new PsiElement[]{arrayIndex.getValue()});
            }

            @Override
            public void visitPhpArrayHashElement(ArrayHashElement arrayHashElement) {
                this.visitElementsRecursive(new PsiElement[]{arrayHashElement.getKey(), arrayHashElement.getValue()});
            }

            @Override
            public void visitPhpAssignmentExpression(AssignmentExpression assignmentExpression) {
                this.visitElementsRecursive(new PsiElement[]{assignmentExpression.getValue(), assignmentExpression.getVariable()});
            }

            @Override
            public void visitPhpSelfAssignmentExpression(SelfAssignmentExpression expression) {
                this.visitPhpAssignmentExpression(expression);
            }

            @Override
            public void visitPhpMultiassignmentExpression(MultiassignmentExpression multiassignmentExpression) {
                this.visitElementsRecursive((PsiElement[])multiassignmentExpression.getVariables().toArray(PhpPsiElement.EMPTY_ARRAY));
                this.visitElementsRecursive(new PsiElement[]{multiassignmentExpression.getValue()});
            }

            private void visitReadReference(@NotNull PhpReference phpReference) {
                if (phpReference == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.attachReferenceToFrom(phpReference, false, true);
            }

            private void visitReference(@NotNull PhpReference phpReference) {
                if (phpReference == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.attachReferenceToFrom(phpReference, this.isWriteAccess(phpReference), this.isReadAccess(phpReference));
            }

            private void handleExtraReferencesTo(@Nullable RefElement refResolved, @Nullable PhpReference reference, boolean isForWrite, boolean isForRead) {
                PhpRefClass refClass = PhpRefUtil.getContainingRefClass(refResolved);
                if (refClass == null) {
                    return;
                }
                PhpRefMethod refMethod = (PhpRefMethod)ObjectUtils.tryCast((Object)refResolved, PhpRefMethod.class);
                if (refMethod != null && refMethod.isConstructor()) {
                    fromRefElementImpl.addReference(refClass, (PsiElement)refClass.getPhpElement(), (PsiElement)fromElement, isForWrite, isForRead, reference);
                }
                if (reference instanceof ClassConstantReference && PhpLangUtil.equalsClassNames("class", reference.getNameCS())) {
                    refClass.setConstructorImplicitlyUsed();
                } else if (fromRefElement instanceof PhpRefMethodImpl && reference instanceof ClassReference && PhpLangUtil.isStaticReference((PsiElement)reference) && PhpPsiUtil.getParentByCondition((PsiElement)reference, NewExpression.INSTANCEOF, Statement.INSTANCEOF) != null) {
                    ((PhpRefMethodImpl)fromRefElement).setWithStaticConstructor();
                }
            }

            private void attachMagicVariable(PhpExpression variable) {
                this.attachMagicMethodUsage(variable, false, true);
            }

            private void attachReferenceToFrom(@NotNull PhpReference phpReference, boolean isForWrite, boolean isForRead) {
                if (phpReference == null) {
                    1.$$$reportNull$$$0(2);
                }
                List resolvedElements = PhpRefUtil.resolveReferenceToList(phpReference).toList();
                this.attachMagicReferenceToFrom(phpReference, resolvedElements, isForRead, isForWrite);
                for (PsiElement resolvedElement : resolvedElements) {
                    RefElement inRefResolved = PhpRefUtil.getReferenceEx(resolvedElement, (RefManagerImpl)fromRefElement.getRefManager());
                    this.handleExtraReferencesTo(inRefResolved, phpReference, isForWrite, isForRead);
                    fromRefElementImpl.addReference(inRefResolved, resolvedElement, (PsiElement)fromElement, isForWrite, isForRead, phpReference);
                }
            }

            private void attachMagicReferenceToFrom(@NotNull PhpReference phpReference, @NotNull List<PsiElement> resolvedElements, boolean isForRead, boolean isForWrite) {
                if (phpReference == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (resolvedElements == null) {
                    1.$$$reportNull$$$0(4);
                }
                List resolvedNames = StreamEx.of(resolvedElements).select(PhpPsiElement.class).map(NavigationItem::getName).toList();
                boolean isMagicResolved = StreamEx.of((Collection)resolvedNames).anyMatch(MAGIC_REFERENCES::contains);
                boolean isCoreResolved = StreamEx.of((Collection)resolvedNames).anyMatch(CORE_REFERENCES::contains);
                boolean containsAnyResolvedFunction = StreamEx.of(resolvedElements).anyMatch(resolved -> resolved instanceof Function);
                if (resolvedElements.isEmpty() || isMagicResolved || !containsAnyResolvedFunction) {
                    this.attachMagicReference(phpReference, isForWrite, isForRead);
                }
                if (resolvedElements.isEmpty() || isCoreResolved || !containsAnyResolvedFunction) {
                    this.attachCoreReference(phpReference, null);
                }
            }

            private void attachCallbackReferenceTo(@NotNull PhpCallbackReferenceBase classCallbackReference, @NotNull StringLiteralExpression referenceHolder) {
                if (classCallbackReference == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (referenceHolder == null) {
                    1.$$$reportNull$$$0(6);
                }
                for (PhpNamedElement namedElement : PhpRefUtil.resolveReferenceToList((PsiPolyVariantReference)classCallbackReference).select(PhpNamedElement.class)) {
                    this.attachStringLiteralTo(PhpRefUtil.getReferenceEx((PsiElement)namedElement, (RefManagerImpl)fromRefElement.getRefManager()), namedElement, referenceHolder);
                }
            }

            private void attachStringLiteralTo(@Nullable RefElement refResolvedElement, @NotNull PhpNamedElement resolvedElement, @NotNull StringLiteralExpression referenceHolder) {
                if (resolvedElement == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (referenceHolder == null) {
                    1.$$$reportNull$$$0(8);
                }
                fromRefElementImpl.addReference(refResolvedElement, (PsiElement)resolvedElement, (PsiElement)fromElement, true, true, referenceHolder);
                if (refResolvedElement instanceof PhpRefClass) {
                    ((PhpRefClass)refResolvedElement).setConstructorImplicitlyUsed();
                }
            }

            private void attachMagicReference(@NotNull PhpPsiElement phpReference, boolean isForWrite, boolean isForRead) {
                if (phpReference == null) {
                    1.$$$reportNull$$$0(9);
                }
                if (phpReference instanceof MemberReference) {
                    this.attachMagicMethodUsage(((MemberReference)phpReference).getClassReference(), isForWrite, isForRead);
                } else if (phpReference instanceof ClassReference) {
                    this.attachMagicMethodUsage((PhpExpression)phpReference, isForWrite, isForRead);
                } else if (phpReference instanceof FunctionReference) {
                    PhpExpression phpExpression = (PhpExpression)ObjectUtils.tryCast((Object)phpReference.getFirstPsiChild(), PhpExpression.class);
                    if (phpExpression != null) {
                        this.attachMagicMethodUsage(phpExpression, isForWrite, isForRead);
                    } else {
                        for (PsiElement parameter : ((FunctionReference)phpReference).getParameters()) {
                            if (!(parameter instanceof PhpExpression)) continue;
                            this.attachMagicMethodUsage((PhpExpression)parameter, isForWrite, isForRead);
                        }
                    }
                }
            }

            private void attachCoreReference(@NotNull PhpPsiElement phpReferenceContext, @Nullable PhpPsiElement magicContext) {
                if (phpReferenceContext == null) {
                    1.$$$reportNull$$$0(10);
                }
                if (phpReferenceContext instanceof FunctionReference) {
                    RefManager refManager = fromRefElement.getRefManager();
                    for (PsiElement parameter : ((FunctionReference)phpReferenceContext).getParameters()) {
                        int coreHash;
                        if (!(parameter instanceof PhpExpression) || (coreHash = PhpCoreHandler.getCoreHash((PhpExpression)parameter, phpReferenceContext)) <= 0) continue;
                        if (parameter instanceof StringLiteralExpression) {
                            PhpCoreHandlerAnnotator.markMagicFunctions(coreHash, (FunctionReference)phpReferenceContext, refManager);
                            continue;
                        }
                        PhpCoreHandlerAnnotator.markMagicDeclarations(coreHash, (PhpExpression)parameter, refManager);
                    }
                } else if (phpReferenceContext instanceof PhpReference) {
                    int coreHash;
                    PhpPsiElement context;
                    RefManager refManager = fromRefElement.getRefManager();
                    PhpExpression phpReference = (PhpExpression)ObjectUtils.tryCast((Object)phpReferenceContext, PhpExpression.class);
                    if (phpReference != null && (context = (PhpPsiElement)ObjectUtils.chooseNotNull((Object)magicContext, (Object)PhpCoreHandlerAnnotator.getMagicMethodContext(phpReference))) != null && (coreHash = PhpCoreHandler.getCoreHash(phpReference, context)) > 0) {
                        PhpCoreHandlerAnnotator.markMagicDeclarations(coreHash, phpReference, refManager);
                    }
                }
            }

            @Override
            public void visitPhpVariable(Variable variable) {
                this.visitElementsRecursive(variable.getChildren());
                this.visitPhpTypedReference(variable);
                PhpRefManagerImpl phpRefManager = (PhpRefManagerImpl)PhpRefManager.getInstance(fromRefElement.getRefManager());
                if (phpRefManager.isWithGlobalVariables()) {
                    this.visitReference(variable);
                }
            }

            private void visitPhpTypedReference(@NotNull PhpExpression typedElement) {
                if (typedElement == null) {
                    1.$$$reportNull$$$0(11);
                }
                this.visitPhpMagicTypedReference(typedElement);
                this.visitPhpCoreTypedReference(typedElement);
            }

            private void visitPhpMagicTypedReference(@NotNull PhpTypedElement typedElement) {
                if (typedElement == null) {
                    1.$$$reportNull$$$0(12);
                }
                if (typedElement instanceof PhpExpression && this.visitedMagicElements.add(typedElement)) {
                    PhpPsiElement magicContext = PhpMagicContext.getMagicMethodContext(typedElement);
                    if (MAGIC_CONTEXTS.value((Object)magicContext)) {
                        this.attachMagicVariable((PhpExpression)typedElement);
                    }
                    if (magicContext instanceof PhpTypedElement) {
                        this.visitPhpMagicTypedReference((PhpTypedElement)magicContext);
                    }
                }
            }

            private void visitPhpCoreTypedReference(@NotNull PhpTypedElement typedElement) {
                if (typedElement == null) {
                    1.$$$reportNull$$$0(13);
                }
                if (this.visitedCoreElements.add(typedElement)) {
                    PhpPsiElement coreMagicContext = PhpCoreHandlerAnnotator.getMagicMethodContext(typedElement);
                    if (CORE_CONTEXTS.value((Object)coreMagicContext)) {
                        this.attachCoreReference(typedElement, coreMagicContext);
                    }
                    if (coreMagicContext instanceof PhpTypedElement) {
                        this.visitPhpCoreTypedReference((PhpTypedElement)coreMagicContext);
                    }
                }
            }

            @Override
            public void visitPhpFieldReference(FieldReference fieldReference) {
                this.visitMemberReference(fieldReference);
            }

            @Override
            public void visitPhpClassReference(ClassReference classReference) {
                if (PhpPsiUtil.getParentByCondition((PsiElement)classReference, Parameter.INSTANCEOF, PhpScopeHolder.INSTANCE_OF) == null) {
                    this.visitReference(classReference);
                    this.visitPhpTypedReference(classReference);
                }
            }

            @Override
            public void visitPhpClassConstantReference(ClassConstantReference constantReference) {
                this.visitReference(constantReference);
            }

            @Override
            public void visitPhpUnaryExpression(UnaryExpression expr) {
                if (PhpPsiUtil.isOfType((PsiElement)expr, PhpElementTypes.CLONE_EXPRESSION, PhpElementTypes.INFIX_EXPRESSION, PhpElementTypes.INFIX_WRITE_EXPRESSION, PhpElementTypes.POSTFIX_EXPRESSION, PhpElementTypes.SILENCE_EXPRESSION)) {
                    this.visitElementsRecursive(new PsiElement[]{expr.getValue()});
                } else if (PhpPsiUtil.isOfType((PsiElement)expr, PhpElementTypes.CAST_EXPRESSION) && !PhpPsiUtil.isOfType(expr.getParent(), PhpElementTypes.STATEMENT)) {
                    this.visitElementsRecursive(new PsiElement[]{expr.getValue()});
                }
            }

            @Override
            public void visitPhpArrayCreationExpression(ArrayCreationExpression expression) {
                List<PhpPsiElement> myElements = PhpPsiUtil.getChildren((PsiElement)expression, (Condition<? super PsiElement>)((Condition)element -> element instanceof PhpPsiElement));
                for (PhpPsiElement myElement : myElements) {
                    if (myElement instanceof ArrayHashElement) {
                        this.visitArrayHashElement((ArrayHashElement)myElement);
                        continue;
                    }
                    if (!PhpPsiUtil.isOfType((PsiElement)myElement, PhpElementTypes.ARRAY_VALUE)) continue;
                    this.visitElementsRecursive(new PsiElement[]{myElement.getFirstPsiChild()});
                }
            }

            private void visitArrayHashElement(@NotNull ArrayHashElement arrayHashElement) {
                if (arrayHashElement == null) {
                    1.$$$reportNull$$$0(14);
                }
                this.visitElementsRecursive(new PsiElement[]{arrayHashElement.getKey(), arrayHashElement.getValue()});
            }

            @Override
            public void visitPhpBinaryExpression(BinaryExpression expression) {
                this.visitElementsRecursive(expression.getLeftOperand(), expression.getRightOperand());
            }

            @Override
            public void visitPhpTernaryExpression(TernaryExpression expression) {
                this.visitElementsRecursive(new PsiElement[]{expression.getTrueVariant(), expression.getFalseVariant(), expression.getCondition()});
            }

            @Override
            public void visitPhpMethodReference(MethodReference reference) {
                this.visitMemberReference(reference);
            }

            private void visitMemberReference(@NotNull PhpExpression reference) {
                if (reference == null) {
                    1.$$$reportNull$$$0(15);
                }
                ArrayDeque<MemberReference> classMemberReferences = new ArrayDeque<MemberReference>();
                while (reference != null) {
                    if (classMemberReferences.size() > 400) {
                        LOG.debug("CLASS MEMBERS CHAIN LIMIT for `" + reference.getText() + "` in " + PsiUtilCore.getVirtualFile((PsiElement)reference));
                        classMemberReferences.forEach(r -> this.processMemberReference((MemberReference)r));
                        break;
                    }
                    if (reference instanceof MemberReference) {
                        classMemberReferences.push((MemberReference)reference);
                        reference = ((MemberReference)reference).getClassReference();
                        continue;
                    }
                    classMemberReferences.forEach(r -> this.processMemberReference((MemberReference)r));
                    this.visitElementsRecursive(new PsiElement[]{reference});
                    break;
                }
            }

            private void processMemberReference(@NotNull MemberReference reference) {
                if (reference == null) {
                    1.$$$reportNull$$$0(16);
                }
                if (reference instanceof FieldReference) {
                    this.visitReference(reference);
                    this.visitPhpTypedReference(reference);
                } else if (reference instanceof MethodReference) {
                    this.visitPhpFunctor((MethodReference)reference);
                }
            }

            @Override
            public void visitPhpFunctionCall(FunctionReference reference) {
                this.visitPhpFunctor(reference);
                PhpReference[] functionCallInnerReferences = (PhpReference[])PsiTreeUtil.getChildrenOfType((PsiElement)reference, PhpReference.class);
                if (functionCallInnerReferences != null && functionCallInnerReferences.length > 0) {
                    this.visitElementsRecursive((PsiElement[])functionCallInnerReferences);
                }
            }

            private void visitPhpFunctor(@NotNull FunctionReference reference) {
                if (reference == null) {
                    1.$$$reportNull$$$0(17);
                }
                PsiElement[] parameters = reference.getParameters();
                this.visitElementsRecursive(parameters);
                for (PsiElement parameter : parameters) {
                    this.inferParameterClosure(parameter);
                }
                this.visitReadReference(reference);
            }

            private void inferParameterClosure(@NotNull PsiElement parameter) {
                PhpAccessVariableInstruction variableInstruction;
                if (parameter == null) {
                    1.$$$reportNull$$$0(18);
                }
                if (PhpPsiUtil.isOfType(parameter, PhpElementTypes.VARIABLE) && CLOSURE_SIGNATURE.equals(PhpType.removeParametrisedType(((VariableImpl)parameter).getSignature())) && (variableInstruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)parameter, PhpAccessVariableInstruction.class)) != null) {
                    final RefManagerImpl refManager = (RefManagerImpl)fromRefElement.getRefManager();
                    PhpControlFlowUtil.processPreviousVariableAccesses(variableInstruction, false, new PhpInstructionProcessor(){

                        @Override
                        public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                            if (instruction.getAccess().isWrite() || instruction.getAccess().isWriteRef()) {
                                PhpPsiElement rhe;
                                AssignmentExpression expression = PhpPsiUtil.getParentOfClass((PsiElement)instruction.getAnchor(), AssignmentExpression.class);
                                if (expression != null && PhpPsiUtil.isOfType((PsiElement)(rhe = expression.getValue()), PhpElementTypes.CLOSURE)) {
                                    this.attachClosure(refManager, (PsiElement)PhpPsiUtil.getChildByCondition((PsiElement)rhe, Function.INSTANCEOF), expression);
                                }
                                return false;
                            }
                            return true;
                        }
                    });
                }
            }

            private void attachClosure(@NotNull RefManagerImpl refManager, @Nullable PsiElement parameterClosure, @NotNull PhpPsiElement expression) {
                RefElement refElement;
                if (refManager == null) {
                    1.$$$reportNull$$$0(19);
                }
                if (expression == null) {
                    1.$$$reportNull$$$0(20);
                }
                if (parameterClosure instanceof Function && ((Function)parameterClosure).isClosure() && (refElement = PhpRefUtil.getReferenceEx(parameterClosure, refManager)) instanceof PhpRefFunction) {
                    fromRefElementImpl.addReference(refElement, parameterClosure, (PsiElement)fromElement, false, true, expression);
                }
            }

            @Override
            public void visitPhpInclude(Include include) {
                this.visitElementsRecursive(new PsiElement[]{include.getArgument()});
                fromRefElementImpl.markOutReference(include);
            }

            @Override
            public void visitPhpConstantReference(ConstantReference reference) {
                this.visitReference(reference);
            }

            @Override
            public void visitPhpArrayAccessExpression(ArrayAccessExpression expression) {
                PhpPsiElement value = expression.getValue();
                this.visitElementsRecursive(new PsiElement[]{value, expression.getIndex()});
                if (expression.getIndex() != null && value instanceof Variable) {
                    this.attachCoreReference(value, PhpCoreHandlerAnnotator.getMagicMethodContext(expression));
                }
            }

            @Override
            public void visitPhpExpression(PhpExpression expression) {
                if (PhpPsiUtil.isOfType((PsiElement)expression, PhpElementTypes.CLOSURE)) {
                    PsiElement parameterClosure = expression.getFirstChild();
                    PhpPsiElement callReference = PhpPsiUtil.getParentOfClass(parameterClosure, FunctionReference.class);
                    if (callReference != null) {
                        this.attachClosure((RefManagerImpl)fromRefElement.getRefManager(), parameterClosure, callReference);
                    } else if (!(fromRefElement instanceof PhpRefFileImpl)) {
                        this.attachClosure((RefManagerImpl)fromRefElement.getRefManager(), parameterClosure, expression);
                    }
                } else {
                    this.visitElementsRecursive(expression.getChildren());
                }
            }

            @Override
            public void visitPhpStringLiteralExpression(StringLiteralExpression expression) {
                Object[] references = expression.getReferences();
                PsiElement[] expressionChildren = expression.getChildren();
                StreamEx.of((Object[])references).select(PhpCallbackReferenceBase.class).forEach(reference -> this.attachCallbackReferenceTo((PhpCallbackReferenceBase)((Object)reference), expression));
                this.visitElementsRecursive(expressionChildren);
                if (references.length == 0 && expressionChildren.length == 0) {
                    this.attachImplicitStringLiteralReferences(expression);
                }
            }

            private void attachImplicitStringLiteralReferences(@NotNull StringLiteralExpression expression) {
                String contents;
                if (expression == null) {
                    1.$$$reportNull$$$0(21);
                }
                if (!expression.isHeredoc() && !StringUtil.containsWhitespaces((CharSequence)(contents = expression.getContents())) && StringUtil.countNewLines((CharSequence)contents) == 0 && (StringUtil.containsChar((String)contents, (char)'\\') || CLASS_NAME_PATTERN.matcher(contents).matches())) {
                    for (PhpClass phpClass : PhpIndex.getInstance(expression.getProject()).getAnyByFQN(contents)) {
                        this.attachStringLiteralTo(PhpRefUtil.getReferenceEx((PsiElement)phpClass, (RefManagerImpl)fromRefElement.getRefManager()), phpClass, expression);
                    }
                }
            }

            @Override
            public void visitPhpParenthesizedExpression(ParenthesizedExpression expression) {
                this.apply((PsiElement)expression.extract());
            }

            @Override
            public void visitPhpIsset(PhpIsset issetExpression) {
                this.visitElementsRecursive((PsiElement[])issetExpression.getVariables());
            }

            @Override
            public void visitPhpEmpty(PhpEmpty emptyExpression) {
                this.visitElementsRecursive((PsiElement[])emptyExpression.getVariables());
            }

            @Override
            public void visitPhpUnset(PhpUnset unsetStatement) {
                this.visitElementsRecursive((PsiElement[])unsetStatement.getArguments());
            }

            @Override
            public void visitPhpExit(PhpExit exitExpression) {
                this.visitElementsRecursive(new PsiElement[]{exitExpression.getArgument()});
            }

            @Override
            public void visitPhpEchoStatement(PhpEchoStatement echoStatement) {
                this.visitElementsRecursive((PsiElement[])echoStatement.getArguments());
                fromRefElementImpl.markOutReference(echoStatement);
            }

            @Override
            public void visitPhpPrint(PhpPrintExpression printExpression) {
                this.visitElementsRecursive(new PsiElement[]{printExpression.getArgument()});
                fromRefElementImpl.markOutReference(printExpression);
            }

            @Override
            public void visitPhpEval(PhpEval element) {
                this.visitElementsRecursive(element.getChildren());
                fromRefElementImpl.markOutReference(element);
            }

            @Override
            public void visitPhpStaticStatement(PhpStaticStatement staticStatement) {
                StreamEx.of(staticStatement.getDeclarations()).map(AssignmentExpression::getValue).forEach(this::apply);
            }

            private boolean isWriteAccess(@NotNull PhpReference reference) {
                Object parentExpression;
                if (reference == null) {
                    1.$$$reportNull$$$0(22);
                }
                return 1.isLHE(reference, parentExpression = PhpPsiUtil.getParentByCondition((PsiElement)reference, (Condition<? super PsiElement>)((Condition)expression -> !(expression instanceof ParenthesizedExpression)))) || 1.isUnaryAssignmentExpression(parentExpression);
            }

            private boolean isReadAccess(@NotNull PhpReference reference) {
                Object parentExpression;
                if (reference == null) {
                    1.$$$reportNull$$$0(23);
                }
                return !1.isLHE(reference, parentExpression = PhpPsiUtil.getParentByCondition((PsiElement)reference, (Condition<? super PsiElement>)((Condition)expression -> !(expression instanceof ParenthesizedExpression)))) || 1.isUnaryAssignmentExpression(parentExpression);
            }

            private static boolean isLHE(@NotNull PhpReference lheReference, @Nullable PsiElement expression) {
                if (lheReference == null) {
                    1.$$$reportNull$$$0(24);
                }
                return expression instanceof PhpExpression && PhpPsiUtil.isOfType(expression, PhpElementTypes.ASSIGNMENTS) && lheReference == expression.getFirstChild();
            }

            private static boolean isUnaryAssignmentExpression(@Nullable PsiElement expression) {
                return PhpPsiUtil.isOfType(expression, PhpElementTypes.INFIX_EXPRESSION, PhpElementTypes.INFIX_WRITE_EXPRESSION, PhpElementTypes.POSTFIX_EXPRESSION);
            }

            public void attachMagicMethodUsage(@Nullable PhpExpression phpMemberReference, boolean isForWrite, boolean isForRead) {
                RefManager refManager;
                Collection<PhpRefMethod> functions;
                PhpPsiElement magicMethodContext;
                PhpMagicHandler magicProvider;
                if (phpMemberReference != null && (magicProvider = PhpMagicContext.getMagicProvider(phpMemberReference, magicMethodContext = PhpMagicContext.getMagicMethodContext(phpMemberReference), functions = 1.resolveRefMethodDeclarations(magicMethodContext, refManager = fromRefElement.getRefManager()))) != null) {
                    int referencedHash = magicProvider.getReferencedHash(phpMemberReference, magicMethodContext, isForWrite, isForRead);
                    PhpMagicContext.markMagicDeclarations(referencedHash, phpMemberReference, fromRefElement.getRefManager());
                }
            }

            @NotNull
            private static Collection<PhpRefMethod> resolveRefMethodDeclarations(@Nullable PhpPsiElement magicMethodContext, @NotNull RefManager refManager) {
                if (refManager == null) {
                    1.$$$reportNull$$$0(25);
                }
                if (magicMethodContext instanceof FunctionReference) {
                    List list = StreamEx.of((Object[])((FunctionReference)magicMethodContext).multiResolve(false)).map(ResolveResult::getElement).map(arg_0 -> ((RefManager)refManager).getReference(arg_0)).select(PhpRefMethod.class).toList();
                    if (list == null) {
                        1.$$$reportNull$$$0(26);
                    }
                    return list;
                }
                List list = ContainerUtil.emptyList();
                if (list == null) {
                    1.$$$reportNull$$$0(27);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 26, 27 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "phpReference";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "resolvedElements";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "classCallbackReference";
                        break;
                    }
                    case 6: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "referenceHolder";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "resolvedElement";
                        break;
                    }
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "phpReferenceContext";
                        break;
                    }
                    case 11: 
                    case 12: 
                    case 13: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "typedElement";
                        break;
                    }
                    case 14: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "arrayHashElement";
                        break;
                    }
                    case 15: 
                    case 16: 
                    case 17: 
                    case 22: 
                    case 23: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "reference";
                        break;
                    }
                    case 18: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parameter";
                        break;
                    }
                    case 19: 
                    case 25: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "refManager";
                        break;
                    }
                    case 20: 
                    case 21: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 24: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "lheReference";
                        break;
                    }
                    case 26: 
                    case 27: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/lang/inspections/reference/elements/PhpRefUtil$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/lang/inspections/reference/elements/PhpRefUtil$1";
                        break;
                    }
                    case 26: 
                    case 27: {
                        objectArray = objectArray2;
                        objectArray2[1] = "resolveRefMethodDeclarations";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitReadReference";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "visitReference";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "attachReferenceToFrom";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "attachMagicReferenceToFrom";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "attachCallbackReferenceTo";
                        break;
                    }
                    case 7: 
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "attachStringLiteralTo";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray;
                        objectArray[2] = "attachMagicReference";
                        break;
                    }
                    case 10: {
                        objectArray = objectArray;
                        objectArray[2] = "attachCoreReference";
                        break;
                    }
                    case 11: {
                        objectArray = objectArray;
                        objectArray[2] = "visitPhpTypedReference";
                        break;
                    }
                    case 12: {
                        objectArray = objectArray;
                        objectArray[2] = "visitPhpMagicTypedReference";
                        break;
                    }
                    case 13: {
                        objectArray = objectArray;
                        objectArray[2] = "visitPhpCoreTypedReference";
                        break;
                    }
                    case 14: {
                        objectArray = objectArray;
                        objectArray[2] = "visitArrayHashElement";
                        break;
                    }
                    case 15: {
                        objectArray = objectArray;
                        objectArray[2] = "visitMemberReference";
                        break;
                    }
                    case 16: {
                        objectArray = objectArray;
                        objectArray[2] = "processMemberReference";
                        break;
                    }
                    case 17: {
                        objectArray = objectArray;
                        objectArray[2] = "visitPhpFunctor";
                        break;
                    }
                    case 18: {
                        objectArray = objectArray;
                        objectArray[2] = "inferParameterClosure";
                        break;
                    }
                    case 19: 
                    case 20: {
                        objectArray = objectArray;
                        objectArray[2] = "attachClosure";
                        break;
                    }
                    case 21: {
                        objectArray = objectArray;
                        objectArray[2] = "attachImplicitStringLiteralReferences";
                        break;
                    }
                    case 22: {
                        objectArray = objectArray;
                        objectArray[2] = "isWriteAccess";
                        break;
                    }
                    case 23: {
                        objectArray = objectArray;
                        objectArray[2] = "isReadAccess";
                        break;
                    }
                    case 24: {
                        objectArray = objectArray;
                        objectArray[2] = "isLHE";
                        break;
                    }
                    case 25: {
                        objectArray = objectArray;
                        objectArray[2] = "resolveRefMethodDeclarations";
                        break;
                    }
                    case 26: 
                    case 27: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 26, 27 -> new IllegalStateException(string);
                };
            }
        });
    }

    @Nullable
    public static PhpRefClass getContainingRefClass(@Nullable RefElement refElement) {
        if (refElement instanceof PhpRefClass) {
            return (PhpRefClass)refElement;
        }
        if (refElement instanceof PhpRefClassMember) {
            return ((PhpRefClassMember)refElement).getOwnerClass();
        }
        return null;
    }

    public static PhpRefParameter @NotNull [] initializeParameterList(@NotNull PhpRefFunction refFunction, @NotNull Function function) {
        if (refFunction == null) {
            PhpRefUtil.$$$reportNull$$$0(23);
        }
        if (function == null) {
            PhpRefUtil.$$$reportNull$$$0(24);
        }
        PhpRefManager phpRefManager = PhpRefManager.getInstance(refFunction.getRefManager());
        Parameter[] parameters = function.getParameters();
        if (parameters.length > 0) {
            PhpRefParameter[] refParameters = new PhpRefParameter[parameters.length];
            for (int i = 0; i < refParameters.length; ++i) {
                refParameters[i] = phpRefManager.createRefParameter(parameters[i], i, refFunction);
            }
            if (refParameters == null) {
                PhpRefUtil.$$$reportNull$$$0(25);
            }
            return refParameters;
        }
        if (PhpRefParameter.EMPTY_ARRAY == null) {
            PhpRefUtil.$$$reportNull$$$0(26);
        }
        return PhpRefParameter.EMPTY_ARRAY;
    }

    @Nullable
    public static RefElement getReferenceEx(@Nullable PsiElement elem, @NotNull RefManagerImpl refManager) {
        if (refManager == null) {
            PhpRefUtil.$$$reportNull$$$0(27);
        }
        if (!((Boolean)ReadAction.compute(() -> elem == null || !elem.isValid() || elem instanceof LightElement || !(elem instanceof PsiDirectory) && !PhpRefUtil.mightHavePhpReferences(elem, refManager))).booleanValue()) {
            return refManager.getReference(elem, true);
        }
        if (elem != null && (PhpRefUtil.belongsToPhpLibraryScope(elem) || !PhpRefUtil.mightHavePhpReferences(elem, refManager))) {
            PhpRefManager extension = PhpRefManager.getInstance((RefManager)refManager);
            return refManager.getFromRefTableOrCache(elem, () -> (PhpRefElementImpl)ReadAction.compute(() -> (PhpRefElementImpl)ObjectUtils.tryCast((Object)extension.createRefElement(elem), PhpRefElementImpl.class)), element -> {
                PsiFile containingFile = (PsiFile)ReadAction.compute(() -> ((PsiElement)elem).getContainingFile());
                element.setFromCommon(PhpRefScopeUtil.isByBuiltInLibrary(containingFile.getVirtualFile()));
                element.initializeIfNeeded();
            });
        }
        return null;
    }

    private static boolean mightHavePhpReferences(@NotNull PsiElement elem, @NotNull RefManagerImpl refManager) {
        if (elem == null) {
            PhpRefUtil.$$$reportNull$$$0(28);
        }
        if (refManager == null) {
            PhpRefUtil.$$$reportNull$$$0(29);
        }
        if (refManager.belongsToScope(elem)) {
            return true;
        }
        return ContainerUtil.exists((Object[])((PhpReferenceScopeExtension[])PhpReferenceScopeExtension.EP_NAME.getExtensions()), e -> e.mightHavePhpReferences(elem));
    }

    static void traversePhpUnitDocTagsForReferences(@NotNull PhpRefElementImpl refElement, @NotNull PhpNamedElement declaration) {
        PhpDocComment docComment;
        if (refElement == null) {
            PhpRefUtil.$$$reportNull$$$0(30);
        }
        if (declaration == null) {
            PhpRefUtil.$$$reportNull$$$0(31);
        }
        if ((docComment = declaration.getDocComment()) instanceof PhpDocCommentImpl) {
            RefManagerImpl refManager = refElement.getRefManager();
            List<PhpDocTag> docTags = ((PhpDocCommentImpl)docComment).getDocTagByClass(PhpDocTag.class);
            ((StreamEx)StreamEx.of(docTags).filter(PhpUnitUtil::isInPhpUnitTag)).map(tag -> PhpPsiUtil.getChildOfType((PsiElement)tag, PHP_DOC_REFERENCE_HOLDERS)).select(PhpDocPsiElement.class).append(docTags).flatMap(tag -> StreamEx.of((Object[])tag.getReferences())).map(PsiReference::resolve).select(PhpNamedElement.class).map(resolvedElement -> PhpRefUtil.getReferenceEx((PsiElement)resolvedElement, refManager)).select(PhpRefElement.class).forEach(reference -> refElement.addPhpDocReference((PhpRefElement)reference));
        }
    }

    private static boolean belongsToPhpLibraryScope(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            PhpRefUtil.$$$reportNull$$$0(32);
        }
        PsiFile containingFile = (PsiFile)ReadAction.compute(() -> ((PsiElement)psiElement).getContainingFile());
        if (containingFile == null) {
            return false;
        }
        VirtualFile virtualFile = (VirtualFile)ReadAction.compute(() -> ((PsiFile)containingFile).getVirtualFile());
        if (virtualFile == null) {
            return false;
        }
        Boolean inProject = (Boolean)ReadAction.compute(() -> PhpRefUtil.isInLibrarySource(psiElement, virtualFile));
        return inProject;
    }

    public static boolean isInLibrarySource(@NotNull PsiElement psiElement, VirtualFile virtualFile) {
        if (psiElement == null) {
            PhpRefUtil.$$$reportNull$$$0(33);
        }
        return FileIndexFacade.getInstance((Project)psiElement.getProject()).isInLibrarySource(virtualFile) || PhpRuntimeLibraryRootsProvider.isInStubRoots(psiElement.getProject(), virtualFile);
    }

    static void buildFunctorReferences(@NotNull PhpRefFunction refFunction, @NotNull Function function) {
        Object body;
        if (refFunction == null) {
            PhpRefUtil.$$$reportNull$$$0(34);
        }
        if (function == null) {
            PhpRefUtil.$$$reportNull$$$0(35);
        }
        if ((body = PhpPsiUtil.getChildByCondition(function, (Condition<? super PsiElement>)((Condition)element -> element instanceof PhpPsiElement && !(element instanceof ParameterList)))) instanceof GroupStatement) {
            refFunction.setHasBody();
            if (body.getChildren().length == 0) {
                refFunction.setEmptyBody();
            }
        }
        if (function.isClosure()) {
            refFunction.setClosure();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 18, 25, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElements";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refManager";
                break;
            }
            case 5: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpPsiElement";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpTypeLocal";
                break;
            }
            case 15: 
            case 24: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 16: 
            case 23: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refFunction";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpReference";
                break;
            }
            case 18: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/reference/elements/PhpRefUtil";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromElement";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromRefElement";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elem";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/reference/elements/PhpRefUtil";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveReferenceToList";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "initializeParameterList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runOnCollection";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "attachRefToOuter";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "attachRefToOuterScope";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "attachRefToModule";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "attachRefToOwner";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "attachTypeToDeclaration";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferenceToList";
                break;
            }
            case 18: 
            case 25: 
            case 26: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceToResolve";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addReferencesTo";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "initializeParameterList";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceEx";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "mightHavePhpReferences";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "traversePhpUnitDocTagsForReferences";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "belongsToPhpLibraryScope";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isInLibrarySource";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "buildFunctorReferences";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 18, 25, 26 -> new IllegalStateException(string);
        };
    }
}

