/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.reference.visitors;

import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.ControlStatement;
import com.jetbrains.php.lang.psi.elements.DoWhile;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Finally;
import com.jetbrains.php.lang.psi.elements.For;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Global;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.If;
import com.jetbrains.php.lang.psi.elements.Include;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.MultiassignmentExpression;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpAttributesList;
import com.jetbrains.php.lang.psi.elements.PhpCase;
import com.jetbrains.php.lang.psi.elements.PhpEchoStatement;
import com.jetbrains.php.lang.psi.elements.PhpEmpty;
import com.jetbrains.php.lang.psi.elements.PhpEval;
import com.jetbrains.php.lang.psi.elements.PhpExit;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpIsset;
import com.jetbrains.php.lang.psi.elements.PhpMatchArm;
import com.jetbrains.php.lang.psi.elements.PhpMatchExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPrintExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpStaticStatement;
import com.jetbrains.php.lang.psi.elements.PhpSwitch;
import com.jetbrains.php.lang.psi.elements.PhpThrowExpression;
import com.jetbrains.php.lang.psi.elements.PhpTraitUseRule;
import com.jetbrains.php.lang.psi.elements.PhpUnset;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpYield;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.Try;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.While;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PhpExpressionVisitor
extends PhpElementVisitor {
    @NotNull
    final Consumer<? super PhpPsiElement> myExpressionProcessor;

    public PhpExpressionVisitor(@NotNull Consumer<? super PhpPsiElement> expressionProcessor) {
        if (expressionProcessor == null) {
            PhpExpressionVisitor.$$$reportNull$$$0(0);
        }
        this.myExpressionProcessor = expressionProcessor;
    }

    @Override
    public void visitPhpElement(PhpPsiElement element) {
        if (element instanceof Statement) {
            this.visitPhpStatement((Statement)element);
        }
        if (element instanceof PhpExpression) {
            this.visitPhpExpression((PhpExpression)element);
        }
    }

    @Override
    public void visitPhpIf(If ifStatement) {
        this.visitControlFlow(ifStatement);
        this.visitElements((PsiElement[])ifStatement.getElseIfBranches());
        this.visitElements(new PsiElement[]{ifStatement.getElseBranch()});
    }

    @Override
    public void visitPhpElseIf(ElseIf elseIfStatement) {
        this.visitControlFlow(elseIfStatement);
    }

    @Override
    public void visitPhpElse(Else elseStatement) {
        this.visitElements(new PsiElement[]{elseStatement.getStatement()});
    }

    @Override
    public void visitPhpWhile(While whileStatement) {
        this.visitControlFlow(whileStatement);
    }

    @Override
    public void visitPhpDoWhile(DoWhile doWhileStatement) {
        this.visitControlFlow(doWhileStatement);
    }

    @Override
    public void visitPhpForeach(ForeachStatement foreach) {
        this.visitElements(new PsiElement[]{foreach.getKey(), foreach.getValue(), foreach.getArray(), foreach.getStatement()});
    }

    @Override
    public void visitPhpFor(For forStatement) {
        this.visitElements(new PsiElement[][]{forStatement.getInitialExpressions(), forStatement.getConditionalExpressions(), forStatement.getRepeatedExpressions()});
        this.visitElements(new PsiElement[]{forStatement.getStatement()});
    }

    @Override
    public void visitPhpSwitch(PhpSwitch switchStatement) {
        this.visitElements(switchStatement.getArgument());
        this.visitElements((PsiElement[])switchStatement.getAllCases());
    }

    @Override
    public void visitPhpCase(PhpCase phpCase) {
        this.visitControlFlow(phpCase);
    }

    @Override
    public void visitPhpTry(Try tryStatement) {
        this.visitElements((PsiElement[])tryStatement.getCatchClauses());
        this.visitElements(new PsiElement[]{tryStatement.getStatement(), tryStatement.getFinallyBlock()});
    }

    @Override
    public void visitPhpCatch(Catch phpCatch) {
        this.visitElements(new PsiElement[]{phpCatch.getException(), phpCatch.getStatement()});
    }

    @Override
    public void visitPhpFinally(Finally element) {
        this.visitElements(new PsiElement[]{element.getStatement()});
    }

    @Override
    public void visitPhpReturn(PhpReturn returnStatement) {
        this.visitElements(returnStatement.getArgument());
    }

    @Override
    public void visitPhpYield(PhpYield element) {
        this.visitElements(element.getArgument());
    }

    @Override
    public void visitPhpGroupStatement(GroupStatement groupStatement) {
        this.visitElements(groupStatement.getStatements());
    }

    @Override
    public void visitPhpGlobal(Global globalStatement) {
        this.visitElements((PsiElement[])globalStatement.getVariables());
    }

    @Override
    public void visitPhpNamespace(PhpNamespace namespace) {
        this.visitElements(new PsiElement[]{namespace.getStatements()});
    }

    @Override
    public void visitPhpExpression(PhpExpression expression) {
        this.myExpressionProcessor.consume((Object)expression);
    }

    @Override
    public void visitPhpUse(PhpUse expression) {
        PhpReference targetReference = expression.getTargetReference();
        if (targetReference != null) {
            this.visitPhpExpression(targetReference);
        }
    }

    @Override
    public void visitPhpNewExpression(NewExpression expression) {
        this.visitPhpExpression(expression);
    }

    @Override
    public void visitPhpAssignmentExpression(AssignmentExpression assignmentExpression) {
        this.visitPhpExpression(assignmentExpression);
    }

    @Override
    public void visitPhpSelfAssignmentExpression(SelfAssignmentExpression expression) {
        this.visitPhpExpression(expression);
    }

    @Override
    public void visitPhpMultiassignmentExpression(MultiassignmentExpression multiassignmentExpression) {
        this.visitPhpExpression(multiassignmentExpression);
    }

    @Override
    public void visitPhpUnaryExpression(UnaryExpression expr) {
        this.visitPhpExpression(expr);
    }

    @Override
    public void visitPhpVariable(Variable variable) {
        this.visitPhpExpression(variable);
    }

    @Override
    public void visitPhpClassReference(ClassReference classReference) {
        this.visitPhpExpression(classReference);
    }

    @Override
    public void visitPhpMethodReference(MethodReference reference) {
        this.visitPhpExpression(reference);
    }

    @Override
    public void visitPhpClassConstantReference(ClassConstantReference constantReference) {
        this.visitPhpExpression(constantReference);
    }

    @Override
    public void visitPhpFieldReference(FieldReference fieldReference) {
        this.visitPhpExpression(fieldReference);
    }

    @Override
    public void visitPhpFunctionCall(FunctionReference reference) {
        this.visitPhpExpression(reference);
    }

    @Override
    public void visitPhpInclude(Include include) {
        this.visitPhpExpression(include);
    }

    @Override
    public void visitPhpConstantReference(ConstantReference reference) {
        this.visitPhpExpression(reference);
    }

    @Override
    public void visitPhpArrayAccessExpression(ArrayAccessExpression expression) {
        this.visitPhpExpression(expression);
    }

    @Override
    public void visitPhpBinaryExpression(BinaryExpression expression) {
        this.visitPhpExpression(expression);
    }

    @Override
    public void visitPhpTernaryExpression(TernaryExpression expression) {
        this.visitPhpExpression(expression);
    }

    @Override
    public void visitPhpStringLiteralExpression(StringLiteralExpression expression) {
        this.visitPhpExpression(expression);
    }

    @Override
    public void visitPhpParenthesizedExpression(ParenthesizedExpression expression) {
        this.visitPhpExpression(expression);
    }

    @Override
    public void visitPhpIsset(PhpIsset issetExpression) {
        this.visitPhpExpression(issetExpression);
    }

    @Override
    public void visitPhpEmpty(PhpEmpty emptyExpression) {
        this.visitPhpExpression(emptyExpression);
    }

    @Override
    public void visitPhpUnset(PhpUnset unsetStatement) {
        this.visitElements((PsiElement[])unsetStatement.getArguments());
    }

    @Override
    public void visitPhpExit(PhpExit exitExpression) {
        this.visitPhpExpression(exitExpression);
    }

    @Override
    public void visitPhpPrint(PhpPrintExpression printExpression) {
        this.visitPhpExpression(printExpression);
    }

    @Override
    public void visitPhpEval(PhpEval element) {
        this.visitPhpExpression(element);
    }

    @Override
    public void visitPhpThrowExpression(PhpThrowExpression throwExpression) {
        this.apply((PsiElement)throwExpression.getArgument());
    }

    @Override
    public void visitPhpStaticStatement(PhpStaticStatement staticStatement) {
        staticStatement.getDeclarations().forEach(this::apply);
    }

    @Override
    public void visitPhpEchoStatement(PhpEchoStatement echoStatement) {
        this.myExpressionProcessor.consume((Object)echoStatement);
    }

    @Override
    public void visitPhpTraitUseRule(PhpTraitUseRule type) {
        this.apply((PsiElement)type.getOriginalReference());
        for (ClassReference override : type.getOverrides()) {
            this.apply((PsiElement)override);
        }
        this.apply(type.getOriginal());
    }

    @Override
    public void visitPhpAttributesList(PhpAttributesList attributesList) {
        this.visitElements(attributesList.getAttributes());
    }

    @Override
    public void visitPhpAttribute(PhpAttribute attribute) {
        this.apply((PsiElement)attribute.getClassReference());
        this.visitElements(attribute.getParameters());
    }

    @Override
    public void visitPhpMatchExpression(PhpMatchExpression matchExpression) {
        this.visitElements(new PsiElement[]{matchExpression.getArgument()});
        for (PhpMatchArm arm : matchExpression.getMatchArms()) {
            this.visitElements(arm.getConditions());
            this.visitElements(new PsiElement[]{arm.getBodyExpression()});
        }
    }

    @Override
    public void visitPhpConstant(Constant constant) {
        this.visitElements(constant.getChildren());
    }

    @Override
    public void visitPhpStatement(Statement statement) {
        this.visitElements(statement.getChildren());
    }

    private void visitElements(PsiElement ... elements) {
        if (elements == null) {
            PhpExpressionVisitor.$$$reportNull$$$0(1);
        }
        for (PsiElement element : elements) {
            this.apply(element);
        }
    }

    private void visitElements(Collection<? extends PsiElement> elements) {
        for (PsiElement psiElement : elements) {
            this.apply(psiElement);
        }
    }

    private void visitElements(PsiElement[] ... elementArrays) {
        for (PsiElement[] elementArray : elementArrays) {
            this.visitElements(elementArray);
        }
    }

    private void visitControlFlow(@NotNull ControlStatement controlStmt) {
        if (controlStmt == null) {
            PhpExpressionVisitor.$$$reportNull$$$0(2);
        }
        this.visitElements(new PsiElement[]{controlStmt.getCondition(), controlStmt.getStatement()});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionProcessor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controlStmt";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/reference/visitors/PhpExpressionVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitElements";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitControlFlow";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

