/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.regexp;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.injection.PhpInjectionUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.regexp.PhpRegExpModifierInspectionBase;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ConcatenationExpression;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.StringLiteralExpressionImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.List;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.jetbrains.annotations.NotNull;

public final class PhpRegExpInvalidDelimiterInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpRegExpInvalidDelimiterInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpStringLiteralExpression(StringLiteralExpression expression) {
                String message;
                String contents = expression.getContents();
                StringLiteralExpressionImpl expressionImpl = (StringLiteralExpressionImpl)ObjectUtils.tryCast((Object)expression, StringLiteralExpressionImpl.class);
                if (expressionImpl == null || contents.isEmpty() || PsiTreeUtil.findChildOfType((PsiElement)expression, Variable.class) != null || PhpPsiUtil.getParentOfClass((PsiElement)expression, ConcatenationExpression.class) != null) {
                    return;
                }
                String optionsText = expressionImpl.getRegExpOptionsText();
                if (optionsText == null) {
                    return;
                }
                Pair injectionInfo = (Pair)ContainerUtil.getOnlyItem((Collection)InjectedLanguageManager.getInstance((Project)holder.getProject()).getInjectedPsiFiles((PsiElement)expression));
                if (!PhpRegExpInvalidDelimiterInspection.isInjectedInLiteralWithLeadingDelimiter((Pair<PsiElement, TextRange>)injectionInfo, expression)) {
                    return;
                }
                RegExpPattern pattern = PhpRegExpModifierInspectionBase.getPattern((Pair<PsiElement, TextRange>)injectionInfo);
                if (pattern == null) {
                    return;
                }
                String patternText = pattern.getText();
                char leadingDelimiter = contents.charAt(0);
                String string = Character.isLetterOrDigit(leadingDelimiter) || leadingDelimiter == '\\' ? PhpBundle.message("inspection.php.regexp.delimiter.is.alphanumeric.or.backslash", new Object[0]) : (message = PhpRegExpInvalidDelimiterInspection.containsDelimiter(patternText, leadingDelimiter, PhpInjectionUtil.getTrailingDelimiter(contents)) ? PhpBundle.message("inspection.php.regexp.delimiter.is.used.in.reg.exp", new Object[0]) : null);
                if (message == null) {
                    return;
                }
                holder.registerProblem((PsiElement)expression, PhpRegExpInvalidDelimiterInspection.getLeadingDelimiterRange(), message, new LocalQuickFix[]{new PhpReplaceWithValidDelimiter(patternText, optionsText)});
            }
        };
    }

    private static boolean containsDelimiter(String patternText, char leadingDelimiter, char trailingDelimiter) {
        int delimiterCounter = 0;
        for (int i = 0; i < patternText.length(); ++i) {
            char c = patternText.charAt(i);
            if (leadingDelimiter == trailingDelimiter && PhpRegExpInvalidDelimiterInspection.charEqualsDelimiter(c, leadingDelimiter, patternText, i)) {
                return true;
            }
            if (leadingDelimiter == trailingDelimiter) continue;
            if (PhpRegExpInvalidDelimiterInspection.charEqualsDelimiter(c, leadingDelimiter, patternText, i)) {
                ++delimiterCounter;
            }
            if (!PhpRegExpInvalidDelimiterInspection.charEqualsDelimiter(c, trailingDelimiter, patternText, i)) continue;
            --delimiterCounter;
        }
        return delimiterCounter != 0;
    }

    private static boolean isInjectedInLiteralWithLeadingDelimiter(Pair<PsiElement, TextRange> info, StringLiteralExpression pattern) {
        if (info == null || info.getSecond() == null) {
            return false;
        }
        return ((TextRange)info.getSecond()).getStartOffset() == pattern.getValueRange().getStartOffset() + 1;
    }

    private static boolean charEqualsDelimiter(char delimiter, char c, String patternText, int position) {
        return delimiter == c && (position == 0 || patternText.charAt(position - 1) != '\\');
    }

    private static TextRange getLeadingDelimiterRange() {
        return TextRange.create((int)1, (int)2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/regexp/PhpRegExpInvalidDelimiterInspection", "buildVisitor"));
    }

    private static class PhpReplaceWithValidDelimiter
    extends PsiUpdateModCommandQuickFix {
        private static final List<Character> VALID_DELIMITERS = List.of(Character.valueOf('/'), Character.valueOf('#'), Character.valueOf('~'), Character.valueOf('*'), Character.valueOf('^'), Character.valueOf('%'), Character.valueOf('&'), Character.valueOf('!'), Character.valueOf('-'), Character.valueOf('+'), Character.valueOf('='), Character.valueOf('_'));
        private final String myPatternText;
        private final String myOptionsText;

        PhpReplaceWithValidDelimiter(String patternText, String optionsText) {
            this.myPatternText = patternText;
            this.myOptionsText = optionsText;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("inspection.php.regexp.replace.with.valid.delimiter", new Object[0]);
            if (string == null) {
                PhpReplaceWithValidDelimiter.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            StringLiteralExpression expression;
            if (project == null) {
                PhpReplaceWithValidDelimiter.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpReplaceWithValidDelimiter.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpReplaceWithValidDelimiter.$$$reportNull$$$0(3);
            }
            if ((expression = (StringLiteralExpression)ObjectUtils.tryCast((Object)element, StringLiteralExpression.class)) == null) {
                return;
            }
            Character validDelimiter = (Character)ContainerUtil.find(VALID_DELIMITERS, c -> !PhpRegExpInvalidDelimiterInspection.containsDelimiter(this.myPatternText, c.charValue(), PhpInjectionUtil.getTrailingDelimiter(c.charValue())));
            if (validDelimiter == null) {
                return;
            }
            String newContents = validDelimiter + this.myPatternText + validDelimiter + this.myOptionsText;
            StringLiteralExpression newExpr = PhpPsiElementFactory.createStringLiteralExpression(project, newContents, expression.isSingleQuote());
            expression.replace((PsiElement)newExpr);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/regexp/PhpRegExpInvalidDelimiterInspection$PhpReplaceWithValidDelimiter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/regexp/PhpRegExpInvalidDelimiterInspection$PhpReplaceWithValidDelimiter";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

