/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.regexp;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.injection.PhpInjectionUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeSmell.PhpPregMatchWithoutEffectiveRegexpInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.StringLiteralExpressionImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.intellij.lang.regexp.RegExpFile;
import org.intellij.lang.regexp.psi.RegExpBoundary;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.intellij.lang.regexp.psi.RegExpSimpleClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpRegExpModifierInspectionBase
extends PhpInspection {
    protected static final Map<Character, PhpRegExpModifier> regExpModifiers = Map.ofEntries(Map.entry(Character.valueOf('i'), PhpRegExpModifier.PCRE_CASELESS), Map.entry(Character.valueOf('m'), PhpRegExpModifier.PCRE_MULTILINE), Map.entry(Character.valueOf('s'), PhpRegExpModifier.PCRE_DOTALL), Map.entry(Character.valueOf('x'), PhpRegExpModifier.PCRE_EXTENDED), Map.entry(Character.valueOf('A'), PhpRegExpModifier.PCRE_ANCHORED), Map.entry(Character.valueOf('D'), PhpRegExpModifier.PCRE_DOLLAR_ENDONLY), Map.entry(Character.valueOf('U'), PhpRegExpModifier.PCRE_UNGREEDY), Map.entry(Character.valueOf('X'), PhpRegExpModifier.PCRE_EXTRA), Map.entry(Character.valueOf('J'), PhpRegExpModifier.PCRE_INFO_JCHANGED), Map.entry(Character.valueOf('u'), PhpRegExpModifier.PCRE_UTF8), Map.entry(Character.valueOf('S'), PhpRegExpModifier.PCRE_S), Map.entry(Character.valueOf('e'), PhpRegExpModifier.PCRE_E), Map.entry(Character.valueOf('n'), PhpRegExpModifier.PCRE_N));

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpRegExpModifierInspectionBase.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpStringLiteralExpression(StringLiteralExpression expression) {
                List<Pair<Character, TextRange>> phpRegExpModifiersWithTextRanges = PhpRegExpModifierInspectionBase.getModifiersWithTextRanges(expression);
                if (phpRegExpModifiersWithTextRanges.isEmpty()) {
                    return;
                }
                if (PsiTreeUtil.findChildOfType((PsiElement)expression, Variable.class) != null) {
                    return;
                }
                Pair injectionInfo = (Pair)ContainerUtil.getOnlyItem((Collection)InjectedLanguageManager.getInstance((Project)holder.getProject()).getInjectedPsiFiles((PsiElement)expression));
                RegExpPattern pattern = PhpRegExpModifierInspectionBase.getPattern((Pair<PsiElement, TextRange>)injectionInfo);
                if (pattern == null || PhpRegExpModifierInspectionBase.regularExpressionWithOutModifiers((Pair<PsiElement, TextRange>)injectionInfo, expression)) {
                    return;
                }
                List phpRegExpModifiers = ContainerUtil.map(phpRegExpModifiersWithTextRanges, e -> (Character)e.first);
                for (Pair<Character, TextRange> modifierWithTextRange : phpRegExpModifiersWithTextRanges) {
                    PhpRegExpModifierInspectionBase.this.doCheck(holder, phpRegExpModifiers, (Character)modifierWithTextRange.first, (TextRange)modifierWithTextRange.second, expression, pattern);
                }
            }
        };
    }

    @Nullable
    public static RegExpPattern getPattern(Pair<PsiElement, TextRange> injectionInfo) {
        if (injectionInfo == null) {
            return null;
        }
        RegExpFile regexpFile = (RegExpFile)ObjectUtils.tryCast((Object)injectionInfo.getFirst(), RegExpFile.class);
        if (regexpFile == null) {
            return null;
        }
        return PhpPregMatchWithoutEffectiveRegexpInspection.getOnlyChildOfType((PsiElement)regexpFile, RegExpPattern.class);
    }

    protected abstract void doCheck(@NotNull ProblemsHolder var1, @NotNull List<Character> var2, @NotNull Character var3, @NotNull TextRange var4, @NotNull StringLiteralExpression var5, @NotNull RegExpPattern var6);

    private static boolean regularExpressionWithOutModifiers(@NotNull Pair<PsiElement, TextRange> injectionInfo, @NotNull StringLiteralExpression expression) {
        if (injectionInfo == null) {
            PhpRegExpModifierInspectionBase.$$$reportNull$$$0(1);
        }
        if (expression == null) {
            PhpRegExpModifierInspectionBase.$$$reportNull$$$0(2);
        }
        return ((TextRange)injectionInfo.second).equals((Object)expression.getValueRange());
    }

    @NotNull
    protected static List<Pair<Character, TextRange>> getModifiersWithTextRanges(@NotNull StringLiteralExpression injectionHostString) {
        StringLiteralExpressionImpl stringLiteralExpression;
        if (injectionHostString == null) {
            PhpRegExpModifierInspectionBase.$$$reportNull$$$0(3);
        }
        if ((stringLiteralExpression = (StringLiteralExpressionImpl)ObjectUtils.tryCast((Object)injectionHostString, StringLiteralExpressionImpl.class)) == null || stringLiteralExpression.getContents().isEmpty()) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                PhpRegExpModifierInspectionBase.$$$reportNull$$$0(4);
            }
            return list;
        }
        String options = stringLiteralExpression.getRegExpOptionsText();
        if (options == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                PhpRegExpModifierInspectionBase.$$$reportNull$$$0(5);
            }
            return list;
        }
        ArrayList<Pair<Character, TextRange>> modifiers = new ArrayList<Pair<Character, TextRange>>();
        for (int i = options.length() - 1; i >= 0; --i) {
            int startOffset = injectionHostString.getValueRange().getEndOffset() - i - 1;
            TextRange range = new TextRange(startOffset, startOffset + 1);
            modifiers.add((Pair<Character, TextRange>)Pair.create((Object)Character.valueOf(options.charAt(options.length() - i - 1)), (Object)range));
        }
        ArrayList<Pair<Character, TextRange>> arrayList = modifiers;
        if (arrayList == null) {
            PhpRegExpModifierInspectionBase.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectionInfo";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectionHostString";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/regexp/PhpRegExpModifierInspectionBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/regexp/PhpRegExpModifierInspectionBase";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiersWithTextRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "regularExpressionWithOutModifiers";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getModifiersWithTextRanges";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6 -> new IllegalStateException(string);
        };
    }

    protected static class PhpRegExpModifier {
        public static final PhpRegExpModifier PCRE_CASELESS = new PhpRegExpModifier('i'){

            @Override
            protected boolean modifierIsRedundant(@NotNull RegExpPattern pattern, @NotNull List<Character> phpRegExpModifiers) {
                if (pattern == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (phpRegExpModifiers == null) {
                    1.$$$reportNull$$$0(1);
                }
                return Arrays.stream(pattern.getBranches()).flatMap(b -> Arrays.stream(b.getAtoms())).allMatch(a -> a instanceof RegExpChar && !Character.isLetter(((RegExpChar)a).getValue()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pattern";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "phpRegExpModifiers";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/lang/inspections/regexp/PhpRegExpModifierInspectionBase$PhpRegExpModifier$1";
                objectArray[2] = "modifierIsRedundant";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        public static final PhpRegExpModifier PCRE_MULTILINE = new PhpRegExpModifier('m');
        public static final PhpRegExpModifier PCRE_DOTALL = new PhpRegExpModifier('s'){

            @Override
            protected boolean modifierIsRedundant(@NotNull RegExpPattern pattern, @NotNull List<Character> phpRegExpModifiers) {
                if (pattern == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (phpRegExpModifiers == null) {
                    2.$$$reportNull$$$0(1);
                }
                return !ContainerUtil.exists((Iterable)PsiTreeUtil.findChildrenOfType((PsiElement)pattern, RegExpSimpleClass.class), c -> c.getKind().equals((Object)RegExpSimpleClass.Kind.ANY));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pattern";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "phpRegExpModifiers";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/lang/inspections/regexp/PhpRegExpModifierInspectionBase$PhpRegExpModifier$2";
                objectArray[2] = "modifierIsRedundant";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        public static final PhpRegExpModifier PCRE_EXTENDED = new PhpRegExpModifier('x');
        public static final PhpRegExpModifier PCRE_ANCHORED = new PhpRegExpModifier('A');
        public static final PhpRegExpModifier PCRE_DOLLAR_ENDONLY = new PhpRegExpModifier('D'){

            @Override
            protected boolean modifierIsRedundant(@NotNull RegExpPattern pattern, @NotNull List<Character> phpRegExpModifiers) {
                if (pattern == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (phpRegExpModifiers == null) {
                    3.$$$reportNull$$$0(1);
                }
                return phpRegExpModifiers.contains(Character.valueOf(PCRE_MULTILINE.getCharacter())) || !ContainerUtil.exists((Iterable)PsiTreeUtil.findChildrenOfType((PsiElement)pattern, RegExpBoundary.class), c -> c.getType().equals((Object)RegExpBoundary.Type.LINE_END));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pattern";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "phpRegExpModifiers";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/lang/inspections/regexp/PhpRegExpModifierInspectionBase$PhpRegExpModifier$3";
                objectArray[2] = "modifierIsRedundant";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        public static final PhpRegExpModifier PCRE_UNGREEDY = new PhpRegExpModifier('U');
        public static final PhpRegExpModifier PCRE_EXTRA = new PhpRegExpModifier('X');
        public static final PhpRegExpModifier PCRE_INFO_JCHANGED = new PhpRegExpModifier('J');
        public static final PhpRegExpModifier PCRE_UTF8 = new PhpRegExpModifier('U');
        public static final PhpRegExpModifier PCRE_S = new PhpRegExpModifier('S');
        public static final PhpRegExpModifier PCRE_E = new PhpRegExpModifier('e');
        public static final PhpRegExpModifier PCRE_N = new PhpRegExpModifier('n'){

            @Override
            protected boolean modifierIsRedundant(@NotNull RegExpPattern pattern, @NotNull List<Character> phpRegExpModifiers) {
                if (pattern == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (phpRegExpModifiers == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (PhpLanguageLevel.current((Project)pattern.getProject()).isAtLeast(PhpLanguageLevel.PHP820)) {
                    Collection groups = PsiTreeUtil.findChildrenOfType((PsiElement)pattern, RegExpGroup.class);
                    return ContainerUtil.filter((Collection)groups, g -> g.isCapturing() && !g.isAnyNamedGroup()).isEmpty();
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pattern";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "phpRegExpModifiers";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/lang/inspections/regexp/PhpRegExpModifierInspectionBase$PhpRegExpModifier$4";
                objectArray[2] = "modifierIsRedundant";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        private final char myCharacter;

        PhpRegExpModifier(char character) {
            this.myCharacter = character;
        }

        public char getCharacter() {
            return this.myCharacter;
        }

        protected boolean modifierIsRedundant(@NotNull RegExpPattern pattern, @NotNull List<Character> phpRegExpModifiers) {
            if (pattern == null) {
                PhpRegExpModifier.$$$reportNull$$$0(0);
            }
            if (phpRegExpModifiers == null) {
                PhpRegExpModifier.$$$reportNull$$$0(1);
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pattern";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "phpRegExpModifiers";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/lang/inspections/regexp/PhpRegExpModifierInspectionBase$PhpRegExpModifier";
            objectArray[2] = "modifierIsRedundant";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class PhpRemoveRegExpModifierQuickFix
    extends PsiUpdateModCommandQuickFix {
        private final Character myModifierToDelete;

        PhpRemoveRegExpModifierQuickFix(Character modifierToDelete) {
            this.myModifierToDelete = modifierToDelete;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("inspection.php.remove.modifier", this.myModifierToDelete);
            if (string == null) {
                PhpRemoveRegExpModifierQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            StringLiteralExpression stringLiteralExpression;
            if (project == null) {
                PhpRemoveRegExpModifierQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpRemoveRegExpModifierQuickFix.$$$reportNull$$$0(2);
            }
            if (updater == null) {
                PhpRemoveRegExpModifierQuickFix.$$$reportNull$$$0(3);
            }
            if ((stringLiteralExpression = (StringLiteralExpression)ObjectUtils.tryCast((Object)element, StringLiteralExpression.class)) == null) {
                return;
            }
            PhpRemoveRegExpModifierQuickFix.deleteModifier(stringLiteralExpression, this.myModifierToDelete.charValue(), project);
        }

        public static void deleteModifier(@NotNull StringLiteralExpression stringLiteralExpression, char modifierToDelete, Project project) {
            String newRegExp;
            if (stringLiteralExpression == null) {
                PhpRemoveRegExpModifierQuickFix.$$$reportNull$$$0(4);
            }
            if ((newRegExp = PhpRemoveRegExpModifierQuickFix.constructRegExpWithModifiers(stringLiteralExpression, modifierToDelete)) == null) {
                return;
            }
            stringLiteralExpression.replace((PsiElement)PhpPsiElementFactory.createStringLiteralExpression(project, newRegExp, stringLiteralExpression.isSingleQuote()));
        }

        @Nullable
        public static String constructRegExpWithModifiers(@NotNull StringLiteralExpression stringLiteralExpression, char modifierToDelete) {
            String regExpText;
            int trailingDelimiterIndex;
            if (stringLiteralExpression == null) {
                PhpRemoveRegExpModifierQuickFix.$$$reportNull$$$0(5);
            }
            if ((trailingDelimiterIndex = (regExpText = stringLiteralExpression.getContents()).lastIndexOf(PhpInjectionUtil.getTrailingDelimiter(regExpText))) == -1) {
                return null;
            }
            StringBuilder newRegExp = new StringBuilder(regExpText.substring(0, trailingDelimiterIndex + 1));
            PhpRegExpModifierInspectionBase.getModifiersWithTextRanges(stringLiteralExpression).forEach(m -> {
                if (!((Character)m.first).equals(Character.valueOf(modifierToDelete))) {
                    newRegExp.append(m.first);
                }
            });
            return newRegExp.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/regexp/PhpRegExpModifierInspectionBase$PhpRemoveRegExpModifierQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stringLiteralExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/regexp/PhpRegExpModifierInspectionBase$PhpRemoveRegExpModifierQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteModifier";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "constructRegExpWithModifiers";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }
}

