/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.strictStandards;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.classes.PhpHierarchyChecksInspection;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public final class PhpSignatureMismatchDuringInheritanceInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpSignatureMismatchDuringInheritanceInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpClass(PhpClass clazz) {
                if (PhpLanguageLevel.current((Project)clazz.getProject()).isAtLeast(PhpLanguageLevel.PHP800)) {
                    return;
                }
                for (Method method : clazz.getOwnMethods()) {
                    String name = method.getName();
                    if (PhpLangUtil.equalsMethodNames(name, "__construct") || method instanceof PhpDocMethod) continue;
                    PhpClass containingClass = method.getContainingClass();
                    PsiElement node = method.getNameIdentifier();
                    if (containingClass == null || containingClass.isTrait() || node == null || name.equalsIgnoreCase(containingClass.getName())) continue;
                    Ref methodProblem = new Ref(null);
                    PhpClassHierarchyUtils.processSuperMethods(method, (superMethod, subClass, baseClass) -> {
                        PsiElement target;
                        if (superMethod instanceof PhpDocMethod) {
                            return true;
                        }
                        PhpClass superContainingClass = superMethod.getContainingClass();
                        if (superContainingClass == null || superContainingClass.isTrait()) {
                            return true;
                        }
                        Pair<PhpHierarchyChecksInspection.Compatibility, Parameter> result = PhpHierarchyChecksInspection.checkDeclarationsCompatibility(superMethod, method);
                        PsiElement psiElement = target = result.second != null ? (PsiElement)result.second : node;
                        if (target.getContainingFile() == holder.getFile()) {
                            if (!((PhpHierarchyChecksInspection.Compatibility)result.first).isCompatible()) {
                                String descriptionTemplate = this.getDescriptionTemplate((Method)superMethod, superContainingClass);
                                ProblemDescriptor descriptor = result.second != null ? InspectionManager.getInstance((Project)((Parameter)result.second).getProject()).createProblemDescriptor((PsiElement)result.second, descriptionTemplate, isOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING) : PhpHierarchyChecksInspection.getMethodSignatureDescriptor(method, node, descriptionTemplate, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, new LocalQuickFix[0]);
                                PhpHierarchyChecksInspection.MethodProblem problem = new PhpHierarchyChecksInspection.MethodProblem(superMethod.getContainingClass(), descriptor.getPsiElement(), holder -> ((PhpHierarchyChecksInspection.Compatibility)result.first).registerProblem((ProblemsHolder)holder, descriptor));
                                methodProblem.set((Object)PhpHierarchyChecksInspection.chooseProblemWithApplicableStrictness((PhpHierarchyChecksInspection.MethodProblem)methodProblem.get(), problem));
                            } else {
                                methodProblem.set((Object)PhpHierarchyChecksInspection.chooseProblemWithApplicableStrictness((PhpHierarchyChecksInspection.MethodProblem)methodProblem.get(), PhpHierarchyChecksInspection.MethodProblem.empty(superMethod.getContainingClass())));
                            }
                        }
                        return false;
                    });
                    if (methodProblem.get() == null || ((PhpHierarchyChecksInspection.MethodProblem)methodProblem.get()).myProblemRegistar == null) continue;
                    ((PhpHierarchyChecksInspection.MethodProblem)methodProblem.get()).myProblemRegistar.accept(holder);
                }
            }

            @InspectionMessage
            private String getDescriptionTemplate(Method superMethod, PhpClass superContainingClass) {
                if (isOnTheFly) {
                    String superName = PhpHierarchyChecksInspection.buildSuperName(superMethod, superContainingClass);
                    return PhpBundle.message("inspection.message.declaration.should.be.compatible.with", superName);
                }
                return PhpBundle.message("inspection.message.declaration.should.be.compatible.with.super", new Object[0]);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/strictStandards/PhpSignatureMismatchDuringInheritanceInspection", "buildVisitor"));
    }
}

