/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.suppression;

import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocPsiElement;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocRef;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.suppression.PhpSuppressAllForFileCommentFix;
import com.jetbrains.php.lang.inspections.suppression.PhpSuppressForDocCommentFix;
import com.jetbrains.php.lang.inspections.suppression.PhpSuppressForFieldCommentFix;
import com.jetbrains.php.lang.inspections.suppression.PhpSuppressForFileCommentFix;
import com.jetbrains.php.lang.inspections.suppression.PhpSuppressForFunctionCommentFix;
import com.jetbrains.php.lang.inspections.suppression.PhpSuppressForStatementCommentFix;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpExpressionCodeFragment;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpCase;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.PhpPsiElementImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpParameterBasedTypeProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class PhpSuppressionUtil {
    public static final String SUPPRESS_INSPECTIONS_TAG_NAME = "@noinspection";
    @VisibleForTesting
    @ApiStatus.Internal
    public static boolean ourDontCollectCommentsFromEndOfFile = false;

    private PhpSuppressionUtil() {
    }

    public static SuppressQuickFix[] getSuppressActions(@Nullable PsiElement element, @NotNull String toolId) {
        if (toolId == null) {
            PhpSuppressionUtil.$$$reportNull$$$0(0);
        }
        return new SuppressQuickFix[]{new PhpSuppressForStatementCommentFix(toolId), new PhpSuppressForDocCommentFix(toolId), new PhpSuppressForFunctionCommentFix(toolId), new PhpSuppressForFieldCommentFix(toolId), new PhpSuppressForFileCommentFix(toolId), new PhpSuppressAllForFileCommentFix()};
    }

    public static boolean isSuppressedFor(@Nullable PsiElement element, @NotNull String toolId) {
        if (toolId == null) {
            PhpSuppressionUtil.$$$reportNull$$$0(1);
        }
        if (element == null) {
            return true;
        }
        if (element.getContainingFile() instanceof PhpExpressionCodeFragment || PhpParameterBasedTypeProvider.isMeta(element)) {
            return true;
        }
        return (Boolean)ReadAction.compute(() -> PhpSuppressionUtil.isSuppressedInComments(toolId, PhpSuppressionUtil.getAllSuppressionDocComments(element)));
    }

    public static Collection<PhpDocComment> getAllSuppressionDocComments(PsiElement place) {
        HashSet<PhpDocComment> res = new HashSet<PhpDocComment>();
        res.addAll(PhpSuppressionUtil.getPhpDocComments(PhpSuppressionUtil.findEnclosingSuppressibleStatement(place)));
        res.addAll(PhpSuppressionUtil.getPhpDocComments((PsiElement)place.getContainingFile()));
        res.addAll(PhpSuppressionUtil.getPhpDocCommentsFromFunction(place));
        res.addAll(PhpSuppressionUtil.getPhpDocCommentsForField(place));
        return res;
    }

    @Nullable
    public static PsiElement getFieldForSuppression(PsiElement element) {
        Field field;
        Field field2 = field = element instanceof Field ? (Field)element : (Field)PhpPsiUtil.getParentByCondition(element, Field.INSTANCEOF, PhpClass.INSTANCEOF);
        if (field == null) {
            return null;
        }
        return field.getParent();
    }

    public static PhpDocComment getPhpDocCommentForField(PsiElement element) {
        PsiElement field = PhpSuppressionUtil.getFieldForSuppression(element);
        if (field == null) {
            return null;
        }
        for (PsiElement prevSibling = field.getPrevSibling(); prevSibling != null; prevSibling = prevSibling.getPrevSibling()) {
            if (prevSibling instanceof PhpDocComment) {
                PhpDocComment comment = (PhpDocComment)prevSibling;
                return comment;
            }
            if (!(prevSibling instanceof PhpPsiElement)) continue;
            return null;
        }
        return null;
    }

    private static Collection<PhpDocComment> getPhpDocCommentsForField(PsiElement element) {
        PhpDocComment comment = PhpSuppressionUtil.getPhpDocCommentForField(element);
        if (comment == null) {
            return Collections.emptyList();
        }
        return List.of(comment);
    }

    public static void addCommentWithSuppressionTag(@NotNull PsiElement element, String text) {
        PhpDocTag docTag;
        PhpDocComment docComment;
        if (element == null) {
            PhpSuppressionUtil.$$$reportNull$$$0(2);
        }
        if ((docComment = PhpPsiUtil.getParentOfClass((PsiElement)(docTag = PhpPsiElementFactory.createPhpDocTag(element.getProject(), text)), PhpDocComment.class)) == null) {
            return;
        }
        PhpCodeEditUtil.insertDocCommentBeforeAndGetTextRange(element, docComment);
    }

    private static Collection<PhpDocComment> getPhpDocCommentsFromFunction(PsiElement element) {
        SmartList result = new SmartList();
        PhpPsiElement anchor = PhpSuppressionUtil.getTopmostFunction(element);
        while (anchor != null) {
            PhpDocComment docComment = (PhpDocComment)ObjectUtils.tryCast((Object)anchor.getPrevPsiSibling(), PhpDocComment.class);
            ContainerUtil.addIfNotNull((Collection)result, (Object)docComment);
            anchor = docComment;
        }
        return result;
    }

    @Nullable
    public static Function getTopmostFunction(@Nullable PsiElement element) {
        return (Function)PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)((Condition)e -> e instanceof Function && !((Function)e).isClosure()));
    }

    @NotNull
    public static List<PhpDocComment> getPhpDocComments(@Nullable PsiElement element) {
        if (element == null) {
            List<PhpDocComment> list = Collections.emptyList();
            if (list == null) {
                PhpSuppressionUtil.$$$reportNull$$$0(3);
            }
            return list;
        }
        if (element instanceof Statement || element instanceof PhpNamedElement || element instanceof PsiComment) {
            PsiElement parent;
            PhpPsiElement prev = element instanceof PsiComment ? PhpPsiElementImpl.findPrevPhpPsiElement(element) : ((PhpPsiElement)element).getPrevPsiSibling();
            SmartList comments = new SmartList();
            if (element instanceof PhpCase && prev instanceof PhpCase) {
                PsiElement child = prev.getLastChild();
                ASTNode nonWhitespaceSibling = FormatterUtil.getPreviousNonWhitespaceSibling((ASTNode)child.getNode());
                PsiElement sibling = null;
                if (nonWhitespaceSibling != null) {
                    sibling = nonWhitespaceSibling.getPsi();
                }
                if (sibling instanceof PhpDocComment) {
                    comments.add((PhpDocComment)sibling);
                }
            }
            while (prev instanceof PhpDocComment) {
                comments.add((PhpDocComment)prev);
                prev = prev.getPrevPsiSibling();
            }
            if (comments.size() == 0 && (element instanceof Statement || element instanceof Parameter) && ((parent = element.getParent()) instanceof GroupStatement || parent instanceof ParameterList) && (prev = ((PhpPsiElement)parent).getPrevPsiSibling()) instanceof PhpDocComment) {
                comments.add((PhpDocComment)prev);
            }
            SmartList smartList = comments;
            if (smartList == null) {
                PhpSuppressionUtil.$$$reportNull$$$0(4);
            }
            return smartList;
        }
        if (element instanceof PhpFile) {
            PsiElement child;
            SmartList result = new SmartList();
            for (child = element.getFirstChild().getFirstChild(); child != null && PhpSuppressionUtil.addDocComment((List<PhpDocComment>)result, child); child = child.getNextSibling()) {
            }
            if (!ourDontCollectCommentsFromEndOfFile && ApplicationManager.getApplication().isInternal()) {
                for (child = element.getLastChild(); child != null && PhpSuppressionUtil.addDocComment((List<PhpDocComment>)result, child); child = child.getPrevSibling()) {
                }
            }
            SmartList smartList = result;
            if (smartList == null) {
                PhpSuppressionUtil.$$$reportNull$$$0(5);
            }
            return smartList;
        }
        List<PhpDocComment> list = Collections.emptyList();
        if (list == null) {
            PhpSuppressionUtil.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static boolean addDocComment(List<PhpDocComment> result, PsiElement child) {
        if (child.getNode() instanceof CompositeElement) {
            if (PhpDocComment.INSTANCEOF.value((Object)child)) {
                result.add((PhpDocComment)child);
            } else {
                return false;
            }
        }
        return true;
    }

    private static boolean isSuppressedInComments(@NotNull String toolId, Collection<PhpDocComment> comments) {
        if (toolId == null) {
            PhpSuppressionUtil.$$$reportNull$$$0(7);
        }
        return comments.stream().anyMatch(comment -> PhpSuppressionUtil.isSuppressedInComment(toolId, comment));
    }

    public static boolean isSuppressedInComment(@NotNull String toolId, @Nullable PhpDocComment comment) {
        if (toolId == null) {
            PhpSuppressionUtil.$$$reportNull$$$0(8);
        }
        return PhpSuppressionUtil.getSuppressionsIds(comment).anyMatch(suppressionId -> SuppressionUtil.isInspectionToolIdMentioned((String)suppressionId, (String)toolId));
    }

    @NotNull
    public static Stream<String> getSuppressionsIds(@Nullable PhpDocComment comment) {
        if (comment == null) {
            Stream<String> stream = Stream.empty();
            if (stream == null) {
                PhpSuppressionUtil.$$$reportNull$$$0(9);
            }
            return stream;
        }
        Stream<String> stream = Arrays.stream(comment.getTagElementsByName(SUPPRESS_INSPECTIONS_TAG_NAME)).map(t -> PhpSuppressionUtil.getInspectionIdsList(t));
        if (stream == null) {
            PhpSuppressionUtil.$$$reportNull$$$0(10);
        }
        return stream;
    }

    public static String getInspectionIdsList(PhpDocTag tag) {
        return PhpPsiUtil.getChildren((PsiElement)tag, (Condition<? super PsiElement>)((Condition)e -> e instanceof PhpDocRef)).stream().map(ref -> ref.getText()).collect(Collectors.joining(", "));
    }

    @Nullable
    public static PsiElement findEnclosingSuppressibleStatement(@Nullable PsiElement element) {
        return PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)((Condition)e -> e instanceof Statement && !(e instanceof GroupStatement) || e instanceof PhpNamedElement && !(e instanceof PhpDocPsiElement) && !(e instanceof Variable) || e instanceof PsiComment), GroupStatement.INSTANCEOF);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/suppression/PhpSuppressionUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/suppression/PhpSuppressionUtil";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhpDocComments";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressionsIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressActions";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addCommentWithSuppressionTag";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedInComments";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedInComment";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 9, 10 -> new IllegalStateException(string);
        };
    }
}

