/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.type;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.classes.PhpHierarchyChecksInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeAnalyserVisitor;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeInfo;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpArithmeticTypeCheckInspection
extends PhpInspection {
    private static final TokenSet TYPE_CHECKED_PHP8_OPERATORS = TokenSet.andNot((TokenSet)TokenSet.orSet((TokenSet[])new TokenSet[]{PhpTokenTypes.tsMATH_OPS, PhpTokenTypes.tsBIT_OPS, PhpTokenTypes.tsSHIFT_OPS, PhpTokenTypes.tsUNARY_POSTFIX_OPS, PhpTokenTypes.tsUNARY_PREFIX_OPS}), (TokenSet)TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opNOT, PhpTokenTypes.kwCLONE}), PhpTokenTypes.CAST_OPERATORS}));
    private static final PhpType ALLOWED_FOR_MATH_IN_800 = new PhpType().add(PhpType.NUMBER).add(PhpType.FLOAT_INT).add(PhpType.BOOLEAN).add(PhpType.NULL).add(PhpType.STRING).add("\\GMP").add(PhpType.MIXED).add(PhpType.VOID).add("\\Decimal\\Decimal");
    @NotNull
    public static final TokenSet ADDITIONS = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opPLUS, PhpTokenTypes.opPLUS_ASGN});

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpArithmeticTypeCheckInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpSelfAssignmentExpression(SelfAssignmentExpression expression) {
                this.check(expression, expression.getOperation(), PhpCodeEditUtil.convertAssigmentOperations(expression.getOperationType()), () -> PhpArithmeticTypeCheckInspection.getTypeFromSelfAssignmentVariableWithoutCurrentExpression((PsiElement)expression.getVariable()), (PsiElement)expression.getValue());
            }

            @Override
            public void visitPhpBinaryExpression(BinaryExpression expression) {
                this.check(expression, expression.getOperation(), expression.getOperationType(), () -> new PhpType().add(expression.getLeftOperand()), expression.getRightOperand());
            }

            @Override
            public void visitPhpUnaryExpression(UnaryExpression expression) {
                this.check(expression, expression.getOperation(), PsiUtilCore.getElementType((PsiElement)expression.getOperation()), () -> PhpType.EMPTY, (PsiElement)expression.getValue());
            }

            private void check(@NotNull PhpExpression mark, @Nullable PsiElement operation, @Nullable IElementType operationType, Supplier<@NotNull PhpType> leftTypeSupplier, @Nullable PsiElement right) {
                if (mark == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (TYPE_CHECKED_PHP8_OPERATORS.contains(operationType)) {
                    Project project = holder.getProject();
                    PhpType rtNonGlobal = new PhpType().add(right);
                    if (PhpType.intersects(rtNonGlobal, PhpType.MIXED)) {
                        return;
                    }
                    PhpType ltNonGlobal = leftTypeSupplier.get();
                    if (PhpType.intersects(ltNonGlobal, PhpType.MIXED)) {
                        return;
                    }
                    PhpType lt = ltNonGlobal.global(project);
                    if (lt.isAmbiguous()) {
                        return;
                    }
                    PhpType rt = rtNonGlobal.global(project);
                    if (rt.isAmbiguous()) {
                        return;
                    }
                    if (ADDITIONS.contains(operationType) && PhpHierarchyChecksInspection.streamOfTypes(lt).anyMatch(PhpType::isArray) && PhpHierarchyChecksInspection.streamOfTypes(rt).anyMatch(PhpType::isArray)) {
                        return;
                    }
                    if (PhpType.intersects(ALLOWED_FOR_MATH_IN_800, lt) && PhpType.intersects(ALLOWED_FOR_MATH_IN_800, rt)) {
                        return;
                    }
                    if (operation != null) {
                        holder.registerProblem((PsiElement)mark, PhpBundle.message("types.not.supported.as.operands.for.0.1.2", operation.getText(), lt, rt), new LocalQuickFix[0]);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mark", "com/jetbrains/php/lang/inspections/type/PhpArithmeticTypeCheckInspection$1", "check"));
            }
        };
    }

    @NotNull
    public static PhpType getTypeFromSelfAssignmentVariableWithoutCurrentExpression(final @Nullable PsiElement variable) {
        if (variable == null) {
            PhpType phpType = PhpType.EMPTY;
            if (phpType == null) {
                PhpArithmeticTypeCheckInspection.$$$reportNull$$$0(1);
            }
            return phpType;
        }
        PhpType phpType = (PhpType)CachedValuesManager.getCachedValue((PsiElement)variable, () -> CachedValueProvider.Result.create((Object)PhpTypeInfo.getTypeFromAST(variable, new PhpTypeAnalyserVisitor(){

            @Override
            public boolean addTypeFromExpression(@NotNull PhpExpression curAnchor) {
                if (curAnchor == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (curAnchor == variable) {
                    return false;
                }
                return super.addTypeFromExpression(curAnchor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "curAnchor", "com/jetbrains/php/lang/inspections/type/PhpArithmeticTypeCheckInspection$2", "addTypeFromExpression"));
            }
        }), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (phpType == null) {
            PhpArithmeticTypeCheckInspection.$$$reportNull$$$0(2);
        }
        return phpType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/type/PhpArithmeticTypeCheckInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpArithmeticTypeCheckInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeFromSelfAssignmentVariableWithoutCurrentExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

