/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.type;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocProperty;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.quickfix.type.PhpChangeSetHookParameterTypeToMatchFieldTypeQuickFix;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpPropertyHook;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpFieldAssignmentTypeMismatchInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpFieldAssignmentTypeMismatchInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpAssignmentExpression(AssignmentExpression assignmentExpression) {
                Project project = assignmentExpression.getProject();
                FieldReference fieldReference = (FieldReference)ObjectUtils.tryCast((Object)assignmentExpression.getVariable(), FieldReference.class);
                PhpTypedElement assignedValue = (PhpTypedElement)ObjectUtils.tryCast((Object)assignmentExpression.getValue(), PhpTypedElement.class);
                if (fieldReference != null && assignedValue != null) {
                    PhpType assignedValueType = assignedValue.getGlobalType();
                    SmartHashSet incompatibleTypes = new SmartHashSet();
                    for (Field field : fieldReference.multiResolveStrict(Field.class)) {
                        if (field == null || field instanceof PhpDocProperty || field instanceof PhpClassImpl.MyRenamableFakePsiElement || field.isConstant()) continue;
                        PhpType fieldType = field.getDeclaredType();
                        if (fieldType.isConvertibleFromGlobal(project, assignedValueType)) {
                            return;
                        }
                        PhpType setHookType = PhpFieldAssignmentTypeMismatchInspection.getSetHookType(field);
                        if (setHookType.containsAll(fieldType) && setHookType.isConvertibleFromGlobal(project, assignedValueType)) {
                            return;
                        }
                        incompatibleTypes.add(fieldType);
                    }
                    if (incompatibleTypes.size() == 1) {
                        LocalQuickFix[] fixes = LocalQuickFix.EMPTY_ARRAY;
                        PhpType type = (PhpType)ContainerUtil.getOnlyItem((Collection)incompatibleTypes);
                        if (PhpLanguageFeature.PROPERTY_HOOKS.isSupported(project) && PhpType.OBJECT.equals(assignedValueType) && assignedValueType.isConvertibleFrom(project, type)) {
                            fixes = new LocalQuickFix[]{new PhpChangeSetHookParameterTypeToMatchFieldTypeQuickFix(type)};
                        }
                        holder.registerProblem((PsiElement)assignmentExpression, PhpBundle.message("inspection.field.assignment.type.mismatch", type, assignedValueType), fixes);
                    } else if (incompatibleTypes.size() > 1) {
                        holder.registerProblem((PsiElement)assignmentExpression, PhpBundle.message("inspection.field.assignment.type.mismatch.multi.resolve", assignedValueType), new LocalQuickFix[0]);
                    }
                }
            }
        };
    }

    private static PhpType getSetHookType(@NotNull Field field) {
        PhpPropertyHook setHook;
        if (field == null) {
            PhpFieldAssignmentTypeMismatchInspection.$$$reportNull$$$0(1);
        }
        if ((setHook = (PhpPropertyHook)ContainerUtil.find(field.getPropertyHooksList(), it -> it.getHookType() == PhpPropertyHook.PhpPropertyHookType.SET)) == null) {
            return PhpType.EMPTY;
        }
        Parameter param = setHook.getParameter(0);
        if (param == null) {
            return PhpType.EMPTY;
        }
        return param.getDeclaredType();
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP740;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpFieldAssignmentTypeMismatchInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getSetHookType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

