/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.type;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpIllegalStringOffsetInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpIllegalStringOffsetInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpArrayAccessExpression(@NotNull ArrayAccessExpression element) {
                PhpPsiElement value;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((value = element.getValue()) instanceof ArrayAccessExpression) {
                    return;
                }
                ArrayIndex index = element.getIndex();
                if (index != null && !index.getTextRange().isEmpty() && !PhpIllegalStringOffsetInspection.isIntTypeOrAmbiguous((PsiElement)index.getValue()) && PhpIllegalStringOffsetInspection.isStringType((PsiElement)value)) {
                    holder.registerProblem((PsiElement)index, PhpBundle.message("inspection.illegal.string.offset.problem", index.getText()), new LocalQuickFix[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/lang/inspections/type/PhpIllegalStringOffsetInspection$1", "visitPhpArrayAccessExpression"));
            }
        };
    }

    public static boolean isStringType(@Nullable PsiElement value) {
        PhpType valueType;
        if (PhpPsiUtil.isOfType(value, PhpElementTypes.STRING)) {
            return true;
        }
        return value instanceof PhpTypedElement && PhpType.STRING.equals(valueType = ((PhpTypedElement)value).getGlobalType().filterUnknown());
    }

    private static boolean isIntTypeOrAmbiguous(@Nullable PsiElement index) {
        if (PhpPsiUtil.isOfType(index, PhpElementTypes.STRING)) {
            return false;
        }
        if (PhpPsiUtil.isOfType(index, PhpElementTypes.NUMBER)) {
            return true;
        }
        if (index instanceof PhpTypedElement) {
            PhpType valueType = ((PhpTypedElement)index).getType();
            if (PhpType.intersectsGlobal(index.getProject(), valueType, PhpType.INT)) {
                return true;
            }
            if (valueType.global(index.getProject()).isAmbiguous()) {
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/type/PhpIllegalStringOffsetInspection", "buildVisitor"));
    }
}

