/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.type;

import com.google.common.base.Predicates;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocProperty;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.quickfix.type.PhpAddInferredTypeAsPropertyTypeQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.type.PhpChangeFieldTypeToMatchSuperQuickFix;
import com.jetbrains.php.lang.intentions.generators.PhpAccessorsGenerator;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpMissingFieldTypeInspection
extends PhpInspection {
    public static final Predicate<String> NOT_APPLICABLE_TYPE_IN_FIELD_DECLARATION = Predicates.or((com.google.common.base.Predicate[])new com.google.common.base.Predicate[]{PhpType::isAnonymousClass, PhpLangUtil::isClassNameSpecial, PhpType::isCallableType, "\\resource"::equalsIgnoreCase, "\\void"::equalsIgnoreCase, "\\never"::equalsIgnoreCase});

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpMissingFieldTypeInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpField(Field field) {
                PhpType inferredType;
                if (field.isConstant() || field instanceof PhpDocProperty || field.getTypeDeclaration() != null || PhpMissingFieldTypeInspection.overridesFieldOfParentClass(field)) {
                    return;
                }
                PsiElement nameIdentifier = field.getNameIdentifier();
                if (nameIdentifier == null) {
                    return;
                }
                Project project = field.getProject();
                PhpType fieldType = field.getGlobalType();
                if (fieldType.filterNull().isEmpty()) {
                    PhpType typeFromGetter = PhpMissingFieldTypeInspection.getTypeFromGetter(field);
                    if (typeFromGetter.isEmpty() || typeFromGetter.equals(PhpType.VOID)) {
                        holder.registerProblem(nameIdentifier, PhpBundle.message("inspection.missing.field.type", new Object[0]), new LocalQuickFix[0]);
                        return;
                    }
                    fieldType = typeFromGetter;
                }
                if (!(inferredType = PhpMissingFieldTypeInspection.getSuitableTypeForFieldTypeDeclaration(project, field, fieldType)).isEmpty()) {
                    String typeStr = PhpChangeFieldTypeToMatchSuperQuickFix.getDeclaredTypeString(project, inferredType, field);
                    if (typeStr == null) {
                        return;
                    }
                    if (PhpAddInferredTypeAsPropertyTypeQuickFix.canApplyFix(field)) {
                        holder.registerProblem(nameIdentifier, PhpBundle.message("inspection.missing.field.type", new Object[0]), new LocalQuickFix[]{new PhpAddInferredTypeAsPropertyTypeQuickFix(inferredType, typeStr, isOnTheFly)});
                    }
                }
            }
        };
    }

    @NotNull
    private static PhpType getTypeFromGetter(@NotNull Field field) {
        PhpClass clazz;
        if (field == null) {
            PhpMissingFieldTypeInspection.$$$reportNull$$$0(1);
        }
        if ((clazz = field.getContainingClass()) == null) {
            PhpType phpType = PhpType.EMPTY;
            if (phpType == null) {
                PhpMissingFieldTypeInspection.$$$reportNull$$$0(2);
            }
            return phpType;
        }
        Method[] getters = new PhpAccessorsGenerator(clazz, field).findGetters();
        if (getters.length != 1) {
            PhpType phpType = PhpType.EMPTY;
            if (phpType == null) {
                PhpMissingFieldTypeInspection.$$$reportNull$$$0(3);
            }
            return phpType;
        }
        PhpType phpType = getters[0].getGlobalType();
        if (phpType == null) {
            PhpMissingFieldTypeInspection.$$$reportNull$$$0(4);
        }
        return phpType;
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP740;
    }

    @NotNull
    private static PhpType getSuitableTypeForFieldTypeDeclaration(@NotNull Project project, @NotNull Field field, @NotNull PhpType fieldType) {
        PhpTypedElement defaultValue;
        PhpType defaultValueType;
        PhpType composedType;
        if (project == null) {
            PhpMissingFieldTypeInspection.$$$reportNull$$$0(5);
        }
        if (field == null) {
            PhpMissingFieldTypeInspection.$$$reportNull$$$0(6);
        }
        if (fieldType == null) {
            PhpMissingFieldTypeInspection.$$$reportNull$$$0(7);
        }
        if ((composedType = PhpMissingFieldTypeInspection.composeFieldType(project, fieldType, defaultValueType = (defaultValue = (PhpTypedElement)ObjectUtils.tryCast((Object)field.getDefaultValue(), PhpTypedElement.class)) != null ? defaultValue.getGlobalType() : PhpType.EMPTY)).filterNull().size() != 1 && !PhpLanguageFeature.UNION_TYPES.isSupported(project) || composedType.hasIntersectionType() && !PhpLanguageFeature.INTERSECTION_TYPES.isSupported(project)) {
            PhpType phpType = PhpType.EMPTY;
            if (phpType == null) {
                PhpMissingFieldTypeInspection.$$$reportNull$$$0(8);
            }
            return phpType;
        }
        PhpType phpType = PhpAnnotatorVisitor.isPropertyDefaultValueTypeCompatible(field, composedType, (PsiElement)defaultValue) ? composedType : PhpType.EMPTY;
        if (phpType == null) {
            PhpMissingFieldTypeInspection.$$$reportNull$$$0(9);
        }
        return phpType;
    }

    @NotNull
    public static PhpType composeFieldType(@NotNull Project project, @NotNull PhpType inferredType, @NotNull PhpType defaultValueType) {
        if (project == null) {
            PhpMissingFieldTypeInspection.$$$reportNull$$$0(10);
        }
        if (inferredType == null) {
            PhpMissingFieldTypeInspection.$$$reportNull$$$0(11);
        }
        if (defaultValueType == null) {
            PhpMissingFieldTypeInspection.$$$reportNull$$$0(12);
        }
        PhpType result = PhpMissingFieldTypeInspection.composeType(project, inferredType, NOT_APPLICABLE_TYPE_IN_FIELD_DECLARATION);
        if (defaultValueType.isNullable() && !result.isEmpty() && !PhpType.MIXED.equals(result)) {
            result.add(PhpType.NULL);
        }
        PhpType phpType = result;
        if (phpType == null) {
            PhpMissingFieldTypeInspection.$$$reportNull$$$0(13);
        }
        return phpType;
    }

    @NotNull
    public static PhpType composeType(@NotNull Project project, @NotNull PhpType inferredType, Predicate<String> notSuitableTypesPredicate) {
        PhpType filteredType;
        if (project == null) {
            PhpMissingFieldTypeInspection.$$$reportNull$$$0(14);
        }
        if (inferredType == null) {
            PhpMissingFieldTypeInspection.$$$reportNull$$$0(15);
        }
        if ((filteredType = inferredType.filterOut(notSuitableTypesPredicate)).size() != inferredType.size()) {
            PhpType phpType = PhpType.EMPTY;
            if (phpType == null) {
                PhpMissingFieldTypeInspection.$$$reportNull$$$0(16);
            }
            return phpType;
        }
        if (PhpType.intersects(PhpType.MIXED, filteredType)) {
            if (PhpLanguageFeature.MIXED_TYPE_HINT.isSupported(project)) {
                PhpType phpType = PhpType.MIXED;
                if (phpType == null) {
                    PhpMissingFieldTypeInspection.$$$reportNull$$$0(17);
                }
                return phpType;
            }
            PhpType phpType = PhpType.EMPTY;
            if (phpType == null) {
                PhpMissingFieldTypeInspection.$$$reportNull$$$0(18);
            }
            return phpType;
        }
        PhpType result = new PhpType();
        boolean convertFalseToBool = !PhpLanguageFeature.UNION_TYPES.isSupported(project) || filteredType.filterNull().equals(PhpType.FALSE) && !PhpLanguageFeature.STANDALONE_NULL_FALSE.isSupported(project);
        boolean convertTrueToBool = !PhpLanguageLevel.current((Project)project).isAtLeast(PhpLanguageLevel.PHP820) || filteredType.filterNull().equals(PhpType.TRUE);
        for (String typeFqn : filteredType.getTypes()) {
            if (typeFqn.equalsIgnoreCase("\\false") && convertFalseToBool || typeFqn.equalsIgnoreCase("\\true") && convertTrueToBool) {
                result.add(PhpType.BOOLEAN);
                continue;
            }
            if (PhpType.isPluralType(typeFqn)) {
                result.add(PhpType.ARRAY);
                continue;
            }
            result.add(typeFqn);
        }
        if (PhpType.intersects(result, PhpType.ITERABLE) && PhpType.intersects(result, PhpType.ARRAY_TRAVERSABLE_TYPE)) {
            PhpType phpType = result.filter(PhpType.ARRAY_TRAVERSABLE_TYPE);
            if (phpType == null) {
                PhpMissingFieldTypeInspection.$$$reportNull$$$0(19);
            }
            return phpType;
        }
        PhpType phpType = result;
        if (phpType == null) {
            PhpMissingFieldTypeInspection.$$$reportNull$$$0(20);
        }
        return phpType;
    }

    public static boolean overridesFieldOfParentClass(Field field) {
        Ref superFieldFound = new Ref((Object)false);
        PhpClassHierarchyUtils.processSuperFields(field, (member, subClass, baseClass) -> {
            superFieldFound.set((Object)true);
            return false;
        });
        return (Boolean)superFieldFound.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 8, 9, 13, 16, 17, 18, 19, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/type/PhpMissingFieldTypeInspection";
                break;
            }
            case 5: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldType";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inferredType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValueType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpMissingFieldTypeInspection";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeFromGetter";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuitableTypeForFieldTypeDeclaration";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "composeFieldType";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "composeType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromGetter";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSuitableTypeForFieldTypeDeclaration";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "composeFieldType";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "composeType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 8, 9, 13, 16, 17, 18, 19, 20 -> new IllegalStateException(string);
        };
    }
}

