/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.type;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.classes.PhpIncorrectMagicMethodSignatureInspection;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocSignatureInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddMethodDeclarationQuickFix;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureProcessor;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpMissingReturnTypeInspection
extends PhpInspection {
    public boolean myIgnoreTestMethods = true;
    public boolean myIgnoreEmptyFunction = true;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpMissingReturnTypeInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpFunction(Function function) {
                PhpMissingReturnTypeInspection.this.doCheck(function, holder, isOnTheFly);
            }

            @Override
            public void visitPhpMethod(Method method) {
                if (method instanceof PhpDocMethod) {
                    return;
                }
                if (PhpIncorrectMagicMethodSignatureInspection.isCheckedMagicMethod(method)) {
                    return;
                }
                if (method.getMethodType(false) == Method.MethodType.CONSTRUCTOR) {
                    return;
                }
                if ("__destruct".equalsIgnoreCase(method.getName())) {
                    return;
                }
                if (PhpMissingReturnTypeInspection.this.myIgnoreTestMethods && PhpUnitUtil.isTestMethod(method)) {
                    return;
                }
                PhpMissingReturnTypeInspection.this.doCheck(method, holder, isOnTheFly);
            }
        };
    }

    public void doCheck(Function function, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpMissingReturnTypeInspection.$$$reportNull$$$0(1);
        }
        if (!(!this.myIgnoreEmptyFunction || function instanceof Method && ((Method)function).isAbstract() || function.getControlFlow().getInstructions().length != 2)) {
            return;
        }
        Project project = holder.getProject();
        PhpReturnType declarationType = (PhpReturnType)function.getTypeDeclaration();
        if (declarationType != null) {
            return;
        }
        PhpType functionType = function.getType();
        if (!PhpMissingReturnTypeInspection.isReturnTypeCanBeAdded(functionType.filterUnknown(), project)) {
            return;
        }
        PhpType globalType = functionType.global(function.getProject());
        if (!PhpMissingReturnTypeInspection.isReturnTypeCanBeAdded(globalType, project)) {
            return;
        }
        PsiElement fnToken = PhpPsiUtil.getChildOfType((PsiElement)function, TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.kwFUNCTION, PhpTokenTypes.kwFN}));
        if (fnToken == null) {
            return;
        }
        PsiElement identifier = (PsiElement)ObjectUtils.notNull((Object)function.getNameIdentifier(), (Object)fnToken);
        if (!identifier.getTextRange().isEmpty()) {
            String hint = PhpMissingReturnTypeInspection.createTypeHint(PhpLanguageLevel.current((Project)project), function, functionType);
            if (hint.isEmpty()) {
                return;
            }
            if (function.isClosure() || PhpMissingReturnTypeInspection.hasMixedTypeNotFromPhpDoc(function, globalType)) {
                if (!isOnTheFly) {
                    return;
                }
                holder.registerProblem(identifier, PhpBundle.message("inspection.php.missing.return.type.description", new Object[0]), ProblemHighlightType.INFORMATION, new LocalQuickFix[]{new PhpAddReturnTypeQuickFix(PhpLanguageLevel.current((Project)project), hint, function.getType())});
            } else {
                holder.registerProblem(identifier, PhpBundle.message("inspection.php.missing.return.type.description", new Object[0]), new LocalQuickFix[]{new PhpAddReturnTypeQuickFix(PhpLanguageLevel.current((Project)project), hint, function.getType())});
            }
        }
    }

    private static boolean isReturnTypeCanBeAdded(PhpType globalType, @NotNull Project project) {
        if (project == null) {
            PhpMissingReturnTypeInspection.$$$reportNull$$$0(2);
        }
        if (globalType.hasUnknown()) {
            return false;
        }
        if (PhpType.intersects(PhpType.VOID, globalType) && !globalType.equals(PhpType.VOID)) {
            return false;
        }
        return PhpDocSignatureInspection.isReturnTypeSupported(globalType, project);
    }

    private static boolean hasMixedTypeNotFromPhpDoc(@NotNull Function function, PhpType globalType) {
        if (function == null) {
            PhpMissingReturnTypeInspection.$$$reportNull$$$0(3);
        }
        return !PhpType.intersects(PhpType.MIXED, function.getDocType()) && PhpType.intersects(PhpType.MIXED, globalType);
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP700;
    }

    @NotNull
    public static String createTypeHint(@NotNull PhpLanguageLevel languageLevel, @NotNull PhpScopeHolder scopeHolder, @NotNull PhpType functionType) {
        if (languageLevel == null) {
            PhpMissingReturnTypeInspection.$$$reportNull$$$0(4);
        }
        if (scopeHolder == null) {
            PhpMissingReturnTypeInspection.$$$reportNull$$$0(5);
        }
        if (functionType == null) {
            PhpMissingReturnTypeInspection.$$$reportNull$$$0(6);
        }
        Project project = scopeHolder.getProject();
        int size = functionType.size();
        if (languageLevel.hasFeature(PhpLanguageFeature.STATIC_RETURN_TYPE_HINT)) {
            functionType = functionType.filterOut(PhpTypeSignatureKey.POLYMORPHIC_CLASS::isSigned);
        }
        boolean addStatic = size != functionType.size();
        PhpType type = functionType.global(project);
        boolean allowMultipleTypes = languageLevel.hasFeature(PhpLanguageFeature.UNION_TYPES);
        String typeHint = type.equals(PhpType.VOID) && languageLevel.hasFeature(PhpLanguageFeature.RETURN_VOID) ? PhpLangUtil.toPresentableFQN("\\void") : PhpAddMethodDeclarationQuickFix.createTypeHint(languageLevel, type, (PsiElement)scopeHolder, false, allowMultipleTypes);
        List typeHints = StringUtil.split((String)typeHint, (String)"|");
        String string = addStatic ? StringUtil.notNullize((String)PhpCodeUtil.getTypeHintString(languageLevel, allowMultipleTypes, (Collection<String>)ContainerUtil.append((List)typeHints, (Object[])new String[]{"static"}))) : typeHint;
        if (string == null) {
            PhpMissingReturnTypeInspection.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"myIgnoreTestMethods", (String)PhpBundle.message("checkbox.ignore.test.methods", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]), OptPane.checkbox((String)"myIgnoreEmptyFunction", (String)PhpBundle.message("checkbox.ignore.empty.functions", new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            PhpMissingReturnTypeInspection.$$$reportNull$$$0(8);
        }
        return optPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionType";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/type/PhpMissingReturnTypeInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpMissingReturnTypeInspection";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeHint";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doCheck";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isReturnTypeCanBeAdded";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasMixedTypeNotFromPhpDoc";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createTypeHint";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8 -> new IllegalStateException(string);
        };
    }

    public static final class PhpAddReturnTypeQuickFix
    extends PsiUpdateModCommandQuickFix {
        private final String myTypeHint;
        @NotNull
        private final PhpType myType;
        @NotNull
        private final PhpLanguageLevel myLanguageLevel;

        public PhpAddReturnTypeQuickFix(@NotNull PhpLanguageLevel languageLevel, String typeHint, @NotNull PhpType type) {
            if (languageLevel == null) {
                PhpAddReturnTypeQuickFix.$$$reportNull$$$0(0);
            }
            if (type == null) {
                PhpAddReturnTypeQuickFix.$$$reportNull$$$0(1);
            }
            this.myLanguageLevel = languageLevel;
            this.myTypeHint = typeHint;
            this.myType = type;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("add.return.type", new Object[0]);
            if (string == null) {
                PhpAddReturnTypeQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @IntentionName
        @NotNull
        public String getName() {
            String string = PhpBundle.message("intention.name.add.as.function.s.return.type", this.myTypeHint);
            if (string == null) {
                PhpAddReturnTypeQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            Function function;
            if (project == null) {
                PhpAddReturnTypeQuickFix.$$$reportNull$$$0(4);
            }
            if (element == null) {
                PhpAddReturnTypeQuickFix.$$$reportNull$$$0(5);
            }
            if (updater == null) {
                PhpAddReturnTypeQuickFix.$$$reportNull$$$0(6);
            }
            if ((function = PhpPsiUtil.getParentOfClass(element, false, Function.class)) == null || function.getTypeDeclaration() != null) {
                return;
            }
            String hint = PhpMissingReturnTypeInspection.createTypeHint(this.myLanguageLevel, function, this.myType);
            PhpChangeSignatureProcessor.addReturnType(function, hint);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "languageLevel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/type/PhpMissingReturnTypeInspection$PhpAddReturnTypeQuickFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpMissingReturnTypeInspection$PhpAddReturnTypeQuickFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

