/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.type;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.classes.PhpHierarchyChecksInspection;
import com.jetbrains.php.lang.inspections.quickfix.type.PhpChangeReturnTypeQuickFix;
import com.jetbrains.php.lang.inspections.type.PhpMissingReturnTypeInspection;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureDialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpMixedReturnTypeCanBeReducedInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpMixedReturnTypeCanBeReducedInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            @Override
            public void visitPhpFunction(Function function) {
                PhpReturnType declaration;
                String hint = PhpMixedReturnTypeCanBeReducedInspection.getReducedMixedTypeHint(function);
                if (StringUtil.isNotEmpty((String)hint) && (declaration = (PhpReturnType)function.getTypeDeclaration()) != null) {
                    holder.registerProblem((PsiElement)declaration, PhpBundle.message("inspection.message.type.can.be.reduced.to", hint), new LocalQuickFix[]{new PhpChangeReturnTypeQuickFix(holder.getProject(), PhpType.MIXED, PhpMixedReturnTypeCanBeReducedInspection.createTypeFromHint(hint))});
                }
            }

            @Override
            public void visitPhpMethod(Method method) {
                if (!(method instanceof PhpDocMethod)) {
                    this.visitPhpFunction(method);
                }
            }
        };
    }

    @NlsSafe
    private static String getReducedMixedTypeHint(Function function) {
        String hint;
        if (!function.getDeclaredType().equals(PhpType.MIXED)) {
            return null;
        }
        PhpType inferredType = function.getInferredType().global(function.getProject());
        if (!inferredType.hasUnknown() && inferredType.size() < 5 && StringUtil.isNotEmpty((String)(hint = PhpMissingReturnTypeInspection.createTypeHint(PhpLanguageLevel.current((Project)function.getProject()), function, function.getInferredType()))) && !hint.equals("mixed")) {
            PhpType type;
            if (function instanceof Method && !PhpMixedReturnTypeCanBeReducedInspection.typeIsCompatibleWithChildrenReturnType(type = PhpMixedReturnTypeCanBeReducedInspection.createTypeFromHint(hint), (Method)function)) {
                return null;
            }
            return hint;
        }
        return null;
    }

    @NotNull
    private static PhpType createTypeFromHint(String hint) {
        PhpType phpType = PhpChangeSignatureDialog.getTypeFromPresentation(hint, null);
        if (phpType == null) {
            PhpMixedReturnTypeCanBeReducedInspection.$$$reportNull$$$0(1);
        }
        return phpType;
    }

    private static boolean typeIsCompatibleWithChildrenReturnType(PhpType superMethodNewReturnType, Method superMethod) {
        Ref res = new Ref((Object)true);
        Project project = superMethod.getProject();
        PhpClassHierarchyUtils.processOverridingMethods(superMethod, (childMethod, subClass, baseClass) -> {
            PhpReturnType declaration = (PhpReturnType)childMethod.getTypeDeclaration();
            res.set((Object)(declaration == null || PhpHierarchyChecksInspection.getCompatibility(project, childMethod, superMethodNewReturnType, childMethod.getDeclaredType()).isCompatible() ? 1 : 0));
            return (Boolean)res.get();
        });
        return (Boolean)res.get();
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP800;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/type/PhpMixedReturnTypeCanBeReducedInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpMixedReturnTypeCanBeReducedInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypeFromHint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

