/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.type;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.config.library.PhpRuntimeLibraryRootsProvider;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.parameterCountMismatch.PhpChangeFunctionSignatureFromUsageQuickFix;
import com.jetbrains.php.lang.inspections.phpdoc.PhpIntRangesMismatchInspection;
import com.jetbrains.php.lang.inspections.type.PhpSetInheritanceBetweenClassesQuickFixBase;
import com.jetbrains.php.lang.inspections.type.PhpStrictTypeCheckingInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTraitUseRule;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.impl.MethodReferenceImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpParamsInspection
extends PhpInspection {
    private static final Comparator<Pair<List<Parameter>, Map<PsiElement, ProblemDescriptor>>> COMPARATOR = (o1, o2) -> {
        int i = ((List)o1.getFirst()).size() - ((List)o2.getFirst()).size();
        return i != 0 ? i : ((Map)o1.second).size() - ((Map)o2.second).size();
    };
    private static final Collection<PhpType> TYPES_ALLOWED_FOR_CAST = Set.of(PhpType.INT, PhpType.STRING, PhpType.BOOLEAN, PhpType.FLOAT, PhpType.ARRAY, PhpType.OBJECT);
    private static final int PARAMETER_LIMIT = 50;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpParamsInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){
            final Set<VirtualFile> extensionRoots;
            {
                this.extensionRoots = PhpRuntimeLibraryRootsProvider.getLibraryRoots(holder.getProject());
            }

            @Override
            public void visitPhpFunctionCall(FunctionReference reference) {
                if (reference.getParent() instanceof PhpUse) {
                    return;
                }
                ResolveResult[] results = reference.multiResolve(false);
                PhpParamsInspection.checkCall(reference, results, reference.getParameters(), this.extensionRoots, holder);
            }

            @Override
            public void visitPhpMethodReference(MethodReference call) {
                if (call.getNameNode() != null) {
                    if (call.getParent() instanceof PhpTraitUseRule) {
                        return;
                    }
                    if (PhpParamsInspection.tryCheckPropertyHookCall(call, holder)) {
                        return;
                    }
                    ResolveResult[] results = ((PsiPolyVariantReference)call.getReference()).multiResolve(false);
                    if (results.length > 0 && results[0].getElement() instanceof PhpDocMethod) {
                        results = ((PsiPolyVariantReference)call.getReference()).multiResolve(true);
                    }
                    PhpParamsInspection.checkCall(call, results, call.getParameters(), this.extensionRoots, holder);
                }
            }

            @Override
            public void visitPhpNewExpression(NewExpression expression) {
                ClassReference classReference = expression.getClassReference();
                PsiElement[] parameters = expression.getParameters();
                this.checkConstructorCall(expression, classReference, parameters);
            }

            @Override
            public void visitPhpAttribute(PhpAttribute attribute) {
                this.checkConstructorCall(attribute, attribute.getClassReference(), attribute.getParameters());
            }

            private void checkConstructorCall(PhpPsiElement expression, ClassReference classReference, PsiElement[] parameters) {
                if (classReference != null) {
                    Method constructor;
                    ResolveResult[] results = classReference.multiResolve(false);
                    if (results.length == 1 && results[0].getElement() instanceof Method) {
                        PhpParamsInspection.checkCall(expression, results, parameters, this.extensionRoots, holder);
                    } else if (results.length == 1 && results[0].getElement() instanceof PhpClass && (constructor = ((PhpClass)results[0].getElement()).getConstructor()) != null) {
                        PhpParamsInspection.checkCall(expression, PsiElementResolveResult.createResults((PsiElement[])new PsiElement[]{constructor}), parameters, this.extensionRoots, holder);
                    }
                }
            }
        };
    }

    private static void checkCall(PhpPsiElement call, ResolveResult[] results, PsiElement[] callParams, Set<? extends VirtualFile> extensionRoots, ProblemsHolder holder) {
        if (results.length > 0) {
            callParams = (PsiElement[])PhpStrictTypeCheckingInspection.unwrapSpreadOperator(callParams).toArray((Object[])PsiElement.EMPTY_ARRAY);
            ArrayList warnings = new ArrayList();
            boolean onTheFly = holder.isOnTheFly();
            boolean unpackedArgument = callParams.length > 0 && PhpCodeInsightUtil.isUnpackedArgument(callParams[callParams.length - 1]);
            IntFunction<PhpType> typeFunc = PhpParamsInspection.createCachedTypeFunc(callParams);
            List<PsiElement> arguments = Arrays.asList(callParams);
            if (PhpParamsInspection.processSignatures(results, extensionRoots, Arrays.asList(callParams), (Processor<? super List<Parameter>>)((Processor)declParams -> {
                HashMap<PsiElement, ProblemDescriptor> problems = new HashMap<PsiElement, ProblemDescriptor>();
                warnings.add(new Pair(declParams, problems));
                return !PhpParamsInspection.checkMissingParameter(call, arguments, declParams, problems, onTheFly, unpackedArgument) && PhpParamsInspection.checkParametersTypes(typeFunc, call, arguments, declParams, problems, onTheFly);
            }))) {
                return;
            }
            PhpParamsInspection.registerProblems(holder, warnings);
        }
    }

    private static void registerProblems(ProblemsHolder holder, List<? extends Pair<List<Parameter>, Map<PsiElement, ProblemDescriptor>>> warnings) {
        warnings.sort(COMPARATOR);
        Pair item = (Pair)ContainerUtil.getFirstItem(warnings);
        if (item != null) {
            ((Map)item.getSecond()).forEach((key, value) -> holder.registerProblem(value));
        }
    }

    public static boolean checkParametersTypes(IntFunction<? extends PhpType> typeFunc, PhpPsiElement call, List<? extends PsiElement> callParams, List<? extends Parameter> declParams, Map<PsiElement, ProblemDescriptor> problems, boolean isOnTheFly) {
        Parameter declParameter;
        boolean result = true;
        PhpNamedElement pos = PhpPsiUtil.getParentOfClass((PsiElement)call, PhpNamedElement.class);
        String ns = pos != null ? pos.getNamespaceName() : "\\";
        PhpIndex phpIndex = PhpIndex.getInstance(call.getProject());
        for (int i = 0; i < callParams.size() && (declParameter = PhpParamsInspection.getMappedParam(callParams, declParams, i)) != null; ++i) {
            String message;
            PhpType callType;
            PhpType declType;
            if (declParameter.isOptional(callParams) && declParameter.getDeclaredType().isEmpty() || (declType = declParameter.getGlobalType()).isAmbiguous()) continue;
            ProblemDescriptor descriptor = null;
            PhpType localType = PhpParamsInspection.unpluraliseSpreadArguments(new PhpType().add(callParams.get(i)).filterNull(), callParams.get(i));
            if (!declType.isConvertibleLocal(call.getProject(), localType) && !PhpParamsInspection.isCallTypeConvertibleFromDeclaredType(callType = PhpParamsInspection.getCallType(typeFunc, callParams, i), declType, phpIndex)) {
                String description = isOnTheFly ? PhpBundle.message("inspection.wrong_param_type", callType.toStringRelativized(ns), declType.toStringRelativized(ns)) : PhpBundle.message("parameter.ref.type.is.not.compatible.with.declaration", new Object[0]);
                descriptor = PhpParamsInspection.createSimpleDescriptor(callParams.get(i), isOnTheFly, description, PhpParamsInspection.getFixes(callParams.get(i), callType, declType));
            }
            if (descriptor == null && (message = PhpIntRangesMismatchInspection.getErrorMessage(declParameter.getProject(), declParameter.getGlobalType(), PhpParamsInspection.getCallType(typeFunc, callParams, i))) != null) {
                descriptor = PhpParamsInspection.createSimpleDescriptor(callParams.get(i), isOnTheFly, message, new LocalQuickFix[0]);
            }
            if (descriptor == null) continue;
            problems.put(callParams.get(i), descriptor);
            result = false;
        }
        return result;
    }

    private static PhpType getCallType(IntFunction<? extends PhpType> typeFunc, List<? extends PsiElement> callParams, int i) {
        PhpType callType = PhpParamsInspection.unpluraliseSpreadArguments(typeFunc.apply(i), callParams.get(i));
        return callType;
    }

    public static PhpType unpluraliseSpreadArguments(PhpType type, PsiElement argument) {
        return PhpCodeInsightUtil.isUnpackedArgument(argument) ? type.unpluralize() : type;
    }

    @Nullable
    public static Parameter getMappedParam(List<? extends PsiElement> arguments, @NotNull List<? extends Parameter> params, int i) {
        Parameter mappedParam;
        if (params == null) {
            PhpParamsInspection.$$$reportNull$$$0(1);
        }
        if (PhpPsiUtil.isArgumentUnpacking(arguments.get(i))) {
            return null;
        }
        String name = PhpAnnotatorVisitor.getNameOfMappedParam(arguments, params, i);
        Parameter parameter = mappedParam = name != null ? (Parameter)ContainerUtil.find(params, p -> PhpLangUtil.equalsParameterNames(p.getName(), name)) : null;
        if (mappedParam != null) {
            return mappedParam;
        }
        Parameter lastItem = (Parameter)ContainerUtil.getLastItem(params);
        return lastItem != null && lastItem.isVariadic() ? lastItem : null;
    }

    @Contract(pure=true)
    @NotNull
    public static @NotNull IntFunction<@NotNull PhpType> createCachedTypeFunc(PsiElement @NotNull [] callParams) {
        if (callParams == null) {
            PhpParamsInspection.$$$reportNull$$$0(2);
        }
        PhpType[] types = new PhpType[callParams.length];
        IntFunction<PhpType> intFunction = i -> {
            if (i >= types.length) {
                return PhpType.EMPTY;
            }
            if (types[i] == null) {
                types[i] = new PhpType().add(callParams[i]).global(callParams[i].getProject());
            }
            return types[i];
        };
        if (intFunction == null) {
            PhpParamsInspection.$$$reportNull$$$0(3);
        }
        return intFunction;
    }

    private static boolean tryCheckPropertyHookCall(MethodReference reference, ProblemsHolder holder) {
        String name = reference.getName();
        if (name == null || !name.equals("set")) {
            return false;
        }
        if (MethodReferenceImpl.getFieldReferencedFromPropertyHookCall(reference.getClassReference()) == null) {
            return false;
        }
        ParameterList argumentsList = reference.getParameterList();
        if (argumentsList == null) {
            return false;
        }
        int length = argumentsList.getParameters().length;
        if (length == 0) {
            String description = PhpBundle.message("inspection.missing_param", "value");
            ParameterList parameterList = reference.getParameterList();
            if (PhpPsiUtil.isOfType(parameterList.getPrevSibling(), PhpTokenTypes.chLPAREN) && PhpPsiUtil.isOfType(parameterList.getNextSibling(), PhpTokenTypes.chRPAREN)) {
                TextRange rangeInParent = parameterList.getTextRangeInParent();
                holder.problem((PsiElement)reference, description).range(TextRange.create((int)(rangeInParent.getStartOffset() - 1), (int)(rangeInParent.getEndOffset() + 1))).register();
            }
        }
        return true;
    }

    public static boolean checkMissingParameter(PhpPsiElement call, List<PsiElement> callParams, List<Parameter> declParams, Map<PsiElement, ProblemDescriptor> problems, boolean isOnTheFly, boolean unpackedArgument) {
        if (unpackedArgument) {
            return false;
        }
        Collection<@NlsSafe String> missingRequiredParameterNames = PhpParamsInspection.getMissingRequiredParametersNames(callParams, declParams);
        if (!missingRequiredParameterNames.isEmpty()) {
            PsiElement anchorToHighlight = (PsiElement)ObjectUtils.notNull((Object)((PhpPsiElement)PhpPsiUtil.getChildByCondition((PsiElement)call, ParameterList.INSTANCEOF)), (Object)call);
            String description = missingRequiredParameterNames.size() == 1 ? PhpBundle.message("inspection.missing_param", ContainerUtil.getFirstItem(missingRequiredParameterNames)) : PhpBundle.message("required.parameters.missing", StringUtil.join(missingRequiredParameterNames, (String)", "));
            problems.put((PsiElement)call, PhpChangeFunctionSignatureFromUsageQuickFix.getDescriptor(anchorToHighlight, description, isOnTheFly));
            return true;
        }
        return false;
    }

    private static @NotNull Collection<@NlsSafe String> getMissingRequiredParametersNames(List<? extends PsiElement> callParams, List<? extends Parameter> declParams) {
        Collection argumentMappedParamsNames = IntStream.range(0, callParams.size()).mapToObj(i -> PhpAnnotatorVisitor.getNameOfMappedParam(callParams, declParams, i)).filter(Objects::nonNull).collect(Collectors.toCollection(() -> CollectionFactory.createCaseInsensitiveStringSet()));
        Collection collection = declParams.stream().filter(p -> PhpParamsInspection.required(p, callParams)).map(Parameter::getName).filter(name -> !argumentMappedParamsNames.contains(name)).map(name -> "$" + name).collect(Collectors.toList());
        if (collection == null) {
            PhpParamsInspection.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    private static ProblemDescriptor createSimpleDescriptor(PsiElement call, boolean isOnTheFly, @InspectionMessage String description, LocalQuickFix ... fixes) {
        if (fixes == null) {
            PhpParamsInspection.$$$reportNull$$$0(5);
        }
        ProblemDescriptor problemDescriptor = InspectionManager.getInstance((Project)call.getProject()).createProblemDescriptor(call, description, isOnTheFly, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        if (problemDescriptor == null) {
            PhpParamsInspection.$$$reportNull$$$0(6);
        }
        return problemDescriptor;
    }

    @NotNull
    public static @NotNull LocalQuickFix @NotNull [] getFixes(@NotNull PsiElement argument, PhpType argumentType, @NotNull PhpType declType) {
        if (argument == null) {
            PhpParamsInspection.$$$reportNull$$$0(7);
        }
        if (declType == null) {
            PhpParamsInspection.$$$reportNull$$$0(8);
        }
        if (TYPES_ALLOWED_FOR_CAST.contains(declType)) {
            boolean forCasting;
            if (PhpPsiUtil.isOfType(argument, PhpElementTypes.CAST_EXPRESSION)) {
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{LocalQuickFix.from((ModCommandAction)new PhpChangeCastOperationQuickFix((UnaryExpression)argument, declType))};
                if (localQuickFixArray == null) {
                    PhpParamsInspection.$$$reportNull$$$0(9);
                }
                return localQuickFixArray;
            }
            boolean bl = forCasting = declType.equals(PhpType.ARRAY) || declType.equals(PhpType.OBJECT) || argumentType.types().allMatch(type -> PhpType.isPrimitiveType(type) && !PhpType.isObject(type));
            if (!forCasting) {
                if (LocalQuickFix.EMPTY_ARRAY == null) {
                    PhpParamsInspection.$$$reportNull$$$0(10);
                }
                return LocalQuickFix.EMPTY_ARRAY;
            }
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{LocalQuickFix.from((ModCommandAction)new PhpReplaceArgumentWithCastQuickFix(argument, declType))};
            if (localQuickFixArray == null) {
                PhpParamsInspection.$$$reportNull$$$0(11);
            }
            return localQuickFixArray;
        }
        return PhpParamsInspection.getInheritanceChangeQuickFixes(argument, argumentType, declType);
    }

    @NotNull
    private static @NotNull LocalQuickFix @NotNull [] getInheritanceChangeQuickFixes(@NotNull PsiElement argument, @NotNull PhpType argumentType, @NotNull PhpType declType) {
        PhpIndex phpIndex;
        PhpClass onlyArgumentClass;
        if (argument == null) {
            PhpParamsInspection.$$$reportNull$$$0(12);
        }
        if (argumentType == null) {
            PhpParamsInspection.$$$reportNull$$$0(13);
        }
        if (declType == null) {
            PhpParamsInspection.$$$reportNull$$$0(14);
        }
        if ((onlyArgumentClass = PhpParamsInspection.getOnlyArgumentClass(phpIndex = PhpIndex.getInstance(argument.getProject()), argumentType)) == null || onlyArgumentClass.isTrait()) {
            if (LocalQuickFix.EMPTY_ARRAY == null) {
                PhpParamsInspection.$$$reportNull$$$0(15);
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
        if (!onlyArgumentClass.isWritable()) {
            if (LocalQuickFix.EMPTY_ARRAY == null) {
                PhpParamsInspection.$$$reportNull$$$0(16);
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
        LocalQuickFix[] localQuickFixArray = (LocalQuickFix[])((StreamEx)StreamEx.of(declType.getTypes()).filter(PhpLangUtil::isFqn)).flatMap(fqn -> phpIndex.getAnyByFQN((String)fqn).stream()).map(declaredParameterClass -> PhpSetInheritanceBetweenClassesQuickFixBase.getFix(onlyArgumentClass, declaredParameterClass)).nonNull().toArray((Object[])LocalQuickFix.EMPTY_ARRAY);
        if (localQuickFixArray == null) {
            PhpParamsInspection.$$$reportNull$$$0(17);
        }
        return localQuickFixArray;
    }

    @Nullable
    private static PhpClass getOnlyArgumentClass(PhpIndex phpIndex, PhpType argumentType) {
        if (argumentType.size() != 1 || !PhpLangUtil.isFqn(argumentType.toString())) {
            return null;
        }
        return (PhpClass)ContainerUtil.getOnlyItem(phpIndex.getAnyByFQN(argumentType.toString()));
    }

    public static boolean isCallTypeConvertibleFromDeclaredType(PhpType callType, PhpType declType, PhpIndex index) {
        return declType.isEmpty() || callType.isAmbiguous() || declType.isConvertibleFrom(callType, index);
    }

    private static boolean required(Parameter p, List<? extends PsiElement> arguments) {
        return !p.isOptional(arguments) && !p.isVariadic();
    }

    private static boolean processSignatures(ResolveResult[] results, Set<? extends VirtualFile> extensionRoots, List<? extends PsiElement> arguments, Processor<? super List<Parameter>> processor) {
        for (ResolveResult result : results) {
            Parameter[] declParams;
            PsiElement element = result.getElement();
            if (!(element instanceof Function)) continue;
            Function f = (Function)element;
            if (!result.isValidResult() || (declParams = f.getParameters()).length > 50 || !(PhpParamsInspection.belongToExtensions(element, extensionRoots) ? PhpParamsInspection.collectSignatureVariants(declParams, arguments, processor) : processor.process(Arrays.asList(declParams)))) continue;
            return true;
        }
        return false;
    }

    private static boolean belongToExtensions(PsiElement element, @NotNull Set<? extends VirtualFile> extensionRoots) {
        if (extensionRoots == null) {
            PhpParamsInspection.$$$reportNull$$$0(18);
        }
        return VfsUtilCore.isUnder((VirtualFile)element.getContainingFile().getVirtualFile(), extensionRoots);
    }

    private static boolean collectSignatureVariants(Parameter[] declParams, List<? extends PsiElement> arguments, Processor<? super List<Parameter>> processor) {
        ArrayList sigs = new ArrayList();
        sigs.add(new ArrayList());
        for (Parameter declParam : declParams) {
            int sigsSize = sigs.size();
            for (int i1 = 0; i1 < sigsSize; ++i1) {
                List sig = (List)sigs.get(i1);
                if (!PhpParamsInspection.required(declParam, arguments)) {
                    sigs.add(new ArrayList(sig));
                }
                sig.add(declParam);
            }
        }
        return sigs.stream().filter(s -> !s.isEmpty()).anyMatch(arg_0 -> processor.process(arg_0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6, 9, 10, 11, 15, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callParams";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/type/PhpParamsInspection";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentType";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpParamsInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createCachedTypeFunc";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMissingRequiredParametersNames";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createSimpleDescriptor";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixes";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getInheritanceChangeQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getMappedParam";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createCachedTypeFunc";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createSimpleDescriptor";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFixes";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getInheritanceChangeQuickFixes";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "belongToExtensions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6, 9, 10, 11, 15, 16, 17 -> new IllegalStateException(string);
        };
    }

    private static final class PhpChangeCastOperationQuickFix
    extends PsiUpdateModCommandAction<UnaryExpression> {
        private final PhpType myType;

        private PhpChangeCastOperationQuickFix(UnaryExpression argument, PhpType type) {
            super((PsiElement)argument);
            this.myType = type;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.change.cast.operation.quick.fix.family.name", this.myType.toStringResolved());
            if (string == null) {
                PhpChangeCastOperationQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        protected Presentation getPresentation(@NotNull ActionContext context, @NotNull UnaryExpression element) {
            PsiElement operation;
            if (context == null) {
                PhpChangeCastOperationQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpChangeCastOperationQuickFix.$$$reportNull$$$0(2);
            }
            if ((operation = element.getOperation()) != null) {
                Presentation presentation = Presentation.of((String)PhpBundle.message("intention.name.change.cast.to", operation.getText(), this.myType.toStringResolved()));
                if (presentation == null) {
                    PhpChangeCastOperationQuickFix.$$$reportNull$$$0(3);
                }
                return presentation;
            }
            Presentation presentation = Presentation.of((String)this.getFamilyName());
            if (presentation == null) {
                PhpChangeCastOperationQuickFix.$$$reportNull$$$0(4);
            }
            return presentation;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull UnaryExpression argument, @NotNull ModPsiUpdater updater) {
            PhpPsiElement castValue;
            if (context == null) {
                PhpChangeCastOperationQuickFix.$$$reportNull$$$0(5);
            }
            if (argument == null) {
                PhpChangeCastOperationQuickFix.$$$reportNull$$$0(6);
            }
            if (updater == null) {
                PhpChangeCastOperationQuickFix.$$$reportNull$$$0(7);
            }
            if ((castValue = argument.getValue()) == null) {
                return;
            }
            argument.replace((PsiElement)PhpReplaceArgumentWithCastQuickFix.createCastElementToType(context.project(), (PsiElement)castValue, this.myType));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 5, 6, 7 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/type/PhpParamsInspection$PhpChangeCastOperationQuickFix";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "argument";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpParamsInspection$PhpChangeCastOperationQuickFix";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 5, 6, 7 -> new IllegalArgumentException(string);
            };
        }
    }

    public static final class PhpReplaceArgumentWithCastQuickFix
    extends PsiUpdateModCommandAction<PsiElement> {
        private final PhpType myParameterType;

        public PhpReplaceArgumentWithCastQuickFix(PsiElement argument, PhpType parameterType) {
            super(argument);
            this.myParameterType = parameterType;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.replace.argument.with.cast.quick.fix.family.name", this.myParameterType.toStringResolved());
            if (string == null) {
                PhpReplaceArgumentWithCastQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiElement element) {
            if (context == null) {
                PhpReplaceArgumentWithCastQuickFix.$$$reportNull$$$0(1);
            }
            if (element == null) {
                PhpReplaceArgumentWithCastQuickFix.$$$reportNull$$$0(2);
            }
            Presentation presentation = Presentation.of((String)PhpBundle.message("intention.name.cast.to", element.getText(), this.myParameterType.toStringResolved()));
            if (presentation == null) {
                PhpReplaceArgumentWithCastQuickFix.$$$reportNull$$$0(3);
            }
            return presentation;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull PsiElement startElement, @NotNull ModPsiUpdater updater) {
            if (context == null) {
                PhpReplaceArgumentWithCastQuickFix.$$$reportNull$$$0(4);
            }
            if (startElement == null) {
                PhpReplaceArgumentWithCastQuickFix.$$$reportNull$$$0(5);
            }
            if (updater == null) {
                PhpReplaceArgumentWithCastQuickFix.$$$reportNull$$$0(6);
            }
            startElement.replace((PsiElement)PhpReplaceArgumentWithCastQuickFix.createCastElementToType(context.project(), startElement, this.myParameterType));
        }

        private static PhpPsiElement createCastElementToType(@NotNull Project project, PsiElement element, PhpType type) {
            if (project == null) {
                PhpReplaceArgumentWithCastQuickFix.$$$reportNull$$$0(7);
            }
            String castExpressionText = String.format("(%s)%s", type.toStringRelativized("\\"), element.getText());
            return PhpPsiElementFactory.createPhpPsiFromText(project, PhpElementTypes.CAST_EXPRESSION, castExpressionText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 4, 5, 6, 7 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/type/PhpParamsInspection$PhpReplaceArgumentWithCastQuickFix";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpParamsInspection$PhpReplaceArgumentWithCastQuickFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentation";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createCastElementToType";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 4, 5, 6, 7 -> new IllegalArgumentException(string);
            };
        }
    }
}

