/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.type;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.refactoring.extract.extractInterface.PhpExtractInterfaceProcessor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpSetInheritanceBetweenClassesQuickFixBase
extends PsiUpdateModCommandQuickFix {
    @NotNull
    private final String mySubClassFqn;
    @NotNull
    private final String myBaseClassFqn;

    protected PhpSetInheritanceBetweenClassesQuickFixBase(@NotNull String subClassFqn, @NotNull String baseClassFqn) {
        if (subClassFqn == null) {
            PhpSetInheritanceBetweenClassesQuickFixBase.$$$reportNull$$$0(0);
        }
        if (baseClassFqn == null) {
            PhpSetInheritanceBetweenClassesQuickFixBase.$$$reportNull$$$0(1);
        }
        this.mySubClassFqn = subClassFqn;
        this.myBaseClassFqn = baseClassFqn;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("quickfix.set.inheritance.between.classes", PhpLangUtil.toShortName(this.mySubClassFqn), this.inheritanceModifierPresentation(), PhpLangUtil.toShortName(this.myBaseClassFqn));
        if (string == null) {
            PhpSetInheritanceBetweenClassesQuickFixBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        PhpIndex index;
        PhpClass subClass;
        if (project == null) {
            PhpSetInheritanceBetweenClassesQuickFixBase.$$$reportNull$$$0(3);
        }
        if (element == null) {
            PhpSetInheritanceBetweenClassesQuickFixBase.$$$reportNull$$$0(4);
        }
        if (updater == null) {
            PhpSetInheritanceBetweenClassesQuickFixBase.$$$reportNull$$$0(5);
        }
        if ((subClass = (PhpClass)ContainerUtil.getOnlyItem((index = PhpIndex.getInstance(project)).getAnyByFQN(this.mySubClassFqn))) != null) {
            this.doApply((PhpClass)updater.getWritable((PsiElement)subClass), this.myBaseClassFqn);
        }
    }

    protected abstract void doApply(@NotNull PhpClass var1, @NotNull String var2);

    @NotNull
    protected abstract String inheritanceModifierPresentation();

    @Nullable
    static LocalQuickFix getFix(@NotNull PhpClass argumentClass, @NotNull PhpClass declaredParameterClass) {
        if (argumentClass == null) {
            PhpSetInheritanceBetweenClassesQuickFixBase.$$$reportNull$$$0(6);
        }
        if (declaredParameterClass == null) {
            PhpSetInheritanceBetweenClassesQuickFixBase.$$$reportNull$$$0(7);
        }
        if (declaredParameterClass.isTrait()) {
            return null;
        }
        if (declaredParameterClass.isInterface()) {
            return argumentClass.isInterface() ? new PhpMakeInterfaceExtendsInterfaceQuickFix(argumentClass.getFQN(), declaredParameterClass.getFQN()) : new PhpMakeClassImplementInterfaceQuickFix(argumentClass.getFQN(), declaredParameterClass.getFQN());
        }
        if (!argumentClass.isInterface() && argumentClass.getSuperFQN() == null && !declaredParameterClass.isFinal()) {
            return new PhpMakeClassExtendsClassQuickFix(argumentClass.getFQN(), declaredParameterClass.getFQN());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subClassFqn";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClassFqn";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/type/PhpSetInheritanceBetweenClassesQuickFixBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentClass";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaredParameterClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpSetInheritanceBetweenClassesQuickFixBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static class PhpMakeInterfaceExtendsInterfaceQuickFix
    extends PhpSetInheritanceBetweenClassesQuickFixBase {
        protected PhpMakeInterfaceExtendsInterfaceQuickFix(@NotNull String subClassFqn, @NotNull String baseClassFqn) {
            if (subClassFqn == null) {
                PhpMakeInterfaceExtendsInterfaceQuickFix.$$$reportNull$$$0(0);
            }
            if (baseClassFqn == null) {
                PhpMakeInterfaceExtendsInterfaceQuickFix.$$$reportNull$$$0(1);
            }
            super(subClassFqn, baseClassFqn);
        }

        @Override
        protected void doApply(@NotNull PhpClass subClass, @NotNull String baseClassFqn) {
            if (subClass == null) {
                PhpMakeInterfaceExtendsInterfaceQuickFix.$$$reportNull$$$0(2);
            }
            if (baseClassFqn == null) {
                PhpMakeInterfaceExtendsInterfaceQuickFix.$$$reportNull$$$0(3);
            }
            PhpExtractInterfaceProcessor.addImplementClause(subClass.getProject(), subClass, baseClassFqn);
        }

        @Override
        @NotNull
        protected String inheritanceModifierPresentation() {
            return "extends";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "subClassFqn";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseClassFqn";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "subClass";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpSetInheritanceBetweenClassesQuickFixBase$PhpMakeInterfaceExtendsInterfaceQuickFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doApply";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpMakeClassImplementInterfaceQuickFix
    extends PhpMakeInterfaceExtendsInterfaceQuickFix {
        protected PhpMakeClassImplementInterfaceQuickFix(@NotNull String subClassFqn, @NotNull String baseClassFqn) {
            if (subClassFqn == null) {
                PhpMakeClassImplementInterfaceQuickFix.$$$reportNull$$$0(0);
            }
            if (baseClassFqn == null) {
                PhpMakeClassImplementInterfaceQuickFix.$$$reportNull$$$0(1);
            }
            super(subClassFqn, baseClassFqn);
        }

        @Override
        @NotNull
        protected String inheritanceModifierPresentation() {
            return "implements";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "subClassFqn";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "baseClassFqn";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/lang/inspections/type/PhpSetInheritanceBetweenClassesQuickFixBase$PhpMakeClassImplementInterfaceQuickFix";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpMakeClassExtendsClassQuickFix
    extends PhpSetInheritanceBetweenClassesQuickFixBase {
        protected PhpMakeClassExtendsClassQuickFix(@NotNull String subClassFqn, @NotNull String baseClassFqn) {
            if (subClassFqn == null) {
                PhpMakeClassExtendsClassQuickFix.$$$reportNull$$$0(0);
            }
            if (baseClassFqn == null) {
                PhpMakeClassExtendsClassQuickFix.$$$reportNull$$$0(1);
            }
            super(subClassFqn, baseClassFqn);
        }

        @Override
        protected void doApply(@NotNull PhpClass subClass, @NotNull String baseClassFqn) {
            if (subClass == null) {
                PhpMakeClassExtendsClassQuickFix.$$$reportNull$$$0(2);
            }
            if (baseClassFqn == null) {
                PhpMakeClassExtendsClassQuickFix.$$$reportNull$$$0(3);
            }
            PhpLangUtil.addExtendsClause(subClass, baseClassFqn);
        }

        @Override
        @NotNull
        protected String inheritanceModifierPresentation() {
            return "extends";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "subClassFqn";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseClassFqn";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "subClass";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/inspections/type/PhpSetInheritanceBetweenClassesQuickFixBase$PhpMakeClassExtendsClassQuickFix";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doApply";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

