/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.intentions.generators.PhpAccessorsGenerator;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpPropertyHook;
import com.jetbrains.php.lang.psi.elements.impl.FieldImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J!\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0094\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0002J\r\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002J\u001c\u0010\u0012\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00022\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J$\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\u00022\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u001a2\u0006\u0010\t\u001a\u00020\u0002H\u0002J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0002H\u0002\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/php/lang/intentions/PhpAddPropertyHooksIntention;", "Lcom/intellij/modcommand/PsiUpdateModCommandAction;", "Lcom/jetbrains/php/lang/psi/elements/Field;", "<init>", "()V", "invoke", "", "context", "Lcom/intellij/modcommand/ActionContext;", "field", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "getFamilyName", "", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "isElementApplicable", "", "element", "createHooks", "hookTypes", "", "Lcom/jetbrains/php/lang/psi/elements/PhpPropertyHook$PhpPropertyHookType;", "extendHooks", "propertyHooksContainer", "Lcom/intellij/psi/PsiElement;", "collectMissingHooks", "", "attemptRemoveTrailingSemicolon", "intellij.php.impl"})
@SourceDebugExtension(value={"SMAP\nPhpAddPropertyHooksIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhpAddPropertyHooksIntention.kt\ncom/jetbrains/php/lang/intentions/PhpAddPropertyHooksIntention\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n1#2:94\n1863#3,2:95\n1557#3:97\n1628#3,3:98\n*S KotlinDebug\n*F\n+ 1 PhpAddPropertyHooksIntention.kt\ncom/jetbrains/php/lang/intentions/PhpAddPropertyHooksIntention\n*L\n65#1:95,2\n74#1:97\n74#1:98,3\n*E\n"})
public final class PhpAddPropertyHooksIntention
extends PsiUpdateModCommandAction<Field> {
    public PhpAddPropertyHooksIntention() {
        super(Field.class);
    }

    protected void invoke(@NotNull ActionContext context, @NotNull Field field, @NotNull ModPsiUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        this.invoke(field);
    }

    public final void invoke(@NotNull Field field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Set<PhpPropertyHook.PhpPropertyHookType> missingHooks = this.collectMissingHooks(field);
        PsiElement psiElement = FieldImpl.getPropertyHooksContainer(field);
        if (psiElement != null) {
            PsiElement it = psiElement;
            boolean bl = false;
            this.extendHooks(it, field, missingHooks);
        } else {
            this.createHooks(field, missingHooks);
        }
    }

    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("add.property.hooks", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    protected boolean isElementApplicable(@NotNull Field element, @NotNull ActionContext context) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.isElementApplicable(element);
    }

    public final boolean isElementApplicable(@NotNull Field element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PhpLanguageLevel phpLanguageLevel = PhpLanguageLevel.current((Project)element.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)phpLanguageLevel, (String)"current(...)");
        PhpLanguageLevel languageLevel = phpLanguageLevel;
        if (!languageLevel.isAtLeast(PhpLanguageLevel.PHP840)) {
            return false;
        }
        Field $this$isElementApplicable_u24lambda_u241 = element;
        boolean bl = false;
        boolean bl2 = $this$isElementApplicable_u24lambda_u241.isAbstract() || $this$isElementApplicable_u24lambda_u241.isConstant() || $this$isElementApplicable_u24lambda_u241.isReadonly() || $this$isElementApplicable_u24lambda_u241.getModifier().isStatic();
        if (bl2) {
            return false;
        }
        return !((Collection)this.collectMissingHooks(element)).isEmpty();
    }

    public final void createHooks(@NotNull Field field, @NotNull Set<? extends PhpPropertyHook.PhpPropertyHookType> hookTypes) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter(hookTypes, (String)"hookTypes");
        String hooksBody = CollectionsKt.joinToString$default((Iterable)hookTypes, (CharSequence)"\n", null, null, (int)0, null, arg_0 -> PhpAddPropertyHooksIntention.createHooks$lambda$2(field, arg_0), (int)30, null);
        PsiElement hooksBlock = PhpPsiElementFactory.createPropertyHooks(field.getProject(), hooksBody);
        this.attemptRemoveTrailingSemicolon(field);
        field.getParent().addAfter(hooksBlock, (PsiElement)field);
    }

    public final void extendHooks(@NotNull PsiElement propertyHooksContainer, @NotNull Field field, @NotNull Set<? extends PhpPropertyHook.PhpPropertyHookType> hookTypes) {
        Intrinsics.checkNotNullParameter((Object)propertyHooksContainer, (String)"propertyHooksContainer");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter(hookTypes, (String)"hookTypes");
        Iterable $this$forEach$iv = hookTypes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PhpPropertyHook.PhpPropertyHookType hookType = (PhpPropertyHook.PhpPropertyHookType)((Object)element$iv);
            boolean bl = false;
            PhpPropertyHook hook = PhpPsiElementFactory.createPropertyHook(field.getProject(), hookType, field.getName());
            PsiElement propertyHookDefinitionClose = PhpPsiUtil.getChildOfType(propertyHooksContainer, PhpTokenTypes.chRBRACE);
            PsiElement psiElement = FieldImpl.getPropertyHooksContainer(field);
            if (psiElement == null) continue;
            psiElement.addBefore((PsiElement)hook, propertyHookDefinitionClose);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<PhpPropertyHook.PhpPropertyHookType> collectMissingHooks(Field field) {
        void $this$mapTo$iv$iv;
        Set missingHooks = CollectionsKt.toMutableSet((Iterable)((Iterable)EntriesMappings.entries$0));
        List<PhpPropertyHook> list = field.getPropertyHooksList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getPropertyHooksList(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            PhpPropertyHook phpPropertyHook = (PhpPropertyHook)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean $i$f$collectMissingHooks$stub_for_inlining = false;
            boolean bl = false;
            collection.add(p0.getHookType());
        }
        List hooks = (List)destination$iv$iv;
        missingHooks.removeAll(hooks);
        Method[] methodArray = new PhpAccessorsGenerator(field).findGetters();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"findGetters(...)");
        if (!(((Object[])methodArray).length == 0)) {
            missingHooks.remove((Object)PhpPropertyHook.PhpPropertyHookType.GET);
        }
        Method[] methodArray2 = new PhpAccessorsGenerator(field).findSetters();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray2, (String)"findSetters(...)");
        if (!(((Object[])methodArray2).length == 0)) {
            missingHooks.remove((Object)PhpPropertyHook.PhpPropertyHookType.SET);
        }
        return missingHooks;
    }

    private final void attemptRemoveTrailingSemicolon(Field field) {
        block1: {
            PsiElement psiElement = PhpPsiUtil.getNextSiblingIgnoreWhitespace(field, true);
            if (psiElement == null) break block1;
            PsiElement $this$attemptRemoveTrailingSemicolon_u24lambda_u244 = psiElement;
            boolean bl = false;
            if (PhpPsiUtil.isOfType($this$attemptRemoveTrailingSemicolon_u24lambda_u244, PhpTokenTypes.opSEMICOLON)) {
                $this$attemptRemoveTrailingSemicolon_u24lambda_u244.delete();
            }
        }
    }

    private static final CharSequence createHooks$lambda$2(Field $field, PhpPropertyHook.PhpPropertyHookType it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        String string = PhpPsiElementFactory.createPropertyHook($field.getProject(), it, $field.getName()).getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<PhpPropertyHook.PhpPropertyHookType> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])PhpPropertyHook.PhpPropertyHookType.values());
        }
    }
}

