/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.impl.ClassConstImpl;
import com.jetbrains.php.lang.psi.elements.impl.FieldImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.refactoring.move.member.PhpMoveMemberDialog;
import com.jetbrains.php.refactoring.move.member.PhpMoveMemberProcessor;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class PhpClassCanBeConvertedToEnumIntention
extends BaseElementAtCaretIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("intention.php.replace.class.with.enum", new Object[0]);
        if (string == null) {
            PhpClassCanBeConvertedToEnumIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            PhpClassCanBeConvertedToEnumIntention.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            PhpClassCanBeConvertedToEnumIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            PhpClassCanBeConvertedToEnumIntention.$$$reportNull$$$0(3);
        }
        if (!PhpLanguageFeature.ENUM_CLASSES.isSupported(project)) {
            return false;
        }
        PhpClass clazz = this.getPhpClass(element);
        if (clazz == null || clazz.hasTraitUses() || !PhpClassCanBeConvertedToEnumIntention.canBeReplacedWithEnum(clazz)) {
            return false;
        }
        List<PhpClassMember> classMembers = Arrays.asList(clazz.getOwnFields());
        if (ContainerUtil.exists(classMembers, m -> !PhpMoveMemberDialog.isConstant(m) || !m.getModifier().isPublic()) || PhpMoveMemberDialog.containsDuplicatedValues(classMembers)) {
            return false;
        }
        PhpType backedType = PhpMoveMemberDialog.getBackedType(classMembers);
        return backedType != null;
    }

    public PhpClass getPhpClass(PsiElement element) {
        return (PhpClass)PhpPsiUtil.getParentByCondition(element, false, PhpClass.INSTANCEOF, PhpFile.INSTANCEOF);
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PhpClass clazz;
        if (project == null) {
            PhpClassCanBeConvertedToEnumIntention.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            PhpClassCanBeConvertedToEnumIntention.$$$reportNull$$$0(5);
        }
        if (element == null) {
            PhpClassCanBeConvertedToEnumIntention.$$$reportNull$$$0(6);
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)(clazz = this.getPhpClass(element)))) {
            return;
        }
        String error = PhpClassCanBeConvertedToEnumIntention.getError(clazz);
        if (error != null) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)error, (String)PhpBundle.message("intention.php.replace.class.with.enum.title", new Object[0]), null);
            return;
        }
        List<PhpClassMember> classMembers = Arrays.asList(clazz.getOwnFields());
        PhpType backedType = PhpMoveMemberDialog.getBackedType(classMembers);
        WriteAction.run(() -> PhpClassCanBeConvertedToEnumIntention.changeClassTemplateToEnum(clazz, project, backedType));
        PhpMoveMemberProcessor processor = new PhpMoveMemberProcessor(project, clazz, clazz, classMembers, true, false);
        processor.run();
    }

    @NlsContexts.DialogMessage
    public static String getError(PhpClass clazz) {
        if (PhpClassCanBeConvertedToEnumIntention.hasNewExpressionsUsages(clazz)) {
            return PhpBundle.message("intention.php.replace.class.with.enum.error.message", new Object[0]);
        }
        return null;
    }

    public static boolean hasNewExpressionsUsages(PhpClass phpClass) {
        Collection references = ReferencesSearch.search((PsiElement)phpClass).findAll();
        for (PsiReference ref : references) {
            NewExpression newExpression = (NewExpression)ObjectUtils.tryCast((Object)ref.getElement().getParent(), NewExpression.class);
            if (newExpression == null) continue;
            return true;
        }
        return false;
    }

    public static boolean canBeReplacedWithEnum(PhpClass clazz) {
        return !clazz.isEnum() && !clazz.isTrait() && clazz.getOwnMethods().length == 0 && clazz.getSuperClass() == null && !PhpClassHierarchyUtils.subclassExists(clazz);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        PsiElement element;
        PhpClass clazz;
        if (project == null) {
            PhpClassCanBeConvertedToEnumIntention.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            PhpClassCanBeConvertedToEnumIntention.$$$reportNull$$$0(8);
        }
        if (file == null) {
            PhpClassCanBeConvertedToEnumIntention.$$$reportNull$$$0(9);
        }
        if ((clazz = PhpPsiUtil.getParentOfClass(element = file.findElementAt(editor.getCaretModel().getOffset()), PhpClass.class)) == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                PhpClassCanBeConvertedToEnumIntention.$$$reportNull$$$0(10);
            }
            return intentionPreviewInfo;
        }
        List<PhpClassMember> classMembers = Arrays.asList(clazz.getOwnFields());
        PhpType backedType = PhpMoveMemberDialog.getBackedType(classMembers);
        if (backedType == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                PhpClassCanBeConvertedToEnumIntention.$$$reportNull$$$0(11);
            }
            return intentionPreviewInfo;
        }
        String fileText = String.format("enum %s %s {\n%s}", clazz.getName(), ": " + backedType, PhpClassCanBeConvertedToEnumIntention.getCasesText(classMembers));
        return new IntentionPreviewInfo.CustomDiff((FileType)PhpFileType.INSTANCE, clazz.getText(), fileText);
    }

    private static String getCasesText(Collection<PhpClassMember> constants) {
        StringBuilder builder2 = new StringBuilder();
        for (PhpClassMember member : constants) {
            ClassConstImpl classConst;
            if (!(member instanceof Field) || (classConst = (ClassConstImpl)ObjectUtils.tryCast((Object)member, ClassConstImpl.class)) == null || classConst.getDefaultValue() == null) continue;
            String caseText = "\tcase " + classConst.getName() + " = " + classConst.getDefaultValue().getText() + ";";
            builder2.append(caseText).append("\n");
        }
        return builder2.toString();
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            PhpClassCanBeConvertedToEnumIntention.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static void changeClassTemplateToEnum(@NotNull PhpClass clazz, @NotNull Project project, PhpType backedType) {
        ASTNode node;
        if (clazz == null) {
            PhpClassCanBeConvertedToEnumIntention.$$$reportNull$$$0(13);
        }
        if (project == null) {
            PhpClassCanBeConvertedToEnumIntention.$$$reportNull$$$0(14);
        }
        if ((node = clazz.getNode().findChildByType(TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.kwCLASS, PhpTokenTypes.kwINTERFACE}))) == null) {
            return;
        }
        PsiElement enumTemplate = PhpPsiElementFactory.createFromText(project, PhpTokenTypes.kwENUM, "enum a {}");
        node.getPsi().replace(enumTemplate);
        PhpAnnotatorVisitor.PhpAddEnumBackedTypeQuickFix.insertBackedType(project, clazz, backedType);
        PhpClassCanBeConvertedToEnumIntention.removeModifier((PsiElement)clazz);
    }

    public static void removeModifier(@NotNull PsiElement startElement) {
        PhpClass phpClass;
        if (startElement == null) {
            PhpClassCanBeConvertedToEnumIntention.$$$reportNull$$$0(15);
        }
        if ((phpClass = (PhpClass)ObjectUtils.tryCast((Object)startElement, PhpClass.class)) == null) {
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)phpClass)) {
            return;
        }
        ASTNode finalNode = phpClass.getNode().findChildByType(TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.kwFINAL, PhpTokenTypes.kwABSTRACT}));
        PsiElement readonlyKeyWord = FieldImpl.getReadonlyKeyword((PsiElement)phpClass);
        if (finalNode != null) {
            finalNode.getPsi().delete();
        }
        if (readonlyKeyWord != null) {
            readonlyKeyWord.delete();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 13, 14, 15 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpClassCanBeConvertedToEnumIntention";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpClassCanBeConvertedToEnumIntention";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "changeClassTemplateToEnum";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeModifier";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 13, 14, 15 -> new IllegalArgumentException(string);
        };
    }
}

