/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpDefaultMatchArm;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpMatchArm;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpExtractMatchConditionIntoSeparateArmIntention
extends PsiUpdateModCommandAction<PsiElement> {
    PhpExtractMatchConditionIntoSeparateArmIntention() {
        super(PsiElement.class);
    }

    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("intention.family.name.split.into.two.separate.match.arms", new Object[0]);
        if (string == null) {
            PhpExtractMatchConditionIntoSeparateArmIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected boolean isElementApplicable(@NotNull PsiElement element, @NotNull ActionContext context) {
        PhpMatchArm matchArm;
        if (element == null) {
            PhpExtractMatchConditionIntoSeparateArmIntention.$$$reportNull$$$0(1);
        }
        if (context == null) {
            PhpExtractMatchConditionIntoSeparateArmIntention.$$$reportNull$$$0(2);
        }
        if ((matchArm = PhpPsiUtil.getParentOfClass(element, PhpMatchArm.class)) == null || matchArm.getBodyExpression() == null) {
            return false;
        }
        List<@NotNull PhpExpression> conditions = matchArm.getConditions();
        if (conditions.size() <= 1 && (conditions.isEmpty() || !(matchArm instanceof PhpDefaultMatchArm))) {
            return false;
        }
        PhpExpression firstCondition = (PhpExpression)ContainerUtil.getFirstItem(conditions);
        PhpExpression lastCondition = (PhpExpression)ContainerUtil.getLastItem(conditions);
        if (firstCondition == null) {
            return false;
        }
        TextRange conditionsRange = TextRange.create((int)firstCondition.getTextRange().getStartOffset(), (int)lastCondition.getTextRange().getEndOffset());
        return conditionsRange.contains(element.getTextRange());
    }

    @Nullable
    private static PsiElement getComma(int offset, @NotNull PsiElement element, boolean left) {
        if (element == null) {
            PhpExtractMatchConditionIntoSeparateArmIntention.$$$reportNull$$$0(3);
        }
        if (PhpPsiUtil.isOfType(element, PhpTokenTypes.opCOMMA) && offset == element.getTextRange().getStartOffset() && !left) {
            return element;
        }
        return left ? PhpPsiUtil.getPrevSiblingByCondition(element, (Condition<? super PsiElement>)((Condition)e -> PhpPsiUtil.isOfType(e, PhpTokenTypes.opCOMMA))) : PhpPsiUtil.getNextSiblingByCondition(element, (Condition<? super PsiElement>)((Condition)e -> PhpPsiUtil.isOfType(e, PhpTokenTypes.opCOMMA)));
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        if (context == null) {
            PhpExtractMatchConditionIntoSeparateArmIntention.$$$reportNull$$$0(4);
        }
        if (element == null) {
            PhpExtractMatchConditionIntoSeparateArmIntention.$$$reportNull$$$0(5);
        }
        if (updater == null) {
            PhpExtractMatchConditionIntoSeparateArmIntention.$$$reportNull$$$0(6);
        }
        PhpMatchArm matchArm = PhpPsiUtil.getParentOfClass(element, PhpMatchArm.class);
        Object adjustedElement = PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)((Condition)e -> e.getParent() == matchArm));
        assert (adjustedElement != null);
        PsiElement leftComma = PhpExtractMatchConditionIntoSeparateArmIntention.getComma(context.offset(), adjustedElement, true);
        PsiElement rightComma = PhpExtractMatchConditionIntoSeparateArmIntention.getComma(context.offset(), adjustedElement, false);
        PhpExpression condition = PhpExtractMatchConditionIntoSeparateArmIntention.getConditionBetween(leftComma, rightComma);
        assert (matchArm != null && condition != null);
        PhpExpression bodyExpression = matchArm.getBodyExpression();
        assert (bodyExpression != null);
        if (leftComma == null || rightComma != null) {
            matchArm.deleteChildRange((PsiElement)condition, rightComma);
        } else {
            matchArm.deleteChildRange(leftComma, (PsiElement)condition);
        }
        PhpMatchArm armToInsert = PhpPsiElementFactory.createMatchArm(context.project(), condition.getText(), bodyExpression.getText());
        PsiElement newArm = PhpExtractMatchConditionIntoSeparateArmIntention.insertNewMatchArm(context.project(), matchArm, armToInsert);
        updater.moveCaretTo(newArm);
    }

    @NotNull
    private static PsiElement insertNewMatchArm(@NotNull Project project, PhpMatchArm matchArm, PhpMatchArm newMatchArm) {
        if (project == null) {
            PhpExtractMatchConditionIntoSeparateArmIntention.$$$reportNull$$$0(7);
        }
        PsiElement matchExpression = matchArm.getParent();
        if (matchArm instanceof PhpDefaultMatchArm) {
            Object prevArm = PhpPsiUtil.getPrevSiblingByCondition((PsiElement)matchArm, (Condition<? super PsiElement>)((Condition)PhpMatchArm.class::isInstance));
            if (prevArm != null) {
                PsiElement anchor = matchExpression.addAfter(PhpPsiElementFactory.createComma(project), prevArm);
                PsiElement psiElement = matchExpression.addAfter((PsiElement)newMatchArm, anchor);
                if (psiElement == null) {
                    PhpExtractMatchConditionIntoSeparateArmIntention.$$$reportNull$$$0(8);
                }
                return psiElement;
            }
            PsiElement comma = matchExpression.addBefore(PhpPsiElementFactory.createComma(project), (PsiElement)matchArm);
            PsiElement psiElement = matchExpression.addBefore((PsiElement)newMatchArm, comma);
            if (psiElement == null) {
                PhpExtractMatchConditionIntoSeparateArmIntention.$$$reportNull$$$0(9);
            }
            return psiElement;
        }
        PsiElement anchor = matchExpression.addAfter(PhpPsiElementFactory.createComma(project), (PsiElement)matchArm);
        PsiElement psiElement = matchExpression.addAfter((PsiElement)newMatchArm, anchor);
        if (psiElement == null) {
            PhpExtractMatchConditionIntoSeparateArmIntention.$$$reportNull$$$0(10);
        }
        return psiElement;
    }

    @Nullable
    private static PhpExpression getConditionBetween(@Nullable PsiElement left, @Nullable PsiElement right) {
        assert (left != null || right != null);
        return left != null ? (PhpExpression)PhpPsiUtil.getNextSiblingByCondition(left, PhpExpression.INSTANCEOF) : (PhpExpression)PhpPsiUtil.getPrevSiblingByCondition(right, PhpExpression.INSTANCEOF);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpExtractMatchConditionIntoSeparateArmIntention";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpExtractMatchConditionIntoSeparateArmIntention";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "insertNewMatchArm";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isElementApplicable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getComma";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "insertNewMatchArm";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

