/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.lang.intentions.PhpInvertIfIntention;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpFlipTernaryExpressionIntention
extends PsiUpdateModCommandAction<PsiElement> {
    public PhpFlipTernaryExpressionIntention() {
        super(PsiElement.class);
    }

    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("intention.family.name.flip", new Object[0]);
        if (string == null) {
            PhpFlipTernaryExpressionIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        TernaryExpression ternaryExpression;
        if (context == null) {
            PhpFlipTernaryExpressionIntention.$$$reportNull$$$0(1);
        }
        if (element == null) {
            PhpFlipTernaryExpressionIntention.$$$reportNull$$$0(2);
        }
        if (updater == null) {
            PhpFlipTernaryExpressionIntention.$$$reportNull$$$0(3);
        }
        if ((ternaryExpression = PhpFlipTernaryExpressionIntention.getTernaryExpression(element)) == null) {
            return;
        }
        PhpPsiElement trueVariant = ternaryExpression.getTrueVariant();
        PhpPsiElement falseVariant = ternaryExpression.getFalseVariant();
        PhpPsiElement condition = ternaryExpression.getCondition();
        if (trueVariant == null || falseVariant == null || condition == null) {
            return;
        }
        PsiElement trueCopy = trueVariant.copy();
        trueVariant.replace((PsiElement)falseVariant);
        falseVariant.replace(trueCopy);
        PhpInvertIfIntention.updateCondition((PsiElement)condition);
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiElement element) {
        if (context == null) {
            PhpFlipTernaryExpressionIntention.$$$reportNull$$$0(4);
        }
        if (element == null) {
            PhpFlipTernaryExpressionIntention.$$$reportNull$$$0(5);
        }
        if (!PhpWorkaroundUtil.isIntentionAvailable(element)) {
            return null;
        }
        TernaryExpression parent = PhpFlipTernaryExpressionIntention.getTernaryExpression(element);
        if (parent == null || parent.isShort() || parent.getCondition() == null || parent.getTrueVariant() == null || parent.getFalseVariant() == null) {
            return null;
        }
        return Presentation.of((String)this.getFamilyName());
    }

    @Nullable
    private static TernaryExpression getTernaryExpression(@NotNull PsiElement element) {
        if (element == null) {
            PhpFlipTernaryExpressionIntention.$$$reportNull$$$0(6);
        }
        return (TernaryExpression)PhpPsiUtil.getParentByCondition(element, false, TernaryExpression.INSTANCEOF, Statement.INSTANCEOF);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpFlipTernaryExpressionIntention";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpFlipTernaryExpressionIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTernaryExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

