/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.intentions;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiNavigator;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.actions.generation.PhpGeneratePhpDocBlocksAction;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.inspections.classes.PhpHierarchyChecksInspection;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocCommentGenerator;
import com.jetbrains.php.lang.inspections.quickfix.type.PhpChangeFieldTypeToMatchSuperQuickFix;
import com.jetbrains.php.lang.intentions.changeVisibility.PhpChangeVisibilityIntentionBase;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.PhpClassFieldsList;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpGenerateDocBlockIntention
extends PsiUpdateModCommandAction<PsiElement> {
    private static final Condition<PsiElement> FUNCTION_CONDITION = Conditions.and(Function.INSTANCEOF, (Condition)Conditions.not(PhpDocMethod.class::isInstance));
    private static final Condition<PsiElement> FIELD_CONDITION = Conditions.and(Field.INSTANCEOF, e -> PhpPsiUtil.isOfType(e.getParent(), PhpElementTypes.CLASS_FIELDS));
    private static final Condition<PsiElement> FIELD_OR_FUNCTION_CONDITION = Conditions.or(FIELD_CONDITION, FUNCTION_CONDITION);

    public PhpGenerateDocBlockIntention() {
        super(PsiElement.class);
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        PsiElement targetElement;
        if (context == null) {
            PhpGenerateDocBlockIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            PhpGenerateDocBlockIntention.$$$reportNull$$$0(1);
        }
        if (updater == null) {
            PhpGenerateDocBlockIntention.$$$reportNull$$$0(2);
        }
        if ((targetElement = PhpGenerateDocBlockIntention.getTargetElement(element, context.project())) == null) {
            return;
        }
        PhpGenerateDocBlockIntention.addComment(context.project(), (ModPsiNavigator)updater, targetElement);
    }

    @Nullable
    private static Field extractFieldFromGroupedDeclaration(@NotNull Project project, @NotNull Field field, @NotNull PsiElement classFields) {
        if (project == null) {
            PhpGenerateDocBlockIntention.$$$reportNull$$$0(3);
        }
        if (field == null) {
            PhpGenerateDocBlockIntention.$$$reportNull$$$0(4);
        }
        if (classFields == null) {
            PhpGenerateDocBlockIntention.$$$reportNull$$$0(5);
        }
        String defaultValue = PhpChangeVisibilityIntentionBase.getDefaultValueText(field);
        PhpPsiElement newField = PhpPsiElementFactory.createClassField(project, field.getModifier(), field.isReadonly(), field.getName(), defaultValue, PhpChangeFieldTypeToMatchSuperQuickFix.getDeclaredTypeString(project, field.getDeclaredType(), field));
        PhpCodeEditUtil.removeStatementWithDelivery((PsiElement)field, PhpTokenTypes.opCOMMA);
        PsiElement addedField = classFields.getParent().addBefore((PsiElement)newField, classFields);
        return (Field)PhpPsiUtil.getChildByCondition(addedField, Field.INSTANCEOF);
    }

    private static void addComment(@NotNull Project project, @NotNull ModPsiNavigator navigator, @Nullable PsiElement targetElement) {
        PsiElement beforeElement;
        if (project == null) {
            PhpGenerateDocBlockIntention.$$$reportNull$$$0(6);
        }
        if (navigator == null) {
            PhpGenerateDocBlockIntention.$$$reportNull$$$0(7);
        }
        PhpDocComment comment = PhpDocCommentGenerator.constructDocComment(project, targetElement, true);
        if (targetElement != null && comment != null && (beforeElement = PhpGeneratePhpDocBlocksAction.PhpGeneratePhpDocBlocksActionHandler.getBeforeElement(targetElement)) != null) {
            TextRange docRange = PhpCodeEditUtil.insertDocCommentBeforeAndGetTextRange(beforeElement, comment);
            Document document = targetElement.getContainingFile().getFileDocument();
            List<RangeMarker> caretMarkers = PhpDocCommentGenerator.collectCaretMarkers(document, docRange);
            if (!caretMarkers.isEmpty()) {
                PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
                navigator.moveCaretTo(caretMarkers.get(0).getStartOffset());
                caretMarkers.forEach(marker -> document.deleteString(marker.getStartOffset(), marker.getEndOffset()));
            }
        }
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiElement element) {
        PsiElement prev;
        PsiElement beforeElement;
        PsiElement targetElement;
        if (context == null) {
            PhpGenerateDocBlockIntention.$$$reportNull$$$0(8);
        }
        if (element == null) {
            PhpGenerateDocBlockIntention.$$$reportNull$$$0(9);
        }
        if ((targetElement = PhpGenerateDocBlockIntention.getElement(element)) != null && (beforeElement = PhpGeneratePhpDocBlocksAction.PhpGeneratePhpDocBlocksActionHandler.getBeforeElement(targetElement)) != null && !((prev = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(beforeElement, true)) instanceof PhpDocComment)) {
            return Presentation.of((String)PhpGenerateDocBlockIntention.getNameText());
        }
        return null;
    }

    private static PsiElement getTargetElement(PsiElement element, Project project) {
        PsiElement targetElement = PhpGenerateDocBlockIntention.getElement(element);
        if (targetElement instanceof Function) {
            return targetElement;
        }
        if (targetElement instanceof Field) {
            PhpClassFieldsList classFields = ((Field)targetElement).getParentList();
            if (classFields == null) {
                return null;
            }
            if (PhpHierarchyChecksInspection.isGroupedDeclarations(classFields)) {
                return PhpGenerateDocBlockIntention.extractFieldFromGroupedDeclaration(project, (Field)targetElement, (PsiElement)classFields);
            }
            return targetElement;
        }
        return null;
    }

    @Nullable
    private static PsiElement getElement(PsiElement element) {
        return PhpPsiUtil.getParentByCondition(element, false, FIELD_OR_FUNCTION_CONDITION, GroupStatement.INSTANCEOF);
    }

    @NotNull
    public String getFamilyName() {
        String string = PhpGenerateDocBlockIntention.getNameText();
        if (string == null) {
            PhpGenerateDocBlockIntention.$$$reportNull$$$0(10);
        }
        return string;
    }

    @IntentionFamilyName
    public static String getNameText() {
        return PhpBundle.message("intention.generate.phpdoc", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFields";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/intentions/PhpGenerateDocBlockIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/intentions/PhpGenerateDocBlockIntention";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "extractFieldFromGroupedDeclaration";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addComment";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 10: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10 -> new IllegalStateException(string);
        };
    }
}

